/*
 * Copyright (c) 2008, 2009  Nokia Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef OMAP_SYSFS_H
#define OMAP_SYSFS_H

#include "fbdev.h"

int dss2_write_two_ints(const char *fmt, int index, const char *option, int a,
			int b);
int dss2_write_one_int(const char *fmt, int index, const char *option, int a);
int dss2_read_two_ints(const char *fmt, int index, const char *option,
		       int *ret_a, int *ret_b);
int dss2_read_one_int(const char *fmt, int index, const char *option,
		      int *ret_a);
int dss2_read_str(const char *fmt, int index, const char *option, char *str,
		  size_t len);
int dss2_write_str(const char *fmt, int index, const char *option,
		   const char *str);
int sysfs_read(const char *path, char *value, size_t len);
int sysfs_write(const char *path, const char *value, size_t len);

#endif
