/*
 * Copyright © 2006-2007 Daniel Stone
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Author: Daniel Stone <daniel@fooishbar.org>
 */

#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#include "os.h"
#include "hotplug.h"
#include "config-backends.h"

void
config_init(void)
{
#if defined(CONFIG_DBUS_API) || defined(CONFIG_HAL)
    if (config_dbus_core_init()) {
# ifdef CONFIG_DBUS_API
       if (!config_dbus_init())
	    ErrorF("[config] failed to initialise D-Bus API\n");
# endif
# ifdef CONFIG_HAL
        if (!config_hal_init())
            ErrorF("[config] failed to initialise HAL\n");
# endif
    }
    else {
	ErrorF("[config] failed to initialise D-Bus core\n");
    }
#endif
#if defined(CONFIG_OSSO_API)
    if (!config_osso_init())
      ErrorF("[config] failed to initialise OSSO API\n");
#endif
}

void
config_fini(void)
{
#if defined(CONFIG_DBUS_API) || defined(CONFIG_HAL)
# ifdef CONFIG_HAL
    config_hal_fini();
# endif
# ifdef CONFIG_DBUS_API
    config_dbus_fini();
# endif
    config_dbus_core_fini();
#endif
#if defined(CONFIG_OSSO_API)
    config_osso_fini();
#endif
}
