/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef TPSESSIONCHANNEL_H
#define TPSESSIONCHANNEL_H

#include <QObject>
#include <TelepathyQt4/Types>
#include <TelepathyQt4/Types>
#include <TelepathyQt4/Message>
#include <TelepathyQt4/PendingChannel>
#include <TelepathyQt4/ChannelRequest>
#include <TelepathyQt4/Channel>
#include <TelepathyQt4/TextChannel>
#include <TelepathyQt4/PendingReady>
#include <TelepathyQt4/ContactManager>
#include <TelepathyQt4/Connection>

class TpSessionChannel;

#include "tpsession.h"

class TpSessionChannel : public QObject
{
  Q_OBJECT
public:
    TpSessionChannel(Tp::TextChannelPtr);
    TpSessionChannel(Tp::ConnectionPtr conn,const Tp::ContactPtr &contact);
    void sendMessage(QString message);
    QString peerId();
    QString objectPath();
    QString type();
signals:
  void channelReady(TpSessionChannel *);
  void channelDestroyed(TpSessionChannel *);
  void messageReceived(const Tp::ReceivedMessage &,TpSessionChannel *);
  void messageSent(const Tp::Message &,Tp::MessageSendingFlags, const QString &,TpSessionChannel *);
public slots:
    void onChannelCreated(Tp::PendingOperation *op);
    void onChannelReady(Tp::PendingOperation *op);
    void onChannelDestroyed();
    void onMessageReceived(const Tp::ReceivedMessage &);
    void onMessageSent(const Tp::Message &,Tp::MessageSendingFlags, const QString &);
public:
    Tp::ContactPtr peerContact;
    Tp::TextChannelPtr channel;
};

#endif // TPSESSIONCHANNEL_H
