#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-12-11 10:36:19 graham>
#
#  COPYRIGHT
# Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#
# TODO
#	in need of serious structural fix to write it properly.

"""
Transform the XML entries that make up the TeX Catalogue into HTML for
distribution on CTAN.
"""

import os
import re
import sys
import datetime
import time
import codecs
from xml.dom.ext import PrettyPrint

from tcutils import commify, list_packages, loadXML

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.73 $".split()[1]
__verdate__ = "$Date: 2005/01/09 11:17:09 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/gencat.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: gencat.py,v $")

########################################################################
#
# SUPPORT - COMMON STRINGS
#
def cat_header(version=""):
    location = "."
    if "Entry" in version: location = ".."
    return re.sub("!!LOCATION!!", location,
                  """<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<!--This file is automatically generated. Do not edit!-->
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta http-equiv="Content-Style-Type" content="text/css">
  <title>The TeX Catalogue OnLine, %s !!Edition!! Edition</title>
  <link rel="stylesheet" type="text/css" href="!!LOCATION!!/texcatalogue.css">
</head>
<body bgcolor="white">
  <h1><a name="top"></a></h1>
  <div style="text-align:center">
    <a href="!!LOCATION!!/index.html">
      <img src="!!LOCATION!!/title.png" alt="The TeX Catalogue Online" border="0">
    </a>
  </div>
  <p></p>
  <div style="text-align:center">
    <a href="http://tug.ctan.org/find.html">Search</a> |
    <a href="!!LOCATION!!/index.html">Home</a> |
    <a href="!!LOCATION!!/alpha.html">Alpha</a> |
    <a href="!!LOCATION!!/brief.html">Brief</a> |
    <a href="!!LOCATION!!/bytopic.html">Topical</a> |
    <a href="!!LOCATION!!/hier.html">Hierarchical</a> <!--|
    <a href="!!LOCATION!!/full.html">Full</a Available from Graham as PDF-->
  </div>
""" % version)

def cat_title(version=""):
    return """  <p></p>
  <hr>
  <p class="names">
    <i>TeX Catalogue (%s !!Edition!! Edition)</i>
    <a href="http://www.togaware.com">Graham Williams</a>
  </p>
  <p class="names"></p><p></p>
""" % version

def cat_copyright(version=""):
    location = "."
    if version == "Entry": location = ".."
    return re.sub("!!LOCATION!!", location,
                  """  <hr>
    <center><small>Copyright (c) 1986-2004
    <a href="http://www.togaware.com">""" +\
"""<img src="!!LOCATION!!/gwtw.png" align="center" border=0
        ></a>.&nbsp;&nbsp;
    This page was generated %s.</small>
  </center>
  <hr>
""" %  re.sub("\.[0-9]*$", "", str(datetime.datetime.utcnow())))

def cat_alpha_index(version=""):
    return """  <hr>
  <h3 align="center">
    <a href="#A">A</a> | 
    <a href="#B">B</a> | 
    <a href="#C">C</a> | 
    <a href="#D">D</a> | 
    <a href="#E">E</a> | 
    <a href="#F">F</a> | 
    <a href="#G">G</a> | 
    <a href="#H">H</a> | 
    <a href="#I">I</a> | 
    <a href="#J">J</a> | 
    <a href="#K">K</a> | 
    <a href="#L">L</a> | 
    <a href="#M">M</a> | 
    <a href="#N">N</a> | 
    <a href="#O">O</a> | 
    <a href="#P">P</a> | 
    <a href="#Q">Q</a> | 
    <a href="#R">R</a> | 
    <a href="#S">S</a> | 
    <a href="#T">T</a> | 
    <a href="#U">U</a> | 
    <a href="#V">V</a> | 
    <a href="#W">W</a> | 
    <a href="#X">X</a> | 
    <a href="#Y">Y</a> | 
    <a href="#Z">Z</a> | 
  </h3><!--"-->
"""
def cat_tail(version=""):
    if version == "Entry":
        return """
</body>
</html>
"""
    else:
        return """
  <hr>
</body>
</html>
"""

def mapper(str, edition="home"):
    strmap = {}
    if edition == "home":
        strmap = {"!!Edition!!": "Home",
                  "!!Home Pointer!!": "",
                  "!!BASE2!!": "http://theory.uwinnipeg.ca/scripts/CTAN",
                  "!!BASE3!!": "http://theory.uwinnipeg.ca/scripts/CTAN"}
    else:
        strmap = {"!!Edition!!": "Ctan",
                  "!!Home Pointer!!": """<LI>The
<a href="http://texcatalogue.sarovar.org">Home</a> Edition
is a stand-alone version of the Catalogue at
<a href="http://sarovar.org">Sarovar.org</a>.""",
                  "!!BASE2!!": "../..",
                  "!!BASE3!!": "../../.."}

    for p in strmap:
        str = re.sub(p, strmap[p], str)
    return str

timestart = time.time()

########################################################################
#
# BUILD LIST OF ENTRIES.
#
entries = list_packages()
ecount = commify(len(entries))
print "The catalogue contains %s entries." % ecount
#
########################################################################
#
# LIST OF AUTHORS.
#
from xml.dom.ext.reader.Sax import FromXmlFile
authors = FromXmlFile("entries/authors", validate=False)
authors = authors.getElementsByTagName("author")
print "There are %d package authors." % len(authors)

def get_author(id, authors):
    for a in authors:
        if a.getAttribute('id')==id:
            gname = a.getAttribute('givenname')
            fname = a.getAttribute('familyname')
            if gname and fname:
                return " ".join([gname, fname])
            elif gname:
                return gname
            elif fname:
                return fname
            else:
                return ""
            
    return ""

########################################################################
#
# GENERATE PREFACE
#
timehere = time.time()
fname = "index.html"
print "Writing the file `%s'" % fname,
content = cat_header("Preface") +\
          cat_title("Preface")
content += """
<p>
<hr>
<p class="notes"> Welcome to The TeX Catalogue Online, !!Edition!!
Edition, listing %s TeX, LaTeX, and related packages and tools.
Most are available online from <a href="http://tug.ctan.org">CTAN, the
Comprehensive TeX Archive Network</A>. For a good on-line overview of
using LaTeX see Peter Flynn's <a
href="http://tug.ctan.org/tex-archive/info/beginlatex/html/index.html">Beginner's Introduction</a>. Visit CTAN for assistance with
<a href="http://tug.ctan.org/installationadvice/">installing a package</a>.
The canonical location of the Catalogue is at <a
href="http://texcatalogue.sarovar.org">texcatalogue.sarovar.org</a> while
the source is available at <a
href="http://sarovar.org/projects/texcatalogue/">sarovar.org/projects/texcatalogue/</a>. A PDF version is available from <a href="http://www.togaware.com">Togaware</a>.

</p>
<ul> 
<li> You can <a href="http://tug.ctan.org/find.html">Search</a> the
 Catalogue and other CTAN related material, courtesy of Jim Hefferon.

!!Home Pointer!!

<li>The <a href="alpha.html">Alphabetic</a> Index lists the name of each entry with a link to the full entry.

<LI>The <A HREF="brief.html">Brief</A> Index has a short
description of each entry and a link to the full entry.

<LI>The <A HREF="bytopic.html">Topical</A> Index provides a
systematic index by topic.

<LI>The <A HREF="hier.html">Hierarchical</A> Index is based on
the CTAN hierarchy with links to full entries.


<li>The Full Catalogue, as a PDF document, is available for purchase from <a href="http://www.togaware.com/">Togaware</a>
for a small fee to help support further development.
  
</ul> 

<p>See the <A HREF="licenses.html">CTAN License Information</A> Web
page for information on licenses.</P>

<HR>

<p>The TeX Catalogue Online is also available from
any CTAN node or mirror, including the following.
Pick one that is close to you.

(The "search" link attempts to find a CTAN node that may be close to you.
Multiple clicks may find alternatives. Courtesy of Randy Kobes.)
<P>
<TABLE WIDTH="100%%">
<TR>

<TD ALIGN="center">
<A HREF="http://theory.uwinnipeg.ca/scripts/CTAN/help/Catalogue/index.html"><IMG BORDER="0" SRC="./search.png" ALT="search"></A><BR><B>search</B>
</TD>

<!--td align=center>
  <a href=http://mirror.aarnet.edu.au/pub/CTAN/help/Catalogue/index.html><img height=15 alt=au title="Australia" src=./au.png></a>
  <br><b>aarnet</b>
</td-->

<td align=center>
  <a href=ftp://ctan.unsw.edu.au/tex-archive/help/Catalogue/index.html><img height=15 alt=au title="Australia" src=./au.png></a>
  <br><b>unsw</b>
</td>

<td align=center>
  <a href=ftp://ftp.das.ufsc.br/pub/ctan/help/Catalogue/index.html><img height=15 alt=br title="Brazil" src=./br.png></a>
  <br><b>ufsc</b>
</td>

<td align=center>
<a href=ftp://sunsite.cnlab-switch.ch/mirror/tex/help/Catalogue/index.html><img height=15 src=./ch.png alt=ch title="Switzerland"></a> <br> <b>switch</b>

<td align=center>
<a href=ftp://ftp.cstug.cz/pub/tex/CTAN/help/Catalogue/index.html><img height=15 src=./cz.png alt=cz title="The Czech Republic"></a><br><b>cstug</b>

<td align=center>
<a href=ftp://ftp.dante.de/tex-archive/help/Catalogue/index.html><img height=15 src=./de.png alt=de title="Germany"></a> <br> <b>dante</b>

<td align=center>
<a href=ftp://ftp.loria.fr/pub/unix/tex/ctan/help/Catalogue/index.html><img height=15 src=./fr.png alt=fr title="France"></a> <br> <b>loria</b>

<td align=center>
<a href=http://ftp.tex.ac.uk/tex-archive/help/Catalogue/index.html><img height=15 src=./gb.png alt=gb title="Great Britain"></a> <br> <b>tex</b>

<td align=center>
  <a href=http://komo.padinet.com/CTAN/help/Catalogue/index.html><img height=15 alt=id title="Indonesia" src=./id.png></a>
  <br><b>komo</b>
</td>

<td align=center>
  <a href=ftp://cis.uniRoma2.it/TeX/help/Catalogue/index.html><img height=15 alt=it src=./it.png title="Italy"></a>
  <br><b>roma</b>
</td>
<td align=center>
<a href=ftp://ftp.riken.go.jp/pub/tex-archive/help/Catalogue/index.html><img height=15 src=./jp.png alt=jp title="Japan"></a> <br> <b>riken</b>

<td align=center>
  <a href=http://ftp.ktug.or.kr/tex-archive/help/Catalogue/index.html><img height=15 alt=kr title="Korea" src=./kr.png></a>
  <br><b>ktug</b>
</td>

<td align=center>
  <a href=ftp://ftp.fciencias.unam.mx/pub/tex/help/Catalogue/index.html><img height=15 alt=mx title="Mexico" src=./mx.png></a>
  <br><b>unam</b>
</td>

<td align=center>
  <a href=ftp://sunsite.icm.edu.pl/pub/CTAN/help/Catalogue/index.html><img height=15 alt=pl src=./pl.png title="Poland"></a>
  <br><b>gust</b>
</td>
<td align=center>
  <a href=ftp://ftp.rge.com/pub/tex/help/Catalogue/index.html><img height=15 alt=us src=./us.png title="United States"></a>
  <br><b>rge</b>
</td>

<td align=center>
  <a href=http://tug.ctan.org/tex-archive/help/Catalogue/index.html><img height=15 alt=us src=./us.png title="United States"></a>
  <br><b>tug</b>
</td>
</table>


<hr><p>Icons associated with many entries in the catalogue
allow you to:

<ul>
  <li><img alt="CTAN" src="./search.png">
      view the directory on a nearby CTAN node
  <li><img alt="DANTE" src="./dir.png">
      view the directory on a nearby CTAN node
  <li><img alt="Download" src="./tar.png">
      download a gzip'd tar file from a nearby CTAN node
  <li><img alt="Download" src="./tar.png">
      download a gzip'd tar file from the Dante CTAN node
  <li><img alt="Home" src="./home.png">
      jump to the package's home page
  <li><img src="./doc.png"
           alt="Documentation">
      view documentation (possibly many)
  <li><img src="./acroread.png"
           alt="PDF">
      view PDF documentation (requires <a href=http://www.adobe.com/prodindex/acrobat/readstep.html>acroread</a> plugin)
  <li><img src="./ps.png"
           alt="PostScript">
      view PostScript documentation
  <li><img src="./dvi.png"
           alt="DVI">
      view DVI documentation
  <li><img src="./html.png"
           alt="HTML">
      view HTML documentation
</ul>


<p>Other icons simply provide further information about the package:

<ul>

<li><img src=./texlive.png alt=TeXLive>
available on the <a href="http://www.tug.org/texlive/index.html">
TeX Live CD ROM</a>

<li><img src=./tetex.png alt=teTeX>
part of the <a href="http://www.tug.org/teTeX/">
teTeX distribution</a>

<li><img src=./miktex.png alt=MikTeX>
part of the <a href="http://www.miktex.org/">
MikTeX distribution</a>

</ul>

<p> The file CTAN:README.structure describes the purpose of each top
 level directory. </p>


<hr>

<p>The catalogue began life in 1986! It was originially maintained as
a BibTeX database, and started generating HTML in 1992. It migrated to
XML using XSL style sheets to generate the various formatted versions
of the catalogue in 1997.  The source migrated to the open source
server <a href="http://sarovar.org/projects/texcatalogue/">Sarovar</a>
in 2004, together with a rewrite of all the processing code from XSL
to Python, with much relief. The DTD for the Catalogue is in <A
HREF="catalogue.dtd">catalogue.dtd</A> or generically at <A
HREF="http://texcatalogue.sarovar.org/catalogue.dtd">Sarovar</A>.

<P>The catalogue is regularly updated and others are welcome to join
the team maintaining the catalogue by creating an account on <a
href="http://sarovar.org">Sarovar</a>. There are bound to be errors in
the catalogue.  If you come across any, or have comments,
enhancements, and additions, please send them to me at <img
src="gwtw.png" align="center">.

<p>The catalogue has evolved over quite a few years.  Thanks to many
who have contributed entries and ideas.  In particular, <a
href="http://www.cs.ruu.nl/~piet">Piet van Oostrum</a> supplied quite
a few one line descriptions and Sebastian Rahtz has added many entries
for the <A HREF="http://www.tug.org/texlive">TUG TeX Live CDROM</A>.
Robin Fairbains and Barbara Beeton have provided various updates and
suggestions. Stanislaw Wawrykiewicz maintains many of the Polish
entries from GUST. Randy Kobes contributed code and ideas for the
alphabetic and hierachical editions and maintains and runs the
extremely useful CGI script used to <A
HREF="http://theory.uwinnipeg.ca/scripts/CTAN/">locate a nearby CTAN
node</A>.  Jim Hefferon implemented and maintains the Catalogue <A
HREF="http://tug.ctan.org/find.html">search</A> facility. Joao Palhoto Matos
made the icons look great.


<P>Juergen Fenn maintains the topical index to the cataogue and Martin
Bayer</a> has provided a template for the improved look and feel of
the catalogue.

<P> Other sources of information about TeX and LaTeX can be obtained
from the <A HREF="http://www.tug.org/">TeX Users Group</A>.

<p>

The Catalogue is Copyright (c) 1986-2004 by Graham Williams, but is
made available under the <a href="licenses.lppl.html">LaTeX Project
Public License (lppl)</a> License, allowing you to freely distribute it.

<p>

""" % ecount
content += cat_copyright("Preface") +\
           cat_tail("Preface")

for edition in ("home", "ctan"):
    index = codecs.open("www-" + edition + "/" + fname, "w", "utf-8")
    index.write(mapper(content, edition))
    index.close()
print "took %d seconds." % (time.time() - timehere)

########################################################################
#
# GENERATE ALPHA INDEX
#
timehere = time.time()
fname = "alpha.html"
print "Writing the file `%s'" % fname,
content = cat_header("Alphabetic") +\
          cat_title("Alphabetic") +\
          cat_alpha_index("Alphabetic") +\
          cat_copyright("Alphabetic")
section = ""
for p in entries:
    if p[0] <> section:
        content += """  <a name="%s"></a><h3>%s</h3><hr>\n""" %\
                   (p[0].upper(), p[0].upper())
        section = p[0]
    content += """    <a name="%s" href="entries/%s.html">
      <li><big>%s</big></li>
    </a>\n""" % (p, p, p)
content += cat_tail("Alphabetic")
for edition in ("home", "ctan"):
    alpha = codecs.open("www-" + edition + "/" + fname, "w", "utf-8")
    alpha.write(mapper(content, edition))
    alpha.close()
print "took %d seconds." % (time.time() - timehere)

########################################################################
#
# GENERATE BRIEF INDEX
# CAPTURE HIERARCHICAL INFORMATION
# GENERATE INDIVIDUAL ENTRY HTML FILES
# GENERATE SINGLE CATALOGUE XML FILE
#
timehere = time.time()
print "Checking individual entries and writing the catalogue file."
brief_content = cat_header("Brief") +\
                cat_title("Brief") +\
                cat_alpha_index("Brief") +\
                cat_copyright("Brief")
section = ""
hier_list = {}
#
# Catalogue
#
#catalogue = codecs.open("catalogue.xml", "w", "utf-8")
#catalogue.write("""<?xml version="1.0"?>
#<!DOCTYPE catalogue SYSTEM "http://texcatalogue.sarovar.org/catalogue.dtd">
#
#<catalogue maintainer="Graham.Williams togaware.com"
#           datestamp="%s"
#           license="Copyright 1986-2004 (c) Graham J. Williams under the GPL">
#""" % datetime.datetime.utcnow() )
for p in entries:
    if p[0] <> section:
        print p[0],
        sys.stdout.flush()
        section = p[0]
        brief_content += """<a name="%s"></a><h3>%s</h3>""" %\
                         (p[0].upper(), p[0].upper())
    doc = loadXML(p)
    if not doc: continue
    #
    # Catalogue
    #
    #entry = doc.getElementsByTagName("entry")
    #PrettyPrint(entry[0], catalogue)
    #
    #
    #
    cap = doc.getElementsByTagName("caption")[0].firstChild.nodeValue
    #
    # Get hierarchy information while we are at it.
    #
    ctan = doc.getElementsByTagName("ctan")
    hier = "noctan"
    if ctan:
        hier = ctan[0].getAttribute('path')
        if hier[0] != '/': hier = '/' + hier
    if hier in hier_list:
        hier_list[hier] += [p]
    else:
        hier_list[hier] = [p]
    #
    # Output the caption to the brief index
    #
    brief_content += """<table cellpadding="3" width="100%%">
<tr>
<th align="left" valign="top" width="20%%">
<a name="%s" href="entries/%s.html"><big>%s</big></a>
</th>
<td align="left" valign="bottom" width="80%%">
<em>%s</em>
</td>
</tr></table>""" % (p, p, p, cap)
    #
    # Output the individual entry file into ./entries/?/*.html
    # only if the XML is more recent than the HTML
    #
    if os.path.exists("www-home/entries/" + p + ".html"):
        tshtml = os.stat("www-home/entries/" + p + ".html")[8]
        tsxml  = os.stat("entries/" + p[0] + "/" + p + ".xml")[8]
        if tsxml < tshtml: continue
    print "[%s]" % p,
    #
    # Now output the individual entry - 
    #
    entry_content = cat_header("Entry for %s," % p)
    #
    # Caption
    #
    entry_content += """  <p></p>
  <hr>
  <table cellpadding="3" width="100%%">
    <tr>
    <th align="left" valign="top" rowspan="4" width="20%%">
      <big><a name="%s">%s</a></big>
    </th>
    <td align="left" valign="bottom" colspan="2" width="80%%">
      <strong><em>%s</em></strong>
    </td>
    </tr>
""" % (p, p, cap)
    #
    # Description
    #
    desc = doc.getElementsByTagName("description")
    description = ""
    if desc:
        for a in desc[0].childNodes:
            if a.nodeType == a.TEXT_NODE:
                description += a.nodeValue
            elif a.nodeType == a.ELEMENT_NODE:
                if a.nodeName == "xref":
                    try:
                        value = a.firstChild.nodeValue
                        refid = a.getAttribute("refid")
                    except:
                        print "\nFATAL: xref error in %s - aborting" % p
                        sys.exit(1)
                    description += "<a href='%s.html'>%s</a>" % (refid, value)
                elif a.nodeName == "p":
                    description += "<br><br>"
                elif a.nodeName == "pre":
                    value = a.firstChild.nodeValue
                    description += "<pre>%s</pre>" % (value)
                    # HACK SOLUTION - PRE seems to terminate P! See sgame.
                    description += '<p class="description">'
		elif a.nodeName == "a":
		    try:
			value = a.firstChild.nodeValue
			refid = a.getAttribute("href")
		    except:
			print "\nFATAL: a href error in %s - aborting" % p
			sys.exit(1)
		    description += "<a href='%s'>%s</a>" % (refid, value)
                else:
                    try:
                        description += a.firstChild.nodeValue
                    except:
                        print "\nFATAL: element %s error in %s - aborting" %\
                              (a, p)
                        sys.exit(1)
    #
    # Authors
    #
    auth = doc.getElementsByTagName("authorref")
    auth_len = len(auth)
    if auth:
        auth_count = 0
        if auth_len < 2:
            description += "The author is "
        else:
            description += "The authors are "
        for a in auth:
            auth_count += 1
            #try:
            name = get_author(a.getAttribute("id"), authors)
            #except:
            #    print "\nFATAL: author name missing in %s - aborting" % p
            #    sys.exit(1)
            if auth_count == 1:
                if not name:
                    description += "unknown"
                else:
                    description += name
                if auth_len == 1: description += "."
            elif auth_count < auth_len:
                description += ", " + name
            else:
                description += " and " + name + "."
    else:
        description += "The author of this package is not recoded."
    #
    # See Also
    #
    links = doc.getElementsByTagName("also")
    if links:
        description += " See also"
        for x in links:
            refid = x.getAttribute("refid")
            description += " <a href='%s.html'>%s</a>" % (refid, refid) 
        description += "."
    #
    # Print out the description.
    #
    if description:
        entry_content += """    <tr>
    <td colspan="2" width="80%%"><p class="description">%s</p></td>
    </tr>
""" % description
    #
    # ICON BAR
    #
    entry_content += """  <tr><td align="left" width="100%%">\n"""
    #
    # CTAN
    #
    if ctan:
        entry_content += """    <a href="!!BASE3!!%s/">
      <img src="../search.png" border="0"
      title="Visit a nearby CTAN:%s. If this fails, try Dante."></a>
    <a href="ftp://ftp.dante.de/tex-archive%s"><img src="../dir.png" border="0"     title="Visit Dante:%s"></a>
    <a href="http://theory.uwinnipeg.ca/scripts/CTAN%s.tar.gz"><img src="../tar.png" border="0"
           title="Download from a nearby CTAN (automatically identified)."></a>
    <a href="ftp://ftp.dante.de/tex-archive%s.tar.gz">
      <img src="../tar.png" border="0"
      title="Download from Dante."></a>
""" % (hier, hier, hier, hier, hier, hier)
    #
    # Home
    #
    home = doc.getElementsByTagName("home")
    for h in home:
        home_value = h.getAttribute('href')
        entry_content += """ <a href="%s"><img src="../home.png" border="0"
        title="Visit the Package Home Page"></a>
""" % home_value
    #
    # Documentation
    #
    docs = doc.getElementsByTagName("documentation")
    for d in docs:
        docs_href = d.getAttribute("href")
        docs_location = docs_href.split(":")[0]
        doc_png = "doc.png"
        if os.path.splitext(docs_href)[1] == ".pdf":
            doc_png = "acroread.png"
        elif  os.path.splitext(docs_href)[1] == ".dvi":
            doc_png = "dvi.png"
        elif  os.path.splitext(docs_href)[1] == ".ps":
            doc_png = "ps.png"
        elif  os.path.splitext(docs_href)[1] == ".html":
            doc_png = "html.png"
        #
        # Documentation located on CTAN
        #
        if docs_location == "ctan":
            entry_content += """  <a href="!!BASE3!!%s"><img
  src="../%s" border="0"
  title="Read documentation for this package from %s."></a>
""" % (docs_href.split(":")[1], doc_png, docs_href)
        #
        # Documentation located on the internet through HTTP
        #
        elif docs_location in ("http", "ftp"):
            entry_content += """  <a href="%s"><img src="../%s" border="0"
  title="Read documentation for this package from %s."></a>
""" % (docs_href, doc_png, docs_href)
        else:
            print "ERROR: %s: Unknown location: %s." % \
                  (p, docs_location)
            sys.exit(1)
    #
    # TeXlive
    #
    if doc.getElementsByTagName("texlive"):
        entry_content += """   <a href="http://www.tug.org/texlive/index.html">
      <img src="../texlive.png" border="0"
           title="This package is included in the TeXLive distribution."></a>
"""
    #
    # teTeX
    #
    if doc.getElementsByTagName("tetex"):
        entry_content += """   <a href="http://www.tug.org/teTeX/">
      <img src="../tetex.png" border="0"
           title="This package is included in the teTeX distribution."></a>
"""
    #
    # miktex
    #
    if doc.getElementsByTagName("miktex"):
        entry_content += """   <a href="http://www.miktex.org/">
      <img src="../miktex.png" border="0"
           title="This package is included in MikTeX."></a>
"""
    entry_content += """  </td>\n"""
    #
    # Info Panel
    # 
    entry_content += """  </tr><tr><td align="right" valign="bottom" width="100%%">
  <small><em>"""
    #
    # License
    #
    try:
        license = doc.getElementsByTagName("license")[0].getAttribute("type")
        entry_content += """
        License: <strong><a href="../licenses.%s.html">%s</a></strong>""" %\
        (license, license)
    except:
        print "\nFATAL: no license found in %s - aborting" % p
        sys.exit(1)
        
    #
    # Version
    #
    version = doc.getElementsByTagName("version")
    if version:
        try:
            version = version[0].getAttribute("number")
        except:
            print "\nFATAL: version number error in %s - aborting" % p
            sys.exit(1)
        entry_content += """
    Version: <strong>%s</strong>""" % version
    #
    # Updated
    # 
    datestamp = doc.getElementsByTagName("entry")[0].getAttribute("datestamp")
    datestamp = datestamp.split()[0] # Get just the date
    entry_content += """
    Updated: <strong>%s</strong>""" % datestamp
    #
    # Finished
    #
    entry_content += """
  </em></small>
  </td></tr>
  </table>
"""
    entry_content += cat_copyright("Entry") +\
                     cat_tail("Entry")
    for edition in ("home", "ctan"):
        entry = codecs.open("www-" + edition + "/entries/" + p + ".html", "w", "utf-8")
        entry.write(mapper(entry_content, edition))
        entry.close()

#catalogue.write("""
#</catalogue>
#""")
#catalogue.close()
print "\nThat took %d seconds." % (time.time() - timehere)

timehere = time.time()
fname = "brief.html"
print "Writing the file `%s'" % fname,
brief_content += cat_tail("Brief")
for edition in ("home", "ctan"):
    brief = codecs.open("www-" + edition + "/" + fname, "w", "utf-8")
    brief.write(mapper(brief_content, edition))
    brief.close()
print "took %d seconds." % (time.time() - timehere)
########################################################################
#
# GENERATE HIERARCHY INDEX
#
timehere = time.time()
fname = "hier.html"
print "Writing the file `%s'" % fname,
content = cat_header("Hierarchical") +\
          cat_title("Hierarchical") +\
          cat_copyright("Hierarchical")
# Aggregate single items up to next level
remove_list = []
hier_keys = hier_list.keys()
for h in hier_keys:
    if len(hier_list[h]) == 1:
        newh = os.path.dirname(h)
        if newh in hier_list:
            hier_list[newh] += [hier_list[h][0]]
        else:
            hier_list[newh] = [hier_list[h][0]]
        del(hier_list[h])
hier_sorted_keys = hier_list.keys()
hier_sorted_keys.sort()
for h in hier_sorted_keys:
    location = """<a href="!!BASE2!!/%s">%s</a>""" %  (h, h)
    packages = ", ".join(map(lambda x: """<a href="entries/%s.html">%s</a>"""\
                             % (x, x), hier_list[h]))
    content += "<h3>%s</h3> %s\n" % (location, packages)
content += cat_tail("Hierarchical")
for edition in ("home", "ctan"):
    hier = codecs.open("www-" + edition + "/" + fname, "w", "utf-8")
    hier.write(mapper(content, edition))
    hier.close()
print "took %d seconds." % (time.time() - timehere)

print "Processing completed in %d seconds." % (time.time() - timestart)
