#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-04-27 21:22:46 Graham.Williams togaware.com>
#
#  COPYRIGHT
# Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#

"""Convert any dates in old yyyy/mm/dd to yyy-mm-dd 00:00:00."""

########################################################################
# IMPORTS
#

import re
import sys
import os
import shutil

from tcutils import list_packages

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.1 $".split()[1]
__verdate__ = "$Date: 2004/04/27 11:28:39 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/fixdates.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: fixdates.py,v $")

########################################################################
#
# READ AND ADD DOCTYPE
#

def fix_utc_iso_dates(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        doc = open(xmlfname).readlines()
        ndoc = map(lambda x:re.sub('(\d\d\d\d)/(\d\d)/(\d\d)',
                                   '\g<1>-\g<2>-\g<3> 00:00:00', x), doc)
        if ndoc <> doc:
            print "Fixed %s." % p
            shutil.copy(xmlfname, xmlfname + ".date.bak")
            ndoc = "".join(ndoc)
            nfile = open(xmlfname, "w")
            nfile.write(ndoc)
            nfile.close()
            # sys.exit(0) # For testing
            
###################################################################
# MAIN PROGRAM
#
def _usage():
    """Print documentation."""
    print __doc__

def _main():
    """Process command line options then perform the action."""
    packages = list_packages()
    fix_utc_iso_dates(packages)

########################################################################
#
# INTERACTIVE
#
# Test to see if we are running as a main program, rather than being
# imported as a library. If it's a main program, then let's do some
# work. Otherwise let's quielty proceed.
#
if __name__ == "__main__":
    _main()
