/*
 * This file is part of sp-response-time
 *
 * Copyright (C) 2005-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */ 

/**
   @file record.c

   Implementation of configuration operations
   <p>
*/

#include <stdlib.h>
#include <malloc.h>
#include <signal.h>
#include <pthread.h>

#include <X11/Xlib.h>

#include <X11/extensions/record.h> 

#include "common.h"
#include "record.h"
#include "analyser.h"

static void record_callback(XPointer closure, XRecordInterceptData *data ) {
	(void)closure;
	handle_event(data->server_time);
	XRecordFreeData(data);
}

static XRecordContext init_record_context(Display* dpy) {
	XRecordClientSpec* xids;
	XRecordRange** ranges;
	int data_flags = XRecordFromServerTime
		| XRecordFromClientTime
		| XRecordFromClientSequence;

	xids = malloc(sizeof *xids);
	xids[0] = XRecordAllClients;
	
	// TODO: Make this little bit more better way.
	int nbr_ranges = 2;
	ranges = malloc(nbr_ranges * sizeof *ranges);

	{ // Limit visibility of i-variable.
		
		int i = 0;
//		ranges[i] = XRecordAllocRange();
//		ranges[i]->delivered_events.first = EnterNotify;
//		ranges[i]->delivered_events.last = KeymapNotify;
//		++i;
//		ranges[i] = XRecordAllocRange();
//		ranges[i]->core_requests.first = 0;
//		ranges[i]->core_requests.last = 0;
//		++i;
//		ranges[i] = XRecordAllocRange();
//		ranges[i]->device_events.first = KeyPress;
//		ranges[i]->device_events.last = MotionNotify;
//		++i;
		// TODO: Should we listen ButtonRelease events instead of ButtonPress events.
		ranges[i] = XRecordAllocRange();
		ranges[i]->device_events.first = ButtonPress;
		ranges[i]->device_events.last = ButtonPress;
		++i;
		// TODO: Should we listen KeyRelease events instead of KeyPress events.
		ranges[i] = XRecordAllocRange();
		ranges[i]->device_events.first = KeyPress;
		ranges[i]->device_events.last = KeyPress;
		++i;
//		ranges[i] = XRecordAllocRange();
//		ranges[i]->device_events.first = ButtonRelease;
//		ranges[i]->device_events.last = ButtonRelease;
//		++i;
//		ranges[i] = XRecordAllocRange();
//		ranges[i]->core_replies.first = sz_xGenericReply;
//		ranges[i]->core_replies.last = sz_xSetModifierMappingReply;
//		++i;
	}
	
	return XRecordCreateContext( dpy, data_flags, 
		xids, 1, ranges, nbr_ranges);
}


void *event_recorder() {
	Status status;
	Display* dpy = NULL;
	XRecordContext record_context;
	
	if ((dpy = setup_display(getenv("DISPLAY"))) == NULL) {
		pthread_exit(NULL);
	}
	
	record_context = init_record_context(dpy);
	
	status = 0;
	status = XRecordEnableContextAsync(
		dpy, record_context,
		record_callback,
		(XPointer)dpy);

	if (status == 0)
	{
	  log_error("Failed to enable XRecord context!\n");
		pthread_exit(NULL);
	}
	

	/* FIXME: usleep() makes the polling slightly less offensive
	   but might affect the accuracy of results; not a very
	   good compromise, is there a better way? */

	while (True)
	{
		XRecordProcessReplies(dpy);
		usleep(100);
	}

	sleep(-1);
	XRecordDisableContext(dpy, record_context);

	XRecordFreeContext(dpy, record_context);

	XCloseDisplay(dpy);

	pthread_exit(NULL);
}

