/*
 * This file is part of sp-response-time
 *
 * Copyright (C) 2005-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */ 

/**
   @file analyser.h

   Implementation of configuration operations
*/

#ifndef ANALYSER_H_
#define ANALYSER_H_

#include <X11/Xlib.h>
#include <X11/extensions/Xdamage.h>

/*
 * Default time to wait after last non ignorable damage before
 * deside that update is done.
 */
#define DEFAULT_WAIT_TIME 3000

/*
 * Default size of damage areas which are big enough to not ignore.
 * Smaller areas than this will be ignored.
 * Size is in square pixels.
 */
#define DEFAULT_IGNORE_AREA 3000

/*
 * Initialization data structure for analyser.
 */
typedef struct AnalyserInitData {
	int wait_time;
	int ignore_area;
} AnalyserInitData;

/**
 * This is the method which starts analyser.
 * 
 * @param init_data Pointer to a AnalyserInitData structure. If NULL then
 * default values will be used.
 * 
 * @return pthread return data.
 */
void *run_analyser(void *init_data);

void reset_analyser();
void terminate_analyser();
void send_dummy_event();

void handle_event(Time timestamp);
void handle_damage(Time timestamp, XDamageNotifyEvent* dev);

#endif //ANALYSER_H_
