#!/bin/sh

APPS="rtcom-call-ui rtcom-messaging-ui osso-addressbook hildon-status-menu"

# Apps will be respawned, so we extract the
# files before killing them
cd $HOME/.rtcom-eventlogger/

# Handle both old (only db) and new (db and attachments) backup formats
if [ -f backup.tgz ]; then
    tar xzf backup.tgz
    rm backup.tgz
elif [ -f backup.db ]; then
    mv backup.db el.db
else
    # We don't know what to do, so we fail
    exit 1
fi

PIDS=`pidof $APPS` && kill -15 $PIDS

