/* Copyright (c) 2010, Nokia Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * * Neither the name of the Nokia Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Dynamic module for modest to expose some functionality
 */

#include <modest-plugin.h>

/* Own includes */
#include "qtmm-plugin.h"
#include "qtmm-debug.h"
#include "qtmm-dbus-service.h"

/* Private data definition */
struct _QtmMPluginPrivate {
    gboolean disposed;

    GObject *plugin_service;
};

#define GET_PRIVATE(o) ((QtmMPluginPrivate *)           \
                        ((QtmMPlugin *)(o))->priv)

MODEST_PLUGIN_REGISTER_TYPE (QtmMPlugin, qtmm_plugin);

/*
 * GObject funcs
 */

/* Instance init */
static void
qtmm_plugin_init (QtmMPlugin *plugin)
{
    QtmMPluginPrivate *priv;

    priv = plugin->priv = G_TYPE_INSTANCE_GET_PRIVATE (
        plugin, QTMM_TYPE_PLUGIN, QtmMPluginPrivate);

    QTMM_DEBUG ("Modest plugin version: %s",
                modest_plugin_get_api_version (MODEST_PLUGIN (plugin)));

    priv->plugin_service = qtmm_dbus_service_new ();
}

/* Instance disposal, unref all other GObjects here */
static void
qtmm_plugin_dispose (GObject *object)
{
    QtmMPluginPrivate *priv;

    QTMM_DEBUG();

    priv = GET_PRIVATE (object);

    if (priv == NULL) return;

    if (priv->disposed) {
        QTMM_DEBUG ("Already disposed");
        return;
    }

    priv->disposed = TRUE;

    if (priv->plugin_service) {
        g_object_unref (priv->plugin_service);
        priv->plugin_service = NULL;
    }

    G_OBJECT_CLASS (qtmm_plugin_parent_class)->dispose (object);
}

/* Class (type) init */
static void
qtmm_plugin_class_init (QtmMPluginClass *klass)
{
    GObjectClass *object_class;

    QTMM_DEBUG();

    object_class = G_OBJECT_CLASS (klass);

    object_class->dispose     = qtmm_plugin_dispose;

    g_type_class_add_private (klass, sizeof (QtmMPluginPrivate));
}
