/* Copyright (c) 2010, Nokia Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * * Neither the name of the Nokia Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QTMM_DEFS_H_
#define QTMM_DEFS_H_

#include <config.h>
#include <glib.h>

G_BEGIN_DECLS

/* D-BUS names and paths */
#define QTMM_DBUS_BASE          "com.nokia.Qtm.Modest"
#define QTMM_DBUS_COMMON_NAME   QTMM_DBUS_BASE ".Plugin"
#define QTMM_DBUS_OBJ_PATH      "/com/nokia/Qtm/Modest/Plugin"
#define QTMM_DBUS_IFACE_NAME    QTMM_DBUS_COMMON_NAME
#define QTMM_DBUS_ERRORS_PREFIX QTMM_DBUS_COMMON_NAME ".Errors"

/* Email priority values */
#define QTMM_PRIORITY_NORMAL 0
#define QTMM_PRIORITY_LOW    1
#define QTMM_PRIORITY_HIGH   2

/* Enum for status */
typedef enum {
    QTMM_SEARCH_IDLE = 0,
    QTMM_SEARCH_RUNNING,
    QTMM_SEARCH_DONE,
    QTMM_SEARCH_CANCELLED
} QtmmSearchState;

/* Type definition for a custom D-BUS type for HeadersReceived signal */
GType
qtmm_header_info_get_type (void);

/* Type definition for a custom D-BUS type for FolderContentsChanged signal */
GType
qtmm_folder_info_get_type (void);

G_END_DECLS

#endif /* QTMM_DEFS_H_ */
