/* Copyright (c) 2010, Nokia Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * * Neither the name of the Nokia Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Header for the plugin email header search
 */

#ifndef QTMM_SEARCH_H_
#define QTMM_SEARCH_H_

#include <glib.h>

#include <tny-account.h>

#include "qtmm-search.h"
#include "qtmm-defs.h"

G_BEGIN_DECLS

/* GObject type "convenience" macros */
#define QTMM_TYPE_SEARCH            (qtmm_search_get_type())
#define QTMM_SEARCH(obj)            (G_TYPE_CHECK_INSTANCE_CAST(        \
                                         (obj),                         \
                                         QTMM_TYPE_SEARCH,              \
                                         QtmMSearch))
#define QTMM_SEARCH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(           \
                                         (klass),                       \
                                         QTMM_TYPE_SEARCH,              \
                                         QtmMSearchClass))
#define QTMM_IS_SEARCH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE(        \
                                         (obj),                         \
                                         QTMM_TYPE_SEARCH))
#define QTMM_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(  \
                                         (klass),              \
                                         QTMM_TYPE_SEARCH))
#define QTMM_SEARCH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(         \
                                         (obj),                         \
                                         QTMM_TYPE_SEARCH,              \
                                         QtmMSearchClass))

/*
 * The actual "class" definitions
 */
typedef struct _QtmMSearch        QtmMSearch;
typedef struct _QtmMSearchClass   QtmMSearchClass;
typedef struct _QtmMSearchPrivate QtmMSearchPrivate;

struct _QtmMSearch {
    GObject            parent;

    /*<private>*/
    QtmMSearchPrivate *priv;
};

struct _QtmMSearchClass {
    GObjectClass       parent_class;
};

GType qtmm_search_get_type (void) G_GNUC_CONST;

/* Create a new instance with appropriate search parameters */
GObject *
qtmm_search_new (TnyAccount  *account,
                 const gchar *folders[],
                 time_t       begin_time,
                 time_t       end_time,
                 gboolean     sync,
                 gint         op_id);

/* Start the search */
gboolean
qtmm_search_start (QtmMSearch *search);

/* Get the status of the search op */
QtmmSearchState
qtmm_search_get_status (QtmMSearch *search);

/* Get the operation id of the search */
gint
qtmm_search_get_id (QtmMSearch *search);

G_END_DECLS

#endif /* QTMM_SEARCH_H_ */
