/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QWidget>
#include <QPushButton>
#include <QVBoxLayout>
#include <QTextBrowser>
#include <QMaemo5InformationBox>

class ExampleWidget : public QWidget
{
    Q_OBJECT
public:
    ExampleWidget()
    {
        QVBoxLayout *layout = new QVBoxLayout(this);

        QPushButton *bannerButton = new QPushButton("Show a Banner");
        QPushButton *noteButton = new QPushButton("Show a Note");
        QPushButton *complexNoteButton = new QPushButton("Show a complex Note");

        layout->addWidget(bannerButton);
        layout->addWidget(noteButton);
        layout->addWidget(complexNoteButton);

        connect(bannerButton, SIGNAL(clicked()), SLOT(showBanner()));
        connect(noteButton, SIGNAL(clicked()), SLOT(showNote()));
        connect(complexNoteButton, SIGNAL(clicked()), SLOT(showComplexNote()));
    }

public slots:
    void showBanner()
    {
//! [0]
        QMaemo5InformationBox::information(this, "This is a Maemo5 <b>banner</b>",
                                           QMaemo5InformationBox::DefaultTimeout);
//! [0]
    }

    void showNote()
    {
//! [1]
        QMaemo5InformationBox::information(this, "This is a Maemo5 <b>note</b>",
                                           QMaemo5InformationBox::NoTimeout);
//! [1]
    }

    void showComplexNote()
    {
//! [2]
        QMaemo5InformationBox *box = new QMaemo5InformationBox(this);
        QTextBrowser *textBrowser = new QTextBrowser(box);
        textBrowser->setText("This is a Maemo5 <b>note</b> containing custom widget");
        box->setWidget(textBrowser);
        box->setTimeout(QMaemo5InformationBox::NoTimeout);
        box->exec();
//! [2]
    }
};

