/**
 * @file ui_feed.h	UI actions concerning a single feed
 *
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _UI_FEED_H
#define _UI_FEED_H
#include "feed.h"

/** 
 * Handles completed feed update requests.
 *
 * @param request	the completed request
 */
void ui_feed_process_update_result(struct request *request);

/**
 * Updates the feed list entry of the given feed.
 *
 * @param fp		the feed to process
 */
void ui_feed_update(feedPtr fp);

/** Creates feed details dialog
  *
  * @param parent the parent window for the dialog
  * @param fp a pointer to a feed whose details are to be shown
  * @return the feed details dialog
  */
GtkWidget *ui_feed_propdialog_new(GtkWindow * parent, feedPtr fp);

/** Creates add new feed dialog
  *
  * @param parent the parent window for the dialog
  * @return the add new feed dialog
  */
GtkWidget *ui_feed_newdialog_new(GtkWindow * parent, const gchar * source);

/** Returns the add feed dialog to a normal state, which means
  * that the buttons are brought back to a sensitive state and the
  * dialog is made modal again
  */

gboolean newdialog_return_to_normal(gpointer data);

/** Closes the add feed dialog
  */
void newdialog_destroy();

/** Closes the import opml dialog
  */
void importopml_dialog_destroy(void);


/*Temporarly mark the New items as hidden. So we will know for example after 
 * refreshing, what items are realy new, and what was new just before refreshing*/
void ui_feed_set_new_items_hidden(feedPtr fp);

/** Remove the hidden and new attribute from that items, what it has these*/

void ui_feed_remove_hidden_attribute(feedPtr fp);

struct fp_prop_ui_data {
    feedPtr fp;
    folderPtr parent_folder;

    gint flags;                 /* Used by the authdialog to know how to request the feed update */
    gint selector;              /* Desiginates which fileselection dialog box is open.
                                 * Set to 'u' for source
                                 * Set to 'f' for filter */
    gchar *sourceURI;

    GtkWidget *dialog;
    GtkWidget *newfeedbtn;
    GtkWidget *propokbtn;
    GtkWidget *feedNameEntry;
    GtkWidget *feedLocationEntry;
    GtkWidget *downloadImagesEntry;
    GtkWidget *refreshInterval;
    GtkWidget *sourceEntry;
    GtkWidget *selectFile;
    GtkWidget *authcheckbox;
    GtkWidget *credTable;
    GtkWidget *username;
    GtkWidget *password;
    GtkWidget *filter;
    GtkWidget *filterCheckbox;
    GtkWidget *filterbox;
    GtkWidget *filterSelectFile;
    GtkWidget *cacheDefaultRadio;
    GtkWidget *cacheDisableRadio;
    GtkWidget *cacheUnlimitedRadio;
    GtkWidget *cacheLimitedRadio;
    GtkWidget *cacheItemLimit;
    GtkWidget *parent_window;

    GtkWidget *label_widget;
};

/** Enables / disables the ok button on the add new feed dialog */
void enable_sensitive_newfeedbtn(GtkWidget * widget, gpointer user_data);

#endif                          /* _UI_FEED_H */
