/**
 *   @file support.h
 *
 *   Support functions are collected here.
 *
 * Copyright (c) 2005-06 Nokia Corporation. All rights reserved.
 * Contact: Ouyang Qi <qi.ouyang@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) gettext ( String)
#  define C_(String) dgettext("hildon-common-strings", String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


/* Font family thats used with "Keep for later" label in gtkhtml widget */
#define GTKHTML_DEFAULT_FONT_FAMILY "Nokia Sans"

/*
 * Public Functions.
 */

/**
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 * @param widget where to get the widget from
 * @param the name of the wanted widget
 */
GtkWidget *lookup_widget(GtkWidget * widget, const gchar * widget_name);

/** Use this function to set the directory containing installed pixmaps. 
  * @param directory directory for the pixmaps
  */
void add_pixmap_directory(const gchar * directory);


/*
 * Private Functions.
 */

/** This is used to create the pixmaps used in the interface. 
  * @param widget
  * @param filename the pixmap file
  */
GtkWidget *create_pixmap(GtkWidget * widget, const gchar * filename);

/** This is used to create the pixbufs used in the interface. 
  * @param filename the pixbuf file
  */
GdkPixbuf *create_pixbuf(const gchar * filename);

/** Used to create a composite pixbuf loaded from the two files
  * @param filename1: filename of The Folder closed or open icon
  * @param filename2: filename of The plus or minus emblem icon
*/
GdkPixbuf *create_composite_pixbuf(const gchar * filename1,
                                   const gchar * filename2);

/** This is used to set ATK action descriptions. 
  * @param action
  * @param action_name
  * @param description
  */
void glade_set_atk_action_description(AtkAction * action,
                                      const gchar * action_name,
                                      const gchar * description);

/** Alters the font size of a widget
  *
  * @param w the widget whose font size needs to be changed
  * @param dsize either an absolute or relative size
  * @param setIt if TRUE, the size is set as absolute
  * @param bold if the font should be bolded
  */
inline GtkWidget *widget_alter_font_size(GtkWidget * w, int dsize, int setIt,
                                         gboolean bold);
