/**
 * @file ui_search.h everything about searching
 *
 * Copyright (C) 2003, 2004 Lars Lindner <lars.lindner@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _UI_SEARCH_H
#define _UI_SEARCH_H

#include <gtk/gtk.h>

/** This function is called when a search is being initiated by the user.
  * The search is initiated only if the search mode is SFM_NORMAL
  * @param button not used
  * @param user_data not used
  */
void on_searchentry_activate(GtkButton * button, gpointer user_data);

/** If the search results button in the menu is selected the last
  * search results, if any, are displayed to the user
  *
  * @param menuitem not used
  * @param user_data not used
  */
void on_searchresults_menuitem_selected(GtkWidget * menuitem,
                                        gpointer user_data);

/** Frees the searchFeed structure and sets the search results
  * menuitem to an insensitive state
  */
void ui_search_clear_search_results();

gboolean start_search(gpointer data);

#endif
