/**
    @file interface.h
   
    Dialogs and windows for the main application are created here.
  
 * Copyright (c) 2005-06 Nokia Corporation. All rights reserved.
 * Contact: Ouyang Qi <qi.ouyang@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "appdata.h"
#include "ui_feedlist.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

/** Emmited when the window hasn't the focus, to set the needed variables to
  * FALSE
  *
  */
gboolean
window_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer user_data);

/** Creates the main window and menus
  *
  * @param app_ui_data application specific data
  * @return vbox containing the feedlist
  */
GtkWidget *create_mainwindow(AppUIData *);


/** Creates the properties dialog
  *
  * @param unmovable
  * @return the properties dialog
  */
GtkWidget *create_propdialog(gboolean unmovable);

/** Creates the add feed dialog
  *
  * @return the add feed dialog
  */
GtkWidget *create_newdialog(void);

/** Creates the settings dialog
  *
  * @return the settings dialog
  */
GtkWidget *create_prefdialog(void);

/** Creates the new folder dialog
  *
  * @param folder the location of the folder
  * @param parent the parent window that this window is transient for
  * @return the new folder dialog */
GtkWidget *create_newfolderdialog(folderPtr folder,
                                  GtkTreeView * parent_treeview,
                                  GtkWindow * parent);

/** Creates the folder naming dialog
  *
  * @return the folder naming dialog */
GtkWidget *create_foldernamedialog(void);

/** Creates the refresh dialog
  *
  * @return the refresh dialog */
GtkWidget *create_refresh_dialog(void);

/** Creates the manage folders dialog
  *
  * @return the manage folders dialog */
GtkWidget *create_manage_folders_dialog(void);

/** Creates the change folder dialog
  *
  * @param parent the parent window that this window is transient for
  * @return the change folder dialog */
GtkWidget *create_change_folder_dialog(GtkWindow * parent);

/**
 Handle key press event
 @param widget Widget receiving the event.
 @param event The event.
 @param app_ui_data Application data.
 @return TRUE if modifier pressed or known event, FALSE otherwise.
*/
gboolean key_press(GtkWidget * widget, GdkEventKey * event,
                   AppUIData * app_ui_data);

/**
 Handle key release event
 @param widget Widget receiving the event.
 @param event The event.
 @param app_ui_data Application data.
 @return TRUE if modifier pressed or known event, FALSE otherwise.
*/
gboolean key_release(GtkWidget * widget, GdkEventKey * event,
                     AppUIData * app_ui_data);

/** Hardware key presses, up and down arrows, must move in the folder tree
  * in a cyclical manner, which means that pressing the up arrow in the topmost
  * feed moves the cursor to the bottom most feed
  *
  * @param tr tree view to cycle */
gboolean tree_view_cycle_up(GtkWidget * tr);

/** Hardware key presses, up and down arrows, must move in the folder tree
  * in a cyclical manner, which means that pressing the down arrow in the bottom most
  * feed moves the cursor to the topmost feed
  *
  * @param tr tree view to cycle */
gboolean tree_view_cycle_down(GtkWidget * tr);

void refresh_insens_messages(AppUIData * app_ui_data);
//void new_insens_messages(AppUIData * app_ui_data);
void unsubscribe_insens_messages(AppUIData * app_ui_data);
//void set_feed_properties_insens_messages(AppUIData * app_ui_data);
/** Closes all opened dialog.
  *
  * @app_data AppData
  
*/
void close_all_opened_dialog(AppData * app_data);

/** Updating edit menu items; called from idle
 *
 * @user_data pointer to AppData*/
gboolean ui_update_edit_menu( gpointer user_data );
