/*
 * This file is based on unfinished/experimental/abandoned sources from
 * Liferea CVS. The original copyright notice is reproduced here:
 * 
 * 
 * fallback HTML display module, which displays the item view
 * contents in a text widget
 * 
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>  
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <hildon/hildon-defines.h>
#include <hildon/hildon-pannable-area.h>
#include <osso-log.h>
#include <hildon-mime.h>
/* TODO: remove those libxml ?? or any other? */
#include <libxml/xmlerror.h>
#include <libxml/uri.h>
#include <libxml/parser.h>
#include <libxml/HTMLparser.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <time.h>

#define __USE_GNU
#include <string.h>

#include <osso-rss-feed-reader/settings.h>

#include "../common.h"
#include "../conf.h"
#include "../htmlview.h"
#include "../support.h"
#include "../callbacks.h"
#include "../update.h"
#include "../debug.h"
#include "../dbus.h"
#include "../appdata.h"
#include "gtkhtml_plugin.h"
#include "../ui_itemlist.h"
#include "../ui_popup.h"
#include "../item.h"
#include "../conf.h"
#include "../metadata.h"
#include "../debug_new.h"

//TODO:This many needed for file opening???
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>


#include <gtkhtml/gtkhtml.h>
#include <gtkhtml/gtkhtml-search.h>
#include <gtkhtml/gtkhtml-stream.h>
#include <gtkhtml/gtkhtml-embedded.h>
#include "htmlimport.h"

#define ENCLOSURE_ICON_FULLPATH "/usr/share/icons/hicolor/48x48/hildon/rss_reader_openfromserver.png"


static gfloat zoomLevel = 1.0;
const gchar *id_delimiter = "_____";

extern AppData *app_data;
extern nodePtr displayed_node;
static gboolean load_images = FALSE;

typedef struct saveForLater {
    itemPtr ip;
    GtkHTML *ghtml_widget;
} *saveForLaterPtr;

typedef struct _SortData {
    gboolean time;
    gboolean asc;
} SortData;

/* Func prototypes */
/* Free the image request list */
void free_img_request_list(GSList * request_list);
/** 
    Callback for link-clicked event in gtkhtml
*/
static void link_clicked_cb(GtkHTML * html, const gchar * url, gpointer data);


/* Renders description so that img tags have absolute urls */

static gchar *_render_description(itemPtr ptr);


/**
    Not sure where this can be used yet.
*/
void gtkhtml_scroll_to_top(GtkWidget * scrollpane);
/**
  * Count the number of images that will appear in the feed 
  * When displayed
*/
guint gtkhtml_get_fd_number_of_images(feedPtr fp);


#define DOUBLE_CLICK_TIME 0.5

GSList *render_list, *render_list_head;
guint idle_id = 0;
GtkHTMLStream *stream_handle = NULL;

static void stop_rendering();
gchar *gtkhtml_just_render_item(itemPtr ip, gboolean forDisplay);

gint time_compare_func(gconstpointer a, gconstpointer b, gpointer user_data);
void gtkhtml_apply_zoom_level(void);
gboolean htmlview_container_destroy_cb(GtkWidget * widget,
                                       GdkEvent * event, gpointer user_data);
gboolean htmlview_destroy_cb(GtkWidget * widget,
                             GdkEvent * event, gpointer user_data);
gboolean html_event_cb(GtkWidget * widget, GdkEventButton * event,
                       gpointer user_data);
void grab_top_focus();
void grab_focus(GtkHTML * html, gint x, gint y, gboolean forward);
void html_tap_and_hold_cb(GtkWidget * widget);
void gtkhtml_save_for_later_clicked_cb(GtkWidget * widget,
                                       gpointer user_data);
gboolean gtkhtml_save_for_later_destroy_cb(GtkWidget * widget,
                                           gpointer user_data);

/*
 * !!!!!!!!!!!!!!!!!!!!!!!!!1Please fix the TODOs !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 */

/*****************************************************************************/
/*****************************************************************************/
/***************************Embedded objects cb ******************************/
/*****************************************************************************/
/*****************************************************************************/

gboolean gtkhtml_save_for_later_destroy_cb(GtkWidget * widget,
                                           gpointer user_data)
{
    g_assert(widget != NULL);
    g_assert(user_data != NULL);

    saveForLaterPtr sfl = (saveForLaterPtr) user_data;
    //not to free the item...
    sfl->ip = NULL;
    g_free(sfl);
    gtk_widget_destroy(widget);
    return TRUE;
}

/*
 * Callback function for rss_save_for_later check button
 * This button is displayed when displaying a feed,
 * be it a normal feed or a search feed. 
 * 
 * NOTES:
 * **Old: feedPtr fp is rendered from displayed_node
 * **Current: feedPtr fp is now rendered from itemPtr ip, 
 * 
 * TODO: 
 * Things can be a lot simpler if we just include the orig_fp pointer
 * in the saveForLaterPtr struct
 */
void gtkhtml_save_for_later_clicked_cb(GtkWidget * widget, gpointer user_data)
{
    g_assert(NULL != widget);
    g_assert(NULL != user_data);
    feedPtr fp = NULL;
    gboolean mark;
    gchar *object_classid = NULL;
    gchar *title_label = NULL;
    /* CHECK: what happens if the user clicks another feed and quickly also 
     * save for later in the previous feed contents? selected feed might be already different than the one expected. */

    itemPtr ip;
    saveForLaterPtr sfl = (saveForLaterPtr) user_data;


    ip = sfl->ip;
    g_assert(NULL != ip);

    //  If it's a vfolder, should refer to the original_fp to update the feed 
    //in_the_feedlist   *NOT* the virtual folder used for search  
    // then also ip should be the real ip, not the virtual ip used in the vfolder


    if (FST_VFOLDER == feed_get_type(ip->fp)) {
        // get real fp
        fp = (feedPtr) ip->sourceFeed;
    } else                      //just proceeds normally
    {
        fp = (feedPtr) ip->fp;
    }



    g_assert(NULL != fp);
    mark = !item_get_mark(ip);

    item_set_mark(ip, mark);

    object_classid =
        g_strdup_printf("%s%s%d", fp->id, id_delimiter, (int) ip->nr);

    title_label = g_strconcat("title://", object_classid,
                              id_delimiter,
                              item_get_source(ip) ? item_get_source(ip) : "",
                              NULL);

    gtk_html_set_link_visited(sfl->ghtml_widget, title_label, mark);

    g_free(object_classid);
    g_free(title_label);

    if (mark) {
        feed_increase_mark_counter(fp);
        if (feed_get_mark_counter(fp) == 1)
            ui_feedlist_update();

        ULOG_INFO("Item %ld is now marked.\n", ip->nr);
    } else {
        feed_decrease_mark_counter(fp);
        if (feed_get_mark_counter(fp) == 0)
            ui_feedlist_update();
        ULOG_INFO("Item %ld is now unmarked.\n", ip->nr);
    }
    
    gtk_widget_queue_draw(GTK_WIDGET(sfl->ghtml_widget));

    return;
}


/*****************************************************************************/
/*****************************************************************************/
/***************************gtkhtml cb ***************************************/
/*     There's this 3 signals: link_clicked, , object_requested */
/*     And some utility functions like: selecting & copying text, searching  */
/*****************************************************************************/
/*****************************************************************************/
/** Got an net connectivity error 
    Free the request, close the html stream as well */

/**
    Net connected. This function is called from handle_iap_connect
    Puts the request list to a download queue 
*/
static void load_done_cb(GtkWidget * widget, gpointer user_data)
{
    if (!is_image_queue_empty()) {
        if (app_data->app_ui_data->low_mem)
            //just free the requests when low mem. Other wise since
            //low_mem signal is not signaled again until high mem, this will be in OOM
        {
            g_debug("load_done_cb: Low memory so will not download img");
            download_cancel_all(FALSE);
            return;
        }
        app_data->app_ui_data->iap_action =
            OSSO_IAP_DOWNLOAD_IMAGES_FOR_DISPLAY;
        request_iap_connect();
    }
}

#define SCALE_MAX_X 400
#define SCALE_MAX_Y 400

static gboolean write_img_stream(const gchar * buf, gsize count,
                                 GError ** error, gpointer data)
{
    gtk_html_stream_write((GtkHTMLStream *) data, buf, count);

    return TRUE;
}

void write_image(gpointer pstream, gpointer data, size_t size)
{
    GtkHTMLStream *stream = (GtkHTMLStream *) pstream;
    if (!data || size == -1) {
        gtk_html_stream_close(stream, GTK_HTML_STREAM_ERROR);
        return;
    }

    if (size > 50000) {
        GdkPixbuf *pb = NULL;
        GdkPixbufLoader *loader = gdk_pixbuf_loader_new();
        gdk_pixbuf_loader_write(loader, data, size, NULL);
        gdk_pixbuf_loader_close(loader, NULL);
        pb = gdk_pixbuf_loader_get_pixbuf(loader);

        if (pb) {
            g_object_ref(pb);
            double height = gdk_pixbuf_get_height(pb);
            double width = gdk_pixbuf_get_width(pb);

            if (height > SCALE_MAX_Y || width > SCALE_MAX_X) {
                if (SCALE_MAX_Y / (double) height >
                    SCALE_MAX_X / (double) width) {
                    height = floor(SCALE_MAX_X * height / width);
                    width = SCALE_MAX_X;
                } else {
                    width = floor(SCALE_MAX_Y * width / height);
                    height = SCALE_MAX_Y;
                }

                GdkPixbuf *spb = gdk_pixbuf_scale_simple(pb,
                                                         (gint) width, (gint) height, GDK_INTERP_BILINEAR);
                if (gdk_pixbuf_save_to_callback(spb, write_img_stream,
                                            (gpointer) stream, "jpeg", NULL,
                                            NULL) != NULL )
                	{
                gtk_html_stream_close(stream, GTK_HTML_STREAM_OK);

                gdk_pixbuf_unref(spb);
                gdk_pixbuf_unref(pb);
                g_object_unref(loader);
                	}
                return;
            }
            gdk_pixbuf_unref(pb);
        }

        g_object_unref(loader);
    }

    gtk_html_stream_write(stream, data, size);
    gtk_html_stream_close(stream, GTK_HTML_STREAM_OK);
}

static void url_requested_cb(GtkHTML * html, const gchar * url,
                             GtkHTMLStream * stream)
{
    int fd;
    gchar *buf = NULL;
//    size_t size;
	int size = 0; //CID: 17563
    if (url && !strncmp(url, "file:", 5)) {
        url += 5;
        fd = open(url, O_RDONLY);

        if (fd != -1) {
            buf = alloca(8192);
            while ((size = read(fd, buf, 8192)) > 0) {
                gtk_html_stream_write(stream, buf, size);
            }
            gtk_html_stream_close(stream,
                    size == -1
                    ? GTK_HTML_STREAM_ERROR
                    : GTK_HTML_STREAM_OK);
            close(fd);

            return;
        }
    } else
        if ((buf =
                    file_cache_find(app_data->app_ui_data->img_cache, url, &size,
                        TRUE))) {
            //try to find it in the cache
            write_image((gpointer) stream, buf, size);
            g_free(buf);
        } else if (url) {
            gboolean load_image = app_data->app_ui_data->load_url &&
                (strcmp(app_data->app_ui_data->load_url, url) == 0);
            if ((load_image
                        || (load_images
                            && feed_get_download_images((feedPtr) displayed_node)))
                    && (app_data->app_ui_data->search_mode != SFM_SEARCH)) {
                //URL reqested from the internet
                download_queue_image(url, (gpointer) stream, load_image);
                if (load_image)
                    load_done_cb(GTK_WIDGET(html), NULL);
            } else
                gtk_html_stream_close(stream, GTK_HTML_STREAM_ERROR);
        }

    return;
}

void post_url(const gchar * url, gboolean bluetooth)
{
    gchar *object_id = NULL;
    gchar **tmp = NULL;         //array of strings 
    feedPtr fp = NULL;
    itemPtr ip = NULL;
    gulong ip_nr = 0;

    if (url != NULL) {

        if (strncmp(url, "email://", 8) == 0) {
            object_id = g_strdup(url + 8);

            /* get the feed id and item id */
            tmp = g_strsplit((const gchar *) object_id,
                             (const gchar *) id_delimiter, 2);

        } else if (strncmp(url, "title://", 8) == 0) {
            object_id = g_strdup(url + 8);

            /* get the feed id and item id */
            tmp = g_strsplit((const gchar *) object_id,
                             (const gchar *) id_delimiter, 3);
        }

        if (tmp) {
            if (displayed_node) {
                if ((FST_FEED == displayed_node->type) ||
                    (FST_VFOLDER == displayed_node->type))
                    fp = (feedPtr) displayed_node;
            }

            if (fp && (strcmp(fp->id, tmp[0]) != 0) && (fp->type != FST_VFOLDER)) {
                g_warning("we are rendering some _real_ feed "
			  "which is not the tobe displayed feed!!!ERRORS\n\n");
                // free stuff
                g_strfreev(tmp);

                return;
            }

            ip_nr = (gulong) g_strtod(tmp[1], NULL);
            if (fp) ip = feed_lookup_item_by_nr_extended(fp, ip_nr, tmp[0]);

            if (ip == NULL) {
                g_warning
                    ("email clicked, couldn't find item pointer,something\
                have gone seriously wrong with the html content render");
                g_strfreev(tmp);

                return;
            }

            if (bluetooth) {
                gchar *content = gtkhtml_just_render_item(ip, FALSE);
                if (content) {
                    const gchar *title = item_get_title(ip);
                    if (!title)
                        title = "RSS Reader Feed";
                    bt_send(title, (gpointer) content, strlen(content));
                    g_free(content);
                }
            } else
                send_item(ip, bluetooth);

            g_strfreev(tmp);
            g_free(object_id);
        } else {
            //just send the url
            if (bluetooth) {
                gchar *tmp =
                    g_strconcat("<html><head><META HTTP-EQUIV=\"Refresh\"",
                                " CONTENT=\"0; URL=", url,
                                "\"</head><a href=\"", url, "\">", url,
                                "</a></html>", NULL);
                bt_send("RSS Reader URL", (gpointer) tmp, strlen(tmp));
                g_free(tmp);
            } else
                send_text_via_email(url);
        }
    }
}

gchar *strip_url(const gchar * url)
{
    gchar *url_tmp = NULL;
    if (url) {
        if (strncmp(url, "title://", 8) == 0) {
            gchar **tmp = g_strsplit((const gchar *) (url + 8),
                                     (const gchar *) id_delimiter, 3);
            url_tmp = g_strdup(trim_whitespaces(tmp[2]));
            g_strfreev(tmp);
        } else
            url_tmp = g_strdup(trim_whitespaces((gchar *) url));
    }

    return url_tmp;
}

void invoke_url(const gchar * url)
{
    if (app_data->app_ui_data->low_mem) {
        hildon_banner_show_information(GTK_WIDGET
                                       (app_data->app_ui_data->main_view),
                                       NULL, dgettext("ke-recv",
                                                      "memr_ib_operation_disabled"));
        return;
    }

    gchar *uri = strip_url(url);

    if (uri && *uri) {
        HildonURIAction *action = NULL;
        GSList *actions = NULL;

        if (!(action = hildon_uri_get_default_action_by_uri(uri, NULL))) {
            if ((actions = hildon_uri_get_actions_by_uri(uri, -1, NULL)))
                action = (HildonURIAction *) actions->data;
        }
        if (!action || !hildon_uri_open(uri, action, NULL)) {
            open_url((gchar *) uri);
        }
        if (actions)
            hildon_uri_free_actions(actions);

    }
    g_free(uri);
}

/* handler for normal links in description clicked 
 * behaviour: launch browser 
 * links can be normal links or 
 * email://feedid_____itemid
 * 
 */

static void link_clicked_cb(GtkHTML * html, const gchar * url, gpointer data)
{

    g_assert(app_data != NULL);

    gtk_widget_queue_draw(GTK_WIDGET(html));

    if (!strncmp(url, "email://", 8)) {
        post_url(url, FALSE);
    } else {
        invoke_url(url);
    }
}

/* handlers for the adding the widget: Save for later */
static gboolean object_requested_cb(GtkHTML * html, GtkHTMLEmbedded * ew)
{
    feedPtr fp = NULL;
    itemPtr ip = NULL;
    GtkWidget *save_for_later = NULL;
    GtkCheckButton *check_button = NULL;
    GtkWidget *fixedcont = NULL;
    GtkRequisition req;

    gchar *tmp1 = NULL;
    gchar **tmp = NULL;         //array of strings 
    gulong nr = 0;

    /*classid should be of the form
     * "parentfeedID""id_delimiter"itemID""id_delimiter"[title|time|sfl|sep|email]
     */

    if (NULL == ew->classid)
        return FALSE;
    /* TODO: Should be put in
     * if  ( strcmp (ew->classid, id_delimiter) != 0) 
     * return  FALSE;
     */
    tmp = g_strsplit((const gchar *) ew->classid,
                     (const gchar *) id_delimiter, 3);

    //now we got fd_id, ip_id, lable_id. What next?

    //get current fp

    if (displayed_node) {
        if ((FST_FEED == displayed_node->type) ||
            (FST_VFOLDER == displayed_node->type))
            fp = (feedPtr) displayed_node;
    } else {
        g_warning
            ("object_requested_cb: ERROR why calling this when displayed_node == NULL???\
                    \n\n");
        return FALSE;
    }
    if (!fp || ((strcmp(fp->id, tmp[0]) != 0) && (fp->type != FST_VFOLDER))) {
        fprintf(stderr,
                "object_requested_cb: we are rendering some _real_ feed \
                    which is not the tobe displayed feed!!!ERRORS\n\n");
        return FALSE;
    }
    nr = (gulong) g_strtod(tmp[1], NULL);
    ip = feed_lookup_item_by_nr_extended(fp, nr, tmp[0]);
    if (ip == NULL) {
        g_warning
            ("\n\n\n\nERROR here feed id = %s, nr = %d, tmp = %s,\n\n\n\n",
             fp->title, (int) nr, tmp[0]);

        g_debug
            ("object_requested_cb: ERROR Something's wrong with the lookup_item_by_id\n**********\
            **************************************************************\n");
        return FALSE;

    }

    if (strcmp(tmp[2], "sfl") == 0) {
        /* Note spec changed so that title is just a link. No change in color */
        /* Save for later checkbox */


        gchar *link = NULL;

        link =
            g_strconcat("title://", tmp[0], id_delimiter, tmp[1],
                        id_delimiter, item_get_source(ip), NULL);
        gtk_html_set_link_visited(html, link, item_get_mark(ip));
        g_free(link);

        save_for_later = gtk_label_new(NULL);
        gtk_widget_show(GTK_WIDGET(save_for_later));
        tmp1 =
            g_strdup_printf
            ("<span foreground=\"blue\" underline=\"single\" size=\"large\">%s</span>",
             _("rss_ia_save_for_later"));
        gtk_label_set_markup(GTK_LABEL(save_for_later), tmp1);
        g_free(tmp1);
        gtk_label_set_use_underline(GTK_LABEL(save_for_later), TRUE);
        widget_alter_font_size(save_for_later, FONT_SIZE, TRUE, FALSE);
        gtk_widget_show(GTK_WIDGET(save_for_later));

        check_button = GTK_CHECK_BUTTON(gtk_check_button_new());

        GTK_TOGGLE_BUTTON(check_button)->active = item_get_mark(ip);

        gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(check_button), TRUE);
        gtk_widget_show(GTK_WIDGET(check_button));
        gtk_button_set_relief(GTK_BUTTON(check_button), GTK_RELIEF_NONE);
        gtk_container_add(GTK_CONTAINER(check_button),
                          GTK_WIDGET(save_for_later));
        gtk_container_set_border_width(GTK_CONTAINER(check_button), 0);

        gtk_widget_size_request(GTK_WIDGET(check_button), &req);
        fixedcont = gtk_fixed_new();
        gtk_widget_set_size_request(GTK_WIDGET(fixedcont), req.width + 3,
                                    req.height + 1);
        gtk_fixed_put(GTK_FIXED(fixedcont), GTK_WIDGET(check_button), 2, 6);
        gtk_container_set_border_width(GTK_CONTAINER(fixedcont), 0);
        gtk_widget_show(GTK_WIDGET(fixedcont));

        /* two ways:
         * 1. Pass the label usng ip->titleLabel 
         * 2. Use gpointer    gtk_html_get_object_by_id       (GtkHTML *html,
         * const gchar *id);
         * 
         */
        saveForLaterPtr sfl = g_new0(struct saveForLater, 1);
        sfl->ip = ip;
        sfl->ghtml_widget = html;

        g_signal_connect((gpointer) check_button, "toggled",
                         G_CALLBACK(gtkhtml_save_for_later_clicked_cb), sfl);
        g_signal_connect((gpointer) check_button, "destroy",
                         G_CALLBACK(gtkhtml_save_for_later_destroy_cb), sfl);

        /* Now embed it in */
        gtk_container_add(GTK_CONTAINER(ew), GTK_WIDGET(fixedcont));
    } else
        g_warning
            ("object_requested_cb: Why other objects than sfl??.Somethig wrong");

    // free stuff
    g_strfreev(tmp);
    return TRUE;
}

/** 
  Asking embedded browser component to find (and highlight) a text
  within the current HTML view.

  @note Highlight does not happen in Browser

  @param str text to find
  @param rewind TRUE: find at beginning, FALSE: find next
  @param retval_ref: set to TRUE if a match did occur (FALSE = no match)

  @return TRUE if browser call succeeded, FALSE if not
*/
gboolean gtkhtml_find_cb(GtkWidget * scrollpane,
                         const gchar * str,
                         gboolean rewind, gboolean * retval_ref)
{
    if (rewind) {
        *retval_ref =
            gtk_html_engine_search(GTK_HTML
                                   (gtk_bin_get_child(GTK_BIN(scrollpane))),
                                   str, FALSE, TRUE, FALSE);
    } else {
        *retval_ref =
            gtk_html_engine_search_next(GTK_HTML
                                        (gtk_bin_get_child
                                         (GTK_BIN(scrollpane))));
    }

    return TRUE;                // always

}

void html_tap_and_hold_cb(GtkWidget * widget)
{
    gint x, y;
    GtkAdjustment *adjustment = NULL;
    GtkHTML *html;
    HTMLEngine *engine;
    HTMLObject *obj;
    guint offset = 0;
    gchar *url = NULL;
    GtkWidget *parent = NULL;
    GdkEventButton eb = { 0 };
    gboolean res;
    gboolean show = FALSE;

    /* overwrite function parameter */
    widget = GTK_WIDGET(gtk_bin_get_child(GTK_BIN(app_data->app_ui_data->html_scrollpane))); 
    parent = GTK_WIDGET(app_data->app_ui_data->html_scrollpane);
    gtk_widget_get_pointer(widget, &x, &y);
//    if ((parent = gtk_widget_get_parent(widget))) {
    if (parent) {
        adjustment =
//            gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(parent));
            hildon_pannable_area_get_hadjustment(HILDON_PANNABLE_AREA(parent));
        x += adjustment->value;
        adjustment =
//            gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(parent));
            hildon_pannable_area_get_vadjustment(HILDON_PANNABLE_AREA(parent));
        y += adjustment->value;
    }

    html = GTK_HTML(widget);
    engine = html->engine;
    obj = html_engine_get_object_at(engine, x, y, &offset, FALSE);

    if (obj) {
        url = (gchar *) html_object_get_url(obj, offset);

        app_data->app_ui_data->context_url = url;

        if (HTML_IS_IMAGE(obj)) {
            app_data->app_ui_data->image_url =
                HTML_IMAGE0(obj)->image_ptr->url;
            app_data->app_ui_data->image_object = (gpointer) obj;

            show = setup_context_popup(4);
        } else {
            app_data->app_ui_data->image_url = NULL;
            app_data->app_ui_data->image_object = NULL;

            if (HTML_IS_TEXT(obj)) {
                if (url && *url && (strncmp(url, "email://", 8) != 0)) {
                    show = setup_context_popup(3);
                } else
                    show = setup_context_popup(6);
            } else {
                show = setup_context_popup(6);
            }
        }
    } else
        show = setup_context_popup(6);

    gtk_widget_queue_draw(widget);

    if (!show)
        return;

    //send a button release event before the menu appear
    //otherwise after closing the menu an unwanted scrolling will happen...
    eb.type = GDK_BUTTON_RELEASE;
    eb.window = widget->window;
    eb.button = 1;
    //need to free the pointer_url otherwise the link_clicked_cb will be called
    //and the url will be marked as visited
    g_free(html->pointer_url);
    html->pointer_url = NULL;
    g_signal_emit_by_name(widget, "button_release_event", &eb, &res, 0);

    if (app_data->app_ui_data->bt_file != NULL)
        return;

    gtk_menu_popup(app_data->app_ui_data->context_menu, NULL, NULL, NULL,
                   NULL, 0, gtk_get_current_event_time());
}

#define FOCUS_BORDER_X 20
#define FOCUS_BORDER_Y 0

void grab_focus(GtkHTML * html, gint x, gint y, gboolean forward)
{
    HTMLObject *obj = NULL;
    guint offset = 0;
    gint height = 0;

    if (!html)
        html = GTK_HTML(gtk_bin_get_child
                        (GTK_BIN(app_data->app_ui_data->html_scrollpane)));

    height = html_engine_get_doc_height(html->engine);

    //search for a focusable object
    while (!obj || html_object_is_container(obj)) {
        obj = html_engine_get_object_at(html->engine, x, y, &offset, TRUE);

        if (!obj || html_object_is_container(obj)) {
            if (forward) {
                /*make sure the loop will not be infinite fix NB#79981 */
                if (y < height - 5)
	                y += 5;
		else
			break;
	    } else {
                /*make sure the loop will not be infinite fix NB#79981*/
                if (5 < y)
                	y -= 5;
		else
			break;
	    }
        }
    }

    if (obj != NULL)
        g_object_set_data(G_OBJECT(html), "last-focus", (gpointer) obj);
}

void grab_top_focus()
{
    gint x, y;
    GtkAdjustment *adj;
//    GtkScrolledWindow *parent;
    HildonPannableArea *parent;

//    parent = GTK_SCROLLED_WINDOW(app_data->app_ui_data->html_scrollpane);
    parent = HILDON_PANNABLE_AREA(app_data->app_ui_data->html_scrollpane);

//    adj = gtk_scrolled_window_get_vadjustment(parent);
    adj = hildon_pannable_area_get_vadjustment(parent);
    y = adj->value + FOCUS_BORDER_Y;
//    adj = gtk_scrolled_window_get_hadjustment(parent);
    adj = hildon_pannable_area_get_hadjustment(parent);
    x = adj->value + FOCUS_BORDER_X;

    grab_focus(GTK_HTML(gtk_bin_get_child(GTK_BIN(parent))), x, y, TRUE);
}

/* Try to find if the focused object is scrolled out of the view, if yes,
 * find the next focusable object from top or bottom depending from forward */
void gtkhtml_grab_cond_focus(gboolean forward)
{
//    GtkScrolledWindow *parent;
    HildonPannableArea *parent;
    GtkHTML *html;
    HTMLObject *obj;
    gint offset, x, y, ox, oy;
    GtkAdjustment *adj;

//    parent = GTK_SCROLLED_WINDOW(app_data->app_ui_data->html_scrollpane);
    parent = HILDON_PANNABLE_AREA(app_data->app_ui_data->html_scrollpane);
    html = GTK_HTML(gtk_bin_get_child(GTK_BIN(parent)));
    obj = html_engine_get_focus_object(html->engine, &offset);

//    adj = gtk_scrolled_window_get_vadjustment(parent);
    adj = hildon_pannable_area_get_vadjustment(parent);
    y = adj->value + FOCUS_BORDER_Y;
//    adj = gtk_scrolled_window_get_hadjustment(parent);
    adj = hildon_pannable_area_get_hadjustment(parent);
    x = adj->value + FOCUS_BORDER_X;

    if (obj)
        html_object_calc_abs_position(obj, &ox, &oy);

    if (!obj || oy < y ||
        oy > y + GTK_WIDGET(parent)->allocation.height - 2 * FOCUS_BORDER_Y) {
        if (forward)
            grab_focus(html, x, y, forward);
        else
            grab_focus(html, x,
                       y + GTK_WIDGET(parent)->allocation.height -
                       2 * FOCUS_BORDER_Y, forward);
    }
}

#define GTK_TAP_THRESHOLD 16

/* This function together with grab_focus is part of a hack that enables
 * correct spatial navigation. When moving focus between links with the arrow
 * buttons, a tap somewhere in the gtkhtml view will set the focus back to the
 * first item. This hack sets the focus to the first link under the tap
 * position. 
 */
/* TODO: This functionality should be done in gtkhtml, but now we don't
 * have time to wait for them to include it now. Bug filed to diablo
 * (NB#73877). Please remove it, when the feature is implemented in gtkhtml.
 */
gboolean html_event_cb(GtkWidget * widget, GdkEventButton * event,
                       gpointer user_data)
{
    grab_focus(NULL, (gint) event->x, (gint) event->y, TRUE);
    return FALSE;
}

/**
  Find out if text is selected 
  @param 
  @param retval_ref: set to TRUE if text selected, FALSE if none

  @return TRUE: selection available (for copy), FALSE: no selection
*/
gboolean htmlwidget_has_selection(GtkWidget * scrollpane)
{

    if (gtk_html_command(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))),
                         "is-selection-active")) {
        gint len = -1;
        gchar *sel =
            gtk_html_get_selection_html(GTK_HTML
                                        (gtk_bin_get_child
                                         (GTK_BIN(scrollpane))), &len);
        gboolean result = sel && *sel;
        g_free(sel);

        return result;
    }

    return FALSE;
}

/**
  htmlview clipboard copy

  @param 

  @return TRUE if text copied to clipboard, FALSE if not
    for the sake of having an inteface for different plugins
    this function should return gboolean

*/
void htmlwidget_copy_selection(GtkWidget * scrollpane)
{
    gtk_html_copy(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
    return;                     // always
}

void gtkhtml_selectall(void)
{
    //TODO: to avoid crash: Un-focus any focused object here first 
    GtkBin *bin = GTK_BIN(app_data->app_ui_data->html_scrollpane);

    GtkAdjustment *adj =
//        gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(bin));
         hildon_pannable_area_get_vadjustment(HILDON_PANNABLE_AREA(bin));
    GtkHTML *html = GTK_HTML(gtk_bin_get_child(bin));
    html_engine_select_region(html->engine, 10, 20, 300, adj->upper + 20);
    return;
}

/*****************************************************************************/
/*****************************************************************************/
/****************************** Parsing the source ***************************/
/*                  gchar *rendered_content is used as a global string         */
/*        TODO: for better (will it?) use, make these functions return a     */
/*          string, rather  than modifying the global string directly        */
/*****************************************************************************/
/*****************************************************************************/
/** Renders the content for the top of the page
  @param: fd    Feed pointer of the feed being displayed
  @return: Feed figures with last time refreshed, title in 
        html format
*/

gchar *gtkhtml_render_head(feedPtr fd)
{

    gchar *tmp = NULL;
    gchar *ret = NULL;
    gchar *format_date = NULL;
    gchar *title = NULL;

    if (!fd) {
        return NULL;
    }
    //feed title is never NULL.
    title = g_strdup(fd->title);
    //need to display the text as it is
    title = utf8_fix((xmlChar *)title);    //fix UTF8 first
    tmp = g_markup_escape_text(title, -1);
    g_free(title);

    if (tmp == NULL)
        ret = NULL;
    else {
        if (fd->lastPoll.tv_sec != 0)
            format_date =
                ui_itemlist_format_date((time_t) fd->lastPoll.tv_sec);
        else
            format_date = g_strdup(" ");

        ret =
            g_strconcat("<a name=\"top_of_page\">", tmp, "<br>", format_date,
                        "<br>", NULL);

        g_free(format_date);
    }

    if (tmp != NULL)
        g_free(tmp);
    return ret;
}

/** Renders the html content for an empty feed
    @Return: "no posts" text
*/
gchar *gtkhtml_render_empty_feed()
{
    gchar *no_posts = g_strdup(_("rss_ia_no_posts"));
    return no_posts;

}


/**

    Embedded objects will have this form
    <OBJECT CLASSID=%s>%s</OBJECT>"
    where classid is of the following format:
       "parentfeedID""id_delimiter"item->nr""id_delimiter"[title|time|sfl|sep|email]
    id_delimiter is declared globally, and currently being "____"
    Only "sfl" is used now. Time , sep, and email are not objects
    Some more suitable ipseparator should be used i think 
*/

/** Only renders the html content of the item.
    @param: ip  The item pointer
    @return:  the item html source
*/
gchar *gtkhtml_just_render_item(itemPtr ip, gboolean forDisplay)
{
    gchar *object_classid = NULL;   //of format feedId___itemId___
    gchar *rendered_anchor = NULL;
    gchar *title = NULL;
    gchar *rendered_title = NULL;
    gchar *rendered_sep = NULL;
    gchar *rendered_timedate = NULL;
    gchar *rendered_sfl = NULL;
    gchar *rendered_description = NULL;
    gchar *tmp = NULL;
    gchar *tmp_img = NULL;
    gchar *title_label = NULL;
    feedPtr fp;
    gchar *enclosures = NULL;
    gchar *encl_length = NULL;
    gint formatlegth = 0, lengthtype = 0;
    struct enclosure_attribute *encl_attr = NULL;
    GSList *attriblist = NULL;

    if (ip == NULL) {
        g_warning("gtkhtml_just_render_item: ERROR: parsing item NULL");
        return NULL;
    }
    // If we're rendering vfolder then we should refer to the real fp 
    if (((nodePtr) ip->fp)->type == FST_VFOLDER)
        fp = ip->sourceFeed;
    else
        fp = ip->fp;

    if ((gchar *) fp->id != NULL)
        object_classid =
            g_strdup_printf("%s%s%d", fp->id, id_delimiter, (int) ip->nr);
    /* Add an anchor here for easy scroll_to_item(ip) func */
    /* Anchor name is object_classid which is fpid_____ipid and unique for any item */
    if (forDisplay)
        rendered_anchor =
            g_strconcat("<a name = \"", object_classid, "\"></a><br>", NULL);
    else
        rendered_anchor = g_strdup("");

    /*Render item title */
    if (item_get_title(ip) == NULL) {
        //set to ip->source if no title
        if (item_get_source(ip) != NULL)
            tmp = g_strdup(item_get_source(ip));
        else
            tmp = NULL;         // or we can do: tmp = g_strdup("-");
    } else
        tmp = g_strdup(item_get_title(ip));

    if (tmp) {
        remove_newlines_and_extra_spaces(tmp);
        title = g_markup_printf_escaped("<b><u>%s</u></b>", tmp);
        g_free(tmp);
    } else
        title = NULL;

    if (forDisplay)
        title_label = g_strconcat("title://", object_classid,
                                  id_delimiter, NULL);

    if (title) {                //then title shouldn't be NULL
        rendered_title =
            g_strconcat("<a href =\" ",
                        forDisplay ? title_label : "",
                        item_get_source(ip) ? item_get_source(ip) : "",
                        "\">", title, "</a>", NULL);
    } else                      // no title
        rendered_title = g_strdup("");
    g_free(title_label);
    g_free(title);

    if (forDisplay) {
        tmp = ui_itemlist_format_date((time_t) ip->time);
        rendered_timedate = g_markup_printf_escaped("<i>%s</i>", tmp);
        g_free(tmp);
    } else
        rendered_timedate = g_strdup(" ");

    if (forDisplay) {
        /*render save for later */
        tmp = g_strconcat(object_classid, id_delimiter, "sfl", NULL);
        rendered_sfl = g_strconcat("<OBJECT CLASSID=\"",
                                   tmp, "\">", _("rss_ia_save_for_later"),
                                   "</OBJECT><br>", NULL);
        g_free(tmp);
    } else
        rendered_sfl = g_strdup("");

    rendered_sep = g_strdup("<b>| </b> ");

    attriblist = metadata_list_get(ip->metadata, "enclosure");
    if (attriblist) {
        while (attriblist) {
            encl_attr = (struct enclosure_attribute *) attriblist->data;
            if (enclosures)
                enclosures = g_strconcat(enclosures, "<br>", NULL);
            else
                enclosures = g_strdup("");

            if (forDisplay)
                tmp_img = g_strconcat("<img src=\"file://",
                                      ENCLOSURE_ICON_FULLPATH, "\"></img> ",
                                      NULL);
            else
                tmp_img =
                    encl_attr->ul ? g_strdup(encl_attr->ul) : g_strdup("");

            if (encl_attr->ul)
                enclosures =
                    g_strconcat(enclosures, "<a href=\"", encl_attr->ul,
                                "\">", tmp_img, "</a> ", NULL);
            else
                enclosures = g_strconcat(enclosures, tmp_img, NULL);

            if (encl_attr->type) {
                enclosures =
                    g_strconcat(enclosures, " ", encl_attr->type, NULL);
            }
            if (encl_attr->length > 0) {
                formatlegth = encl_attr->length;
                /*Lets format the length */
                if (formatlegth > 1024) {   /* KB */
                    formatlegth = formatlegth / 1024;
                    lengthtype = 1;
                    if (formatlegth > 1024) {   /* MB */
                        formatlegth = formatlegth / 1024;
                        lengthtype = 2;
                    }
                }
                encl_length = g_new0(gchar, 6);
                encl_length = g_ascii_dtostr(encl_length, 5, formatlegth);
                if (encl_attr->type) {
                    enclosures = g_strconcat(enclosures, "<b> | </b>", NULL);
                } else {
                    enclosures = g_strconcat(enclosures, "  ", NULL);
                }
                enclosures = g_strconcat(enclosures, encl_length, NULL);
                switch (lengthtype) {
                    case 0:
                        enclosures = g_strconcat(enclosures, " B", NULL);
                        break;
                    case 1:
                        enclosures = g_strconcat(enclosures, " KB", NULL);
                        break;
                    case 2:
                        enclosures = g_strconcat(enclosures, " MB", NULL);
                        break;
                }
                g_free(encl_length);
                encl_length = NULL;
            }

            attriblist = g_slist_next(attriblist);

        }
        enclosures = g_strconcat(enclosures, "<br>", NULL);
    } else {
        enclosures = g_strdup("");
    }

    rendered_description = _render_description(ip);

    tmp = g_strconcat("<br>", rendered_anchor, rendered_title,
                      rendered_description ? "<br>" : "",
                      rendered_description ? rendered_description : "",
                      "<br>", enclosures,
                      rendered_timedate, rendered_sfl, NULL);

    /*free stuff */
    g_free(object_classid);
    g_free(rendered_anchor);
    g_free(rendered_title);
    g_free(rendered_timedate);
    g_free(rendered_description);
    g_free(rendered_sfl);
    g_free(rendered_sep);
    g_free(enclosures);

    return tmp;
}


/******************************************************************************/
/******************************************************************************/
/****************************** HtmlPluginInfo cb *****************************/
 /**/
/******************************************************************************/
/******************************************************************************/
/** destroy callback for the htmlview GTKHTML widget
  * TODO: Not connected yet. Due to this error :
  * #0  0x40bae40c in g_type_check_instance_cast () from /usr/lib/libgobject-2.0.so.0
  * Hopefully without this, htmlview_container_destroy_cb will 
  * destroy its children too. TODO: But there's still leaks
  * with this GtkHtml widget. Perhaps the library?
*/
    gboolean htmlview_destroy_cb(GtkWidget * widget,
                                 GdkEvent * event, gpointer user_data)
{
    GtkWidget *htmlview = (GtkWidget *) user_data;
    if (user_data != NULL)
        gtk_widget_destroy(GTK_WIDGET(htmlview));
    return TRUE;

}

/** destroy callback for gtkhtml_htmlview */
gboolean htmlview_container_destroy_cb(GtkWidget * widget,
                                       GdkEvent * event, gpointer user_data)
{
    if (app_data->app_ui_data->html_scrollpane != NULL)
        gtk_widget_destroy(GTK_WIDGET
                           (app_data->app_ui_data->html_scrollpane));

    return TRUE;

}

/** init anything required to run gtkhtml lib
  * NOTES: gnome and gconf are required but they should have been
  * done by news reader before getting to this call
  * Functions are ordered as in the htmlpluginfo struct 
*/
void gtkhtml_init()
{
    /* init gnome & gconf???
     * Should have been done?? */
}


void gtkhtml_deinit()
{
    g_return_if_fail(app_data || app_data->app_ui_data ||
                     app_data->app_ui_data->htmlwidget);

    stop_rendering();

    if (!G_IS_OBJECT(app_data->app_ui_data->htmlwidget))
        return;

    GTimer *tm =
        g_object_get_data(G_OBJECT(app_data->app_ui_data->htmlwidget),
                          "click-timer");
    if (tm)
        g_timer_destroy(tm);
}

/** Creates a new gtkhtml widget and a scrollbar to contain it
  * Also creates a hidden gtkhtml widget that can be used later
  * to count the number of imates in a feed

  @return: The gtkhtml widget, stored in app_ui_data struct
*/
GtkWidget *gtkhtml_new()
{
    g_assert(NULL != app_data->app_ui_data);

    GtkWidget *htmlview = NULL;
    GtkWidget *gtkhtml_scrollpane = NULL;

    /* Now to the real html widget */
    app_data->app_ui_data->htmlwidget = htmlview = gtk_html_new();
    gtk_widget_set_double_buffered(GTK_WIDGET(htmlview), FALSE);

    gtk_html_allow_selection(GTK_HTML(htmlview), TRUE);
    g_object_set_data(G_OBJECT(htmlview), "click-timer", NULL);

    /* connect signals */
    g_signal_connect(GTK_HTML(htmlview), "url_requested",
                     G_CALLBACK(url_requested_cb), NULL);
    g_signal_connect(GTK_HTML(htmlview), "link_clicked",
                     G_CALLBACK(link_clicked_cb), NULL);
    g_signal_connect(GTK_HTML(htmlview), "object_requested",
                     G_CALLBACK(object_requested_cb), NULL);
    g_signal_connect(GTK_HTML(htmlview), "load_done",
                     G_CALLBACK(load_done_cb), NULL);
    g_signal_connect(G_OBJECT(htmlview), "button_press_event",
                     G_CALLBACK(html_event_cb), NULL);
    g_signal_connect_after(G_OBJECT(htmlview), "tap-and-hold",
                           G_CALLBACK(html_tap_and_hold_cb), NULL);
    gtk_widget_tap_and_hold_setup(GTK_WIDGET(htmlview), NULL, NULL,
                                  GTK_TAP_AND_HOLD_NONE);

    /* TODO: better free app_ui_data -> html_scrollpane here. Just in case */
    app_data->app_ui_data->html_scrollpane = gtkhtml_scrollpane =
//        gtk_scrolled_window_new(NULL, NULL);
//    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(gtkhtml_scrollpane),
//                                   GTK_POLICY_AUTOMATIC,
//                                   GTK_POLICY_AUTOMATIC);
      hildon_pannable_area_new();                                   

    g_object_set (app_data->app_ui_data->html_scrollpane, "hovershoot_max",0,"vovershoot-max",0,NULL);
        
    gtk_container_add(GTK_CONTAINER(gtkhtml_scrollpane),
                      GTK_WIDGET(htmlview));
    g_signal_connect(G_OBJECT(gtkhtml_scrollpane), "destroy",
                     G_CALLBACK(htmlview_container_destroy_cb), NULL);

    GdkColor base;
    GdkColor text;

    gdk_color_parse ("#fff", &base);
    gdk_color_parse ("#000", &text);
    gtk_widget_modify_base ( htmlview, GTK_STATE_NORMAL, &base);
    gtk_widget_modify_text (htmlview, GTK_STATE_NORMAL, &text);

    gtk_widget_show_all(gtkhtml_scrollpane);

    return gtkhtml_scrollpane;
}

void gtkhtml_apply_zoom_level(void)
{
    AppUIData *app_ui_data;
    g_assert(app_data != NULL);
    app_ui_data = app_data->app_ui_data;
    gtk_html_set_magnification(GTK_HTML
                               (gtk_bin_get_child
                                (GTK_BIN(app_ui_data->html_scrollpane))),
                               app_ui_data->zoom_level);
}

gint time_compare_func(gconstpointer a, gconstpointer b, gpointer user_data)
{
    itemPtr itema, itemb;

    itema = (itemPtr) a;
    itemb = (itemPtr) b;

    SortData *data = (SortData *) user_data;

    gint result = 0;

    if (data->time) {
        time_t timea, timeb;

        timea = itema->time;
        timeb = itemb->time;

        result = data->asc ? (timeb - timea) : (timea - timeb);
    } else {
        result = g_utf8_collate(itema->title ? itema->title : "",
                                itemb->title ? itemb->title : "");
        if (data->asc)
            result = -result;
    }

    return result;
}

/** Writes a feed content to the htmlwidget contained in scrollpane
  * Will do the content rendering as well

  @param: scrollpane: Scroll widget containing the gtkhtml widget. This 
    is normally the gtkhtml_widget in app_ui_data
  @string: string content to write to the page. NOT USED.Something
    from textview plugin.
  @Base: Not used. Some leftover from textview plugin
  @node: The node to be displayed, be it a real feed, or a virtual (search)
    feed.

*/

static gboolean render_one_item(gpointer data)
{
    gchar *item_content = NULL;
    itemPtr ip = NULL;

    if (render_list && stream_handle) {
        ip = (itemPtr) render_list->data;

        item_content = gtkhtml_just_render_item(ip, TRUE);

        if (item_content) {
            gtk_html_stream_write(stream_handle, (const gchar *) item_content,
                                  -1);
        }

        g_free(item_content);

        render_list = g_slist_next(render_list);
    }

    if (!render_list) {
        if (stream_handle) {
            gtk_html_stream_close(stream_handle, GTK_HTML_STREAM_OK);
            stream_handle = NULL;
        }

        if (app_data->app_ui_data->scroll_to_feed == displayed_node &&
            app_data->app_ui_data->scroll_to_item) {
            gtkhtml_scroll_to_item(app_data->app_ui_data->scroll_to_feed,
                                   app_data->app_ui_data->scroll_to_item);

            app_data->app_ui_data->scroll_to_feed = NULL;
            app_data->app_ui_data->scroll_to_item = 0;
        }

        if (render_list_head) {
            g_slist_free(render_list_head);
            render_list_head = NULL;
        }

        gtkhtml_apply_zoom_level();

	/* turn on double buffering otherwise widgets may disappear */
	gtk_widget_set_double_buffered(GTK_WIDGET(app_data->app_ui_data->htmlwidget), TRUE);

    }
    gboolean result = render_list != NULL;
    return result;
}

static void stop_rendering()
{

    if (idle_id) {
        g_source_remove(idle_id);
        idle_id = 0;
    }

    render_list = NULL;
    if (render_list_head) {
        g_slist_free(render_list_head);
        render_list_head = NULL;
    }

    if (stream_handle) {
        gtk_html_stream_close(stream_handle, GTK_HTML_STREAM_OK);
        stream_handle = NULL;
    }

}

void gtkhtml_load_images(gboolean load)
{
    load_images = load;
}

void gtkhtml_write_html(GtkWidget * scrollpane, gchar * string,
                        gchar * base, nodePtr node)
{
    GtkHTML *html = GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane)));

    stop_rendering();

    /* turn off double buffering, as it causes flicker */
    gtk_widget_set_double_buffered(GTK_WIDGET(html), FALSE);
    
    load_images = TRUE;

    g_object_set_data(G_OBJECT(html), "node", node);
    g_object_set_data(G_OBJECT(html), "last-focus", NULL);

    if (!node) {
        GtkHTMLStream *stream_handle;

        stream_handle = gtk_html_begin(html);
        if (stream_handle) {
            gtk_html_stream_write(stream_handle, string, -1);
            gtk_html_stream_close(stream_handle, GTK_HTML_STREAM_OK);

            /* to enforce applying of changed zoom levels */
            gtkhtml_scroll_to_top(scrollpane);
            gtkhtml_apply_zoom_level();
        } else
            g_warning("Fatal error: can't allocate stream handle!!!!!!");
        return;
    }

    html_image_factory_cleanup(html_engine_get_image_factory(html->engine));

    GSList *itemlistgs = NULL;
    gchar *fp_head = NULL;
    SortData sd;

    itemlistgs = g_slist_copy(feed_get_item_list((feedPtr) node));

    if (NULL == itemlistgs) {
        gtkhtml_display_empty_feed((feedPtr) node);
        gtkhtml_apply_zoom_level();
        gtk_html_command(html, "scroll-bod");
        return;
    }

    sd.time = getNumericConfValue(RSS_SETTINGS_SORT_KEY) == 0;
    sd.asc = getNumericConfValue(RSS_SETTINGS_SORT_ORDER) == 1;

    GTimer *t = g_timer_new();
    itemlistgs = g_slist_sort_with_data(itemlistgs, time_compare_func, &sd);
    g_debug("After sort: %f", g_timer_elapsed(t, NULL));
    g_timer_destroy(t);

    /* Real html widget now */
    fp_head = gtkhtml_render_head((feedPtr) node);

    stream_handle = gtk_html_begin(html);
    gtk_html_stream_write(stream_handle, fp_head, -1);

    g_free(fp_head);

    render_list = render_list_head = itemlistgs;
    idle_id = g_idle_add(render_one_item, NULL);
}

void gtkhtml_stop(void)
{
    g_debug("***gtkhtml_stop***");

    //need here? or somewhere else?
    download_clear_image_user_data();
    app_data->app_ui_data->image_url = NULL;
    app_data->app_ui_data->image_object = NULL;
    if (app_data->app_ui_data->load_url) {
        gchar *tmp = app_data->app_ui_data->load_url;
        app_data->app_ui_data->load_url = NULL;
        g_free(tmp);
    }

    stop_rendering();
    gtk_html_stop(GTK_HTML
                  (gtk_bin_get_child
                   (GTK_BIN(app_data->app_ui_data->html_scrollpane))));
}


/*********************************SEARCH FEED funcs ************************/
/***************************************************************************/
/* Just make a separate function for writing search feed
 * well, it can be incorporated in gtkhtml_write_html too
 but let's just make life eaier for now. 
 TODO: put this inside gtkhtml_write_html so that the code can
 be faster 
 *  what's different between those 2 functions is that: gtkhtml_write_search feed will
 _NOT_ close the stream, until gtkhtml_finish_search_feed() is called. IT has
 to be done this way because items in vfolder will be added as the search goes on.
 
 And initially, this will not write any thing to the page, it just opens the stream
 
 Where as in gtkhtml_write_html(), since the node is there and not a vfolder
 we can close the stream once we're looped through
 
 NOTE: if there are images in the search result. Only the text will be displayed first
 After the search progress bar has finished. Then we call gtkhtml_finish_search_feed.
 Only at this call, images will be loaded.
 Still a tvh TODO: When appending the item to the search view, we need to count the number
 of images as well
 */

void gtkhtml_block_tap_and_hold_signal(void)
{
    g_assert(app_data != NULL);
    GtkHTML *html =
        GTK_HTML(gtk_bin_get_child
                 (GTK_BIN(app_data->app_ui_data->html_scrollpane)));
    g_signal_handlers_block_by_func(html, html_tap_and_hold_cb, NULL);
}


void gtkhtml_unblock_tap_and_hold_signal(void)
{
    g_assert(app_data != NULL);
    GtkHTML *html =
        GTK_HTML(gtk_bin_get_child
                 (GTK_BIN(app_data->app_ui_data->html_scrollpane)));
    g_signal_handlers_unblock_by_func(html, html_tap_and_hold_cb, NULL);
}

GtkHTMLStream *search_fd_stream_handle = NULL;
/**Start the gtkhtml stream for the search results display
  @param: node = the searchFeed.
*/
void gtkhtml_start_write_search_feed(nodePtr node)
{
    g_assert(app_data != NULL);
    g_assert(FST_VFOLDER == node->type);
    gchar *fp_head = NULL;
    GtkHTML *html =
        GTK_HTML(gtk_bin_get_child
                 (GTK_BIN(app_data->app_ui_data->html_scrollpane)));
    gtkhtml_block_tap_and_hold_signal();

    html_image_factory_cleanup(html_engine_get_image_factory(html->engine));

    /* start the stream */
    search_fd_stream_handle = gtk_html_begin
        (GTK_HTML
         (gtk_bin_get_child
          (GTK_BIN(app_data->app_ui_data->html_scrollpane))));

    /* Real html widget now */
    fp_head = gtkhtml_render_head((feedPtr) node);
    gtk_html_stream_write(search_fd_stream_handle,
                          (const gchar *) fp_head, -1);
    g_free(fp_head);
    return;
}

/**closes the globalstream search_stream_handle used in search results display
*/
void gtkhtml_finish_search_feed(void)
{
    if (displayed_node->type != FST_VFOLDER)
        return;
    gtk_html_stop(GTK_HTML
                  (gtk_bin_get_child
                   (GTK_BIN(app_data->app_ui_data->html_scrollpane))));
    gtk_html_stream_close(search_fd_stream_handle, GTK_HTML_STREAM_OK);

    return;
}

/**Appends an item to search results page as the search goes on
  @param: ip = item pointer.

  NOTE: this item will have two parent feed pointers
    1. ip->fp = searchFeed;
    2. ip->orig_fp = the real feed that ip belongs to

*/
void gtkhtml_searchview_append_item(itemPtr ip)
{
    gchar *item_content = NULL;
    if ((displayed_node->type != FST_VFOLDER) ||
        (app_data->app_ui_data->search_mode != SFM_SEARCH))
        return;
    item_content = gtkhtml_just_render_item(ip, TRUE);

    if (item_content != NULL)
        gtk_html_stream_write(search_fd_stream_handle,
                              (const gchar *) item_content, -1);
    g_free(item_content);
    return;
}

/*****************************other gtkhtml funcs **********************************/
void gtkhtml_zoom_in()
{

    AppUIData *app_ui_data;
    g_assert(app_data != NULL);
    app_ui_data = app_data->app_ui_data;
    switch ((int) (app_ui_data->zoom_level * 100)) {
        case ZOOM_50:
        {
            app_ui_data->zoom_level = ZOOM_80 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_80);
            break;
        }
        case ZOOM_80:
        {
            app_ui_data->zoom_level = ZOOM_100 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_100);
            break;
        }
        case ZOOM_100:
        {
            app_ui_data->zoom_level = ZOOM_120 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_120);
            break;
        }
        case ZOOM_120:
        {
            app_ui_data->zoom_level = ZOOM_150 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_150);
            break;
        }
        case ZOOM_150:
        {
            app_ui_data->zoom_level = ZOOM_200 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_200);
            break;
        }
        case ZOOM_200:
        {
            hildon_banner_show_information(GTK_WIDGET(app_ui_data->main_view),
                                           NULL,
                                           dgettext
                                           (HILDON_COMMON_STRINGS_L10N_PACKAGE,
                                            "ckct_ib_max_zoom_level_reached"));
            return;
            //      break;
        }
    }
    gtkhtml_apply_zoom_level();

#if 0
    gchar tmp[60], tmp2[60];
    snprintf(tmp, sizeof(tmp), "rss_ib_zoom_%d",
             (int) (app_ui_data->zoom_level * 100));
    snprintf(tmp2, sizeof(tmp2), _(tmp));
    hildon_banner_show_information(GTK_WIDGET
                                   (app_data->app_ui_data->main_view), NULL,
                                   tmp2);
#endif    
}

void gtkhtml_zoom_out()
{
    AppUIData *app_ui_data;
    g_assert(app_data != NULL);
    app_ui_data = app_data->app_ui_data;
    switch ((int) (app_ui_data->zoom_level * 100)) {
        case ZOOM_50:
        {
            hildon_banner_show_information(GTK_WIDGET(app_ui_data->main_view),
                                           NULL,
                                           dgettext
                                           (HILDON_COMMON_STRINGS_L10N_PACKAGE,
                                            "ckct_ib_min_zoom_level_reached"));
            return;
            //      break;
        }
        case ZOOM_80:
        {
            app_ui_data->zoom_level = ZOOM_50 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_50);
            break;
        }
        case ZOOM_100:
        {
            app_ui_data->zoom_level = ZOOM_80 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_80);
            break;
        }
        case ZOOM_120:
        {
            app_ui_data->zoom_level = ZOOM_100 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_100);
            break;
        }
        case ZOOM_150:
        {
            app_ui_data->zoom_level = ZOOM_120 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_120);
            break;
        }
        case ZOOM_200:
        {
            app_ui_data->zoom_level = ZOOM_150 / 100.0;
            setNumericConfValue(ZOOM_LEVEL, ZOOM_150);
            break;
        }
    }
    gtkhtml_apply_zoom_level();

#if 0    
    gchar tmp[60], tmp2[60];
    snprintf(tmp, sizeof(tmp), "rss_ib_zoom_%d",
             (int) (app_ui_data->zoom_level * 100));
    snprintf(tmp2, sizeof(tmp2), _(tmp));
    hildon_banner_show_information(GTK_WIDGET
                                   (app_data->app_ui_data->main_view), NULL,
                                   tmp2);
#endif    
}

gfloat gtkhtml_get_zoom_level(GtkWidget * scrollpane)
{
    return zoomLevel;
}

void gtk_html_change_the_zoom_level(GtkWidget * scrollpane, gfloat level)
{
    if (level == 0.5) {
        gtk_html_zoom_reset(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
        gtk_html_zoom_out(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
        gtk_html_zoom_out(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
    } else if (level == 1.5) {
        gtk_html_zoom_reset(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
        gtk_html_zoom_in(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
        gtk_html_zoom_in(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));
    } else if (level == 1.0)
        gtk_html_zoom_reset(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))));


    zoomLevel = level;
    return;
}

/** Move focus to the next/previous focus-able object on the page
    @direction: TRUE if moving down
                FALSE if moving up
*/
gboolean gtkhtml_jump_to_next_focusable_object(gboolean direction)
{

    /* CID : 17919	*/
    GTK_HTML(gtk_bin_get_child
                             (GTK_BIN
                              (app_data->app_ui_data->html_scrollpane)));
    gint position = 0;
    GtkAdjustment* vadj = 
    hildon_pannable_area_get_vadjustment(HILDON_PANNABLE_AREA(app_data->app_ui_data->html_scrollpane));

    position = (gint) gtk_adjustment_get_value(vadj);
    gtk_widget_grab_focus(app_data->app_ui_data->html_scrollpane);
    
    if (direction) {
      /* The adjustment returns the current value at the top edge of the pannable,
       * but when scrolling down, "_scroll_to" only scrolls so that the desired position is 
       * at the bottom edge of the pannable. As a side effect, the adjustment position value
       * can be used without modification when scrolling up :)
       */
      position = position + 300;
    }

    hildon_pannable_area_jump_to(HILDON_PANNABLE_AREA(app_data->app_ui_data->html_scrollpane),
				   -1, position);
    return TRUE;
}


/* TODO: Can be NULL, as gtkhtml will automatically scroll down */
gboolean gtkhtml_scroll_pagedown(GtkWidget * scrollpane)
{
    return TRUE;

}

/** Scrolls the html page to some item in the feed. Used by rss applet
  * When applet opens rss reader, the item should be seen, rather than the
  * top of the feed page.

  @param: scrollpane= scroll container of the html view. Usually app_ui_data->gtkhtml_view
  @param: ip Item pointer
  @return: true if can jump to, false otherwise
*/
gboolean gtkhtml_scroll_to_item(nodePtr ptr, guint32 nr)
{

    g_assert(app_data->app_ui_data != NULL);
    gchar *object_anchor_id = NULL; //of format feedId___itemId
    if (ptr == NULL) {
        g_warning("gtkhtmlplugin: Jumping to a NULL item");
        return FALSE;
    }

    object_anchor_id =
        g_strdup_printf("%s%s%d", ((feedPtr) ptr)->id, id_delimiter,
                        (int) nr);

    gboolean result =
        gtk_html_jump_to_anchor(GTK_HTML
                                (gtk_bin_get_child
                                 (GTK_BIN
                                  (app_data->app_ui_data->html_scrollpane))),
                                object_anchor_id);

    if (result)
        grab_top_focus();

    g_free(object_anchor_id);

    return result;
}

/** Scrolls the html page to the top
  @param: scrollpane: container of the html page
  NOTE:  anchor == "top_of_page" is added at the beginning of the page when rendering 
    "top_of_page" can never be an object_id, so it's fine, no collision!
*/
void gtkhtml_scroll_to_top(GtkWidget * scrollpane)
{
    gtk_html_jump_to_anchor(GTK_HTML(gtk_bin_get_child(GTK_BIN(scrollpane))),
                            "top_of_page");
    return;
}


/*****************************************************************************/
/*****************************************************************************/
                        /*ANY other  (public ??) functions */
/*****************************************************************************/
/*****************************************************************************/

/** Displays the empty feed
  @param: fp: feed pointer

*/
void gtkhtml_display_empty_feed(feedPtr fp)
{

    gchar *fp_head = NULL;
    gchar *no_posts = NULL;
    gchar *fp_content = NULL;

    fp_head = gtkhtml_render_head(fp);
    no_posts = gtkhtml_render_empty_feed();

    if (fp_head == NULL) {      /* Now display it */
        gtk_html_load_from_string(GTK_HTML
                                  (gtk_bin_get_child
                                   (GTK_BIN
                                    (app_data->app_ui_data->
                                     html_scrollpane))),
                                  (const gchar *) no_posts, -1);

    } else
    {
	if (FST_VFOLDER == fp->type )
	    fp_content = g_strconcat(fp_head, "", NULL);
	else    
	    fp_content = g_strconcat(fp_head, no_posts, NULL);

        /* Now display it */
        gtk_html_load_from_string(GTK_HTML
                                  (gtk_bin_get_child
                                   (GTK_BIN
                                    (app_data->app_ui_data->
                                     html_scrollpane))),
                                  (const gchar *) fp_content, -1);
    }


    /* to enforce applying of changed zoom levels */
    gtk_html_change_the_zoom_level(app_data->app_ui_data->html_scrollpane,
                                   gtkhtml_get_zoom_level(app_data->
                                                          app_ui_data->
                                                          html_scrollpane));
    gtk_widget_show_all(app_data->app_ui_data->html_scrollpane);

    if (fp_head)
        g_free(fp_head);

    if (fp_content)
        g_free(fp_content);

    if (no_posts)
        g_free(no_posts);
    return;
}



/*****************************************************************************/
/*
 * foobar
 * baz
 * and all that
 */

static gchar *_render_description(itemPtr ptr) {
    const gchar *buff = item_get_description(ptr);
    gchar **arr = NULL;
    gchar **arr2 = NULL;
    int x = 0;
    int y = 0;
    gchar *s = NULL;
    gchar *e = NULL;
    gchar *foo = NULL;
    gchar *result = NULL;
    gchar *oldresult = NULL;
    gchar *newurl = NULL;

    gchar *baz1 = NULL;
    gchar *baz2 = NULL;


    if (buff) {
        arr = g_strsplit_set(buff," ",-1);
    } 

    if (arr) {
        while ( (gchar *) arr[x] != NULL) {
            foo = arr[x];
            if ( (baz1 = strcasestr(foo,"<img"))!=NULL) {
                y = 1;
            } 
            
            if (strcasestr(foo,"src")!=NULL) {
                if (y==1)
                    y=2;
            }
    
            if (y==2) {
                s = (gchar *) strcasestr(foo,"\"");
                if (s!=NULL) {
                    e = (gchar *) strcasestr((gchar *) (s+1),"\"");
                    if (e!=NULL) {
                        if (strcasestr(foo,"http")==NULL) {
                            arr2 = g_strsplit_set(foo,"\"",3);
                            if (arr2) {
                                newurl = (gchar *)common_build_url(arr2[1],ptr->source);
                                if (newurl != NULL) {
                                    foo = g_strconcat(arr2[0],"\"",  newurl,"\"",arr2[2],NULL);
                                }
                                xmlFree(newurl);
                            }
                            g_strfreev(arr2);
                        }
                        y = 0;
                    }
                }
            }
    
            if (y!=0) {
                baz2 = (gchar *) strcasestr(arr[x],">");
                if ( baz2!=NULL && ((int) baz2> (int) baz1)) {
                    y=0;
                }
            }
    
            if (result == NULL) {
                result = g_strdup(foo);
            } else {
                oldresult = result;
                result = g_strconcat(result," ",foo,NULL);
                g_free(oldresult);
                oldresult = NULL;
            }
            x++;
        }
        g_strfreev(arr);
    } else {
        if (buff==NULL) {
            result = NULL;
        } else {
            result = g_strdup(buff);
        }
    }
    return result;
}


/**************************s**************************************************/
/*  refer to htmlview.h , the interface of ALL the PlugIns
 * gtktextview plugin implements everything
 * gtkhtml2 implements everything except for get_buffer() and render_item()
 */
static htmlviewPluginInfo gtkhtmlInfo = {
    HTMLVIEW_API_VERSION,       /* unsigned int api_version; */
    "GtkHtml",                  /*char * name */
    gtkhtml_init,               /* void (*init) (void); */
    gtkhtml_deinit,             /* void (*deinit) (void); */
    gtkhtml_new,                /*GtkWidget *(*create) (); */
    gtkhtml_write_html,         /* void (*write) (GtkWidget * widget, const gchar * string,
                                 * const gchar * base); */
    NULL,                       /*gtkhtml_launch_url,  *//*void (*launch) (GtkWidget * widget, const gchar * url); */
    NULL,                       /*gtkhtml_launch_inside_possible, *//* gboolean(*launchInsidePossible) (void); */
    gtkhtml_get_zoom_level,     /* gfloat(*zoomLevelGet) (GtkWidget * widget); */
    gtk_html_change_the_zoom_level, /* void (*zoomLevelSet) (GtkWidget * widget, gfloat zoom); */
    gtkhtml_scroll_pagedown,    /* gboolean(*scrollPagedown) (GtkWidget * widget); */
    NULL,                       /*  void (*setProxy) (gchar * hostname, int port, 
                                 * gchar * username, gchar * password); */
    NULL,                       /* GtkWidget *(*get_buffer) (); */
    gtkhtml_searchview_append_item, /*void (*render_item) (); */
    gtkhtml_render_head,
    NULL,                       /*gtkhtml_render_and_add_foot, */
    NULL,
    NULL,                       /*todo */
};

DECLARE_HTMLVIEW_PLUGIN(gtkhtmlInfo);
