/**
    @file download.h

    Download engine of rss reader.

    Copyright (c) 2004-2006 Nokia Corporation. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <glib.h>
#include <time.h>


#include "../update.h"

typedef struct _download_data download_data;

struct _download_data {
    GnomeVFSAsyncHandle *vfs_handle;
    guint fsize;
    gchar *data;
    gchar *data_pos;
    gchar *buffer;
    time_t last_modified;
    struct request *req_data;
};

void download_inform_for_free(struct request *request);

gboolean download_start_request(const gchar * url, time_t last_modified,
                                struct request *nrequest);

gboolean download_begin(struct request *request);
    
struct request *download_get_current_request(void);

void download_cancel(void);

gboolean download_is_in_progress(void);
