/**
 * @file ui_folder.h GUI folder handling
 * 
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _UI_FOLDER_H
#define _UI_FOLDER_H

#include <gtk/gtk.h>

#define	ROOT_FOLDER_PREFIX	""

/** Looks up a folder id from the folder tree
  *
  * @param from the iter to start the search from
  * @param id of the folder to look for
  * @return pointer to the folder
  */
folderPtr ui_folder_lookup_by_id(GtkTreeIter *from, gchar *id);

gboolean ui_folder_check_if_exists(GtkTreeIter * from, gchar * candidate);

/**
 * Remove a node from the feedlist and free its ui_data.
 *
 * @param ptr the node to free
 */
void ui_folder_remove_node(nodePtr ptr);

/** Updates a folder
  *
  * @param folder the folder to update
  */
void ui_folder_update(folderPtr folder);

/** Checks if a folder is expanded
  *
  * @param folder the folder to check
  * @return TRUE if expanded, FALSE otherwise
  */
gboolean ui_is_folder_expanded(folderPtr folder);

/** Checks if the root folder is empty
  */
void ui_folder_handle_empty_root();

/** Checks all the folders in the tree for empty folders
  */
void ui_folder_check_if_empty(void);

GdkPixbuf *ui_folder_select_icon(gboolean expanded);
/* expansion/collapsing */

/** Expands or collapses the given folder
  *
  * @param folder the folder to expand or collapse
  * @param expanded if the folder should be expanded or not
  */
void ui_folder_set_expansion(folderPtr folder, gboolean expanded);

/** Callback for collapsing and expanding a folder. Sets the appropriate
  * icon for the folder depending if the folder is expanded or collapsed
  *
  * @param widget not used
  * @param iter iterator for the folder
  * @param path not used
  * @param user_data not used */
void ui_folder_collapse_expand_cb(GtkTreeView * widget, GtkTreeIter * iter,
                                  GtkTreePath * path, gpointer user_data);

/**  callbacks for expand/collapse events for 
  *  Folder tree view in dialogs 
*/
void ui_folder_mfdialog_collapse_expand_cb(GtkTreeView * widget,
                                           GtkTreeIter * iter,
                                           GtkTreePath * path,
                                           gpointer user_data);

/* Callbacks */

/** Callback function that is called after a new folder has been created
  *
  * @param button not used
  * @param user_data the new folder dialog
  */
void on_newfolderbtn_clicked(GtkButton * button, gpointer user_data);

/** Changes the folder name
  *
  * @param button not used
  * @param user_data not used
  */
void on_foldernamechangebtn_clicked(GtkButton * button, gpointer user_data);

/** Creates the folder rename dialog
  *
  * @param folder the folder to rename
  */
void create_folder_rename_dialog(folderPtr folder);

void ui_folder_close_rename_dialog(void);

#endif
