/**
	@file settings_database.h
  
	Database stores the values based on configuration keys.

	Copyright (c) 2004-2007 Nokia Corporation.
	Parts of code are from Liferea.
	Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License 
	version 2 or later, as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
	02110-1301 USA	
*/

#ifndef __SETTINGS_DATABASE_H__
#define __SETTINGS_DATABASE_H__

#include <glib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* Define bases for keys and schema used in this applet */
#define KEY_BASE         "/apps/osso/rss-feed-reader/settings"
#define ACTIVATION_KEY   "settings_active"

#define REFRESH_INTERVAL 500
#define S_CACHE_SIZE        "cache_size"
#define S_AUTOMATIC_UPDATES "automatic_updates"
//#define S_AUTOMATIC_SCROLLING "automatic_scrolling"
#define S_CONN_TYPE         "connection_type"
#define S_CONN_INTERVAL     "connection_interval"
#define S_OPEN_FEEDS_TO "open_feeds_to"

#define _get_gconf_key(key) g_strconcat(KEY_BASE, "/", key, NULL)

#ifdef __cplusplus 
extern "C" { 
#endif

enum type_ {
    TYPE_INTEGER,
    TYPE_STR,
    TYPE_BOOLEAN
};

/**
	Various value types
	@todo date & time removed, because they were not needed.
*/
typedef enum type_ Type;

struct value_ {
	Type type;
	gboolean changed;
	gint integer;
	gchar* str;
	gboolean boolean;
};

/**
	Structure for holding a value of any (needed) type.
*/
typedef struct value_ Value;


/**
	Initializes the SettingsDatabase component.

	@param state_found	A parameter, where it is saved, if state was
				found or not.
	@return TRUE, if initialization was succesful.
 */
gboolean settings_init(gboolean* state_found);

/**
	Sets a value corresponding a given key in the settings database

	@param key	A key, for which the value is assigned.
	@param value	Value for the given key.
	@return TRUE, if set operation was succesful.
 */
gboolean settings_set_value(const gchar* key, Value* value);
 
/**
	Gets a value corresponding a given key from the settings database
	
	@param key	A key, for which the corresponding value is returned.
	@return The value corresponding the given key.
 */
Value* settings_get_value(const gchar* key);

/**
	Uninitializes the SettingsDatabase component.
	
	@return TRUE, if SettingsDatabase was succesfully destroyed.
 */
gboolean settings_destroy(void);

#ifdef __cplusplus 
}
#endif
#endif /* __SETTINGS_DATABASE_H__ */
