/**
   @file rss-feed-applet-view.h

   A small button-like widget used to show a individual feed on the
   home RSS applet

   Based on fmp-image-button.h, part of the Fremantle Media Player

   Copyright (c) 2004-2009 Nokia. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA
*/

#ifndef _RSS_FEED_APPLET_VIEW_H_
#define _RSS_FEED_APPLET_VIEW_H_

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RSS_TYPE_FEED_APPLET_VIEW             (rss_feed_applet_view_get_type ())
#define RSS_FEED_APPLET_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), RSS_TYPE_FEED_APPLET_VIEW, RssFeedAppletView))
#define RSS_FEED_APPLET_VIEW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), RSS_TYPE_FEED_APPLET_VIEW, RssFeedAppletViewClass))
#define RSS_IS_FEED_APPLET_VIEW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RSS_TYPE_FEED_APPLET_VIEW))
#define RSS_IS_FEED_APPLET_VIEW_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), RSS_TYPE_FEED_APPLET_VIEW))
#define RSS_FEED_APPLET_VIEW_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), RSS_TYPE_FEED_APPLET_VIEW, RssFeedAppletViewClass))

typedef struct _RssFeedAppletViewClass RssFeedAppletViewClass;
typedef struct _RssFeedAppletView RssFeedAppletView;

void rss_feed_applet_view_register_types(GTypeModule *module);

struct _RssFeedAppletViewClass
{
  GtkAlignmentClass parent_class;
};

struct _RssFeedAppletView
{
  GtkAlignment parent_instance;

  /* FIXME: this in public inherited from the FMPImageButton, consider
     move it to a private structure */
  GtkWidget *event_box;
  GtkWidget *img_align;
  GtkWidget *img_up;
  GtkWidget *img_down;
  GtkWidget *title;
  GtkWidget *align_title;

  GdkPixbuf *icon_up;
  GdkPixbuf *icon_down;
  gfloat icon_xalign;
  gfloat icon_yalign;

  gint     min_button_width;
  gboolean togglable;

  gboolean button_is_toggled;
  gboolean mouse_button_is_down;
  gboolean title_is_set;
  gboolean cursor_inside_button;
  gboolean button_is_being_pressed;

  gchar *url;
  gchar *feed;
  gulong nr; /* it seems to be something like a feed identifier */

  gfloat normal_color [4];
  gfloat pressed_color [4];
  gfloat current_color [4];
};

GType        rss_feed_applet_view_get_type           (void) G_GNUC_CONST;
GtkWidget *  rss_feed_applet_view_new                (void);
void         rss_feed_applet_view_align              (RssFeedAppletView *self,
                                                      gfloat       xalign,
                                                      gfloat       yalign);
void         rss_feed_applet_view_set_title          (RssFeedAppletView *self,
                                                      const gchar       *title);
void         rss_feed_applet_view_set_title_markup   (RssFeedAppletView *self,
                                                      const gchar       *title);
void         rss_feed_applet_view_set_image_from_file(RssFeedAppletView *self,
                                                      const gchar       *image_up,
                                                      const gchar       *image_down);
void         rss_feed_applet_view_set_image_from_pixbuf(RssFeedAppletView *self,
                                                        GdkPixbuf         *image_up,
                                                        GdkPixbuf         *image_down);
void         rss_feed_applet_view_set_icon_from_pixbuf(RssFeedAppletView *self,
                                                       GdkPixbuf         *icon_up,
                                                       GdkPixbuf         *icon_down);
void         rss_feed_applet_view_set_icon_align      (RssFeedAppletView *self,
                                                       gfloat             xalign,
                                                       gfloat             yalign);
void         rss_feed_applet_view_set_togglable       (RssFeedAppletView *self,
                                                       gboolean           togglable);
gboolean     rss_feed_applet_view_get_togglable       (RssFeedAppletView *self);
void         rss_feed_applet_view_set_toggle          (RssFeedAppletView *self,
                                                       gboolean           toggled);
gboolean     rss_feed_applet_view_get_toggle          (RssFeedAppletView *self);
gboolean     rss_feed_applet_view_is_beeing_pressed   (RssFeedAppletView *self);

void         rss_feed_applet_view_set_url             (RssFeedAppletView *self,
                                                       const gchar       *url);
const gchar* rss_feed_applet_view_get_url             (RssFeedAppletView *self);

void         rss_feed_applet_view_set_feed            (RssFeedAppletView *self,
                                                       const gchar       *feed);
const gchar* rss_feed_applet_view_get_feed            (RssFeedAppletView *self);

void         rss_feed_applet_view_set_nr              (RssFeedAppletView *self,
                                                       gulong             nr);
gulong       rss_feed_applet_view_get_nr              (RssFeedAppletView *self);

void         rss_feed_applet_view_set_color           (RssFeedAppletView *self,
                                                       gfloat r,
                                                       gfloat g,
                                                       gfloat b,
                                                       gfloat a);
void         rss_feed_applet_view_set_pressed_color   (RssFeedAppletView *self,
                                                       gfloat r,
                                                       gfloat g,
                                                       gfloat b,
                                                       gfloat a);
void         rss_feed_applet_view_get_color           (RssFeedAppletView *self,
                                                       gfloat *r,
                                                       gfloat *g,
                                                       gfloat *b,
                                                       gfloat *a);
void         rss_feed_applet_view_get_pressed_color   (RssFeedAppletView *self,
                                                       gfloat *r,
                                                       gfloat *g,
                                                       gfloat *b,
                                                       gfloat *a);


G_END_DECLS
#endif				/* _RSS_FEED_APPLET_VIEW_H_ */
