/**
    @file applet-private.h

    Copyright (c) 2004-2005 Nokia. All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "applet.h"

struct _HomeRssAppletPrivate {
    void *state_data;
    gboolean startrss;
    int state_size;
    /* Global counters */
    time_t updated;
    gulong unread;

    /* UI widgets */
    GtkWidget *applet_alignment;
    GtkWidget *news;
    GtkWidget *rss_news;        /* VBox with all the feed views */
    GList     *feed_list;
    GtkWidget *empty_label;
    GtkWidget *refresh_banner;
    GtkWidget *button_hbox;
    GtkWidget *move_up_button;
    GtkWidget *move_down_button;
    GtkWidget *refresh_button;
    GtkWidget *global_vbox;

    guint scroll_down_tw_timeout;
    guint scroll_down_tw_starter_timeout;

    /* Timeouts for contionous scrolling when pressing the up/down buttons for
     * long; continous starts after long_buttonpress_timeout expires, and one
     * headline is scrolled after every cont_scroll_timeout */
    guint long_buttonpress_timeout;
    guint cont_scroll_timeout;

    /* Update tracking */
    gboolean online;
    guint timeout;
    /* GConf */
    gboolean update;
    guint interval;
    gboolean animation;
    guint open_feeds_to;
    GConfClient *client;
    int width;
    DBusConnection *connection;
    gboolean refreshing;
    gboolean refresh_banner_displayed;
    osso_context_t *osso;
    gboolean backgrounded;
    gchar *title_backup;
    gchar *title_backup2;
    guint gconf_notify_automatic_updates;
    guint gconf_notify_updates_interval;
//    guint gconf_notify_automatic_scrolling;
    guint gconf_notify_open_feeds_to;

    gint avg_char_width;
    gint line_height;
    gint loaded_headlines;      /* Total number of headlines that have been loaded */    
    gint displayed_headlines;   /* number of headlines can be displayed on
                                 * one "page" of scrolledwindow */
    gint num_of_headlines;      /* number of loaded headlines being displayed */
    gint first_headline_index;  /* Index of the first headline to be displayed */
    gint space_between_rows;

    gint prev_width;
    gint prev_height;

    gint htimeout;
    gboolean save_nomem_dialog_visible;
    gboolean save_nodevicemem_dialog_visible;

    /* Themed elements */
    GdkPixbuf *background;
    GdkPixbuf *refresh_img;
    GdkPixbuf *refreshing_img;
};
