/**
   @file rss-feed-applet-button.c

   A small button-like widget used on the home RSS applet

   Based on fmp-image-button.c, part of the Fremantle Media Player

   Copyright (c) 2004-2009 Nokia. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA
*/

#ifndef _RSS_FEED_APPLET_BUTTON_H_
#define _RSS_FEED_APPLET_BUTTON_H_

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RSS_TYPE_FEED_APPLET_BUTTON             (rss_feed_applet_button_get_type ())
#define RSS_FEED_APPLET_BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), RSS_TYPE_FEED_APPLET_BUTTON, RssFeedAppletButton))
#define RSS_FEED_APPLET_BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), RSS_TYPE_FEED_APPLET_BUTTON, RssFeedAppletButtonClass))
#define RSS_IS_FEED_APPLET_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RSS_TYPE_FEED_APPLET_BUTTON))
#define RSS_IS_FEED_APPLET_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), RSS_TYPE_FEED_APPLET_BUTTON))
#define RSS_FEED_APPLET_BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), RSS_TYPE_FEED_APPLET_BUTTON, RssFeedAppletButtonClass))

typedef struct _RssFeedAppletButtonClass RssFeedAppletButtonClass;
typedef struct _RssFeedAppletButton RssFeedAppletButton;

void rss_feed_applet_button_register_types(GTypeModule *module);

struct _RssFeedAppletButtonClass
{
    GtkAlignmentClass parent_class;
};

struct _RssFeedAppletButton
{
    GtkAlignment parent_instance;

    GtkWidget *img_event_box;
    GtkWidget *img_align;
    GtkWidget *img_up;
    GtkWidget *img_down;
    GtkWidget *title;
    GtkWidget *align_title;

    GdkPixbuf *icon_up;
    GdkPixbuf *icon_down;
    gfloat icon_xalign;
    gfloat icon_yalign;
    gint icon_xpadding;
    gint icon_ypadding;

    gint     min_button_width;
    gboolean togglable;

    gboolean button_is_toggled;
    gboolean mouse_button_is_down;
    gboolean title_is_set;
    gboolean cursor_inside_button;
    gboolean button_is_being_pressed;
};

GType rss_feed_applet_button_get_type(void) G_GNUC_CONST;
GtkWidget *rss_feed_applet_button_new(void);
void rss_feed_applet_button_align(RssFeedAppletButton *self,
                                  gfloat          xalign,
                                  gfloat          yalign);
void rss_feed_applet_button_expand_click_area(RssFeedAppletButton *self,
                                              guint top,
                                              guint bottom,
                                              guint left,
                                              guint right);
void rss_feed_applet_button_set_title(RssFeedAppletButton *self,
                                      const gchar    *title);
void rss_feed_applet_button_set_title_markup(RssFeedAppletButton *self,
                                             const gchar    *title);
void rss_feed_applet_button_set_image_from_file(RssFeedAppletButton *self,
                                                const gchar    *image_up,
                                                const gchar    *image_down);
void rss_feed_applet_button_set_min_width(RssFeedAppletButton *self,
                                          gint           width);
void rss_feed_applet_button_set_image_from_pixbuf(RssFeedAppletButton *self,
                                                  GdkPixbuf      *image_up,
                                                  GdkPixbuf      *image_down);
void rss_feed_applet_button_set_icon_from_pixbuf(RssFeedAppletButton *self,
                                                 GdkPixbuf      *icon_up,
                                                 GdkPixbuf      *icon_down);
void rss_feed_applet_button_set_icon_align(RssFeedAppletButton *self, gfloat xalign,
                                           gfloat yalign);
void rss_feed_applet_button_set_icon_padding(RssFeedAppletButton *self,
                                             gint xpadding, gint ypadding);
void rss_feed_applet_button_set_togglable(RssFeedAppletButton *self,
                                          gboolean togglable);
gboolean rss_feed_applet_button_get_togglable(RssFeedAppletButton *self);
void rss_feed_applet_button_set_toggle(RssFeedAppletButton *self,
                                       gboolean toggled);
gboolean rss_feed_applet_button_get_toggle(RssFeedAppletButton *self);
gboolean rss_feed_applet_button_is_beeing_pressed(RssFeedAppletButton *self);


G_END_DECLS
#endif				/* _RSS_FEED_APPLET_BUTTON_H_ */
