/**
    @file applet.h

    Copyright (c) 2004-2005 Nokia. All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _APPLET_H
#define _APPLET_H

#include <time.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <libosso.h>
#include <hildon/hildon-defines.h>
#include <libhildondesktop/libhildondesktop.h>


/* TODO: this should be in osso-rss-feed-reader-lib */
enum {
    OPEN_TO_RSS,
    OPEN_TO_WEB
};

G_BEGIN_DECLS

#define RSS_TYPE_HOME_APPLET            (rss_home_applet_get_type ())
#define RSS_HOME_APPLET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RSS_TYPE_HOME_APPLET, HomeRssApplet))
#define RSS_HOME_APPLET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RSS_TYPE_HOME_APPLET, HomeRssAppletClass))
#define RSS_IS_HOME_APPLET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RSS_TYPE_HOME_APPLET))
#define RSS_IS_HOME_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RSS_TYPE_HOME_APPLET))
#define RSS_HOME_APPLET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RSS_TYPE_HOME_APPLET, HomeRssAppletPrivate))

typedef struct _HomeRssApplet        HomeRssApplet;
typedef struct _HomeRssAppletClass   HomeRssAppletClass;
typedef struct _HomeRssAppletPrivate HomeRssAppletPrivate;

struct _HomeRssApplet
{
  HDHomePluginItem parent;
  HomeRssAppletPrivate  *priv;
};

struct _HomeRssAppletClass
{
  HDHomePluginItemClass parent;
};

GType rss_home_applet_get_type (void);

G_END_DECLS


#endif
