/**
  @file fl.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _FL_H_
#define _FL_H_

#include <glib.h>
#include <gw-obex.h>

#include "obc-main.h"

typedef struct {
    gboolean   dir;
    gchar     *name;
    gchar     *type;
    gint       size;
    time_t     modified;
    time_t     created;
} FlEntry;

void fl_list_free(GSList *l);

GSList *fl_list_get(ObcContext *ctx, const gchar *dir, gboolean progress,
                    gint *err);

FlEntry *fl_list_find_name(GSList *l, const char *name);

GSList *fl_list_match_glob(GSList *l, const char *glob);

gboolean cmd_ls(ObcContext *ctx, gint argc, gchar *argv[], gint *err);

void ls_help(ObcContext *ctx, const char *name);

#endif /* _FL_H_ */
