/**
  @file bt.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _BT_H_
#define _BT_H_

typedef struct {
    char    *bda;
    char    *name;
    uint16_t clock;
    uint8_t  cod[3];
} BtDev;

int bt_connect(const char *bda, int channel, gboolean ftp, gboolean auth, gboolean encrypt, const char *role);

char *bt_get_remote_name(const char *bda);

BtDev *bt_scan_find_name(GSList *l, const char *name);

GSList *bt_scan(void);

void bt_scan_free(GSList *l);

#endif /* _BT_H_ */
