#! /bin/sh
#
# update-rc.d	Update the links in /etc/rc[0-9S].d/
#

#set -x

initd="/etc/init.d"
etcd="/etc/rc"
notreally=0
force=0
bn="" #basename

# Print usage message and die.

usage() {
	echo "update-rc.d: error: $@"
	cat << EOF
usage: update-rc.d [-n] [-f] <basename> remove
       update-rc.d [-n] <basename> defaults [NN | sNN kNN]
       update-rc.d [-n] <basename> start|stop NN runlvl [runlvl] [...] .
		-n: not really
		-f: force
EOF
	exit 1
}

die(){
   echo "$@"
   exit 1;
}

is_link() {
    op="$1"
    fn="$2"
    bn="$3"
    if [ ! -L "$fn" ] ; then 
	echo "update-rc.d: warning: $fn is not a symbolic link"
	return 1
    fi
    linkdst=`readlink "$fn"`
    [ x"$linkdst" = x ] && die "update-rc.d: error reading symbolic link: $fn"

    if [ x"$linkdst" != x"../init.d/$bn" -a  x"$linkdst" != "$initd/$bn" ]; then
	echo "update-rc.d: warning: $fn is not a link to ../init.d/$bn or $initd/$bn\n"
	return 1
	
    fi
    return 0
}

checklinks() {
    [ x"$1" = x'remove' ] && echo " Removing any system startup links for $initd/$bn ..."

    found=1;
    
    for i in `seq 0 9` S; do
	if ! cd $etcd$i.d 2>/dev/null; then
	    echo $i | grep -q '^[789S]$' && continue
	    die "update-rc.d: chdir $etcd$i.d: $!"
	fi
	
    
	files=`ls -1 .  | grep "^[SK][0-9][0-9]$bn$"`
	[ x"$files" = x ] || found=0
	[ x"$1" = x'remove' ] || continue
	
	for f in $files; do
	    fn="$etcd$i.d/$f"
	    is_link $1 $fn $bn || (echo "   $fn is not a link to ../init.d/$bn; not removing" && continue)
	    echo "   $fn"
	    [ x"$notreally" = x"1" ] && continue
	    rm $fn || die "update-rc.d: rm: $fn"
	done
    done
    return $found
}

makelinks() {
    if checklinks ; then 
	echo " System startup links for $initd/$bn already exist."
	exit 0
    fi
    echo " Adding system startup for $initd/$bn ..."

    for i in `seq 0 9` S; do
	for j in startlinks stoplinks; do
	    varname=$j$i
	    varval=`eval echo \\$$varname`
	    if [ x$varval != x ]; then
		echo "   $etcd$i.d/$varval$bn -> ../init.d/$bn"
		[ x$notreally = x1 ] || ln -s ../init.d/$bn $etcd$i.d/$varval$bn
	    fi
	done
    done
}


defaults() {
    start=20
    stop=20

    [ x"$3" = x ] || usage "defaults takes only one or two codenumbers"
    [ "x$1" = x ] || start="$1"
    if [ x"$2" != x ]; then
	stop="$2"
    else
	stop="$start"
    fi
    
#    &usage ("codenumber must be a number between 0 and 99")
#	if ($start !~ /^\d\d?$/ || $stop  !~ /^\d\d?$/);
    
    start=`printf "%02d" $start`
    stop=`printf "%02d" $stop`
    
    for i in 0 1 6; do
	eval stoplinks$i="K$stop"
    done
    for i in 2 3 4 5; do
	eval startlinks$i="S$start";
    done
}

startstop() {
    action=""
    order=
    while [ "$1" != "" ]; do
	case $1 in
	    start|stop)
		#[ x$action = x$1 ] && usage "unxpected start|stop"
		action=$1
		shift
		order=$1
		echo $order | grep -q '^[0-9][0-9]\?$' || usage "expected NN after $action"
		order=`printf "%02d" $order`
		shift ;;
	    [0-9S])
		if [ ! -d "$etcd$1.d" ]; then 
		    echo "update-rc.d: $etcd$1.d: no such directory"
		    exit 1
		fi
		[ x$action = xstart ] && eval ${action}links$1="S$order"
		[ x$action = xstop ] && eval ${action}links$1="K$order"
		shift;;
	    .)
		shift;;
	    *)
		usage "unknown parametr $1"
		;;
	esac
    done
}


# Check out options.

while [ "$1" != "" ]; do
   case $1
       in
       -n)
	   notreally=1
	   shift ;;
       -f)
	   force=1
	   shift ;;
       -h|--help)
	   usage "help";;
       -*)
	   usage "unknown option $1" ;;
       *)
	   break;;
   esac
done

bn="$1"
shift

[ x"$*" = x ] && usage "wrong arguments number"

if [ x"$1" != x"remove" ]; then
    if [ ! -f "$initd/$bn" ]; then
	echo "update-rc.d: $initd/$bn: file does not exist"
	exit 1
    fi
elif [ -f "$initd/$bn" ]; then
    if [ x"$force" != x"1" ]; then
	echo "update-rc.d: $initd/$bn exists during rc.d purge (use -f to force)"
	exit 1
    fi
fi


case $1 in
    remove)
	checklinks "remove"
	;;
    defaults)
	shift
	defaults "$@"
 	makelinks
	;;
    start|stop)
	startstop "$@"
	makelinks
	;;
    *)
	usage "no <basename>"
	;;
esac

exit 0

