const Ci = Components.interfaces;
const Cc = Components.classes;
const Cr = Components.results;
const Cu = Components.utils;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");

function GeolocationPrompt() {}

GeolocationPrompt.prototype = {
  classDescription: "Microb Geolocation Prompting Component",
  classID:          Components.ID("{15adb1a4-f417-11de-a101-001e37d2764a}"),
  contractID:       "@mozilla.org/geolocation/prompt;1",

  QueryInterface: XPCOMUtils.generateQI([Ci.nsIGeolocationPrompt]),

  prompt: function(request) {
    var pm = Cc["@mozilla.org/permissionmanager;1"].getService(Ci.nsIPermissionManager);
    var result = pm.testExactPermission(request.requestingURI, "geo");

    if (result == Ci.nsIPermissionManager.ALLOW_ACTION) {
      request.allow();
      return;
    }
    if (result == Ci.nsIPermissionManager.DENY_ACTION) {
      request.cancel();
      return;
    }

    function setPagePermission(uri, allow) {
      var prefService = Cc["@mozilla.org/content-pref/service;1"].getService(Ci.nsIContentPrefService);

      if (allow)
        pm.add(uri, "geo", Ci.nsIPermissionManager.ALLOW_ACTION);
      else
        pm.add(uri, "geo", Ci.nsIPermissionManager.DENY_ACTION);
    }

    var requestingWindow = request.requestingWindow.top;
    var notificationBox = Cc["@browser.garage.maemo.org/microb/notificationbox;1"].getService(Ci.nsINotificationBox);

    var notification = notificationBox.getNotificationWithValue("geolocation");
    if (!notification) {
      var buttons = Cc["@mozilla.org/array;1"].createInstance(Ci.nsIMutableArray);
      var button1 = Cc["@browser.garage.maemo.org/microb/notificationbutton;1"].createInstance(Ci.nsINotificationButton);
      var button2 = Cc["@browser.garage.maemo.org/microb/notificationbutton;1"].createInstance(Ci.nsINotificationButton);
      var button3 = Cc["@browser.garage.maemo.org/microb/notificationbutton;1"].createInstance(Ci.nsINotificationButton);
      var button4 = Cc["@browser.garage.maemo.org/microb/notificationbutton;1"].createInstance(Ci.nsINotificationButton);
      button1.label = "weba_bd_geolocaton_allow";
      button1.callback = function(aNotificationBar) {
         request.allow();
      };
      button2.label = "weba_bd_geolocaton_always";
      button2.callback =  function(aNotificationBar) {
        setPagePermission(request.requestingURI, true);
        request.allow();
      };
      button3.label = "weba_bd_geolocaton_never";
      button3.callback =  function(aNotificationBar) {
        setPagePermission(request.requestingURI, false);
        request.cancel();
      };
      button4.label = "weba_bd_not_now";
      button4.callback =  function(aNotificationBar) {
        request.cancel();
      };

      buttons.appendElement(button1, false);
      buttons.appendElement(button2, false);
      buttons.appendElement(button3, false);
      buttons.appendElement(button4, false);

      notificationBox.title = "weba_ti_geolocoation";
      var newBar = notificationBox.appendNotification("weba_nc_geolocaton_dis",
                                                      "geolocation",
                                                      "chrome://microb-geolocation/content/icon.png",
                                                      notificationBox.PRIORITY_WARNING_MEDIUM,
                                                      buttons);
      // Make this a geolocation notification.
      newBar.setAttribute("type", "geo");
    }
  }
};

//module initialization
function NSGetModule(aCompMgr, aFileSpec) {
  return XPCOMUtils.generateModule([GeolocationPrompt]);
}
