#! /bin/sh
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is the Mozilla build system
#
# The Initial Developer of the Original Code is
# Ben Turner <mozilla@songbirdnest.com>
#
# Portions created by the Initial Developer are Copyright (C) 2007
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

# This file contains makefiles that will be generated for every XUL app.

MAKEFILES_db="
  db/Makefile
  db/mdb/Makefile
  db/mdb/public/Makefile
  db/mork/Makefile
  db/mork/build/Makefile
  db/mork/src/Makefile
"

MAKEFILES_dom="
  dom/Makefile
  dom/public/coreEvents/Makefile
  dom/interfaces/base/Makefile
  dom/interfaces/canvas/Makefile
  dom/interfaces/core/Makefile
  dom/interfaces/css/Makefile
  dom/interfaces/events/Makefile
  dom/interfaces/html/Makefile
  dom/interfaces/range/Makefile
  dom/interfaces/stylesheets/Makefile
  dom/interfaces/views/Makefile
  dom/interfaces/xbl/Makefile
  dom/interfaces/xpath/Makefile
  dom/interfaces/xul/Makefile
  dom/base/Makefile
  dom/src/Makefile
  dom/src/events/Makefile
  dom/src/jsurl/Makefile
  dom/locales/Makefile
"

MAKEFILES_editor="
  editor/Makefile
  editor/public/Makefile
  editor/idl/Makefile
  editor/txmgr/Makefile
  editor/txmgr/idl/Makefile
  editor/txmgr/public/Makefile
  editor/txmgr/src/Makefile
  editor/txmgr/tests/Makefile
  editor/txtsvc/Makefile
  editor/txtsvc/public/Makefile
  editor/txtsvc/src/Makefile
  editor/composer/Makefile
  editor/composer/public/Makefile
  editor/composer/src/Makefile
  editor/composer/test/Makefile
  editor/libeditor/Makefile
  editor/libeditor/base/Makefile
  editor/libeditor/base/tests/Makefile
  editor/libeditor/html/Makefile
  editor/libeditor/text/Makefile
"

MAKEFILES_expat="
  parser/expat/Makefile
  parser/expat/lib/Makefile
"

MAKEFILES_gfx="
  gfx/Makefile
  gfx/idl/Makefile
  gfx/public/Makefile
  gfx/src/Makefile
  gfx/src/psshared/Makefile
  gfx/src/thebes/Makefile
  gfx/tests/Makefile
  gfx/qcms/Makefile
"

MAKEFILES_htmlparser="
  parser/htmlparser/Makefile
  parser/htmlparser/public/Makefile
  parser/htmlparser/src/Makefile
  parser/htmlparser/tests/Makefile
  parser/htmlparser/tests/grabpage/Makefile
  parser/htmlparser/tests/logparse/Makefile
  parser/htmlparser/tests/html/Makefile
  parser/htmlparser/tests/outsinks/Makefile
"

MAKEFILES_intl="
  intl/Makefile
  intl/chardet/Makefile
  intl/chardet/public/Makefile
  intl/chardet/src/Makefile
  intl/uconv/Makefile
  intl/uconv/idl/Makefile
  intl/uconv/public/Makefile
  intl/uconv/src/Makefile
  intl/uconv/tests/Makefile
  intl/uconv/ucvja/Makefile
  intl/uconv/ucvlatin/Makefile
  intl/uconv/ucvcn/Makefile
  intl/uconv/ucvtw/Makefile
  intl/uconv/ucvtw2/Makefile
  intl/uconv/ucvko/Makefile
  intl/uconv/ucvibm/Makefile
  intl/uconv/native/Makefile
  intl/locale/Makefile
  intl/locale/public/Makefile
  intl/locale/idl/Makefile
  intl/locale/src/Makefile
  intl/locale/src/unix/Makefile
  intl/locale/src/os2/Makefile
  intl/locale/src/windows/Makefile
  intl/locale/tests/Makefile
  intl/lwbrk/Makefile
  intl/lwbrk/src/Makefile
  intl/lwbrk/public/Makefile
  intl/lwbrk/tests/Makefile
  intl/unicharutil/Makefile
  intl/unicharutil/util/Makefile
  intl/unicharutil/util/internal/Makefile
  intl/unicharutil/idl/Makefile
  intl/unicharutil/src/Makefile
  intl/unicharutil/public/Makefile
  intl/unicharutil/tables/Makefile
  intl/unicharutil/tests/Makefile
  intl/unicharutil/tools/Makefile
  intl/strres/Makefile
  intl/strres/public/Makefile
  intl/strres/src/Makefile
  intl/strres/tests/Makefile
"

MAKEFILES_liveconnect="
  js/src/liveconnect/Makefile
  js/src/liveconnect/classes/Makefile
"

MAKEFILES_xpconnect="
  js/src/xpconnect/Makefile
  js/src/xpconnect/public/Makefile
  js/src/xpconnect/idl/Makefile
  js/src/xpconnect/shell/Makefile
  js/src/xpconnect/src/Makefile
  js/src/xpconnect/loader/Makefile
  js/src/xpconnect/tests/Makefile
  js/src/xpconnect/tests/components/Makefile
  js/src/xpconnect/tests/idl/Makefile
  js/src/xpconnect/tools/Makefile
  js/src/xpconnect/tools/idl/Makefile
"

MAKEFILES_jsdebugger="
  js/jsd/Makefile
  js/jsd/idl/Makefile
"

MAKEFILES_content="
  content/Makefile
  content/base/Makefile
  content/base/public/Makefile
  content/base/src/Makefile
  content/base/test/Makefile
  content/base/test/chrome/Makefile
  content/canvas/Makefile
  content/canvas/public/Makefile
  content/canvas/src/Makefile
  content/events/Makefile
  content/events/public/Makefile
  content/events/src/Makefile
  content/html/Makefile
  content/html/content/Makefile
  content/html/content/public/Makefile
  content/html/content/src/Makefile
  content/html/document/Makefile
  content/html/document/public/Makefile
  content/html/document/src/Makefile
  content/xml/Makefile
  content/xml/content/Makefile
  content/xml/content/src/Makefile
  content/xml/document/Makefile
  content/xml/document/public/Makefile
  content/xml/document/src/Makefile
  content/xul/Makefile
  content/xul/content/Makefile
  content/xul/content/src/Makefile
  content/xul/document/Makefile
  content/xul/document/public/Makefile
  content/xul/document/src/Makefile
  content/xul/templates/public/Makefile
  content/xul/templates/src/Makefile
  content/xul/templates/tests/Makefile
  content/xul/templates/tests/chrome/Makefile
  content/xbl/Makefile
  content/xbl/public/Makefile
  content/xbl/src/Makefile
  content/xbl/builtin/Makefile
  content/xslt/Makefile
  content/xslt/public/Makefile
  content/xslt/src/Makefile
  content/xslt/src/base/Makefile
  content/xslt/src/xml/Makefile
  content/xslt/src/xpath/Makefile
  content/xslt/src/xslt/Makefile
  content/xslt/src/main/Makefile
"

MAKEFILES_layout="
  layout/Makefile
  layout/base/Makefile
  layout/base/tests/Makefile
  layout/build/Makefile
  layout/forms/Makefile
  layout/html/tests/Makefile
  layout/style/Makefile
  layout/printing/Makefile
  layout/xul/base/public/Makefile
  layout/xul/base/src/Makefile
  layout/xul/base/src/tree/src/Makefile
  layout/xul/base/src/tree/public/Makefile
"

MAKEFILES_libimg="
  modules/libimg/Makefile
"

MAKEFILES_libjar="
  modules/libjar/Makefile
  modules/libjar/standalone/Makefile
  modules/libjar/test/Makefile
"

MAKEFILES_libreg="
  modules/libreg/Makefile
  modules/libreg/include/Makefile
  modules/libreg/src/Makefile
  modules/libreg/standalone/Makefile
"

MAKEFILES_libpref="
  modules/libpref/Makefile
  modules/libpref/public/Makefile
  modules/libpref/src/Makefile
"

MAKEFILES_libutil="
  modules/libutil/Makefile
  modules/libutil/public/Makefile
  modules/libutil/src/Makefile
"

MAKEFILES_libvorbis="
  media/libvorbis/Makefile
  media/libvorbis/lib/Makefile
  media/libvorbis/include/Makefile
  media/libvorbis/include/vorbis/Makefile
"

MAKEFILES_libtheora="
  media/libtheora/Makefile
  media/libtheora/lib/Makefile
  media/libtheora/include/Makefile
  media/libtheora/include/theora/Makefile
"

MAKEFILES_liboggz="
  media/liboggz/Makefile
  media/liboggz/src/Makefile
  media/liboggz/src/liboggz/Makefile
  media/liboggz/include/Makefile
  media/liboggz/include/oggz/Makefile
"

MAKEFILES_libogg="
  media/libogg/Makefile
  media/libogg/src/Makefile
  media/libogg/include/Makefile
  media/libogg/include/ogg/Makefile
"

MAKEFILES_libfishsound="
  media/libfishsound/Makefile
  media/libfishsound/src/Makefile
  media/libfishsound/src/libfishsound/Makefile
  media/libfishsound/include/Makefile
  media/libfishsound/include/fishsound/Makefile
"

MAKEFILES_liboggplay="
  media/liboggplay/Makefile
  media/liboggplay/src/Makefile
  media/liboggplay/src/liboggplay/Makefile
  media/liboggplay/include/Makefile
  media/liboggplay/include/oggplay/Makefile
"

MAKEFILES_libsydneyaudio="
  media/libsydneyaudio/Makefile
  media/libsydneyaudio/include/Makefile
  media/libsydneyaudio/src/Makefile
"

MAKEFILES_plugin="
  modules/plugin/Makefile
  modules/plugin/base/src/Makefile
  modules/plugin/base/public/Makefile
  modules/plugin/default/unix/Makefile
  modules/plugin/sdk/Makefile
  modules/plugin/sdk/samples/Makefile
  modules/plugin/sdk/samples/common/Makefile
  modules/plugin/sdk/samples/basic/windows/Makefile
  modules/plugin/sdk/samples/winless/windows/Makefile
"

MAKEFILES_freetype2="
  modules/freetype2/Makefile
"

MAKEFILES_netwerk="
  netwerk/Makefile
  netwerk/base/Makefile
  netwerk/base/public/Makefile
  netwerk/base/src/Makefile
  netwerk/build/Makefile
  netwerk/cache/Makefile
  netwerk/cache/public/Makefile
  netwerk/cache/src/Makefile
  netwerk/cookie/Makefile
  netwerk/cookie/public/Makefile
  netwerk/cookie/src/Makefile
  netwerk/wifi/Makefile
  netwerk/wifi/public/Makefile
  netwerk/wifi/src/Makefile
  netwerk/dns/Makefile
  netwerk/dns/public/Makefile
  netwerk/dns/src/Makefile
  netwerk/protocol/Makefile
  netwerk/protocol/about/Makefile
  netwerk/protocol/about/public/Makefile
  netwerk/protocol/about/src/Makefile
  netwerk/protocol/data/Makefile
  netwerk/protocol/data/src/Makefile
  netwerk/protocol/file/Makefile
  netwerk/protocol/file/public/Makefile
  netwerk/protocol/file/src/Makefile
  netwerk/protocol/ftp/Makefile
  netwerk/protocol/ftp/public/Makefile
  netwerk/protocol/ftp/src/Makefile
  netwerk/protocol/gopher/Makefile
  netwerk/protocol/gopher/src/Makefile
  netwerk/protocol/http/Makefile
  netwerk/protocol/http/public/Makefile
  netwerk/protocol/http/src/Makefile
  netwerk/protocol/res/Makefile
  netwerk/protocol/res/public/Makefile
  netwerk/protocol/res/src/Makefile
  netwerk/mime/Makefile
  netwerk/mime/public/Makefile
  netwerk/mime/src/Makefile
  netwerk/socket/Makefile
  netwerk/socket/base/Makefile
  netwerk/streamconv/Makefile
  netwerk/streamconv/converters/Makefile
  netwerk/streamconv/public/Makefile
  netwerk/streamconv/src/Makefile
  netwerk/streamconv/test/Makefile
  netwerk/test/Makefile
  netwerk/testserver/Makefile
  netwerk/locales/Makefile
  netwerk/system/Makefile
  netwerk/system/win32/Makefile
"

MAKEFILES_uriloader="
  uriloader/Makefile
  uriloader/base/Makefile
  uriloader/exthandler/Makefile
  uriloader/exthandler/tests/Makefile
"

MAKEFILES_profile="
  profile/Makefile
  profile/public/Makefile
  profile/dirserviceprovider/Makefile
  profile/dirserviceprovider/public/Makefile
  profile/dirserviceprovider/src/Makefile
"

MAKEFILES_rdf="
  rdf/Makefile
  rdf/base/Makefile
  rdf/base/idl/Makefile
  rdf/base/public/Makefile
  rdf/base/src/Makefile
  rdf/util/Makefile
  rdf/util/public/Makefile
  rdf/util/src/Makefile
  rdf/util/src/internal/Makefile
  rdf/build/Makefile
  rdf/datasource/Makefile
  rdf/datasource/public/Makefile
  rdf/datasource/src/Makefile
  rdf/tests/Makefile
  rdf/tests/rdfcat/Makefile
  rdf/tests/rdfpoll/Makefile
"

MAKEFILES_caps="
  caps/Makefile
  caps/idl/Makefile
  caps/include/Makefile
  caps/src/Makefile
"

MAKEFILES_chrome="
  chrome/Makefile
  chrome/public/Makefile
  chrome/src/Makefile
"

MAKEFILES_view="
  view/Makefile
  view/public/Makefile
  view/src/Makefile
"

MAKEFILES_docshell="
  docshell/Makefile
  docshell/base/Makefile
  docshell/shistory/Makefile
  docshell/shistory/public/Makefile
  docshell/shistory/src/Makefile
  docshell/build/Makefile
"

MAKEFILES_webshell="
  webshell/Makefile
  webshell/public/Makefile
"

MAKEFILES_widget="
  widget/Makefile
  widget/public/Makefile
  widget/src/Makefile
  widget/src/beos/Makefile
  widget/src/build/Makefile
  widget/src/gtkxtbin/Makefile
  widget/src/photon/Makefile
  widget/src/cocoa/Makefile
  widget/src/os2/Makefile
  widget/src/windows/Makefile
  widget/src/xpwidgets/Makefile
"

MAKEFILES_xpcom="
  xpcom/string/Makefile
  xpcom/string/public/Makefile
  xpcom/string/src/Makefile
  xpcom/Makefile
  xpcom/base/Makefile
  xpcom/build/Makefile
  xpcom/components/Makefile
  xpcom/ds/Makefile
  xpcom/glue/Makefile
  xpcom/glue/standalone/Makefile
  xpcom/io/Makefile
  xpcom/typelib/Makefile
  xpcom/reflect/Makefile
  xpcom/typelib/xpt/Makefile
  xpcom/typelib/xpt/public/Makefile
  xpcom/typelib/xpt/src/Makefile
  xpcom/typelib/xpt/tests/Makefile
  xpcom/typelib/xpt/tools/Makefile
  xpcom/typelib/xpidl/Makefile
  xpcom/reflect/xptcall/Makefile
  xpcom/reflect/xptcall/public/Makefile
  xpcom/reflect/xptcall/src/Makefile
  xpcom/reflect/xptcall/src/md/Makefile
  xpcom/reflect/xptcall/src/md/os2/Makefile
  xpcom/reflect/xptcall/src/md/test/Makefile
  xpcom/reflect/xptcall/src/md/unix/Makefile
  xpcom/reflect/xptcall/src/md/win32/Makefile
  xpcom/reflect/xptcall/tests/Makefile
  xpcom/reflect/xptinfo/Makefile
  xpcom/reflect/xptinfo/public/Makefile
  xpcom/reflect/xptinfo/src/Makefile
  xpcom/reflect/xptinfo/tests/Makefile
  xpcom/proxy/Makefile
  xpcom/proxy/public/Makefile
  xpcom/proxy/src/Makefile
  xpcom/proxy/tests/Makefile
  xpcom/sample/Makefile
  xpcom/threads/Makefile
  xpcom/tools/Makefile
  xpcom/tools/registry/Makefile
  xpcom/stub/Makefile
  xpcom/windbgdlg/Makefile
  xpcom/system/Makefile
"

MAKEFILES_xpcom_obsolete="
  xpcom/obsolete/Makefile
  xpcom/obsolete/component/Makefile
"

MAKEFILES_xpcom_tests="
  xpcom/tests/Makefile
  xpcom/tests/dynamic/Makefile
  xpcom/tests/services/Makefile
  xpcom/tests/windows/Makefile
  xpcom/tests/static-checker/Makefile
"

MAKEFILES_xpinstall="
  xpinstall/Makefile
  xpinstall/public/Makefile
  xpinstall/src/Makefile
"

MAKEFILES_xpfe="
  widget/src/xremoteclient/Makefile
  toolkit/components/remote/Makefile
  xpfe/Makefile
  xpfe/browser/Makefile
  xpfe/browser/public/Makefile
  xpfe/browser/src/Makefile
  xpfe/components/Makefile
  xpfe/components/directory/Makefile
  xpfe/components/find/Makefile
  xpfe/components/find/public/Makefile
  xpfe/components/find/src/Makefile
  xpfe/components/intl/Makefile
  xpfe/components/autocomplete/Makefile
  xpfe/components/autocomplete/public/Makefile
  xpfe/components/autocomplete/src/Makefile
  xpfe/components/windowds/Makefile
  xpfe/components/build/Makefile
  xpfe/appshell/Makefile
  xpfe/appshell/src/Makefile
  xpfe/appshell/public/Makefile
  extensions/spellcheck/Makefile
  extensions/spellcheck/hunspell/Makefile
  extensions/spellcheck/idl/Makefile
  extensions/spellcheck/locales/Makefile
  extensions/spellcheck/src/Makefile
"

MAKEFILES_embedding="
  embedding/Makefile
  embedding/base/Makefile
  embedding/browser/Makefile
  embedding/browser/activex/src/Makefile
  embedding/browser/activex/src/control/Makefile
  embedding/browser/activex/src/control_kicker/Makefile
  embedding/browser/build/Makefile
  embedding/browser/webBrowser/Makefile
  embedding/browser/gtk/Makefile
  embedding/browser/gtk/src/Makefile
  embedding/browser/gtk/tests/Makefile
  embedding/browser/photon/Makefile
  embedding/browser/photon/src/Makefile
  embedding/browser/photon/tests/Makefile
  embedding/components/Makefile
  embedding/components/build/Makefile
  embedding/components/windowwatcher/Makefile
  embedding/components/windowwatcher/public/Makefile
  embedding/components/windowwatcher/src/Makefile
  embedding/components/ui/Makefile
  embedding/components/ui/helperAppDlg/Makefile
  embedding/components/ui/progressDlg/Makefile
  embedding/config/Makefile
  embedding/tests/Makefile
  embedding/tests/winEmbed/Makefile
"

MAKEFILES_xulapp="
  toolkit/Makefile
  toolkit/library/Makefile
  toolkit/crashreporter/Makefile
  toolkit/crashreporter/client/Makefile
  toolkit/crashreporter/google-breakpad/src/client/Makefile
  toolkit/crashreporter/google-breakpad/src/client/linux/handler/Makefile
  toolkit/crashreporter/google-breakpad/src/client/mac/handler/Makefile
  toolkit/crashreporter/google-breakpad/src/client/solaris/handler/Makefile
  toolkit/crashreporter/google-breakpad/src/client/windows/crash_generation/Makefile
  toolkit/crashreporter/google-breakpad/src/client/windows/handler/Makefile
  toolkit/crashreporter/google-breakpad/src/client/windows/sender/Makefile
  toolkit/crashreporter/google-breakpad/src/common/Makefile
  toolkit/crashreporter/google-breakpad/src/common/linux/Makefile
  toolkit/crashreporter/google-breakpad/src/common/mac/Makefile
  toolkit/crashreporter/google-breakpad/src/common/mac/dwarf/Makefile
  toolkit/crashreporter/google-breakpad/src/common/solaris/Makefile
  toolkit/crashreporter/google-breakpad/src/common/windows/Makefile
  toolkit/crashreporter/google-breakpad/src/tools/linux/dump_syms/Makefile
  toolkit/crashreporter/google-breakpad/src/tools/mac/dump_syms/Makefile
  toolkit/crashreporter/google-breakpad/src/tools/solaris/dump_syms/Makefile
  toolkit/content/Makefile
  toolkit/obsolete/Makefile
  toolkit/components/alerts/Makefile
  toolkit/components/alerts/public/Makefile
  toolkit/components/alerts/src/Makefile
  toolkit/components/autocomplete/Makefile
  toolkit/components/autocomplete/public/Makefile
  toolkit/components/autocomplete/src/Makefile
  toolkit/components/Makefile
  toolkit/components/build/Makefile
  toolkit/components/commandlines/Makefile
  toolkit/components/commandlines/public/Makefile
  toolkit/components/commandlines/src/Makefile
  toolkit/components/console/Makefile
  toolkit/components/cookie/Makefile
  toolkit/components/downloads/public/Makefile
  toolkit/components/downloads/Makefile
  toolkit/components/downloads/src/Makefile
  toolkit/components/filepicker/Makefile
  toolkit/components/filepicker/public/Makefile
  toolkit/components/filepicker/src/Makefile
  toolkit/system/gnome/Makefile
  toolkit/system/unixproxy/Makefile
  toolkit/system/osxproxy/Makefile
  toolkit/system/windowsproxy/Makefile
  toolkit/components/help/Makefile
  toolkit/components/passwordmgr/Makefile
  toolkit/components/passwordmgr/public/Makefile
  toolkit/components/passwordmgr/src/Makefile
  toolkit/components/passwordmgr/content/Makefile
  toolkit/components/passwordmgr/test/Makefile
  toolkit/components/places/Makefile
  toolkit/components/places/public/Makefile
  toolkit/components/places/src/Makefile
  toolkit/components/printing/Makefile
  toolkit/components/satchel/Makefile
  toolkit/components/satchel/public/Makefile
  toolkit/components/satchel/src/Makefile
  toolkit/components/startup/Makefile
  toolkit/components/startup/public/Makefile
  toolkit/components/startup/src/Makefile
  toolkit/components/typeaheadfind/Makefile
  toolkit/components/typeaheadfind/public/Makefile
  toolkit/components/typeaheadfind/src/Makefile
  toolkit/components/viewconfig/Makefile
  toolkit/components/viewsource/Makefile
  toolkit/locales/Makefile
  toolkit/mozapps/Makefile
  toolkit/mozapps/downloads/Makefile
  toolkit/mozapps/downloads/src/Makefile
  toolkit/mozapps/extensions/Makefile
  toolkit/mozapps/extensions/public/Makefile
  toolkit/mozapps/extensions/src/Makefile
  toolkit/mozapps/update/Makefile
  toolkit/mozapps/update/public/Makefile
  toolkit/mozapps/update/src/Makefile
  toolkit/mozapps/xpinstall/Makefile
  toolkit/profile/Makefile
  toolkit/profile/public/Makefile
  toolkit/profile/skin/Makefile
  toolkit/profile/src/Makefile
  toolkit/themes/Makefile
  toolkit/themes/gnomestripe/global/Makefile
  toolkit/themes/gnomestripe/Makefile
  toolkit/themes/pmstripe/global/Makefile
  toolkit/themes/pmstripe/Makefile
  toolkit/themes/pinstripe/Makefile
  toolkit/themes/pinstripe/global/Makefile
  toolkit/themes/pinstripe/help/Makefile
  toolkit/themes/pinstripe/mozapps/Makefile
  toolkit/themes/winstripe/Makefile
  toolkit/themes/winstripe/global/Makefile
  toolkit/themes/winstripe/help/Makefile
  toolkit/themes/winstripe/mozapps/Makefile
  toolkit/xre/Makefile
"

MAKEFILES_libpr0n="
  modules/libpr0n/Makefile
  modules/libpr0n/build/Makefile
  modules/libpr0n/public/Makefile
  modules/libpr0n/src/Makefile
  modules/libpr0n/decoders/Makefile
  modules/libpr0n/decoders/gif/Makefile
  modules/libpr0n/decoders/png/Makefile
  modules/libpr0n/decoders/jpeg/Makefile
  modules/libpr0n/decoders/bmp/Makefile
  modules/libpr0n/decoders/icon/Makefile
  modules/libpr0n/decoders/icon/win/Makefile
  modules/libpr0n/decoders/icon/gtk/Makefile
  modules/libpr0n/decoders/icon/beos/Makefile
  modules/libpr0n/decoders/xbm/Makefile
  modules/libpr0n/encoders/Makefile
  modules/libpr0n/encoders/png/Makefile
  modules/libpr0n/encoders/jpeg/Makefile
"

MAKEFILES_accessible="
  accessible/Makefile
  accessible/public/Makefile
  accessible/public/msaa/Makefile
  accessible/src/Makefile
  accessible/src/base/Makefile
  accessible/src/html/Makefile
  accessible/src/xul/Makefile
  accessible/src/msaa/Makefile
  accessible/src/atk/Makefile
  accessible/src/mac/Makefile
  accessible/build/Makefile
"

MAKEFILES_zlib="
  modules/zlib/standalone/Makefile
"

MAKEFILES_libmar="
  modules/libmar/Makefile
  modules/libmar/src/Makefile
  modules/libmar/tool/Makefile
"

add_makefiles "
  $MAKEFILES_db
  $MAKEFILES_dom
  $MAKEFILES_editor
  $MAKEFILES_expat
  $MAKEFILES_gfx
  $MAKEFILES_htmlparser
  $MAKEFILES_intl
  $MAKEFILES_liveconnect
  $MAKEFILES_xpconnect
  $MAKEFILES_jsdebugger
  $MAKEFILES_content
  $MAKEFILES_layout
  $MAKEFILES_libimg
  $MAKEFILES_libjar
  $MAKEFILES_libreg
  $MAKEFILES_libpref
  $MAKEFILES_libutil
  $MAKEFILES_plugin
  $MAKEFILES_netwerk
  $MAKEFILES_uriloader
  $MAKEFILES_profile
  $MAKEFILES_rdf
  $MAKEFILES_sun_java
  $MAKEFILES_caps
  $MAKEFILES_chrome
  $MAKEFILES_view
  $MAKEFILES_docshell
  $MAKEFILES_webshell
  $MAKEFILES_widget
  $MAKEFILES_xpcom
  $MAKEFILES_xpcom_obsolete
  $MAKEFILES_xpcom_tests
  $MAKEFILES_xpinstall
  $MAKEFILES_xpfe
  $MAKEFILES_embedding
  $MAKEFILES_xulapp
  $MAKEFILES_libpr0n
  $MAKEFILES_accessible
  $MAKEFILES_zlib
  $MAKEFILES_libmar
  $MAKEFILES_lcms
"

#
# Conditional makefiles
#

if [ "$MOZ_ZIPWRITER" ]; then
  add_makefiles "
    modules/libjar/zipwriter/Makefile
    modules/libjar/zipwriter/public/Makefile
    modules/libjar/zipwriter/src/Makefile
    modules/libjar/zipwriter/test/Makefile
  "
fi

if [ "$MOZ_STORAGE" ]; then
  add_makefiles "
    db/sqlite3/src/Makefile
    db/morkreader/Makefile
    storage/Makefile
    storage/public/Makefile
    storage/src/Makefile
    storage/build/Makefile
    storage/test/Makefile
  "
fi

if [ "$MOZ_TREE_CAIRO" ] ; then
  add_makefiles "
    gfx/cairo/Makefile
    gfx/cairo/libpixman/src/Makefile
    gfx/cairo/cairo/src/Makefile
    gfx/cairo/cairo/src/cairo-features.h
  "
fi

if [ "$MOZ_UNIVERSALCHARDET" ] ; then
  add_makefiles "
    extensions/universalchardet/Makefile
    extensions/universalchardet/src/Makefile
    extensions/universalchardet/src/base/Makefile
    extensions/universalchardet/src/xpcom/Makefile
    extensions/universalchardet/tests/Makefile
  "
fi

if [ "$MOZ_AUTH_EXTENSION" ]; then
  add_makefiles "
    extensions/auth/Makefile
  "
fi

if test -n "$MOZ_PSM"; then
  add_makefiles "
    security/manager/Makefile
    security/manager/boot/Makefile
    security/manager/boot/src/Makefile
    security/manager/boot/public/Makefile
    security/manager/ssl/Makefile
    security/manager/ssl/src/Makefile
    security/manager/ssl/public/Makefile
    security/manager/pki/Makefile
    security/manager/pki/resources/Makefile
    security/manager/pki/src/Makefile
    security/manager/pki/public/Makefile
    security/manager/locales/Makefile
  "
fi

if [ ! "$SYSTEM_JPEG" ]; then
  add_makefiles "
    jpeg/Makefile
  "
fi

if [ ! "$SYSTEM_ZLIB" ]; then
  add_makefiles "
    modules/zlib/Makefile
    modules/zlib/src/Makefile
  "
fi

if [ ! "$SYSTEM_BZ2" ]; then
  add_makefiles "
    modules/libbz2/Makefile
    modules/libbz2/src/Makefile
  "
fi

if test -n "$MOZ_UPDATE_PACKAGING"; then
  add_makefiles "
    tools/update-packaging/Makefile
    other-licenses/bsdiff/Makefile
  "
fi

if [ ! "$SYSTEM_PNG" ]; then
  add_makefiles "
    modules/libimg/png/Makefile
  "
fi

if [ -f ${srcdir}/l10n/makefiles.all ]; then
  MAKEFILES_langpacks=`cat ${srcdir}/l10n/makefiles.all`
  add_makefiles "
    $MAKEFILES_langpacks
  "
fi

if [ "$MOZ_L10N" ]; then
  add_makefiles "
    l10n/Makefile
  "

  if [ "$MOZ_L10N_LANG" ]; then
    add_makefiles "
      l10n/lang/Makefile
      l10n/lang/addressbook/Makefile
      l10n/lang/bookmarks/Makefile
      l10n/lang/directory/Makefile
      l10n/lang/editor/Makefile
      l10n/lang/global/Makefile
      l10n/lang/history/Makefile
      l10n/lang/messenger/Makefile
      l10n/lang/messengercompose/Makefile
      l10n/lang/navigator/Makefile
      l10n/lang/pref/Makefile
      l10n/lang/related/Makefile
      l10n/lang/sidebar/Makefile
      l10n/lang/addressbook/locale/Makefile
      l10n/lang/bookmarks/locale/Makefile
      l10n/lang/directory/locale/Makefile
      l10n/lang/editor/locale/Makefile
      l10n/lang/global/locale/Makefile
      l10n/lang/history/locale/Makefile
      l10n/lang/messenger/locale/Makefile
      l10n/lang/messengercompose/locale/Makefile
      l10n/lang/navigator/locale/Makefile
      l10n/lang/pref/locale/Makefile
      l10n/lang/related/locale/Makefile
      l10n/lang/sidebar/locale/Makefile
    "
  fi # MOZ_L10N_LANG

fi # MOZ_L10N

if [ "$MOZ_JPROF" ]; then
  add_makefiles "
    tools/jprof/Makefile
    tools/jprof/stub/Makefile
  "
fi

if [ "$MOZ_LEAKY" ]; then
  add_makefiles "
    tools/leaky/Makefile
  "
fi

if [ "$NS_TRACE_MALLOC" ]; then
  add_makefiles "
    tools/trace-malloc/Makefile
    tools/trace-malloc/lib/Makefile
  "
fi

if [ "$MOZ_MAPINFO" ]; then
  add_makefiles "
    tools/codesighs/Makefile
  "
fi

if [ "$MOZ_MATHML" ]; then
  add_makefiles "
    intl/uconv/ucvmath/Makefile
    layout/mathml/Makefile
  "
fi

if [ "$MOZ_SVG" ]; then
  add_makefiles "
    content/svg/Makefile
    content/svg/document/Makefile
    content/svg/document/src/Makefile
    content/svg/content/Makefile
    content/svg/content/src/Makefile
    dom/interfaces/svg/Makefile
    layout/svg/base/src/Makefile
  "
fi

# smil
if [ "$MOZ_SMIL" ]; then
    MAKEFILES_content="$MAKEFILES_content
	content/smil/Makefile
"
fi

if [ "$MOZ_XTF" ]; then
  add_makefiles "
    content/xtf/Makefile
    content/xtf/public/Makefile
    content/xtf/src/Makefile
  "
fi

if [ "$MOZ_XMLEXTRAS" ]; then
  add_makefiles "
    extensions/xmlextras/Makefile
    extensions/xmlextras/pointers/Makefile
    extensions/xmlextras/pointers/src/Makefile
    extensions/xmlextras/build/Makefile
    extensions/xmlextras/build/src/Makefile
  "
fi

if [ "$MOZ_WEBSERVICES" ]; then
  add_makefiles "
    extensions/webservices/Makefile
    extensions/webservices/build/Makefile
    extensions/webservices/build/src/Makefile
    extensions/webservices/interfaceinfo/Makefile
    extensions/webservices/interfaceinfo/src/Makefile
    extensions/webservices/proxy/Makefile
    extensions/webservices/proxy/src/Makefile
    extensions/webservices/public/Makefile
    extensions/webservices/security/Makefile
    extensions/webservices/security/src/Makefile
    extensions/webservices/schema/Makefile
    extensions/webservices/schema/src/Makefile
    extensions/webservices/soap/Makefile
    extensions/webservices/soap/src/Makefile
    extensions/webservices/wsdl/Makefile
    extensions/webservices/wsdl/src/Makefile
  "
fi

if [ "$MOZ_JAVAXPCOM" ]; then
  add_makefiles "
    extensions/java/Makefile
    extensions/java/xpcom/Makefile
    extensions/java/xpcom/interfaces/Makefile
    extensions/java/xpcom/src/Makefile
    extensions/java/xpcom/glue/Makefile
  "
fi

if [ "$MOZ_COMPONENTLIB" ]; then
  add_makefiles "
    embedding/componentlib/Makefile
  "
else
  if [ "$MOZ_STATIC_COMPONENTS" -o "$MOZ_META_COMPONENTS" ]; then
    add_makefiles "
      modules/staticmod/Makefile
    "
  fi
fi # MOZ_COMPONENTLIB

if [ "$MOZ_MEDIA" ]; then
 add_makefiles "
   content/media/Makefile
   content/media/video/Makefile
   content/media/video/public/Makefile
   content/media/video/src/Makefile
   content/media/video/test/Makefile
 "
fi

if [ "$MOZ_OGG" ]; then
 add_makefiles "
   $MAKEFILES_libvorbis
   $MAKEFILES_libtheora
   $MAKEFILES_liboggz
   $MAKEFILES_libogg
   $MAKEFILES_libfishsound
   $MAKEFILES_liboggplay
 "
fi

if [ "$MOZ_SYDNEYAUDIO" ]; then
 add_makefiles "
   $MAKEFILES_libsydneyaudio
 "
fi

if [ "$MOZ_TREE_FREETYPE" ]; then
 add_makefiles "
   $MAKEFILES_freetype2
 "
fi
