
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillahistorylist.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include "gmozillahistorylist.h"
#include "gmozillacppwrapper.h"
#if 0
#endif

/**
 * Struct for holding values for different kinds of indexes to be tested.
 */
typedef struct {
    gint illegal;
    gint over_index;
} IndexToTest;
/**
 * Struct for test data. Global variable named data is created of this type
 * and that variable is used to hold data of test suite that is initalized in
 * init function. Data is used for calling the fuctions and to hold values for
 * expected values.
 */
typedef struct {
    GWebHistoryList* history_list;
    GWebHistoryListIface* iface;
    int numberOfItems;
    GtkWebHistoryItem *expectedItems;
    IndexToTest indexes;
} TestHelpData;

typedef struct {
    int expected_retvalue;
} GMozillaHistoryListClearAllStruct;
typedef struct {
    GType expected_retvalue;
} GMozillaHistoryListGetTypeStruct;
typedef struct {
    GObject* expected_retvalue;
} GMozillaHistoryListNewStruct;
typedef struct {
    GMozillaEngine* engine;
    unsigned int message;
    int number;
    GWebEngineEncoding encoding;
} SendHistoryMessageStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestHelpData help_data;
    TestTableData g_mozilla_history_list_clear_all;
    TestTableData g_mozilla_history_list_get_type;
    TestTableData g_mozilla_history_list_new;
    TestTableData send_history_message;
} TestData;
TestData testdata;

/**
 * Declaration of private functions.
 */
static GMozillaHistoryList* testmozillahistorylist_create_history_list_with_items(int childCount, GtkWebHistoryItem* copyOfItems);



static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_history_list_clear_all.table);
    testdata.g_mozilla_history_list_clear_all.table = NULL;
    testdata.g_mozilla_history_list_clear_all.index = -1;

    g_list_free(testdata.g_mozilla_history_list_get_type.table);
    testdata.g_mozilla_history_list_get_type.table = NULL;
    testdata.g_mozilla_history_list_get_type.index = -1;

    g_list_free(testdata.g_mozilla_history_list_new.table);
    testdata.g_mozilla_history_list_new.table = NULL;
    testdata.g_mozilla_history_list_new.index = -1;

    g_list_free(testdata.send_history_message.table);
    testdata.send_history_message.table = NULL;
    testdata.send_history_message.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_history_list_clear_all(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_clear_all");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_history_list_clear_all.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaHistoryListClearAllStruct* test_item_data =
            (GMozillaHistoryListClearAllStruct*)g_list_nth_data(testdata.g_mozilla_history_list_clear_all.table, test_index);
        testdata.g_mozilla_history_list_clear_all.index++;
        int retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_history_list_clear_all();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            int expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_history_list_clear_all();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_history_list_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_history_list_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaHistoryListGetTypeStruct* test_item_data =
            (GMozillaHistoryListGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_history_list_get_type.table, test_index);
        testdata.g_mozilla_history_list_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_history_list_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_history_list_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_history_list_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_history_list_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaHistoryListNewStruct* test_item_data =
            (GMozillaHistoryListNewStruct*)g_list_nth_data(testdata.g_mozilla_history_list_new.table, test_index);
        testdata.g_mozilla_history_list_new.index++;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_history_list_new();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_history_list_new();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_send_history_message(void)
{

    DEBUG_FUNCTIONS_STARTED("send_history_message");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.send_history_message.index;
        printf("Index of test data: %i\n", test_index);
        SendHistoryMessageStruct* test_item_data =
            (SendHistoryMessageStruct*)g_list_nth_data(testdata.send_history_message.table, test_index);
        testdata.send_history_message.index++;
        GMozillaEngine* engine = test_item_data->engine;
        unsigned int message = test_item_data->message;
        int number = test_item_data->number;
        GWebEngineEncoding encoding = test_item_data->encoding;
        if(testdata.basics) {
            send_history_message(engine,message,number,encoding);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            send_history_message(engine,message,number,encoding);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

//FUNCTIONS FOR TESTING g_mozilla_history_list functions through the interface.

/**
 * g_mozilla_history_list_delete_item deletes items by calling a fuction from
 * other class so actual deleting can't be tested. It takes parameters, so different states
 * can be tested and that is done below.
 */
static void
test_iface_g_mozilla_history_list_delete_item (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_delete_item");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint pos;
        int index;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), pos);
                CU_PASS("Function called for deleting and item from legal position.");
            }
            gint illegal_pos = testdata.help_data.indexes.illegal;
            testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), illegal_pos);
            CU_PASS("Function called for deleting and item from illegal position.");

            gint over_index_pos = testdata.help_data.indexes.over_index;
            testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), over_index_pos);
            CU_PASS("Function called for deleting and item from over index position.");
            CU_PASS("Basic test!");
            
            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), pos);
                CU_PASS("Function called for deleting and item from legal position.");
            }

            gint illegal_pos = testdata.help_data.indexes.illegal;
            testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), illegal_pos);
            CU_PASS("Function called for deleting and item from illegal position.");

            gint over_index_pos = testdata.help_data.indexes.over_index;
            testdata.help_data.iface->delete_item (G_WEB_HISTORY_LIST(testdata.help_data.history_list), over_index_pos);
            CU_PASS("Function called for deleting and item from over index position.");
        }
    }
    DEBUG_FUNCTION_ENDED;
}

/**
 * Here we test that pointer to items returned is not null if there should be
 * items in GMozillaHistoryList. Every value is also checked.
 */
static void
test_iface_g_mozilla_history_list_get_items (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_items");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        GtkWebHistoryItem* items;
        int index;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                printf("    loop%i\n", index);
                printf("    History list pointer: %X\n", (int)testdata.help_data.history_list);
                printf("    iface pointer: %X\n", (int)testdata.help_data.iface);
                printf("    Web History list pointer: %X\n", (int)G_WEB_HISTORY_LIST(testdata.help_data.history_list));
                printf("    History list items: %X\n", (int)G_OBJECT(G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->items));
                items = testdata.help_data.iface->get_items (G_WEB_HISTORY_LIST(testdata.help_data.history_list));
                printf("interface function call made.\n");
            }
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                printf("    loop%i\n", index);
                printf("    History list pointer: %X\n", (int)testdata.help_data.history_list);
                printf("    iface pointer: %X\n", (int)testdata.help_data.iface);
                printf("    Web History list pointer: %X\n", (int)G_WEB_HISTORY_LIST(testdata.help_data.history_list));
                printf("    History list items: %X\n", (int)G_OBJECT(G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->items));
                items = testdata.help_data.iface->get_items (G_WEB_HISTORY_LIST(testdata.help_data.history_list));
                printf("    interface function call made.\n");
                CU_ASSERT_PTR_NOT_EQUAL(items, NULL);
                TESTS_ASSERT_STRING_EQUAL(items[index].url, testdata.help_data.expectedItems[index].url);
                TESTS_ASSERT_STRING_EQUAL(items[index].title, testdata.help_data.expectedItems[index].title);
                TESTS_ASSERT_INT_EQUAL((int)items[index].accessed, (int)testdata.help_data.expectedItems[index].accessed);
                TESTS_ASSERT_STRING_EQUAL(items[index].shistory_thumbnail_fn, testdata.help_data.expectedItems[index].shistory_thumbnail_fn);
            }
        }
    }
    DEBUG_FUNCTION_ENDED;
}

/**
 * Number of items returned needs to be equal to number expected.
 */
static void
test_iface_g_mozilla_history_list_get_items_count (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_items_count");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint retvalue;
        if(testdata.basics) {
            retvalue = testdata.help_data.iface->get_items_count (testdata.help_data.history_list);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            retvalue = testdata.help_data.iface->get_items_count (testdata.help_data.history_list);
            CU_ASSERT_EQUAL(retvalue, testdata.help_data.numberOfItems);
        }
    }

    DEBUG_FUNCTION_ENDED;
}

/**
 * Checks that g_mozilla_history_list_get_item_title return correct titles for
 * all items in list. It also will test that function behaves correctly with
 * illegal index value and, to test all conditions in GMozillaHistoryList,
 * behavior with index bigger than last index in table is also tested.
 */
static void
test_iface_g_mozilla_history_list_get_item_title (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_item_title");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gchar* title;
        int index;
        gint pos;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, pos);
            }
            CU_PASS("Basic test!");

            gint illegal_pos = testdata.help_data.indexes.illegal;
            title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, illegal_pos);

            gint over_count_pos = testdata.help_data.indexes.over_index;
            title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, over_count_pos);

            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, pos);
                TESTS_ASSERT_STRING_EQUAL(title, testdata.help_data.expectedItems[pos].title);
            }

            gint illegal_pos = testdata.help_data.indexes.illegal;
            title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, illegal_pos);
            CU_ASSERT_EQUAL(title, NULL);

            gint over_count_pos = testdata.help_data.indexes.over_index;
            title = testdata.help_data.iface->get_item_title (testdata.help_data.history_list, over_count_pos);
            CU_ASSERT_EQUAL(title, NULL);
        }
    }

    DEBUG_FUNCTION_ENDED;
}
/**
 * Checks that test_g_mozilla_history_list_get_item_url return correct urls for
 * all items in list. It also will test that function behaves correctly with
 * illegal index value.
 */
static void
test_iface_g_mozilla_history_list_get_item_url (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_item_url");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gchar* url;
        int index;
        gint pos;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                url = testdata.help_data.iface->get_item_url (testdata.help_data.history_list, pos);
                TESTS_ASSERT_STRING_EQUAL(url, testdata.help_data.expectedItems[pos].url);
            }
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                url = testdata.help_data.iface->get_item_url (testdata.help_data.history_list, pos);
                TESTS_ASSERT_STRING_EQUAL(url, testdata.help_data.expectedItems[pos].url);
            }

            gint illegal_pos = testdata.help_data.indexes.illegal;
            url = testdata.help_data.iface->get_item_url (testdata.help_data.history_list, illegal_pos);
            CU_ASSERT_EQUAL(url, NULL);
        }
    }

    DEBUG_FUNCTION_ENDED;
}
/**
 * Checks that test_g_mozilla_history_list_get_item_time return correct times for
 * all items in list. It also will test that function behaves correctly with
 * illegal index value.
 */
static void
test_iface_g_mozilla_history_list_get_item_time (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_get_item_time");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint time;
        int index;
        gint pos;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                time = testdata.help_data.iface->get_item_time (testdata.help_data.history_list, pos);
            }
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                time = testdata.help_data.iface->get_item_time (testdata.help_data.history_list, pos);
                TESTS_ASSERT_INT_EQUAL(time, (int)testdata.help_data.expectedItems[pos].accessed);
            }

            gint illegal_pos = testdata.help_data.indexes.illegal;
            time = testdata.help_data.iface->get_item_time (testdata.help_data.history_list, illegal_pos);
            TESTS_ASSERT_INT_EQUAL(time, 0);
        }
    }

    DEBUG_FUNCTION_ENDED;
}
/**
 * Checks that test_g_mozilla_shistory_list_get_item_thumbnail return correct thumbnails for
 * all items in list. It also will test that function behaves correctly with
 * illegal index value.
 */
static void
test_iface_g_mozilla_shistory_list_get_item_thumbnail(void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_shistory_list_get_item_thumbnail");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gchar* thumbnail;
        int index;
        gint pos;
        if(testdata.basics) {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                thumbnail = testdata.help_data.iface->get_item_thumbnail (testdata.help_data.history_list, pos);
                TESTS_ASSERT_STRING_EQUAL(thumbnail, testdata.help_data.expectedItems[pos].shistory_thumbnail_fn);
            }
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            for(index = 0; index < testdata.help_data.numberOfItems; ++index)
            {
                pos = index;
                thumbnail = testdata.help_data.iface->get_item_thumbnail (testdata.help_data.history_list, pos);
                TESTS_ASSERT_STRING_EQUAL(thumbnail, testdata.help_data.expectedItems[pos].shistory_thumbnail_fn);
            }

            gint illegal_pos = testdata.help_data.indexes.illegal;
            thumbnail = testdata.help_data.iface->get_item_thumbnail (testdata.help_data.history_list, illegal_pos);
            CU_ASSERT_EQUAL(thumbnail, NULL);
        }
    }

    DEBUG_FUNCTION_ENDED;
}
/**
 * Calls function to destroy history list. To make sure that list is actually
 * destroyed would be quite tricky, because function is done so that it won't
 * put pointers to NULL after destruction so no assertions are made here.
 */
static void
test_iface_g_mozilla_history_list_destroy (void)
{
    DEBUG_FUNCTIONS_STARTED("g_mozilla_history_list_destroy");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        if(testdata.basics) {
            testdata.help_data.iface->destroy (testdata.help_data.history_list);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            testdata.help_data.iface->destroy (testdata.help_data.history_list);
        }
    }

    DEBUG_FUNCTION_ENDED;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    GMozillaHistoryListClearAllStruct* tmp_g_mozilla_history_list_clear_all = g_new0(GMozillaHistoryListClearAllStruct, 1);
    /* int */tmp_g_mozilla_history_list_clear_all->expected_retvalue = 0;
    testdata.g_mozilla_history_list_clear_all.table =
        g_list_append (testdata.g_mozilla_history_list_clear_all.table, tmp_g_mozilla_history_list_clear_all);
    testdata.g_mozilla_history_list_clear_all.index = 0;

    GMozillaHistoryListGetTypeStruct* tmp_g_mozilla_history_list_get_type = g_new0(GMozillaHistoryListGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_history_list_get_type->expected_retvalue = 0;
    testdata.g_mozilla_history_list_get_type.table =
        g_list_append (testdata.g_mozilla_history_list_get_type.table, tmp_g_mozilla_history_list_get_type);
    testdata.g_mozilla_history_list_get_type.index = 0;

    GMozillaHistoryListNewStruct* tmp_g_mozilla_history_list_new = g_new0(GMozillaHistoryListNewStruct, 1);
    /* GObject* */tmp_g_mozilla_history_list_new->expected_retvalue = 0;
    testdata.g_mozilla_history_list_new.table =
        g_list_append (testdata.g_mozilla_history_list_new.table, tmp_g_mozilla_history_list_new);
    testdata.g_mozilla_history_list_new.index = 0;

    SendHistoryMessageStruct* tmp_send_history_message = g_new0(SendHistoryMessageStruct, 1);
    /* GMozillaEngine* */tmp_send_history_message->engine = NULL;
    /* unsigned int */tmp_send_history_message->message = 0;
    /* int */tmp_send_history_message->number = 0;
    /* GWebEngineEncoding */tmp_send_history_message->encoding = G_WEBENGINE_ENCODING_AUTOMATIC;
    testdata.send_history_message.table =
        g_list_append (testdata.send_history_message.table, tmp_send_history_message);
    testdata.send_history_message.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillahistorylist_advanced_clean");
    return 0;
}

/**
 * Initializes GMozillaHistoryList holding numberOfItems amount of items. Also
 * initializes interface which GMozillaHistoryList will implement and it is
 * needed to gain access to calling of functions in GMozillaHistoryList.
 */
static int
testgmozillahistorylist_interface_init(void)
{
    //testmozillahistorylist_init_test_data();
    init_test_data();
    
    int numberOfItems = 10;
    GtkWebHistoryItem* historyItemTestReference = g_try_new0(GtkWebHistoryItem, numberOfItems);
    if(!historyItemTestReference)
    {
        return 1;
    }
    printf("about to create list.\n");
    testdata.help_data.history_list = G_WEB_HISTORY_LIST(
            testmozillahistorylist_create_history_list_with_items(numberOfItems, historyItemTestReference));
    printf("list created.\n");
    testdata.help_data.expectedItems = historyItemTestReference;
    if(!testdata.help_data.history_list)
    {
        return 1;
    }
    printf("About to get interface.\n");
    testdata.help_data.iface = g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (testdata.help_data.history_list)), G_TYPE_WEB_HISTORY_LIST);
    if(!testdata.help_data.iface)
    {
        return 1;
    }
    printf("Interface received.");
    G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->num_items = numberOfItems;
    testdata.help_data.numberOfItems = numberOfItems;
    G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->isSHistory = TRUE;

    int nullUrlIndex = 2;
    G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->items[nullUrlIndex].url = NULL;
    testdata.help_data.expectedItems[nullUrlIndex].url = NULL;
    
    testdata.help_data.indexes.illegal = -1;
    testdata.help_data.indexes.over_index = numberOfItems;
    printf("testgmozillahistorylist_interface_init ready!\n");
    return 0;
}
/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_interface_clean()
{
    return 0;
}


/**
 * Function used to initialize test data for testing destroy function more
 * carefully. It will put isSHistory field of history_list to FALSE so that
 * we can test that condition with destroy function.
 */
static int
testgmozillahistorylist_interface_destroy_init(void)
{
    printf("testgmozillahistorylist_interface_destroy_init started.\n");
    //testmozillahistorylist_init_test_data();
    init_test_data();

    int numberOfItems = 10;
    testdata.help_data.history_list = G_WEB_HISTORY_LIST(
            testmozillahistorylist_create_history_list_with_items(numberOfItems, NULL));
    if(!testdata.help_data.history_list)
    {
        return 1;
    }
    testdata.help_data.iface = g_type_interface_peek (g_type_class_peek (G_OBJECT_TYPE (testdata.help_data.history_list)), G_TYPE_WEB_HISTORY_LIST);
    if(!testdata.help_data.iface)
    {
        return 1;
    }
    G_MOZILLA_HISTORY_LIST(testdata.help_data.history_list)->isSHistory = FALSE;

    return 0;
    printf("testgmozillahistorylist_interface_destroy_init ended!\n");
}
/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillahistorylist_interface_destroy_clean()
{
    return 0;
}


/******************************************************************************
 * Private functions
 ******************************************************************************/
/**
 * Creates history list with number of items given in parameter.
 */
static GMozillaHistoryList*
testmozillahistorylist_create_history_list_with_items(int childCount, GtkWebHistoryItem* copyOfItems)
{
    GMozillaHistoryList* list = G_MOZILLA_HISTORY_LIST(g_mozilla_history_list_new());
    if(list == NULL)
    {
        return NULL;
    }
    childCount = 10;
    GtkWebHistoryItem* historyItem = g_try_new0(GtkWebHistoryItem, childCount);
    if (!historyItem) {
        g_free(list);
        list = NULL;
        return NULL;
    }
    int i = 0;
    while (i < childCount) {

        gchar* url = g_strdup_printf( "http://www.test%i.com", i);
        gchar* title = g_strdup_printf( "Test%i", i);
        gint accessed = i;
        gchar* thumbnail = g_strdup_printf( "TestThumbnail%i", i);

        historyItem[i].url = url;
        historyItem[i].title = title;
        historyItem[i].accessed = accessed;
        historyItem[i].shistory_thumbnail_fn = thumbnail;
        
        if(copyOfItems)
        {
            copyOfItems[i].url = url;
            copyOfItems[i].title = title;
            copyOfItems[i].accessed = accessed;
            copyOfItems[i].shistory_thumbnail_fn = thumbnail;
        }
        
        ++i;
    }
    list->items = historyItem;
    return list;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillahistorylist_automatic_added[] = {
        // Test is made { "test_g_mozilla_history_list_clear_all", test_g_mozilla_history_list_clear_all },
        // Test is made { "test_g_mozilla_history_list_get_type", test_g_mozilla_history_list_get_type },
        // Test is made { "test_g_mozilla_history_list_new", test_g_mozilla_history_list_new },
        /*NEW*/{ "test_send_history_message", test_send_history_message },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillahistorylist_basics[] = {
        { "test_g_mozilla_history_list_clear_all", test_g_mozilla_history_list_clear_all },
        { "test_g_mozilla_history_list_get_type", test_g_mozilla_history_list_get_type },
        { "test_g_mozilla_history_list_new", test_g_mozilla_history_list_new },
        //NEW { "test_send_history_message", test_send_history_message },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillahistorylist_advanced[] = {
        //{ "test_g_mozilla_history_list_clear_all", test_g_mozilla_history_list_clear_all },
        //{ "test_g_mozilla_history_list_get_type", test_g_mozilla_history_list_get_type },
        //{ "test_g_mozilla_history_list_new", test_g_mozilla_history_list_new },
        ////NEW { "test_send_history_message", test_send_history_message },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Suite for testing interface fuctions of GMozzillaHistoryList.
 */
static CU_TestInfo testgmozillahistorylist_interface[] = { //define something that will test the methods
    //TODO: Implementation of g_mozilla_history_list_get_items is wrong. Items are not of type GObject
    //{ "test_g_mozilla_history_list_get_items", test_g_mozilla_history_list_get_items },
    { "test_iface_g_mozilla_history_list_get_items_count", test_iface_g_mozilla_history_list_get_items_count },
    { "test_iface_g_mozilla_history_list_get_item_title", test_iface_g_mozilla_history_list_get_item_title },
    { "test_iface_g_mozilla_history_list_get_item_url", test_iface_g_mozilla_history_list_get_item_url },
    { "test_iface_g_mozilla_history_list_get_item_time", test_iface_g_mozilla_history_list_get_item_time },
    { "test_iface_g_mozilla_history_list_get_item_thumbnail", test_iface_g_mozilla_shistory_list_get_item_thumbnail },
    { "test_iface_g_mozilla_history_list_delete_item", test_iface_g_mozilla_history_list_delete_item },
    { "test_iface_g_mozilla_history_list_destroy", test_iface_g_mozilla_history_list_destroy },
    CU_TEST_INFO_NULL, //null terminated
};
/**
 * Suite for testing destroy fuction from the interface more carefully.
 */
static CU_TestInfo testgmozillahistorylist_interface_destroy[] = { //define something that will test the methods
    { "test_iface_g_mozilla_history_list_destroy", test_iface_g_mozilla_history_list_destroy },
    CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillahistorylist[] = {
        {"testgmozillahistorylist_automatic_added", testgmozillahistorylist_automatic_init, testgmozillahistorylist_automatic_clean, testgmozillahistorylist_automatic_added },
        {"testgmozillahistorylist_basics", testgmozillahistorylist_basics_init, testgmozillahistorylist_basics_clean, testgmozillahistorylist_basics },
        {"testgmozillahistorylist_advanced", testgmozillahistorylist_advanced_init, testgmozillahistorylist_advanced_clean, testgmozillahistorylist_advanced },
        {"testgmozillahistorylist_interface", testgmozillahistorylist_interface_init, testgmozillahistorylist_interface_clean, testgmozillahistorylist_interface },
        {"testgmozillahistorylist_interface_destroy", testgmozillahistorylist_interface_destroy_init, testgmozillahistorylist_interface_destroy_clean, testgmozillahistorylist_interface_destroy },
        CU_SUITE_INFO_NULL, //null terminated
};
