/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "MicrobEalSidebarExternal.h"
#include "MicrobEalUtils.h"
#include "gmozillaengine.h"
#include <stdio.h>
#include <nsCOMPtr.h>
#include <nsICategoryManager.h>
#include <nsIScriptNameSpaceManager.h>
#include <nsServiceManagerUtils.h>
#include <nsIComponentRegistrar.h>
#include <nsMemory.h>
#include <nsIProgrammingLanguage.h>
#include <nsID.h>
#include <nsIWindowWatcher.h>

NS_IMPL_ISUPPORTS2_CI(MicrobEalSidebarExternal,
                      nsISidebarExternal,
                      nsIClassInfo)

MicrobEalSidebarExternal::MicrobEalSidebarExternal()
{
  ULOG_DEBUG_F();
}

MicrobEalSidebarExternal::~MicrobEalSidebarExternal()
{
  ULOG_DEBUG_F();
}

nsresult
MicrobEalSidebarExternal::RegisterSelf(nsIComponentManager* aCompMgr,
                                       nsIFile* aPath,
                                       const char* aRegistryLocation,
                                       const char* aComponentType,
                                       const nsModuleComponentInfo* aInfo)
{
  ULOG_DEBUG_F();

  nsresult rv;

  nsCOMPtr<nsICategoryManager> catMan = do_GetService(NS_CATEGORYMANAGER_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);

  rv = catMan->AddCategoryEntry(JAVASCRIPT_GLOBAL_PROPERTY_CATEGORY,
                                "external",
                                NS_SIDEBAR_CONTRACTID,
                                PR_TRUE,
                                PR_TRUE,
                                nsnull);

  return rv;
}

nsresult
MicrobEalSidebarExternal::UnregisterSelf(nsIComponentManager* aCompMgr,
                                         nsIFile* aPath,
                                         const char* aRegistryLocation,
                                         const nsModuleComponentInfo* aInfo)
{
  ULOG_DEBUG_F();

  nsresult rv;

  nsCOMPtr<nsICategoryManager> catMan = do_GetService(NS_CATEGORYMANAGER_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);

  rv = catMan->DeleteCategoryEntry(JAVASCRIPT_GLOBAL_PROPERTY_CATEGORY,
                                   "external",
                                   PR_TRUE);

  return rv;
}
/* void AddSearchProvider (in string aDescriptionURL); */
NS_IMETHODIMP
MicrobEalSidebarExternal::AddSearchProvider(const char *aDescriptionURL)
{
  ULOG_DEBUG_F("%s", aDescriptionURL);

  // Get the active window
  nsCOMPtr<nsIWindowWatcher> wwatch = do_GetService(NS_WINDOWWATCHER_CONTRACTID);
  NS_ENSURE_TRUE(wwatch, NS_ERROR_FAILURE);

  nsCOMPtr<nsIDOMWindow> active;
  wwatch->GetActiveWindow(getter_AddRefs(active));
  NS_ENSURE_TRUE(active, NS_ERROR_FAILURE);

  GMozillaEngine* engine = GetGMozEngineForDOMWindow(active);
  gboolean added = FALSE;
  if (engine)
      // Emit signal
      g_signal_emit_by_name(engine,
                            G_WEBWIDGET_ADD_SEARCH_PROVIDER,
                            aDescriptionURL,
                            &added);

  ULOG_DEBUG_F("%d", added);
  return NS_OK;
}

/* unsigned long IsSearchProviderInstalled (in string aSearchURL); */
NS_IMETHODIMP
MicrobEalSidebarExternal::IsSearchProviderInstalled(const char *aSearchURL,
                                                    PRUint32 *_retval NS_OUTPARAM)
{
  ULOG_DEBUG_F("%s", aSearchURL);
  *_retval = 0;
  return NS_OK;
}

/* void getInterfaces (out PRUint32 count, [array, size_is (count), retval] out nsIIDPtr array); */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetInterfaces(PRUint32 *count NS_OUTPARAM,
                                        nsIID ***array NS_OUTPARAM)
{
  ULOG_DEBUG_F();

  nsIID** iids = static_cast<nsIID**>(nsMemory::Alloc(2 * sizeof(nsIID*)));
  NS_ENSURE_TRUE(iids, NS_ERROR_OUT_OF_MEMORY);

  const nsIID& sbIID = NS_GET_IID(nsISidebarExternal);
  iids[0] = static_cast<nsIID*>(nsMemory::Clone(&sbIID, sizeof(nsIID)));
  if (!iids[0]) {
    nsMemory::Free(iids);
    return NS_ERROR_OUT_OF_MEMORY;
  }

  const nsIID& ciIID = NS_GET_IID(nsIClassInfo);
  iids[1] = static_cast<nsIID*>(nsMemory::Clone(&ciIID, sizeof(nsIID)));
  if (!iids[1]) {
    nsMemory::Free(iids[0]);
    nsMemory::Free(iids);
    return NS_ERROR_OUT_OF_MEMORY;
  }

  *array = iids;
  *count = 2;

  return NS_OK;
}

/* nsISupports getHelperForLanguage (in PRUint32 language); */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetHelperForLanguage(PRUint32 language,
                                               nsISupports **_retval NS_OUTPARAM)
{
  ULOG_DEBUG_F();
  *_retval = nsnull;
  return NS_OK;
}

/* readonly attribute string contractID; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetContractID(char **aContractID)
{
  ULOG_DEBUG_F();

  *aContractID = (char*)nsMemory::Clone(NS_SIDEBAR_CONTRACTID,
                                        sizeof(NS_SIDEBAR_CONTRACTID));

  NS_ENSURE_TRUE(*aContractID, NS_ERROR_OUT_OF_MEMORY);

  return NS_OK;
}

/* readonly attribute string classDescription; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetClassDescription(char **aClassDescription)
{
  ULOG_DEBUG_F();
  *aClassDescription = nsnull;
  return NS_OK;
}

/* readonly attribute nsCIDPtr classID; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetClassID(nsCID **aClassID)
{
  ULOG_DEBUG_F();
  *aClassID = nsnull;
  return NS_OK;
}

/* readonly attribute PRUint32 implementationLanguage; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetImplementationLanguage(PRUint32 *aImplementationLanguage)
{
  ULOG_DEBUG_F();
  *aImplementationLanguage = nsIProgrammingLanguage::CPLUSPLUS;
  return NS_OK;
}


/* readonly attribute PRUint32 flags; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetFlags(PRUint32 *aFlags)
{
  ULOG_DEBUG_F();
  *aFlags = nsIClassInfo::DOM_OBJECT;
  return NS_OK;
}

/* [notxpcom] readonly attribute nsCID classIDNoAlloc; */
NS_IMETHODIMP
MicrobEalSidebarExternal::GetClassIDNoAlloc(nsCID *aClassIDNoAlloc)
{
  ULOG_DEBUG_F();
  return NS_ERROR_NOT_AVAILABLE;
}
