/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "MicrobEalNotificationButton.h"
#include "MicrobEalUtils.h"

NS_IMPL_ISUPPORTS1(MicrobEalNotificationButton, nsINotificationButton)

MicrobEalNotificationButton::MicrobEalNotificationButton() : mCallbackHandler(nsnull)
{
}

MicrobEalNotificationButton::~MicrobEalNotificationButton()
{
  mCallbackHandler->Release();
}

nsresult
MicrobEalNotificationButton::ButtonPressed()
{
  if (mCallbackHandler) {
    mCallbackHandler->Execute();
    return NS_OK;
  }

  return NS_ERROR_UNEXPECTED;
}

/* attribute AString label; */
NS_IMETHODIMP
MicrobEalNotificationButton::GetLabel(nsAString & aLabel)
{
  aLabel = mLabel;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationButton::SetLabel(const nsAString & aLabel)
{
  if (CheckLogicalId(aLabel, mLabel))
    return NS_OK;

  mLabel = aLabel;
  return NS_OK;
}

/* attribute AString accessKey; */
NS_IMETHODIMP
MicrobEalNotificationButton::GetAccessKey(nsAString & aAccessKey)
{
  aAccessKey = mAccessKey;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationButton::SetAccessKey(const nsAString & aAccessKey)
{
  mAccessKey = aAccessKey;
  return NS_OK;
}

/* attribute AString popup; */
NS_IMETHODIMP
MicrobEalNotificationButton::GetPopup(nsAString & aPopup)
{
  aPopup = mPopup;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationButton::SetPopup(const nsAString & aPopup)
{
  mPopup = aPopup;
  return NS_OK;
}

/* attribute nsINotificationButtonHandler callback; */
NS_IMETHODIMP
MicrobEalNotificationButton::GetCallback(nsINotificationButtonHandler * *aCallback)
{
  NS_ENSURE_ARG(aCallback);

  *aCallback = mCallbackHandler;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationButton::SetCallback(nsINotificationButtonHandler * aCallback)
{
  NS_ENSURE_ARG(aCallback);
  mCallbackHandler = aCallback;
  mCallbackHandler->AddRef();
  return NS_OK;
}
