/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MICROBEALNOTIFICATIONBOX_H__
#define __MICROBEALNOTIFICATIONBOX_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "nsINotificationBox.h"

#include <nsIGenericFactory.h>
#include <nsCOMArray.h>

#include "MicrobEalNotification.h"
#include "MicrobEalNotificationButton.h"

#define NOTIFICATIONBOX_CONTRACTID "@browser.garage.maemo.org/microb/notificationbox;1"
#define NOTIFICATIONBOX_CLASSNAME "MicroB NotificationBox"
//7b3b01d0-c68f-4f36-b55a-8455d4cc2752
#define NOTIFICATIONBOX_CID  { 0x7b3b01d0, 0xc68f, 0x4f36, { 0xb5, 0x5a, 0x84, 0x55, 0xd4, 0xcc, 0x27, 0x52 } }

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "gmozillaengine.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* Header file */
class MicrobEalNotificationBox : public nsINotificationBox
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSINOTIFICATIONBOX

  MicrobEalNotificationBox();
  virtual ~MicrobEalNotificationBox();

private:
  nsCOMArray<MicrobEalNotification> mNotifications;

  MicrobEalNotification *mCurrent;

  MicrobEalNotification *Get(const nsAString& aValue);
  MicrobEalNotification *Get(MicrobEalNotification *aNotification);
  void Add(MicrobEalNotification *aNotification);
  void Remove(const nsAString &aValue);
  void Remove(MicrobEalNotification *aNotification);
  void RemoveAll();

  PRBool mTitleSet;
  nsString mTitle;

protected:
  // None
};

#endif //#ifndef __NSNOTIFICATIONBOX_H__
