/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLAENGINE_H__
#define __GMOZILLAENGINE_H__

#include <gwebengine.h>
#include <gwebbus.h>
#include <gweb.h>
// FIXME
#include </usr/include/gtkmozembed.h>
// gtk stuff
#include "gdk/gdkx.h"
#include "gtk/gtk.h"

#ifdef __cplusplus /* If this is a C++ compiler, use C linkage */
extern "C" {
#endif

G_BEGIN_DECLS

/** Input Method Context
  */
enum
{
  IM_SIG_HAS_SELECTION,
  IM_SIG_CLIPBOARD_OPERATION,
  IM_SIG_RETRIEVE_SURROUNDING,
  IM_SIG_DELETE_SURROUNDING,
  IM_SIG_COMMIT,
  IM_SIG_PREEDIT_CHANGED,
  IM_SIG_PREEDIT_START,
  IM_SIG_PREEDIT_END,
  IM_NUM_SIGNALS
};

#define G_MOZILLA_ENGINE_NAME             "GMozillaEngine"
#define G_TYPE_MOZILLA_ENGINE             (g_mozilla_engine_get_type ())
#define G_MOZILLA_ENGINE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_ENGINE, GMozillaEngine))
#define G_MOZILLA_ENGINE_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_ENGINE, GMozillaEngineClass))
#define G_IS_MOZILLA_ENGINE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_ENGINE))
#define G_IS_MOZILLA_ENGINE_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_ENGINE))
#define G_MOZILLA_ENGINE_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_ENGINE, GMozillaEngineClass))

typedef struct _GMozillaEngine GMozillaEngine;
typedef struct _GMozillaEngineClass GMozillaEngineClass;

/** Context data structs */
typedef struct _GMozillaEngineCtxUserData GMozillaEngineCtxUserData;
typedef struct _GMozillaEngineCtxDomData GMozillaEngineCtxDomData;
typedef struct _GMozillaEngineCtxMouseData GMozillaEngineCtxMouseData;

/** @struct GMozillaEngine.
  * Defines a Mozilla Engine.
  */
struct _GMozillaEngine
{
    GObject parent;
    GObject* engine;
    GObject* global;

    /* Context Info */
    GMozillaEngineCtxUserData* user_ctx;
    GMozillaEngineCtxDomData* dom_ctx;
    GMozillaEngineCtxMouseData* mouse_ctx;

    gint doc_index;

    GObject *ctx;
    GtkIMContext *gtkIMContext;
    gulong im_signal_cb[IM_NUM_SIGNALS];
    GdkExtensionMode extended_im_mode;
    gint im_surr_offset;
    gint im_surr_num;
    gboolean im_surr_enable;
    gboolean im_do_manual_commit;
    gboolean im_key_pressed;
    guint32 mChromeMask;
    gboolean is_vkb_showed;
    gpointer last_event;

    gboolean text_committed;
    gboolean false_long_press;

    /* small workaround for some JS progress values sent after finish loading */
    gboolean is_loading;

    /* Authentication stuff */
    gchar * username;                         /** < The user's name (used by the password manager) */
    gchar * password;                         /** < The user's password (used by the password manager) */
    gboolean accept;                          /** < If it accepts or not store informations about authentication */
    gchar *last_location;

    gint last_net_status;
    guint sec_mode;
    GArray *signals_array;
    gint signals_array_len;

    gint current_zoom;
    gboolean optimized_view;
    gchar *will_open_location;
    gboolean waiting_connection;
    gboolean user_iteraction_happens;         /* Workaround against specification, and useless Connectivity Info */
    gint progress_bar_state;                  /* Helper variale to control and reduce messaging between UI and Our hacked progress bar ;) */
    guint page_size;
    guint scroll_to_node_timer_id;
    guint vkb_up_timeout;
    gboolean mouse_down;
    gboolean vkb_shown;
    GTimeVal key_press_time;
    GTimeVal key_release_time;
    gboolean emit_open_uri_signal;

    gpointer shistory_listener;
    GObject *notification_vbox;
    int shmid;
    gboolean xshm_rendering_enabled;
    GdkRectangle mLastVisibleArea;
    GdkRectangle mLastTargetArea;
    GdkRegion *mBlockedUpdates;
    int mBlockedUpdatesSource;
    float mZoomValue;
    gpointer select_node;
    GdkRectangle mWindowSize;
    GdkEventKey *prev_eventkey;
    GdkRectangle mMinWindowSize;
    gboolean is_active;
    gboolean dialog_is_active;
    gboolean check_pending_im_enter_keyvent;
    int mBlockedUIRequestsSource;
    GList *mBlockedUIRequests;
    gboolean is_layout_active;
    int ui_xwin_id;
    int mForcedUpdateTimeout;
    guint suspend_timeouts_timer_id;
    guint fake_key_id;
    gboolean timeouts_suspended;
    gboolean mFixedFramesAvailable;
    gboolean mPaintFixedFrames;
    GdkPoint mPrevScrollPos;
    gboolean emit_open_uri_after_click;
    gboolean user_iteraction_click;
    gboolean full_update_required;
    gulong connectivity_signal_id;
    gboolean mouse_up_received;

    gpointer find;
    gchar *prev_find_str;
    gboolean recalculate_element;
    gboolean menu_shown;

    gint nsteps;
    guint navigation_event_id;
    gboolean is_back;

    gboolean dom_focus_while_loading;
    gboolean dom_focused_input;

    guint save_target_id;
};

/** @struct GMozillaEngineClass.
  * Defines the callbacks signals for the Mozilla Engine.
  */
struct _GMozillaEngineClass
{
    GObjectClass parent_class;
    void      (*url_changed)                (GMozillaEngine *, char *);
    void      (*title_changed)              (GMozillaEngine *, char *);
    void      (*close_window)               (GMozillaEngine *, gboolean);
    void      (*start_loading)              (GMozillaEngine *, const char *);
    void      (*finished_loading)           (GMozillaEngine *, int, int, int);
    void      (*progress)                   (GMozillaEngine *, gint curprogress, gint maxprogress);
    void      (*window_request)             (GMozillaEngine *, gpointer, char *, guint, gboolean);
    void      (*icon)                       (GMozillaEngine *, gpointer);
    void      (*loading_progress)           (GMozillaEngine *, gint, gint);
    gint      (*encoding)                   (GMozillaEngine *, guint encoding);
    void      (*security_mode_changed)      (GMozillaEngine *, gpointer, guint);
    gint      (*download_request)           (GMozillaEngine *, const gchar *, const gchar *, const gchar *, glong, gint);
    gint      (*authentification_required)  (GMozillaEngine *, gint, gchar *);
    gint      (*alert)                      (GMozillaEngine *, const gchar *);
    gboolean  (*confirm)                    (GMozillaEngine *, const gchar *);
    gint      (*confirm_ex)                 (GMozillaEngine *, const gchar *, const gchar *, guint bt_flags,
                                                               const gchar *, const gchar *, const gchar *,
                                                               const gchar *, gpointer);
    gchar*    (*prompt)                     (GMozillaEngine *, const gchar *, const gchar *);
    gboolean* (*select)                     (GMozillaEngine *, const gchar *, const gchar *, gpointer, gpointer);
    gint      (*mailto)                     (GMozillaEngine *, const gchar *);
    gint      (*rss_request)                (GMozillaEngine *, gchar *, gchar *);
    void      (*unknown_protocol)           (GMozillaEngine *, const gchar *, gboolean);
    void      (*raise_request)              (GMozillaEngine *);
    gint      (*modal_dialog)               (GObject *, const gchar *, const gchar *, gint, gint, gint, gint);
    void      (*lower_request)              (GMozillaEngine *);
    gboolean  (*upload_dialog)              (GMozillaEngine *, const gchar *, const gchar *, gpointer);
    void      (*file_upload_started)        (GMozillaEngine *);
    void      (*file_upload_progress)       (GMozillaEngine *, gint, const gchar *);
    void      (*file_upload_finished)       (GMozillaEngine *);
    void      (*webengine_popup_menu)       (GMozillaEngine *, guint, gint, gint, gchar *, gchar *, gchar *, gchar *);
    void      (*external_action)            (GMozillaEngine *, const gchar *);
    void      (*frame_stacking_changed)     (GMozillaEngine *, gboolean);
    gint      (*modal_certificate_dialog)   (GMozillaEngine *, const gchar *, gint, gint, gint, gint, gint);
    void      (*ask_cookie)                 (GObject *, gpointer, gint, const gchar *, const gchar *, const gchar *, const gchar *,
                                             const gchar *, gboolean, gint, GObject *);
    gint      (*on_submit)                  (GObject *);
    gint      (*select_match)               (GObject *, gpointer);
    gboolean  (*key_event)                  (GObject *, guint, guint, guint, guint, gpointer);
    gint      (*on_service_notify)          (GObject *, gpointer ctx, const gchar *topic, const gchar *data);
    gboolean  (*size_request)               (GMozillaEngine *, int, int, int, int);
    gint      (*open_uri)                   (GMozillaEngine *, char*);
    void      (*shm_buffer_info)            (GMozillaEngine *);
    void      (*moz_paint_notify)           (GMozillaEngine *);
    void      (*notification_dialog)        (GMozillaEngine *, guint32 xid,  const gchar *);
    void      (*history_changed)            (GMozillaEngine *, guint, gint, gint);
    void      (*meta_refresh)               (GMozillaEngine *, const gchar *, gboolean, gint);
    gboolean  (*add_search_provider)        (GMozillaEngine *, const gchar *);
};

typedef struct _SelectedItem
{
  char* name;
  unsigned int number;
  gboolean selected;
} SelectedItem;

/** Common context data */
typedef struct _GMozillaEngineCtxData GMozillaEngineCtxData;
struct _GMozillaEngineCtxData
{
    guint ctx_type;
    guint moz_ctx_type;
};

/** User context data */
struct _GMozillaEngineCtxUserData
{
    GMozillaEngineCtxData common_data;
    // Referred URL strings are owned by this structure
    gchar *ctx_url;
    gchar *ctx_objurl;
    gchar *ctx_docurl;
    gint x;
    gint y;
};

/** DOM context data */
struct _GMozillaEngineCtxDomData
{
    GMozillaEngineCtxData common_data;
    gboolean mouse_scroll;
    gboolean mouse_up_received;
};

/** Mouse context data */
struct _GMozillaEngineCtxMouseData
{
    GMozillaEngineCtxData common_data;
};

GType g_mozilla_engine_get_type (void);

/** Creates a new mozilla engine instance
  * @return A mozilla engine object
  */
GObject* g_mozilla_engine_new (void);

/** Creates a new mozilla engine instance with a context
  * @param context It is a pointer of the context data struct
  * @return A mozilla engine object according to the context data
  */
GObject* g_mozilla_engine_new_with_context (gpointer context);

/** Creates a new mozilla engine instance with context and tracks
  * @param context It is a pointer of the context data struct
  * @param leave_tracks If the mozilla engine is with or without tracks
  * @return A mozilla engine with context and tracks
  */
GObject* g_mozilla_engine_new_with_context_and_tracks (gpointer context,
        gboolean leave_tracks, gboolean without_history, guint32 flags);

gint
g_mozilla_engine_alert (GMozillaEngine * self, const gchar * dialog_title,
          const gchar * alert_msg, gboolean is_blocking,
          const char *check_msg, gboolean * check_val);

gboolean
g_mozilla_engine_confirm (GMozillaEngine * self, const gchar * dialog_title,
            const gchar * dialog_msg, const char *check_msg,
            gboolean * check_val);

guint
ctx_mozembed_to_eal(guint moz_embed_ctx);

G_END_DECLS

//export for nsITouchInterfaceListener
gint dom_mouse_long_press_cb (GtkMozEmbed *embed, void *event,
                                     GMozillaEngine *self);

guint g_mozilla_engine_get_zoom_level (GMozillaEngine *self);

gboolean content_set_cursor(GMozillaEngine *self, GdkCursorType type);

gpointer g_mozilla_append_notification(GMozillaEngine* self,
                                       const gchar *notification_label,
                                       gpointer notification);

void g_mozilla_add_notification_button(GMozillaEngine* self,
                                       gpointer notification_widget,
                                       gpointer notification,
                                       gpointer notification_button,
                                       gchar *label);

void g_mozilla_show_notification(GMozillaEngine* self,
                                 gpointer notification_widget,
                                 gpointer notification,
                                 const char *title);

void g_mozilla_remove_notification(GMozillaEngine* self,
                                   gpointer notification_widget);

void g_mozilla_engine_update_area(GMozillaEngine *self,
                                  int id, int left, int top,
                                  int width, int height, int zoom);

void g_mozilla_engine_visible_area(GMozillaEngine *self,
                                  int vx, int vy, int vw, int vh,
                                  int tx, int ty, int tw, int th,
                                  int wx, int wy, int ww, int wh);

void g_mozilla_engine_send_mouse_event(GMozillaEngine *self,
                                       int type, int x, int y, int mod,
                                       int button, int clickcount, int time);

void g_mozilla_create_select_notification(GMozillaEngine* self, GSList *list,
                                          gpointer ctx_node, gboolean multiple, const char *title, gint clicked_item);

GWebEngineEncoding g_mozilla_engine_get_encoding (GtkMozEmbed *);

GtkIMContext* register_im_context(GMozillaEngine *self);

gboolean ctx_text_input_or_password(GMozillaEngine *self);

gboolean user_ctx_text_input_or_password(GMozillaEngine *self);

gboolean ctx_text_input(GMozillaEngine *self);

gboolean ctx_password(GMozillaEngine *self);

gboolean ctx_multi(GMozillaEngine *self);

void g_mozilla_engine_go_back(GMozillaEngine *self,
                              guint nsteps);
void g_mozilla_engine_go_forward(GMozillaEngine *self,
                                 guint nsteps);

#ifdef __cplusplus /* If this is a C++ compiler, end C linkage */
}
#endif

#endif /* __GMOZILLAENGINE_H__ */
