/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __tests_common_H__
#define __tests_common_H__


#include <CUnit.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gprintf.h>
#include <stdio.h>



#define TESTS_FAIL_WITH_STRING_MESSAGE(msg)\
{\
    gchar* message;\
    message = g_strdup_printf( "FAILED( \"%s\" )",(msg));\
    CU_assertImplementation(CU_FALSE, __LINE__, message, __FILE__, "", CU_FALSE);\
    g_free(message);\
}

#define TESTS_ASSERT_STRING_EQUAL(actual, expected)\
{\
    if(g_strcmp0(actual,expected) )\
    {\
        gchar* message;\
        message = g_strdup_printf( "TESTS_ASSERT_STRING_EQUAL( %s(\"%s\") == %s(\"%s\") )",#actual,(actual),#expected,(expected));\
        CU_assertImplementation(CU_FALSE, __LINE__, message, __FILE__, "", CU_FALSE);\
        g_free(message);\
    }\
    else\
    {\
        CU_PASS("Strings equal.");\
    }\
}

#define TESTS_ASSERT_STRING_NOT_EQUAL(actual, expected)\
{\
    if(1g_strcmp0(actual,expected) )\
    {\
        gchar* message;\
        message = g_strdup_printf( "TESTS_ASSERT_STRING_NOT_EQUAL( %s(\"%s\") != %s(\"%s\") )",#actual,(actual),#expected,(expected));\
        CU_assertImplementation(CU_FALSE, __LINE__, message, __FILE__, "", CU_FALSE);\
        g_free(message);\
    }\
    else\
    {\
        CU_PASS("Strings not equal.");\
    }\
}
#define TESTS_ASSERT_INT_EQUAL(actual, expected)\
{\
    if((actual) != (expected) )\
    {\
        gchar* message;\
        message = g_strdup_printf( "TESTS_ASSERT_INT_EQUAL(%s( %i ) == %s( %i ))", #actual,(actual),#expected,(expected));\
        CU_assertImplementation(CU_FALSE, __LINE__, message, __FILE__, "", CU_FALSE);\
        g_free(message);\
    }\
    else\
    {\
        CU_PASS("Integers equal.");\
    }\
}

#define TESTS_ASSERT_INT_NOT_EQUAL(actual, expected)\
{\
    if((actual) == (expected) )\
    {\
        gchar* message;\
        message = g_strdup_printf( "TESTS_ASSERT_INT_NOT_EQUAL(%s( %i ) != %s( %i ))", #actual,(actual),#expected,(expected));\
        CU_assertImplementation(CU_FALSE, __LINE__, message, __FILE__, "", CU_FALSE);\
        g_free(message);\
    }\
    else\
    {\
        CU_PASS("Integers not equal.");\
    }\
}

#define DEBUG_FUNCTIONS_STARTED(function_name)\
{\
    printf( "*** Started executing function: %s\n",(function_name));\
}

#define DEBUG_FUNCTION_ENDED \
{\
    printf( "*** Execution ended.\n");\
}

#define INIT_OR_CLEAN_STARTED(function_name)\
{\
    printf( "\n%s\n\n",(function_name));\
}

#define END_INIT_WITH_MESSAGE_IF_FAIL(variable, message)\
{\
    if(!(variable))\
    {\
        printf("\n\nInit failed: %s\n\n\n", (message));\
        return 1;\
    }\
}

typedef struct {
    gint index;
    GList* table;
} TestTableData;


typedef struct {
    gint signal_counter;
    gulong connection_id;
} TestsCommonData;

TestsCommonData tests_common_data;

static void
tests_common_signal_catcher_cb(void)
{
    printf("    Signal catched!\n");
    tests_common_data.signal_counter++;
}
typedef struct {
    GCallback function_to_call;
    int number_of_parameters;
    gpointer function_data;
} TestsCommonFunctionCallData;

/*
static gboolean
tests_common_call_function_and_return_false(gpointer data)
{
    g_return_val_if_fail(data != NULL, FALSE);
    TestsCommonFunctionCallData* real_data = (TestsCommonFunctionCallData*) data;
    g_return_val_if_fail(real_data->function_to_call != NULL, FALSE);
    *(real_data->fuction_to_call)(real_data->fuction_data);
    return FALSE;
}
*/
#endif
