
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillasupport.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#include "gmozillasupport.h"

typedef struct {
    struct timeval test_result_variable;
    struct timeval test_x_variable;
    struct timeval test_y_variable;
    int expected_retvalue;
} GMozillaSupportTimevalSubtractStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestTableData g_mozilla_support_timeval_subtract;
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_support_timeval_subtract.table);
    testdata.g_mozilla_support_timeval_subtract.table = NULL;
    testdata.g_mozilla_support_timeval_subtract.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_support_timeval_subtract(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_support_timeval_subtract");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_support_timeval_subtract.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaSupportTimevalSubtractStruct* test_item_data =
        (GMozillaSupportTimevalSubtractStruct*)g_list_nth_data(testdata.g_mozilla_support_timeval_subtract.table, test_index);
        testdata.g_mozilla_support_timeval_subtract.index++;
        struct timeval result = test_item_data->test_result_variable;
        struct timeval x = test_item_data->test_x_variable;
        struct timeval y = test_item_data->test_y_variable;
        printf("x.tv_usec = %i\n",(int)x.tv_usec);
        printf("y.tv_usec = %i\n",(int)y.tv_usec);
        int retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_support_timeval_subtract(&result, &x, &y);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            int expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_support_timeval_subtract(&test_item_data->test_result_variable, &test_item_data->test_x_variable, &test_item_data->test_y_variable);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillasupport_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillasupport_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillasupport_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    
    GMozillaSupportTimevalSubtractStruct* tmp_g_mozilla_support_timeval_subtract = g_new0(GMozillaSupportTimevalSubtractStruct, 1);
    gettimeofday (&tmp_g_mozilla_support_timeval_subtract->test_x_variable, NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(&tmp_g_mozilla_support_timeval_subtract->test_x_variable, "getting time of day failed");
    gettimeofday (&tmp_g_mozilla_support_timeval_subtract->test_y_variable, NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(&tmp_g_mozilla_support_timeval_subtract->test_y_variable, "getting time of day failed");
    tmp_g_mozilla_support_timeval_subtract->test_y_variable.tv_usec = tmp_g_mozilla_support_timeval_subtract->test_x_variable.tv_usec + 1000;
    /* int */tmp_g_mozilla_support_timeval_subtract->expected_retvalue = 0;
    testdata.g_mozilla_support_timeval_subtract.table =
        g_list_append (testdata.g_mozilla_support_timeval_subtract.table, tmp_g_mozilla_support_timeval_subtract);
    testdata.g_mozilla_support_timeval_subtract.index = 0;

    tmp_g_mozilla_support_timeval_subtract = g_new0(GMozillaSupportTimevalSubtractStruct, 1);
    gettimeofday (&tmp_g_mozilla_support_timeval_subtract->test_x_variable, NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(&tmp_g_mozilla_support_timeval_subtract->test_x_variable, "getting time of day failed");
    gettimeofday (&tmp_g_mozilla_support_timeval_subtract->test_y_variable, NULL);
    END_INIT_WITH_MESSAGE_IF_FAIL(&tmp_g_mozilla_support_timeval_subtract->test_y_variable, "getting time of day failed");
    tmp_g_mozilla_support_timeval_subtract->test_x_variable.tv_usec = 10000000;
    tmp_g_mozilla_support_timeval_subtract->test_y_variable.tv_usec = 0;
    /* int */tmp_g_mozilla_support_timeval_subtract->expected_retvalue = 0;
    testdata.g_mozilla_support_timeval_subtract.table =
        g_list_append (testdata.g_mozilla_support_timeval_subtract.table, tmp_g_mozilla_support_timeval_subtract);
    testdata.g_mozilla_support_timeval_subtract.index = 0;


    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillasupport_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillasupport_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillasupport_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillasupport_advanced_clean");
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillasupport_automatic_added[] = {
        // Test is done { "test_g_mozilla_support_timeval_subtract", test_g_mozilla_support_timeval_subtract },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillasupport_basics[] = {
        { "test_g_mozilla_support_timeval_subtract with all args set with proper values and y.tv_usec is bigger than x.tv_usec", test_g_mozilla_support_timeval_subtract },
        { "test_g_mozilla_support_timeval_subtract with all args set with proper values and y.tv_usec==x.tv_usec-1000", test_g_mozilla_support_timeval_subtract },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillasupport_advanced[] = {
        //{ "test_g_mozilla_support_timeval_subtract", test_g_mozilla_support_timeval_subtract },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillasupport[] = {
        {"testgmozillasupport_automatic_added", testgmozillasupport_automatic_init, testgmozillasupport_automatic_clean, testgmozillasupport_automatic_added },
        {"testgmozillasupport_basics", testgmozillasupport_basics_init, testgmozillasupport_basics_clean, testgmozillasupport_basics },
        {"testgmozillasupport_advanced", testgmozillasupport_advanced_init, testgmozillasupport_advanced_clean, testgmozillasupport_advanced },
        CU_SUITE_INFO_NULL, //null terminated
};
