/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MicrobEalXshmRenderer_h
#define __MicrobEalXshmRenderer_h

#include "nsIDOMEventListener.h"
#include "nsWeakReference.h"
#include "nsCOMPtr.h"
#include "cairo.h"
#include "gfxRect.h"

#include "gmozillaengine.h"
#include "gmozillaweb.h"

#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>

class nsIDOMWindow;

// Shared Memory Buffer Default Depth - Byte Per Pixel
#define SHM_DEPTH   24

// Shared Memory Buffer Max Width
#define SHM_MAX_WIDTH   1500
// Shared Memory Buffer Max Height
#define SHM_MAX_HEIGHT  2500

class MicrobShmBufData
{
public:
  MicrobShmBufData() : id(-1), width(0), height(0), depth(0), bpl(0), blocked(0), data(0) {};
  ~MicrobShmBufData();
  void SetData(unsigned long id, int width, int height, int depth);
  int16_t IsBlocked(void) { if (id == -1) return false; return blocked ? *blocked : false; };
  void SetBlocked(int16_t aIsBlocked) { if (blocked) *blocked = aIsBlocked; };

  int id;
  int width;
  int height;
  int depth;
  int bpl;
  int16_t *blocked;
  void *data;
};

class MicrobEalXshmRenderer : public nsIDOMEventListener,
                              public nsSupportsWeakReference
{
    public:
        NS_DECL_ISUPPORTS
        NS_DECL_NSIDOMEVENTLISTENER

        MicrobEalXshmRenderer();
        ~MicrobEalXshmRenderer();

        nsresult Init(GObject *aWeb);
        nsresult SetUp(GMozillaEngine* engine);
        nsresult UnSetup(nsIDOMWindow *aWindow);
        nsresult PushUpdateRequest(GMozillaEngine* engine, GdkRectangle &aRect, int aReqestId, int zoom = 100);
        static nsresult ResumePendingUpdates(GMozillaEngine* engine);
        static nsresult SuspendPendingUpdates(GMozillaEngine* engine);

        MicrobShmBufData mShmData;
    private:

        nsresult CreateSharedImageData(int width, int height, int depth, GMozillaEngine *aEngine = nsnull);
        static nsresult DrawRectToXshm(nsIDOMWindow *aWindow, gfxRect &aRect, MicrobShmBufData &aData, int aRequestId, float aZoomValue = 1.0);
        static int byte_per_pixel(int depth);

        nsresult RestartShmbShrinkTimer();
        guint GetWindowCount();
        static gboolean draw_blocked_rect(GMozillaEngine *engine, int left, int top, int width, int height, int id);
        static gboolean check_blocked_updates(void *data);
        static gboolean check_blocked_ui_updates(void *data);
        static gboolean force_update_timeout(void *data);
        static gboolean shmbshrinktimer_cb(MicrobEalXshmRenderer* self);
        gboolean CheckVisibility(nsIDOMElement *aElement);
        nsresult UpdateUIShmInfo(void);

        GObject *mGWeb;
        PRBool mDoFrameExpand;
        PRBool mEnableBufferShrink;
        guint mShmShrinkTimerId;
        PRInt32 mShrinkTimeout;
        PRInt32 mDefBuffWidth;
        PRInt32 mDefBuffHeight;
};

#endif /* __MicrobEalXshmRenderer_h */
