
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillapluginlist.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include "gmozillacppwrapper.h"
#include "gmozillapluginlist.h"
#include <unistd.h>
#include <string.h>
#include <glib/gstdio.h>

typedef struct {
    GSList** plugin_list;
    gboolean expected_retvalue;
} GMozillaPluginDisablePluginsStruct;
typedef struct {
    GSList** plugin_list;
    gboolean expected_retvalue;
} GMozillaPluginEnablePluginsStruct;
typedef struct {
    gchar* name;
    gboolean expected_retvalue;
} GMozillaPluginGetItemStatusStruct;
typedef struct {
    GType expected_retvalue;
} GMozillaPluginListGetTypeStruct;
typedef struct {
    GObject* expected_retvalue;
} GMozillaPluginListNewStruct;
typedef struct {
    gchar* name;
    gboolean enabled;
    gboolean expected_retvalue;
} GMozillaPluginSetItemStatusStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestTableData g_mozilla_plugin_disable_plugins;
    TestTableData g_mozilla_plugin_enable_plugins;
    TestTableData g_mozilla_plugin_get_item_status;
    TestTableData g_mozilla_plugin_list_get_type;
    TestTableData g_mozilla_plugin_list_new;
    TestTableData g_mozilla_plugin_set_item_status;
} TestData;
TestData testdata;
static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_plugin_disable_plugins.table);
    testdata.g_mozilla_plugin_disable_plugins.table = NULL;
    testdata.g_mozilla_plugin_disable_plugins.index = -1;

    g_list_free(testdata.g_mozilla_plugin_enable_plugins.table);
    testdata.g_mozilla_plugin_enable_plugins.table = NULL;
    testdata.g_mozilla_plugin_enable_plugins.index = -1;

    g_list_free(testdata.g_mozilla_plugin_get_item_status.table);
    testdata.g_mozilla_plugin_get_item_status.table = NULL;
    testdata.g_mozilla_plugin_get_item_status.index = -1;

    g_list_free(testdata.g_mozilla_plugin_list_get_type.table);
    testdata.g_mozilla_plugin_list_get_type.table = NULL;
    testdata.g_mozilla_plugin_list_get_type.index = -1;

    g_list_free(testdata.g_mozilla_plugin_list_new.table);
    testdata.g_mozilla_plugin_list_new.table = NULL;
    testdata.g_mozilla_plugin_list_new.index = -1;

    g_list_free(testdata.g_mozilla_plugin_set_item_status.table);
    testdata.g_mozilla_plugin_set_item_status.table = NULL;
    testdata.g_mozilla_plugin_set_item_status.index = -1;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_disable_plugins(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_disable_plugins");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_disable_plugins.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginDisablePluginsStruct* test_item_data =
            (GMozillaPluginDisablePluginsStruct*)g_list_nth_data(testdata.g_mozilla_plugin_disable_plugins.table, test_index);
        testdata.g_mozilla_plugin_disable_plugins.index++;
        GSList** plugin_list = test_item_data->plugin_list;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_disable_plugins(plugin_list);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_disable_plugins(plugin_list);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_enable_plugins(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_enable_plugins");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_enable_plugins.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginEnablePluginsStruct* test_item_data =
            (GMozillaPluginEnablePluginsStruct*)g_list_nth_data(testdata.g_mozilla_plugin_enable_plugins.table, test_index);
        testdata.g_mozilla_plugin_enable_plugins.index++;
        GSList** plugin_list = test_item_data->plugin_list;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_enable_plugins(plugin_list);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_enable_plugins(plugin_list);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_get_item_status(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_get_item_status");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_get_item_status.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginGetItemStatusStruct* test_item_data =
            (GMozillaPluginGetItemStatusStruct*)g_list_nth_data(testdata.g_mozilla_plugin_get_item_status.table, test_index);
        testdata.g_mozilla_plugin_get_item_status.index++;
        gchar* name = test_item_data->name;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_get_item_status(name);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_get_item_status(name);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_list_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_list_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_list_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginListGetTypeStruct* test_item_data =
            (GMozillaPluginListGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_plugin_list_get_type.table, test_index);
        testdata.g_mozilla_plugin_list_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_list_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GType expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_list_get_type();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_list_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_list_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_list_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginListNewStruct* test_item_data =
            (GMozillaPluginListNewStruct*)g_list_nth_data(testdata.g_mozilla_plugin_list_new.table, test_index);
        testdata.g_mozilla_plugin_list_new.index++;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_list_new();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_list_new();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_plugin_set_item_status(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_plugin_set_item_status");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_plugin_set_item_status.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaPluginSetItemStatusStruct* test_item_data =
            (GMozillaPluginSetItemStatusStruct*)g_list_nth_data(testdata.g_mozilla_plugin_set_item_status.table, test_index);
        testdata.g_mozilla_plugin_set_item_status.index++;
        gchar* name = test_item_data->name;
        gboolean enabled = test_item_data->enabled;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_plugin_set_item_status(name,enabled);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_plugin_set_item_status(name,enabled);
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_init");
    //init_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    GMozillaPluginDisablePluginsStruct* tmp_g_mozilla_plugin_disable_plugins = g_new0(GMozillaPluginDisablePluginsStruct, 1);
    /* GSList** */tmp_g_mozilla_plugin_disable_plugins->plugin_list = NULL;
    /* gboolean */tmp_g_mozilla_plugin_disable_plugins->expected_retvalue = 0;
    testdata.g_mozilla_plugin_disable_plugins.table =
        g_list_append (testdata.g_mozilla_plugin_disable_plugins.table, tmp_g_mozilla_plugin_disable_plugins);
    testdata.g_mozilla_plugin_disable_plugins.index = 0;

    GMozillaPluginEnablePluginsStruct* tmp_g_mozilla_plugin_enable_plugins = g_new0(GMozillaPluginEnablePluginsStruct, 1);
    /* GSList** */tmp_g_mozilla_plugin_enable_plugins->plugin_list = NULL;
    /* gboolean */tmp_g_mozilla_plugin_enable_plugins->expected_retvalue = 0;
    testdata.g_mozilla_plugin_enable_plugins.table =
        g_list_append (testdata.g_mozilla_plugin_enable_plugins.table, tmp_g_mozilla_plugin_enable_plugins);
    testdata.g_mozilla_plugin_enable_plugins.index = 0;

    GMozillaPluginGetItemStatusStruct* tmp_g_mozilla_plugin_get_item_status = g_new0(GMozillaPluginGetItemStatusStruct, 1);
    /* gchar* */tmp_g_mozilla_plugin_get_item_status->name = NULL;
    /* gboolean */tmp_g_mozilla_plugin_get_item_status->expected_retvalue = 0;
    testdata.g_mozilla_plugin_get_item_status.table =
        g_list_append (testdata.g_mozilla_plugin_get_item_status.table, tmp_g_mozilla_plugin_get_item_status);
    testdata.g_mozilla_plugin_get_item_status.index = 0;

    GMozillaPluginListGetTypeStruct* tmp_g_mozilla_plugin_list_get_type = g_new0(GMozillaPluginListGetTypeStruct, 1);
    /* GType */tmp_g_mozilla_plugin_list_get_type->expected_retvalue = 0;
    testdata.g_mozilla_plugin_list_get_type.table =
        g_list_append (testdata.g_mozilla_plugin_list_get_type.table, tmp_g_mozilla_plugin_list_get_type);
    testdata.g_mozilla_plugin_list_get_type.index = 0;

    GMozillaPluginListNewStruct* tmp_g_mozilla_plugin_list_new = g_new0(GMozillaPluginListNewStruct, 1);
    /* GObject* */tmp_g_mozilla_plugin_list_new->expected_retvalue = 0;
    testdata.g_mozilla_plugin_list_new.table =
        g_list_append (testdata.g_mozilla_plugin_list_new.table, tmp_g_mozilla_plugin_list_new);
    testdata.g_mozilla_plugin_list_new.index = 0;

    GMozillaPluginSetItemStatusStruct* tmp_g_mozilla_plugin_set_item_status = g_new0(GMozillaPluginSetItemStatusStruct, 1);
    /* gchar* */tmp_g_mozilla_plugin_set_item_status->name = NULL;
    /* gboolean */tmp_g_mozilla_plugin_set_item_status->enabled = FALSE;
    /* gboolean */tmp_g_mozilla_plugin_set_item_status->expected_retvalue = 0;
    testdata.g_mozilla_plugin_set_item_status.table =
        g_list_append (testdata.g_mozilla_plugin_set_item_status.table, tmp_g_mozilla_plugin_set_item_status);
    testdata.g_mozilla_plugin_set_item_status.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_advanced_init");
    g_type_init();
    init_test_data();
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillapluginlist_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillapluginlist_advanced_clean");
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillapluginlist_automatic_added[] = {
        // Test is made { "test_g_mozilla_plugin_disable_plugins", test_g_mozilla_plugin_disable_plugins },
        // Test is made { "test_g_mozilla_plugin_enable_plugins", test_g_mozilla_plugin_enable_plugins },
        // Test is made { "test_g_mozilla_plugin_get_item_status", test_g_mozilla_plugin_get_item_status },
        // Test is made { "test_g_mozilla_plugin_list_get_type", test_g_mozilla_plugin_list_get_type },
        // Test is made { "test_g_mozilla_plugin_list_new", test_g_mozilla_plugin_list_new },
        // Test is made { "test_g_mozilla_plugin_set_item_status", test_g_mozilla_plugin_set_item_status },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillapluginlist_basics[] = {
        { "test_g_mozilla_plugin_disable_plugins", test_g_mozilla_plugin_disable_plugins },
        { "test_g_mozilla_plugin_enable_plugins", test_g_mozilla_plugin_enable_plugins },
        { "test_g_mozilla_plugin_get_item_status", test_g_mozilla_plugin_get_item_status },
        { "test_g_mozilla_plugin_list_get_type", test_g_mozilla_plugin_list_get_type },
        { "test_g_mozilla_plugin_list_new", test_g_mozilla_plugin_list_new },
        { "test_g_mozilla_plugin_set_item_status", test_g_mozilla_plugin_set_item_status },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillapluginlist_advanced[] = {
        //{ "test_g_mozilla_plugin_disable_plugins", test_g_mozilla_plugin_disable_plugins },
        //{ "test_g_mozilla_plugin_enable_plugins", test_g_mozilla_plugin_enable_plugins },
        //{ "test_g_mozilla_plugin_get_item_status", test_g_mozilla_plugin_get_item_status },
        //{ "test_g_mozilla_plugin_list_get_type", test_g_mozilla_plugin_list_get_type },
        //{ "test_g_mozilla_plugin_list_new", test_g_mozilla_plugin_list_new },
        //{ "test_g_mozilla_plugin_set_item_status", test_g_mozilla_plugin_set_item_status },
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillapluginlist[] = {
        {"testgmozillapluginlist_automatic_added", testgmozillapluginlist_automatic_init, testgmozillapluginlist_automatic_clean, testgmozillapluginlist_automatic_added },
        {"testgmozillapluginlist_basics", testgmozillapluginlist_basics_init, testgmozillapluginlist_basics_clean, testgmozillapluginlist_basics },
        {"testgmozillapluginlist_advanced", testgmozillapluginlist_advanced_init, testgmozillapluginlist_advanced_clean, testgmozillapluginlist_advanced },
        CU_SUITE_INFO_NULL, //null terminated
};
