/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//#define MOZEAL_LOGGING 1

#include "MicrobEalUtils.h"
#include "common.h"
#include <stdio.h>

#include "nsIWidget.h"
#include "nsIEmbeddingSiteWindow.h"
#include "nsIDOMWindow.h"
#include "nsIDOMDocument.h"
#include "nsIDOMDocumentView.h"
#include "nsIDOMAbstractView.h"
#include "nsIWebBrowserChrome.h"
#include "nsIWindowWatcher.h"
#include "nsServiceManagerUtils.h"
#include "nsIDocShell.h"
#include "nsIInterfaceRequestorUtils.h"
#include "gtkmozembed_internal.h"
#include "nsIDocument.h"
#include "nsIPresShell.h"
#include "gmozillaweb.h"

// Helper method for getting GMozillaEngine pointer from nsIDOMWindow
GMozillaEngine* GetGMozEngineForDOMWindow(nsIDOMWindow* aDOMWindow, GObject** aMozEmbed)
{
  GMozillaEngine *engine = nsnull;
  nsresult rv;
  nsCOMPtr<nsIWebBrowserChrome> chrome;
  nsCOMPtr<nsIWindowWatcher> wwatch = do_GetService(NS_WINDOWWATCHER_CONTRACTID, &rv);
  if (wwatch) {
    if (!aDOMWindow) {
      nsCOMPtr <nsIDOMWindow> DOMWindow;
      rv = wwatch->GetActiveWindow(getter_AddRefs(DOMWindow));
      if (NS_SUCCEEDED(rv) && DOMWindow)
        wwatch->GetChromeForWindow(DOMWindow, getter_AddRefs(chrome));
    } else
      wwatch->GetChromeForWindow(aDOMWindow, getter_AddRefs(chrome));

    if (!chrome) { // try top level window
      nsCOMPtr <nsIDOMWindow> topDOMWindow;
      if (!aDOMWindow) {
        nsCOMPtr <nsIDOMWindow> activeDOMWindow;
        rv = wwatch->GetActiveWindow(getter_AddRefs(activeDOMWindow));
        if (NS_FAILED(rv) || !activeDOMWindow) {
          GMozillaWeb *web = g_mozilla_get_current_web();
          if (web) {
            GList *c = NULL;
            for (c = web->window_list; c; c = c->next) {
              engine = (GMozillaEngine*) c->data;
              if (engine && engine->is_active) {
                if (aMozEmbed)
                  *aMozEmbed = G_OBJECT(engine->engine);
                return engine;
              }
            }
          }
          return nsnull;
        }
        activeDOMWindow->GetTop(getter_AddRefs(topDOMWindow));
      } else {
        aDOMWindow->GetTop(getter_AddRefs(topDOMWindow));
      }
      wwatch->GetChromeForWindow(topDOMWindow, getter_AddRefs(chrome));
    }
  }

  if (!chrome) {
    return nsnull;
  }

  nsCOMPtr<nsIEmbeddingSiteWindow> siteWindow = nsnull;
  siteWindow = do_QueryInterface(chrome, &rv);

  if (NS_FAILED(rv) || !siteWindow) {
    return nsnull;
  }

  GtkWidget* parentWidget;
  rv = siteWindow->GetSiteWindow((void**)(void*)&parentWidget);
  NS_ENSURE_SUCCESS(rv, nsnull);
  if (GTK_IS_WIDGET(parentWidget)) {
    engine = G_MOZILLA_ENGINE(g_object_get_data(G_OBJECT(parentWidget), G_MOZILLA_EAL_PARENT));
    if (aMozEmbed)
      *aMozEmbed = G_OBJECT(parentWidget);
    return engine;
  }

  return nsnull;
}

nsresult
GetDOMWindowByNode(nsIDOMNode *aNode, nsIDOMWindow **aDOMWindow)
{
  NS_ENSURE_ARG(aNode);
  NS_ENSURE_ARG_POINTER(aDOMWindow);
  nsresult rv;
  nsCOMPtr<nsIDOMDocument> nodeDoc;
  rv = aNode ? aNode->GetOwnerDocument(getter_AddRefs(nodeDoc)) : NS_ERROR_FAILURE;
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMDocumentView> docView = do_QueryInterface(nodeDoc, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMAbstractView> absView;
  NS_ENSURE_SUCCESS(rv, rv);
  rv = docView->GetDefaultView(getter_AddRefs(absView));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMWindow> window = do_QueryInterface(absView, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  *aDOMWindow = window;
  NS_IF_ADDREF(*aDOMWindow);
  return rv;
}

nsresult GetContentViewer(nsIWebBrowser *webBrowser, nsIContentViewer **aViewer)
{
  NS_ENSURE_TRUE(webBrowser, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDocShell> docShell(do_GetInterface((nsISupports*)webBrowser));
  NS_ENSURE_TRUE(docShell, NS_ERROR_FAILURE);
  return docShell->GetContentViewer(aViewer);
}


nsresult
GetSendEventTools(GMozillaEngine *self, nsIWidget * *aWidget, nsIViewManager **aViewMgr, nsIDOMWindow * *aDOMWindow)
{
  NS_ENSURE_ARG(self);
  NS_ENSURE_ARG(self->engine);
  NS_ENSURE_ARG_POINTER(aWidget);

  nsresult rv;
  nsCOMPtr <nsIDOMWindow> window;
  nsCOMPtr<nsIViewManager> viewManager;
  nsCOMPtr<nsIWidget> widget;
  nsCOMPtr <nsIWebBrowser> webBrowser;
  gtk_moz_embed_get_nsIWebBrowser(GTK_MOZ_EMBED(self->engine), getter_AddRefs(webBrowser));
  NS_ENSURE_TRUE(webBrowser, NS_ERROR_FAILURE);
  rv = webBrowser->GetContentDOMWindow(getter_AddRefs(window));
  NS_ENSURE_TRUE(window, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDocument> doc;
  nsCOMPtr<nsIDOMDocument> domDoc;
  rv = window->GetDocument(getter_AddRefs(domDoc));
  doc = do_QueryInterface(domDoc, &rv);
  NS_ENSURE_TRUE(doc, NS_ERROR_FAILURE);
  nsIPresShell *shell = doc->GetPrimaryShell();
  NS_ENSURE_TRUE(shell, NS_ERROR_FAILURE);
  viewManager = shell->GetViewManager();
  NS_ENSURE_TRUE(viewManager, NS_ERROR_FAILURE);
  rv = viewManager->GetRootWidget(getter_AddRefs(widget));
  NS_ENSURE_TRUE(widget, NS_ERROR_FAILURE);
  NS_IF_ADDREF(*aWidget = widget);
  if (aViewMgr)
    NS_IF_ADDREF(*aViewMgr = viewManager);
  if (aDOMWindow)
    NS_IF_ADDREF(*aDOMWindow = window);
  return NS_OK;
}
