/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "MicrobEalNotificationBox.h"
#include "MicrobEalNotification.h"

#include "nsIComponentManager.h"
#include "nsComponentManagerUtils.h"
#include "nsIComponentRegistrar.h"
#include "nsCOMPtr.h"

#include "MicrobEalUtils.h"

/* Implementation file */
NS_IMPL_ISUPPORTS1(MicrobEalNotificationBox, nsINotificationBox)

MicrobEalNotificationBox::MicrobEalNotificationBox() : mCurrent(NULL)
{
}

MicrobEalNotificationBox::~MicrobEalNotificationBox()
{
  mNotifications.Clear();
}

/* attribute boolean notificationsHidden; */
NS_IMETHODIMP
MicrobEalNotificationBox::GetNotificationsHidden(PRBool *aNotificationsHidden)
{
  // Not supported
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationBox::SetNotificationsHidden(PRBool aNotificationsHidden)
{
  // Not supported
  return NS_OK;
}

/* nsINotification appendNotification (in AString aLabel, in AString aValue, in AString aImageUrl, in long aPriority, in nsIArray aButtons); */
NS_IMETHODIMP
MicrobEalNotificationBox::AppendNotification(const nsAString & aLabel,
                                             const nsAString & aValue,
                                             const nsAString & aImageUrl,
                                             PRInt32 aPriority,
                                             nsIArray *aButtons,
                                             nsINotification **_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(aButtons);
  NS_ENSURE_ARG(_retval);

  GMozillaEngine* engine = GetGMozEngineForDOMWindow(NULL);
  if (!engine)
    return NS_ERROR_NOT_AVAILABLE;

  *_retval = NULL;
  nsCOMPtr<MicrobEalNotification> notification(do_CreateInstance(NOTIFICATION_CONTRACTID));
  if (!notification) {
    return NS_ERROR_NOT_AVAILABLE;
  }

  notification->SetValue(aValue);
  notification->SetLabel(aLabel);
  notification->SetEngine(engine);
  notification->AddButtons(aButtons);

  *_retval = notification;
  Add(notification);
  notification->AddRef();

  mCurrent = notification;

  return NS_OK;
}

/* nsINotification getNotificationWithValue (in AString aValue); */
NS_IMETHODIMP
MicrobEalNotificationBox::GetNotificationWithValue(const nsAString & aValue,
                                                   nsINotification **_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(_retval);
  *_retval = Get(aValue);

  return NS_OK;
}

/* void removeAllNotifications (in boolean immediate); */
NS_IMETHODIMP
MicrobEalNotificationBox::RemoveAllNotifications(PRBool immediate)
{
  RemoveAll();

  return NS_OK;
}

/* void removeCurrentNotification (); */
NS_IMETHODIMP
MicrobEalNotificationBox::RemoveCurrentNotification()
{
  Remove(mCurrent);
  mCurrent = NULL;;

  return NS_OK;
}

/* void removeNotification (in nsINotification aNotification); */
NS_IMETHODIMP
MicrobEalNotificationBox::RemoveNotification(nsINotification *aNotification)
{
  NS_ENSURE_ARG(aNotification);
  MicrobEalNotification *notification = static_cast<MicrobEalNotification *>(aNotification);
  Remove(notification);

  return NS_OK;
}

/* void removeTransientNotifications (); */
NS_IMETHODIMP
MicrobEalNotificationBox::RemoveTransientNotifications()
{
  // Not supported
  return NS_OK;
}

/* void buttonPressed (ButtonPressed(nsINotification *aNotification, nsINotificationButton *aNotificationButton) */
NS_IMETHODIMP
MicrobEalNotificationBox::ButtonPressed(nsINotification *aNotification,
                                        nsINotificationButton *aNotificationButton)
{
  NS_ENSURE_ARG(aNotification);
  NS_ENSURE_ARG(aNotificationButton);

  MicrobEalNotification *notification = static_cast<MicrobEalNotification *>(aNotification);
  MicrobEalNotificationButton *button = static_cast<MicrobEalNotificationButton *>(aNotificationButton);

  nsresult rv = notification->ButtonPressed(button);

  Remove(notification);

  return rv;
}

/* attribute AString title; */
NS_IMETHODIMP
MicrobEalNotificationBox::GetTitle(nsAString & aTitle)
{
  aTitle = mTitle;
  return NS_OK;
}

NS_IMETHODIMP
MicrobEalNotificationBox::SetTitle(const nsAString & aTitle)
{
  mTitle = aTitle;
  return NS_OK;
}

MicrobEalNotification *
MicrobEalNotificationBox::Get(const nsAString& aNotificationValue)
{
  GMozillaEngine* engine = GetGMozEngineForDOMWindow(NULL);
  if (!engine)
    return NULL;

  const PRUint32 arraySize=mNotifications.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    if (!mNotifications[i]) {
      continue;
    }

    // First check that is it for our window
    GMozillaEngine *notifEngine=NULL;
    mNotifications[i]->GetEngine(&notifEngine);
    if (engine == notifEngine) {
      // It is, is the label same?
      nsString value;
      mNotifications[i]->GetValue(value);

      if (value == aNotificationValue) {
        return mNotifications[i];
      }
    }
  }

  // Not found!

  return NULL;
}

MicrobEalNotification *
MicrobEalNotificationBox::Get(MicrobEalNotification *aNotification)
{
  GMozillaEngine* engine = GetGMozEngineForDOMWindow(NULL);
  if (!engine)
    return NULL;

  const PRUint32 arraySize=mNotifications.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    if (!mNotifications[i]) {
      continue;
    }

    GMozillaEngine *notifEngine=NULL;
    mNotifications[i]->GetEngine(&notifEngine);
    if (engine == notifEngine) {
      if (aNotification == mNotifications[i]) {
        return mNotifications[i];
      }

    }
  }

  // Not found!

  return NULL;
}

void
MicrobEalNotificationBox::Add(MicrobEalNotification *aNotification)
{
  if (!aNotification)
    return;
  const PRUint32 arraySize=mNotifications.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    if (NULL == mNotifications[i]) {
      mNotifications.ReplaceObjectAt(aNotification, i);

      aNotification->AddRef();
      aNotification->AddToUi(mTitle);
      return;
    }
  }

  // There was no empty slot, add one
  mNotifications.AppendObject(aNotification);

  aNotification->AddRef();
  aNotification->AddToUi(mTitle);
}

void
MicrobEalNotificationBox::Remove(const nsAString &aValue)
{
  MicrobEalNotification *notif=Get(aValue);
  if (notif) {
    Remove(notif);
  }
}

void
MicrobEalNotificationBox::Remove(MicrobEalNotification *aNotification)
{
  if (!aNotification) {
    return;
  }

  const PRUint32 arraySize=mNotifications.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    if (!mNotifications[i]) {
      continue;
    }

    if (aNotification == mNotifications[i]) {
      aNotification->RemoveFromUi();
      mNotifications.ReplaceObjectAt(NULL, i);
      return;
    }
  }
}

void
MicrobEalNotificationBox::RemoveAll()
{
  GMozillaEngine* engine = GetGMozEngineForDOMWindow(NULL);
  if (!engine)
    return;

  const PRUint32 arraySize=mNotifications.Count();
  for (PRUint32 i=0; i<arraySize; i++) {
    if (mNotifications[i]) {
      continue;
    }

    GMozillaEngine *notifEngine=NULL;
    mNotifications[i]->GetEngine(&notifEngine);
    if (engine == notifEngine) {
      mNotifications[i]->RemoveFromUi();
      MicrobEalNotification *notification = mNotifications[i];
      mNotifications.ReplaceObjectAt(NULL, i);
      NS_IF_RELEASE(notification);
    }
  }
}

