
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */



#include "testgmozillatransferitem.h"
#include "tests_common.h"

#include <assert.h>
#include <Automated.h>

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "common.h"
#include "gmozillatransferitem.h"
#include "gmozillamarshal.h"
#include "gmozillaengine.h"
#include "gmozillaweb.h"
#include "gmozillacppwrapper.h"
#include "gmozillaconnectivity.h"
#ifdef USE_CONIC
#endif

typedef struct {
    GObject* latest_object;
    gboolean restart_flag;
} TestsInnerState;

typedef struct {
} GMozillaTransferItemAbortedDownloadStruct;
typedef struct {
} GMozillaTransferItemCompletedDownloadStruct;
typedef struct {
} GMozillaTransferItemErrorDownloadStruct;
typedef struct {
    gboolean test_is_retvalue_expected;
    GObject* expected_retvalue;
} GMozillaTransferItemGetLatestObjectStruct;
typedef struct {
    gboolean expected_retvalue;
} GMozillaTransferItemGetRestartFlagStruct;
typedef struct {
    gboolean test_is_retvalue_expected;
} GMozillaTransferItemGetTypeStruct;
typedef struct {
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaTransferItemNewStruct;
typedef struct {
    GObject* item;
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaTransferItemNewWithItemStruct;
typedef struct {
    gchar* url;
    gchar* filename;
    gboolean test_is_retvalue_expected;
    GObject* retvalue;
} GMozillaTransferItemNewWithUrlStruct;
typedef struct {
    glong current;
    glong total;
    glong mode;
} GMozillaTransferItemProgressDownloadStruct;
typedef struct {
    GObject* latest_object;
} GMozillaTransferItemSetLatestObjectStruct;
typedef struct {
    gboolean restart_flag;
} GMozillaTransferItemSetRestartFlagStruct;
typedef struct {
    gchar* test_file_name_with_path_variable;
    gchar** file_name_with_path;
} GMozillaTransferItemStartDownloadStruct;
typedef struct {
    GMozillaTransferItem* self;
} InitProgressTimeoutStruct;
typedef struct {
    GMozillaTransferItem* self;
} ResetProgressTimeoutStruct;

typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemDestroyStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemStartStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemStopStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemContinueStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemCancelStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemReloadStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemGetWebItemStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemGetUrlStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemGetFilenameStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemGetTotalSizeStruct;
typedef struct {
    GMozillaTransferItem** test_self_pp;
    GMozillaTransferItem* self;
    GWebTransferItemIface* iface;
} IfaceGMozillaTransferItemGetProgressStruct;

typedef struct {
    gboolean automatic;
    gboolean basics;
    TestsInnerState state;
    TestTableData g_mozilla_transfer_item_aborted_download;
    TestTableData g_mozilla_transfer_item_completed_download;
    TestTableData g_mozilla_transfer_item_error_download;
    TestTableData g_mozilla_transfer_item_get_latest_object;
    TestTableData g_mozilla_transfer_item_get_restart_flag;
    TestTableData g_mozilla_transfer_item_get_type;
    TestTableData g_mozilla_transfer_item_new;
    TestTableData g_mozilla_transfer_item_new_with_item;
    TestTableData g_mozilla_transfer_item_new_with_url;
    TestTableData g_mozilla_transfer_item_progress_download;
    TestTableData g_mozilla_transfer_item_set_latest_object;
    TestTableData g_mozilla_transfer_item_set_restart_flag;
    TestTableData g_mozilla_transfer_item_start_download;
    TestTableData init_progress_timeout;
    TestTableData reset_progress_timeout;
    TestTableData iface_g_mozilla_transfer_item_destroy;
    TestTableData iface_g_mozilla_transfer_item_start;
    TestTableData iface_g_mozilla_transfer_item_stop;
    TestTableData iface_g_mozilla_transfer_item_continue;
    TestTableData iface_g_mozilla_transfer_item_cancel;
    TestTableData iface_g_mozilla_transfer_item_reload;
    TestTableData iface_g_mozilla_transfer_item_get_web_item;
    TestTableData iface_g_mozilla_transfer_item_get_url;
    TestTableData iface_g_mozilla_transfer_item_get_filename;
    TestTableData iface_g_mozilla_transfer_item_get_total_size;
    TestTableData iface_g_mozilla_transfer_item_get_progress;
} TestData;
TestData testdata;

/**
 * Macro for creating a new transferitem.
 */
#define TESTS_GET_NEW (g_object_new(g_mozilla_transfer_item_get_type(), NULL))



static void init_test_data()
{
    testdata.automatic = FALSE;
    testdata.basics = FALSE;

    g_list_free(testdata.g_mozilla_transfer_item_aborted_download.table);
    testdata.g_mozilla_transfer_item_aborted_download.table = NULL;
    testdata.g_mozilla_transfer_item_aborted_download.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_completed_download.table);
    testdata.g_mozilla_transfer_item_completed_download.table = NULL;
    testdata.g_mozilla_transfer_item_completed_download.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_error_download.table);
    testdata.g_mozilla_transfer_item_error_download.table = NULL;
    testdata.g_mozilla_transfer_item_error_download.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_get_latest_object.table);
    testdata.g_mozilla_transfer_item_get_latest_object.table = NULL;
    testdata.g_mozilla_transfer_item_get_latest_object.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_get_restart_flag.table);
    testdata.g_mozilla_transfer_item_get_restart_flag.table = NULL;
    testdata.g_mozilla_transfer_item_get_restart_flag.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_get_type.table);
    testdata.g_mozilla_transfer_item_get_type.table = NULL;
    testdata.g_mozilla_transfer_item_get_type.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_new.table);
    testdata.g_mozilla_transfer_item_new.table = NULL;
    testdata.g_mozilla_transfer_item_new.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_new_with_item.table);
    testdata.g_mozilla_transfer_item_new_with_item.table = NULL;
    testdata.g_mozilla_transfer_item_new_with_item.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_new_with_url.table);
    testdata.g_mozilla_transfer_item_new_with_url.table = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_progress_download.table);
    testdata.g_mozilla_transfer_item_progress_download.table = NULL;
    testdata.g_mozilla_transfer_item_progress_download.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_set_latest_object.table);
    testdata.g_mozilla_transfer_item_set_latest_object.table = NULL;
    testdata.g_mozilla_transfer_item_set_latest_object.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_set_restart_flag.table);
    testdata.g_mozilla_transfer_item_set_restart_flag.table = NULL;
    testdata.g_mozilla_transfer_item_set_restart_flag.index = -1;

    g_list_free(testdata.g_mozilla_transfer_item_start_download.table);
    testdata.g_mozilla_transfer_item_start_download.table = NULL;
    testdata.g_mozilla_transfer_item_start_download.index = -1;

    g_list_free(testdata.init_progress_timeout.table);
    testdata.init_progress_timeout.table = NULL;
    testdata.init_progress_timeout.index = -1;

    g_list_free(testdata.reset_progress_timeout.table);
    testdata.reset_progress_timeout.table = NULL;
    testdata.reset_progress_timeout.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_destroy.table);
    testdata.iface_g_mozilla_transfer_item_destroy.table = NULL;
    testdata.iface_g_mozilla_transfer_item_destroy.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_start.table);
    testdata.iface_g_mozilla_transfer_item_start.table = NULL;
    testdata.iface_g_mozilla_transfer_item_start.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_stop.table);
    testdata.iface_g_mozilla_transfer_item_stop.table = NULL;
    testdata.iface_g_mozilla_transfer_item_stop.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_continue.table);
    testdata.iface_g_mozilla_transfer_item_continue.table = NULL;
    testdata.iface_g_mozilla_transfer_item_continue.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_cancel.table);
    testdata.iface_g_mozilla_transfer_item_cancel.table = NULL;
    testdata.iface_g_mozilla_transfer_item_cancel.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_reload.table);
    testdata.iface_g_mozilla_transfer_item_reload.table = NULL;
    testdata.iface_g_mozilla_transfer_item_reload.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_get_web_item.table);
    testdata.iface_g_mozilla_transfer_item_get_web_item.table = NULL;
    testdata.iface_g_mozilla_transfer_item_get_web_item.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_get_url.table);
    testdata.iface_g_mozilla_transfer_item_get_url.table = NULL;
    testdata.iface_g_mozilla_transfer_item_get_url.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_get_filename.table);
    testdata.iface_g_mozilla_transfer_item_get_filename.table = NULL;
    testdata.iface_g_mozilla_transfer_item_get_filename.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_get_total_size.table);
    testdata.iface_g_mozilla_transfer_item_get_total_size.table = NULL;
    testdata.iface_g_mozilla_transfer_item_get_total_size.index = -1;

    g_list_free(testdata.iface_g_mozilla_transfer_item_get_progress.table);
    testdata.iface_g_mozilla_transfer_item_get_progress.table = NULL;
    testdata.iface_g_mozilla_transfer_item_get_progress.index = -1;

}

static void reset_all_test_data()
{
    init_test_data();
    testdata.state.latest_object = NULL;
    testdata.state.restart_flag = FALSE;
}


/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_aborted_download(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_aborted_download");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_aborted_download.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemAbortedDownloadStruct* test_item_data =
            (GMozillaTransferItemAbortedDownloadStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_aborted_download.table, test_index);
        testdata.g_mozilla_transfer_item_aborted_download.index++;
        if(testdata.basics) {
            g_mozilla_transfer_item_aborted_download();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_transfer_item_aborted_download();
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_completed_download(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_completed_download");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_completed_download.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemCompletedDownloadStruct* test_item_data =
            (GMozillaTransferItemCompletedDownloadStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_completed_download.table, test_index);
        testdata.g_mozilla_transfer_item_completed_download.index++;
        if(testdata.basics) {
            g_mozilla_transfer_item_completed_download();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_transfer_item_completed_download();
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 * Function call g_signal_emit_by_name(G_OBJECT (self), "error") if latest_object
 * is something else than NULL.
 */
void test_g_mozilla_transfer_item_error_download(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_error_download");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_error_download.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemErrorDownloadStruct* test_item_data =
            (GMozillaTransferItemErrorDownloadStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_error_download.table, test_index);
        testdata.g_mozilla_transfer_item_error_download.index++;
        if(testdata.basics) {
            g_mozilla_transfer_item_error_download();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject *item = testdata.state.latest_object;
            if(G_MOZILLA_TRANSFER_ITEM(item))
            {
                printf("    Latest object pointer: %X", (int)item);
                tests_common_data.signal_counter = 0;
                tests_common_data.connection_id = g_signal_connect(item, G_WEB_TRANSFER_ITEM_SIGNAL_ERROR, G_CALLBACK (tests_common_signal_catcher_cb), NULL);
                printf("    connection id = %i\n", (int)tests_common_data.connection_id);
                g_mozilla_transfer_item_error_download();
                g_usleep(100000);
                CU_ASSERT_EQUAL(tests_common_data.signal_counter, 1);
                g_signal_handler_disconnect( item, tests_common_data.connection_id );
                tests_common_data.signal_counter = 0;
            } else {
                g_mozilla_transfer_item_error_download();
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_get_latest_object(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_latest_object");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_get_latest_object.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemGetLatestObjectStruct* test_item_data =
            (GMozillaTransferItemGetLatestObjectStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_get_latest_object.table, test_index);
        testdata.g_mozilla_transfer_item_get_latest_object.index++;
        GObject* retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_transfer_item_get_latest_object();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            GObject* expected_retvalue = test_item_data->expected_retvalue;
            printf("    Expected retvalue object pointer: %X", (int)expected_retvalue);
            retvalue = g_mozilla_transfer_item_get_latest_object();
            printf("    Real retvalue object pointer: %X", (int)retvalue);
            if(expected_retvalue != NULL)
            {
                CU_ASSERT_NOT_EQUAL(retvalue, NULL);
                gboolean restart_flag = g_mozilla_transfer_item_get_restart_flag();
                CU_ASSERT_EQUAL(retvalue, testdata.state.latest_object);
                CU_ASSERT_EQUAL(restart_flag, testdata.state.restart_flag);
            }
            else
            {
                CU_ASSERT_EQUAL(retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_get_restart_flag(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_restart_flag");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_get_restart_flag.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemGetRestartFlagStruct* test_item_data =
            (GMozillaTransferItemGetRestartFlagStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_get_restart_flag.table, test_index);
        testdata.g_mozilla_transfer_item_get_restart_flag.index++;
        gboolean retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_transfer_item_get_restart_flag();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            gboolean expected_retvalue = test_item_data->expected_retvalue;
            retvalue = g_mozilla_transfer_item_get_restart_flag();
            CU_ASSERT_EQUAL(retvalue, expected_retvalue);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_get_type(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_type");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_get_type.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemGetTypeStruct* test_item_data =
            (GMozillaTransferItemGetTypeStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_get_type.table, test_index);
        testdata.g_mozilla_transfer_item_get_type.index++;
        GType retvalue;
        if(testdata.basics) {
            retvalue = g_mozilla_transfer_item_get_type();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            retvalue = g_mozilla_transfer_item_get_type();
            if(test_item_data->test_is_retvalue_expected)
            {
                TESTS_ASSERT_INT_NOT_EQUAL(retvalue, 0);
            }
            else
            {
                TESTS_ASSERT_INT_EQUAL(retvalue, 0);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_new(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_new");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_new.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemNewStruct* test_item_data =
            (GMozillaTransferItemNewStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_new.table, test_index);
        testdata.g_mozilla_transfer_item_new.index++;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_transfer_item_new();
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_transfer_item_new();
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
                GObject* latest_object = g_mozilla_transfer_item_get_latest_object();
                gboolean restart_flag = g_mozilla_transfer_item_get_restart_flag();
                CU_ASSERT_EQUAL(test_item_data->retvalue, latest_object);
                CU_ASSERT_EQUAL(restart_flag, FALSE);
                testdata.state.latest_object = latest_object;
                testdata.state.restart_flag = restart_flag;
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_new_with_item(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_new_with_item");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_new_with_item.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemNewWithItemStruct* test_item_data =
            (GMozillaTransferItemNewWithItemStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_new_with_item.table, test_index);
        testdata.g_mozilla_transfer_item_new_with_item.index++;
        GObject* item = test_item_data->item;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_transfer_item_new_with_item(item);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_transfer_item_new_with_item(item);
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
                GObject* latest_object = g_mozilla_transfer_item_get_latest_object();
                gboolean restart_flag = g_mozilla_transfer_item_get_restart_flag();
                CU_ASSERT_EQUAL(test_item_data->retvalue, latest_object);
                CU_ASSERT_EQUAL(restart_flag, FALSE);
                testdata.state.latest_object = latest_object;
                testdata.state.restart_flag = restart_flag;
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
             printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_new_with_url(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_new_with_url");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_new_with_url.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemNewWithUrlStruct* test_item_data =
            (GMozillaTransferItemNewWithUrlStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_new_with_url.table, test_index);
        testdata.g_mozilla_transfer_item_new_with_url.index++;
        const gchar* url = test_item_data->url;
        const gchar* filename = test_item_data->filename;
        if(testdata.basics) {
            test_item_data->retvalue = g_mozilla_transfer_item_new_with_url(url,filename);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->retvalue = g_mozilla_transfer_item_new_with_url(url,filename);
            if(test_item_data->test_is_retvalue_expected)
            {
                CU_ASSERT_NOT_EQUAL(test_item_data->retvalue, NULL);
                GObject* latest_object = g_mozilla_transfer_item_get_latest_object();
                gboolean restart_flag = g_mozilla_transfer_item_get_restart_flag();
                CU_ASSERT_EQUAL(test_item_data->retvalue, latest_object);
                CU_ASSERT_EQUAL(restart_flag, FALSE);
                testdata.state.latest_object = latest_object;
                testdata.state.restart_flag = restart_flag;
            }
            else
            {
                CU_ASSERT_EQUAL(test_item_data->retvalue, NULL);
            }
             printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_progress_download(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_progress_download");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_progress_download.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemProgressDownloadStruct* test_item_data =
            (GMozillaTransferItemProgressDownloadStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_progress_download.table, test_index);
        testdata.g_mozilla_transfer_item_progress_download.index++;
        glong current = test_item_data->current;
        glong total = test_item_data->total;
        glong mode = test_item_data->mode;
        if(testdata.basics) {
            g_mozilla_transfer_item_progress_download(current,total,mode);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_transfer_item_progress_download(current,total,mode);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_set_latest_object(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_set_latest_object");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_set_latest_object.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemSetLatestObjectStruct* test_item_data =
            (GMozillaTransferItemSetLatestObjectStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_set_latest_object.table, test_index);
        testdata.g_mozilla_transfer_item_set_latest_object.index++;
        GObject* latest_object = test_item_data->latest_object;
        if(testdata.basics) {
            g_mozilla_transfer_item_set_latest_object(latest_object);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_transfer_item_set_latest_object(latest_object);
            printf("Advanced test runned.\n");
        }
        testdata.state.latest_object = latest_object;
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_set_restart_flag(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_set_restart_flag");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_set_restart_flag.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemSetRestartFlagStruct* test_item_data =
            (GMozillaTransferItemSetRestartFlagStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_set_restart_flag.table, test_index);
        testdata.g_mozilla_transfer_item_set_restart_flag.index++;
        gboolean restart_flag = test_item_data->restart_flag;
        if(testdata.basics) {
            g_mozilla_transfer_item_set_restart_flag(restart_flag);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            g_mozilla_transfer_item_set_restart_flag(restart_flag);
            printf("Advanced test runned.\n");
        }
        testdata.state.restart_flag = restart_flag;
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_g_mozilla_transfer_item_start_download(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_start_download");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.g_mozilla_transfer_item_start_download.index;
        printf("Index of test data: %i\n", test_index);
        GMozillaTransferItemStartDownloadStruct* test_item_data =
            (GMozillaTransferItemStartDownloadStruct*)g_list_nth_data(testdata.g_mozilla_transfer_item_start_download.table, test_index);
        testdata.g_mozilla_transfer_item_start_download.index++;
        gchar** file_name_with_path = test_item_data->file_name_with_path;
        if(testdata.basics) {
            g_mozilla_transfer_item_start_download(file_name_with_path);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            if(G_MOZILLA_TRANSFER_ITEM(testdata.state.latest_object))
            {
                GObject *item = testdata.state.latest_object;

                printf("    Latest object pointer: %X", (int)item);
                tests_common_data.signal_counter = 0;
                tests_common_data.connection_id = g_signal_connect(item, G_WEB_TRANSFER_ITEM_SIGNAL_STARTED, G_CALLBACK (tests_common_signal_catcher_cb), NULL);
                printf("    connection id = %i\n", (int)tests_common_data.connection_id);
                g_mozilla_transfer_item_start_download(file_name_with_path);
                g_usleep(100000);
                CU_ASSERT_EQUAL(tests_common_data.signal_counter, 1);
                g_signal_handler_disconnect( item, tests_common_data.connection_id );
                tests_common_data.signal_counter = 0;

                if(file_name_with_path)
                {
                    if(*file_name_with_path)
                    {
                        CU_ASSERT_EQUAL( *(G_MOZILLA_TRANSFER_ITEM(testdata.state.latest_object)->file_name), **file_name_with_path);
                    }
                    else
                    {
                        CU_ASSERT_EQUAL(*file_name_with_path, NULL);
                    }
                }
            }
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_init_progress_timeout(void)
{

    DEBUG_FUNCTIONS_STARTED("init_progress_timeout");

    if(testdata.automatic)
    {
        CU_FAIL("Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.init_progress_timeout.index;
        printf("Index of test data: %i\n", test_index);
        InitProgressTimeoutStruct* test_item_data =
            (InitProgressTimeoutStruct*)g_list_nth_data(testdata.init_progress_timeout.table, test_index);
        testdata.init_progress_timeout.index++;
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            init_progress_timeout(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            init_progress_timeout(self);
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_reset_progress_timeout(void)
{

    DEBUG_FUNCTIONS_STARTED("reset_progress_timeout");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        /*
        gint test_index = testdata.reset_progress_timeout.index;
        printf("Index of test data: %i\n", test_index);
        ResetProgressTimeoutStruct* test_item_data =
            (ResetProgressTimeoutStruct*)g_list_nth_data(testdata.reset_progress_timeout.table, test_index);
        testdata.reset_progress_timeout.index++;
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            reset_progress_timeout(self);
            CU_PASS("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            reset_progress_timeout(self);
            printf("Advanced test runned.\n");
        }
        */
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_destroy(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_destroy");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_destroy.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemDestroyStruct* test_item_data =
            (IfaceGMozillaTransferItemDestroyStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_destroy.table, test_index);
        testdata.iface_g_mozilla_transfer_item_destroy.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            (test_item_data->iface)->destroy(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            (test_item_data->iface)->destroy(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_start(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_start");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_start.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemStartStruct* test_item_data =
            (IfaceGMozillaTransferItemStartStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_start.table, test_index);
        testdata.iface_g_mozilla_transfer_item_start.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->start(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->start(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_stop(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_stop");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_stop.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemStopStruct* test_item_data =
            (IfaceGMozillaTransferItemStopStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_stop.table, test_index);
        testdata.iface_g_mozilla_transfer_item_stop.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->stop(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->stop(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_continue(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_continue");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_continue.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemContinueStruct* test_item_data =
            (IfaceGMozillaTransferItemContinueStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_continue.table, test_index);
        testdata.iface_g_mozilla_transfer_item_continue.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->do_continue(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->do_continue(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_cancel(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_cancel");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_cancel.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemCancelStruct* test_item_data =
            (IfaceGMozillaTransferItemCancelStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_cancel.table, test_index);
        testdata.iface_g_mozilla_transfer_item_cancel.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->cancel(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->cancel(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_reload(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_reload");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_reload.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemReloadStruct* test_item_data =
            (IfaceGMozillaTransferItemReloadStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_reload.table, test_index);
        testdata.iface_g_mozilla_transfer_item_reload.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->reload(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->reload(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_get_web_item(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_web_item");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_get_web_item.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemGetWebItemStruct* test_item_data =
            (IfaceGMozillaTransferItemGetWebItemStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_get_web_item.table, test_index);
        testdata.iface_g_mozilla_transfer_item_get_web_item.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->get_web_item(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->get_web_item(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_get_url(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_url");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_get_url.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemGetUrlStruct* test_item_data =
            (IfaceGMozillaTransferItemGetUrlStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_get_url.table, test_index);
        testdata.iface_g_mozilla_transfer_item_get_url.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->get_url(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->get_url(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_get_filename(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_filename");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_get_filename.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemGetFilenameStruct* test_item_data =
            (IfaceGMozillaTransferItemGetFilenameStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_get_filename.table, test_index);
        testdata.iface_g_mozilla_transfer_item_get_filename.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->get_filename(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->get_filename(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}
/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_get_total_size(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_total_size");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_get_total_size.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemGetTotalSizeStruct* test_item_data =
            (IfaceGMozillaTransferItemGetTotalSizeStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_get_total_size.table, test_index);
        testdata.iface_g_mozilla_transfer_item_get_total_size.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->get_total_size(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->get_total_size(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * New test case added automatically by test creation script.
 */
void test_iface_g_mozilla_transfer_item_get_progress(void)
{

    DEBUG_FUNCTIONS_STARTED("g_mozilla_transfer_item_get_progress");

    if(testdata.automatic)
    {
        CU_FAIL("//PRIVATE Test is not done yet!");
        printf("Automatic test runned.\n");
    }
    else
    {
        gint test_index = testdata.iface_g_mozilla_transfer_item_get_progress.index;
        printf("Index of test data: %i\n", test_index);
        IfaceGMozillaTransferItemGetProgressStruct* test_item_data =
            (IfaceGMozillaTransferItemGetProgressStruct*)g_list_nth_data(testdata.iface_g_mozilla_transfer_item_get_progress.table, test_index);
        testdata.iface_g_mozilla_transfer_item_get_progress.index++;
        
        GMozillaTransferItem* self = test_item_data->self;
        if(testdata.basics) {
            test_item_data->iface->get_progress(G_WEB_TRANSFER_ITEM(self));
            CU_FAIL("Basic test!");
            printf("Basic test runned.\n");
        }
        else
        {
            test_item_data->iface->get_progress(G_WEB_TRANSFER_ITEM(self));
            printf("Advanced test runned.\n");
        }
    }
    fflush(stdout);
    DEBUG_FUNCTION_ENDED;

}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_automatic_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_init");
    //init_test_data();
    reset_all_test_data();
    testdata.automatic = TRUE;
    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_automatic_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_clean");
    testdata.automatic = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_basics_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_basics_init");
    g_type_init();
    init_test_data();
    testdata.basics = TRUE;
    
    GMozillaTransferItemAbortedDownloadStruct* tmp_g_mozilla_transfer_item_aborted_download = g_new0(GMozillaTransferItemAbortedDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_aborted_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_aborted_download.table, tmp_g_mozilla_transfer_item_aborted_download);
    testdata.g_mozilla_transfer_item_aborted_download.index = 0;

    GMozillaTransferItemCompletedDownloadStruct* tmp_g_mozilla_transfer_item_completed_download = g_new0(GMozillaTransferItemCompletedDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_completed_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_completed_download.table, tmp_g_mozilla_transfer_item_completed_download);
    testdata.g_mozilla_transfer_item_completed_download.index = 0;

    GMozillaTransferItemErrorDownloadStruct* tmp_g_mozilla_transfer_item_error_download = g_new0(GMozillaTransferItemErrorDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_error_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_error_download.table, tmp_g_mozilla_transfer_item_error_download);
    testdata.g_mozilla_transfer_item_error_download.index = 0;

    GMozillaTransferItemGetLatestObjectStruct* tmp_g_mozilla_transfer_item_get_latest_object = g_new0(GMozillaTransferItemGetLatestObjectStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_latest_object->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_get_latest_object->expected_retvalue = NULL;
    testdata.g_mozilla_transfer_item_get_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_latest_object.table, tmp_g_mozilla_transfer_item_get_latest_object);
    testdata.g_mozilla_transfer_item_get_latest_object.index = 0;

    GMozillaTransferItemGetRestartFlagStruct* tmp_g_mozilla_transfer_item_get_restart_flag = g_new0(GMozillaTransferItemGetRestartFlagStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_restart_flag->expected_retvalue = 0;
    testdata.g_mozilla_transfer_item_get_restart_flag.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_restart_flag.table, tmp_g_mozilla_transfer_item_get_restart_flag);
    testdata.g_mozilla_transfer_item_get_restart_flag.index = 0;

    GMozillaTransferItemGetTypeStruct* tmp_g_mozilla_transfer_item_get_type = g_new0(GMozillaTransferItemGetTypeStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_type->test_is_retvalue_expected = FALSE;
    testdata.g_mozilla_transfer_item_get_type.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_type.table, tmp_g_mozilla_transfer_item_get_type);
    testdata.g_mozilla_transfer_item_get_type.index = 0;

    GMozillaTransferItemNewStruct* tmp_g_mozilla_transfer_item_new = g_new0(GMozillaTransferItemNewStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_new->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_new->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new.table =
        g_list_append (testdata.g_mozilla_transfer_item_new.table, tmp_g_mozilla_transfer_item_new);
    testdata.g_mozilla_transfer_item_new.index = 0;

    GMozillaTransferItemNewWithItemStruct* tmp_g_mozilla_transfer_item_new_with_item = g_new0(GMozillaTransferItemNewWithItemStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->item = NULL;
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_item->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_item.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_item.table, tmp_g_mozilla_transfer_item_new_with_item);
    testdata.g_mozilla_transfer_item_new_with_item.index = 0;

    GMozillaTransferItemNewWithUrlStruct* tmp_g_mozilla_transfer_item_new_with_url = g_new0(GMozillaTransferItemNewWithUrlStruct, 1);
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->url = NULL;
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->filename = NULL;
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_url->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_url->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_url.table, tmp_g_mozilla_transfer_item_new_with_url);
    testdata.g_mozilla_transfer_item_new_with_url.index = 0;

    tmp_g_mozilla_transfer_item_new_with_url = g_new0(GMozillaTransferItemNewWithUrlStruct, 1);
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->url = "url";
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->filename = NULL;
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_url->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_url->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_url.table, tmp_g_mozilla_transfer_item_new_with_url);
    testdata.g_mozilla_transfer_item_new_with_url.index = 0;

    tmp_g_mozilla_transfer_item_new_with_url = g_new0(GMozillaTransferItemNewWithUrlStruct, 1);
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->url = NULL;
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->filename = "filename";
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_url->test_is_retvalue_expected = FALSE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_url->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_url.table, tmp_g_mozilla_transfer_item_new_with_url);
    testdata.g_mozilla_transfer_item_new_with_url.index = 0;

    GMozillaTransferItemProgressDownloadStruct* tmp_g_mozilla_transfer_item_progress_download = g_new0(GMozillaTransferItemProgressDownloadStruct, 1);
    /* glong */tmp_g_mozilla_transfer_item_progress_download->current = 0;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->total = 0;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->mode = 0;
    testdata.g_mozilla_transfer_item_progress_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_progress_download.table, tmp_g_mozilla_transfer_item_progress_download);
    testdata.g_mozilla_transfer_item_progress_download.index = 0;

    GMozillaTransferItemSetLatestObjectStruct* tmp_g_mozilla_transfer_item_set_latest_object = g_new0(GMozillaTransferItemSetLatestObjectStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_set_latest_object->latest_object = NULL;
    testdata.g_mozilla_transfer_item_set_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_set_latest_object.table, tmp_g_mozilla_transfer_item_set_latest_object);
    testdata.g_mozilla_transfer_item_set_latest_object.index = 0;

    GMozillaTransferItemSetRestartFlagStruct* tmp_g_mozilla_transfer_item_set_restart_flag = g_new0(GMozillaTransferItemSetRestartFlagStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_set_restart_flag->restart_flag = FALSE;
    testdata.g_mozilla_transfer_item_set_restart_flag.table =
        g_list_append (testdata.g_mozilla_transfer_item_set_restart_flag.table, tmp_g_mozilla_transfer_item_set_restart_flag);
    testdata.g_mozilla_transfer_item_set_restart_flag.index = 0;

    GMozillaTransferItemStartDownloadStruct* tmp_g_mozilla_transfer_item_start_download = g_new0(GMozillaTransferItemStartDownloadStruct, 1);
    /* gchar* */tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable = NULL;
    /* gchar** */tmp_g_mozilla_transfer_item_start_download->file_name_with_path = NULL;
    testdata.g_mozilla_transfer_item_start_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_start_download.table, tmp_g_mozilla_transfer_item_start_download);
    testdata.g_mozilla_transfer_item_start_download.index = 0;

    tmp_g_mozilla_transfer_item_start_download = g_new0(GMozillaTransferItemStartDownloadStruct, 1);
    /* gchar* */tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable = NULL;
    /* gchar** */tmp_g_mozilla_transfer_item_start_download->file_name_with_path =
        &tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable;
    testdata.g_mozilla_transfer_item_start_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_start_download.table, tmp_g_mozilla_transfer_item_start_download);
    testdata.g_mozilla_transfer_item_start_download.index = 0;

    tmp_g_mozilla_transfer_item_start_download = g_new0(GMozillaTransferItemStartDownloadStruct, 1);
    /* gchar* */tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable = "test_file_name_with_path_variable";
    /* gchar** */tmp_g_mozilla_transfer_item_start_download->file_name_with_path = 
        &tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable;
    testdata.g_mozilla_transfer_item_start_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_start_download.table, tmp_g_mozilla_transfer_item_start_download);
    testdata.g_mozilla_transfer_item_start_download.index = 0;

    InitProgressTimeoutStruct* tmp_init_progress_timeout = g_new0(InitProgressTimeoutStruct, 1);
    /* GMozillaTransferItem* */tmp_init_progress_timeout->self = NULL;
    testdata.init_progress_timeout.table =
        g_list_append (testdata.init_progress_timeout.table, tmp_init_progress_timeout);
    testdata.init_progress_timeout.index = 0;

    ResetProgressTimeoutStruct* tmp_reset_progress_timeout = g_new0(ResetProgressTimeoutStruct, 1);
    /* GMozillaTransferItem* */tmp_reset_progress_timeout->self = NULL;
    testdata.reset_progress_timeout.table =
        g_list_append (testdata.reset_progress_timeout.table, tmp_reset_progress_timeout);
    testdata.reset_progress_timeout.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_basics_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_basics_clean");
    testdata.basics = FALSE;
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_advanced_init");
    g_type_init();
    init_test_data();
    
    GObject* latest_object = G_OBJECT(TESTS_GET_NEW);
    
    GMozillaTransferItemAbortedDownloadStruct* tmp_g_mozilla_transfer_item_aborted_download = g_new0(GMozillaTransferItemAbortedDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_aborted_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_aborted_download.table, tmp_g_mozilla_transfer_item_aborted_download);
    testdata.g_mozilla_transfer_item_aborted_download.index = 0;

    GMozillaTransferItemCompletedDownloadStruct* tmp_g_mozilla_transfer_item_completed_download = g_new0(GMozillaTransferItemCompletedDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_completed_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_completed_download.table, tmp_g_mozilla_transfer_item_completed_download);
    testdata.g_mozilla_transfer_item_completed_download.index = 0;

    GMozillaTransferItemSetLatestObjectStruct* tmp_g_mozilla_transfer_item_set_latest_object = g_new0(GMozillaTransferItemSetLatestObjectStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_set_latest_object->latest_object = latest_object;
    testdata.g_mozilla_transfer_item_set_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_set_latest_object.table, tmp_g_mozilla_transfer_item_set_latest_object);
    testdata.g_mozilla_transfer_item_set_latest_object.index = 0;

    GMozillaTransferItemGetLatestObjectStruct* tmp_g_mozilla_transfer_item_get_latest_object = g_new0(GMozillaTransferItemGetLatestObjectStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_latest_object->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_get_latest_object->expected_retvalue = latest_object;
    testdata.g_mozilla_transfer_item_get_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_latest_object.table, tmp_g_mozilla_transfer_item_get_latest_object);
    testdata.g_mozilla_transfer_item_get_latest_object.index = 0;

    GMozillaTransferItemErrorDownloadStruct* tmp_g_mozilla_transfer_item_error_download = g_new0(GMozillaTransferItemErrorDownloadStruct, 1);
    testdata.g_mozilla_transfer_item_error_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_error_download.table, tmp_g_mozilla_transfer_item_error_download);
    testdata.g_mozilla_transfer_item_error_download.index = 0;

    GMozillaTransferItemSetRestartFlagStruct* tmp_g_mozilla_transfer_item_set_restart_flag = g_new0(GMozillaTransferItemSetRestartFlagStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_set_restart_flag->restart_flag = FALSE;
    testdata.g_mozilla_transfer_item_set_restart_flag.table =
        g_list_append (testdata.g_mozilla_transfer_item_set_restart_flag.table, tmp_g_mozilla_transfer_item_set_restart_flag);
    testdata.g_mozilla_transfer_item_set_restart_flag.index = 0;

    GMozillaTransferItemGetRestartFlagStruct* tmp_g_mozilla_transfer_item_get_restart_flag = g_new0(GMozillaTransferItemGetRestartFlagStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_restart_flag->expected_retvalue = tmp_g_mozilla_transfer_item_set_restart_flag->restart_flag;
    testdata.g_mozilla_transfer_item_get_restart_flag.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_restart_flag.table, tmp_g_mozilla_transfer_item_get_restart_flag);
    testdata.g_mozilla_transfer_item_get_restart_flag.index = 0;

    GMozillaTransferItemNewStruct* tmp_g_mozilla_transfer_item_new = g_new0(GMozillaTransferItemNewStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_new->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new.table =
        g_list_append (testdata.g_mozilla_transfer_item_new.table, tmp_g_mozilla_transfer_item_new);
    testdata.g_mozilla_transfer_item_new.index = 0;

    GMozillaTransferItemNewWithItemStruct* tmp_g_mozilla_transfer_item_new_with_item = g_new0(GMozillaTransferItemNewWithItemStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->item = G_OBJECT(TESTS_GET_NEW);
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_item->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_item.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_item.table, tmp_g_mozilla_transfer_item_new_with_item);
    testdata.g_mozilla_transfer_item_new_with_item.index = 0;

    GMozillaTransferItemNewWithUrlStruct* tmp_g_mozilla_transfer_item_new_with_url = g_new0(GMozillaTransferItemNewWithUrlStruct, 1);
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->url = "url";
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->filename = "filename";
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_url->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_url->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_url.table, tmp_g_mozilla_transfer_item_new_with_url);
    testdata.g_mozilla_transfer_item_new_with_url.index = 0;

    GMozillaTransferItemProgressDownloadStruct* tmp_g_mozilla_transfer_item_progress_download = g_new0(GMozillaTransferItemProgressDownloadStruct, 1);
    /* glong */tmp_g_mozilla_transfer_item_progress_download->current = 0;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->total = 0;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->mode = 0;
    testdata.g_mozilla_transfer_item_progress_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_progress_download.table, tmp_g_mozilla_transfer_item_progress_download);
    testdata.g_mozilla_transfer_item_progress_download.index = 0;

    GMozillaTransferItemStartDownloadStruct* tmp_g_mozilla_transfer_item_start_download = g_new0(GMozillaTransferItemStartDownloadStruct, 1);
    /* gchar* */tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable = NULL;
    /* gchar** */tmp_g_mozilla_transfer_item_start_download->file_name_with_path = NULL;
    testdata.g_mozilla_transfer_item_start_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_start_download.table, tmp_g_mozilla_transfer_item_start_download);
    testdata.g_mozilla_transfer_item_start_download.index = 0;

    InitProgressTimeoutStruct* tmp_init_progress_timeout = g_new0(InitProgressTimeoutStruct, 1);
    /* GMozillaTransferItem* */tmp_init_progress_timeout->self = NULL;
    testdata.init_progress_timeout.table =
        g_list_append (testdata.init_progress_timeout.table, tmp_init_progress_timeout);
    testdata.init_progress_timeout.index = 0;

    ResetProgressTimeoutStruct* tmp_reset_progress_timeout = g_new0(ResetProgressTimeoutStruct, 1);
    /* GMozillaTransferItem* */tmp_reset_progress_timeout->self = NULL;
    testdata.reset_progress_timeout.table =
        g_list_append (testdata.reset_progress_timeout.table, tmp_reset_progress_timeout);
    testdata.reset_progress_timeout.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_advanced_clean");
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_advanced2_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_advanced2_init");
    g_type_init();
    init_test_data();
    
    GObject* latest_object = G_OBJECT(TESTS_GET_NEW);

    GMozillaTransferItemNewStruct* tmp_g_mozilla_transfer_item_new = g_new0(GMozillaTransferItemNewStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_new->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new.table =
        g_list_append (testdata.g_mozilla_transfer_item_new.table, tmp_g_mozilla_transfer_item_new);
    testdata.g_mozilla_transfer_item_new.index = 0;

    GMozillaTransferItemNewWithItemStruct* tmp_g_mozilla_transfer_item_new_with_item = g_new0(GMozillaTransferItemNewWithItemStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->item = G_OBJECT(TESTS_GET_NEW);
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_item->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_item->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_item.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_item.table, tmp_g_mozilla_transfer_item_new_with_item);
    testdata.g_mozilla_transfer_item_new_with_item.index = 0;

    GMozillaTransferItemNewWithUrlStruct* tmp_g_mozilla_transfer_item_new_with_url = g_new0(GMozillaTransferItemNewWithUrlStruct, 1);
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->url = "url";
    /* const gchar* */tmp_g_mozilla_transfer_item_new_with_url->filename = "filename";
    /* gboolean */tmp_g_mozilla_transfer_item_new_with_url->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_new_with_url->retvalue = NULL;
    testdata.g_mozilla_transfer_item_new_with_url.table =
        g_list_append (testdata.g_mozilla_transfer_item_new_with_url.table, tmp_g_mozilla_transfer_item_new_with_url);
    testdata.g_mozilla_transfer_item_new_with_url.index = 0;

    GMozillaTransferItemProgressDownloadStruct* tmp_g_mozilla_transfer_item_progress_download = g_new0(GMozillaTransferItemProgressDownloadStruct, 1);
    /* glong */tmp_g_mozilla_transfer_item_progress_download->current = 100;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->total = 100;
    /* glong */tmp_g_mozilla_transfer_item_progress_download->mode = 100;
    testdata.g_mozilla_transfer_item_progress_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_progress_download.table, tmp_g_mozilla_transfer_item_progress_download);
    testdata.g_mozilla_transfer_item_progress_download.index = 0;

    GMozillaTransferItemSetLatestObjectStruct* tmp_g_mozilla_transfer_item_set_latest_object = g_new0(GMozillaTransferItemSetLatestObjectStruct, 1);
    /* GObject* */tmp_g_mozilla_transfer_item_set_latest_object->latest_object = latest_object;
    testdata.g_mozilla_transfer_item_set_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_set_latest_object.table, tmp_g_mozilla_transfer_item_set_latest_object);
    testdata.g_mozilla_transfer_item_set_latest_object.index = 0;

    GMozillaTransferItemGetLatestObjectStruct* tmp_g_mozilla_transfer_item_get_latest_object = g_new0(GMozillaTransferItemGetLatestObjectStruct, 1);
    /* gboolean */tmp_g_mozilla_transfer_item_get_latest_object->test_is_retvalue_expected = TRUE;
    /* GObject* */tmp_g_mozilla_transfer_item_get_latest_object->expected_retvalue = latest_object;
    testdata.g_mozilla_transfer_item_get_latest_object.table =
        g_list_append (testdata.g_mozilla_transfer_item_get_latest_object.table, tmp_g_mozilla_transfer_item_get_latest_object);
    testdata.g_mozilla_transfer_item_get_latest_object.index = 0;

    GMozillaTransferItemStartDownloadStruct* tmp_g_mozilla_transfer_item_start_download = g_new0(GMozillaTransferItemStartDownloadStruct, 1);
    /* gchar* */tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable = g_strdup("string");
    /* gchar** */tmp_g_mozilla_transfer_item_start_download->file_name_with_path =
        &tmp_g_mozilla_transfer_item_start_download->test_file_name_with_path_variable;
    testdata.g_mozilla_transfer_item_start_download.table =
        g_list_append (testdata.g_mozilla_transfer_item_start_download.table, tmp_g_mozilla_transfer_item_start_download);
    testdata.g_mozilla_transfer_item_start_download.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_advanced2_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_advanced2_clean");
    return 0;
}

/**
 * Init function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_interface_advanced_init()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_interface_advanced_init");
    g_type_init();
    init_test_data();
    
    IfaceGMozillaTransferItemDestroyStruct* tmp_iface_g_mozilla_transfer_item_destroy =
        g_new0(IfaceGMozillaTransferItemDestroyStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_destroy->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_destroy->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_destroy->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_destroy.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_destroy.table,
                tmp_iface_g_mozilla_transfer_item_destroy);
    testdata.iface_g_mozilla_transfer_item_destroy.index = 0;

    IfaceGMozillaTransferItemStartStruct* tmp_iface_g_mozilla_transfer_item_start =
        g_new0(IfaceGMozillaTransferItemStartStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_start->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_start->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_start->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_start.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_start.table,
                tmp_iface_g_mozilla_transfer_item_start);
    testdata.iface_g_mozilla_transfer_item_start.index = 0;

    IfaceGMozillaTransferItemStopStruct* tmp_iface_g_mozilla_transfer_item_stop =
        g_new0(IfaceGMozillaTransferItemStopStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_stop->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_stop->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_stop->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_stop.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_stop.table,
                tmp_iface_g_mozilla_transfer_item_stop);
    testdata.iface_g_mozilla_transfer_item_stop.index = 0;

    IfaceGMozillaTransferItemContinueStruct* tmp_iface_g_mozilla_transfer_item_continue =
        g_new0(IfaceGMozillaTransferItemContinueStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_continue->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_continue->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_continue->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_continue.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_continue.table,
                tmp_iface_g_mozilla_transfer_item_continue);
    testdata.iface_g_mozilla_transfer_item_continue.index = 0;

    IfaceGMozillaTransferItemCancelStruct* tmp_iface_g_mozilla_transfer_item_cancel =
        g_new0(IfaceGMozillaTransferItemCancelStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_cancel->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_cancel->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_cancel->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_cancel.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_cancel.table,
                tmp_iface_g_mozilla_transfer_item_cancel);
    testdata.iface_g_mozilla_transfer_item_cancel.index = 0;

    IfaceGMozillaTransferItemReloadStruct* tmp_iface_g_mozilla_transfer_item_reload =
        g_new0(IfaceGMozillaTransferItemReloadStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_reload->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_reload->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_reload->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_reload.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_reload.table,
                tmp_iface_g_mozilla_transfer_item_reload);
    testdata.iface_g_mozilla_transfer_item_reload.index = 0;

    IfaceGMozillaTransferItemGetWebItemStruct* tmp_iface_g_mozilla_transfer_item_get_web_item =
        g_new0(IfaceGMozillaTransferItemGetWebItemStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_get_web_item->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_get_web_item->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_get_web_item->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_get_web_item.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_get_web_item.table,
                tmp_iface_g_mozilla_transfer_item_get_web_item);
    testdata.iface_g_mozilla_transfer_item_get_web_item.index = 0;

    IfaceGMozillaTransferItemGetUrlStruct* tmp_iface_g_mozilla_transfer_item_get_url =
        g_new0(IfaceGMozillaTransferItemGetUrlStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_get_url->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_get_url->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_get_url->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_get_url.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_get_url.table,
                tmp_iface_g_mozilla_transfer_item_get_url);
    testdata.iface_g_mozilla_transfer_item_get_url.index = 0;

    IfaceGMozillaTransferItemGetFilenameStruct* tmp_iface_g_mozilla_transfer_item_get_filename =
        g_new0(IfaceGMozillaTransferItemGetFilenameStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_get_filename->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_get_filename->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_get_filename->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_get_filename.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_get_filename.table,
                tmp_iface_g_mozilla_transfer_item_get_filename);
    testdata.iface_g_mozilla_transfer_item_get_filename.index = 0;

    IfaceGMozillaTransferItemGetTotalSizeStruct* tmp_iface_g_mozilla_transfer_item_get_total_size =
        g_new0(IfaceGMozillaTransferItemGetTotalSizeStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_get_total_size->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_get_total_size->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_get_total_size->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_get_total_size.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_get_total_size.table,
                tmp_iface_g_mozilla_transfer_item_get_total_size);
    testdata.iface_g_mozilla_transfer_item_get_total_size.index = 0;

    IfaceGMozillaTransferItemGetProgressStruct* tmp_iface_g_mozilla_transfer_item_get_progress =
        g_new0(IfaceGMozillaTransferItemGetProgressStruct, 1);
    /* GMozillaTransferItem* */tmp_iface_g_mozilla_transfer_item_get_progress->self =
        (GMozillaTransferItem*)g_mozilla_transfer_item_new();
    /* GWebTransferItemIface* */tmp_iface_g_mozilla_transfer_item_get_progress->iface =
        (GWebTransferItemIface*)g_type_interface_peek (g_type_class_peek (
                G_OBJECT_TYPE (tmp_iface_g_mozilla_transfer_item_get_progress->self)), G_TYPE_WEB_TRANSFER_ITEM);
    testdata.iface_g_mozilla_transfer_item_get_progress.table =
        g_list_append (testdata.iface_g_mozilla_transfer_item_get_progress.table,
                tmp_iface_g_mozilla_transfer_item_get_progress);
    testdata.iface_g_mozilla_transfer_item_get_progress.index = 0;

    return 0;
}

/**
 * Clean function created by test creation script. It is success always.
 */
static int
testgmozillatransferitem_interface_advanced_clean()
{
    INIT_OR_CLEAN_STARTED("testgmozillatransferitem_interface_advanced_clean");
    
    
    return 0;
}


/**
 * All new test cases are going to start from here. They are also added to automatic suite.
 * DO NOT DELETE AUTOMATIC SUITE!
 */

static CU_TestInfo testgmozillatransferitem_automatic_added[] = {
        // Test is made { "test_g_mozilla_transfer_item_aborted_download", test_g_mozilla_transfer_item_aborted_download },
        // Test is made { "test_g_mozilla_transfer_item_completed_download", test_g_mozilla_transfer_item_completed_download },
        // Test is made { "test_g_mozilla_transfer_item_error_download", test_g_mozilla_transfer_item_error_download },
        // Test is made { "test_g_mozilla_transfer_item_get_latest_object", test_g_mozilla_transfer_item_get_latest_object },
        // Test is made { "test_g_mozilla_transfer_item_get_restart_flag", test_g_mozilla_transfer_item_get_restart_flag },
        // Test is made { "test_g_mozilla_transfer_item_get_type", test_g_mozilla_transfer_item_get_type },
        // Test is made { "test_g_mozilla_transfer_item_new", test_g_mozilla_transfer_item_new },
        // Test is made { "test_g_mozilla_transfer_item_new_with_item", test_g_mozilla_transfer_item_new_with_item },
        // Test is made { "test_g_mozilla_transfer_item_new_with_url", test_g_mozilla_transfer_item_new_with_url },
        // Test is made { "test_g_mozilla_transfer_item_progress_download", test_g_mozilla_transfer_item_progress_download },
        // Test is made { "test_g_mozilla_transfer_item_set_latest_object", test_g_mozilla_transfer_item_set_latest_object },
        // Test is made { "test_g_mozilla_transfer_item_set_restart_flag", test_g_mozilla_transfer_item_set_restart_flag },
        // Test is made { "test_g_mozilla_transfer_item_start_download", test_g_mozilla_transfer_item_start_download },
        // Test is made { "test_init_progress_timeout", test_init_progress_timeout },
        { "test_reset_progress_timeout", test_reset_progress_timeout },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillatransferitem_basics[] = {
        { "test_g_mozilla_transfer_item_aborted_download all args NULL", test_g_mozilla_transfer_item_aborted_download },
        { "test_g_mozilla_transfer_item_completed_download all args NULL", test_g_mozilla_transfer_item_completed_download },
        { "test_g_mozilla_transfer_item_error_download all args NULL", test_g_mozilla_transfer_item_error_download },
        { "test_g_mozilla_transfer_item_get_latest_object all args NULL", test_g_mozilla_transfer_item_get_latest_object },
        { "test_g_mozilla_transfer_item_get_restart_flag all args NULL", test_g_mozilla_transfer_item_get_restart_flag },
        { "test_g_mozilla_transfer_item_get_type all args NULL", test_g_mozilla_transfer_item_get_type },
        { "test_g_mozilla_transfer_item_new all args NULL", test_g_mozilla_transfer_item_new },
        { "test_g_mozilla_transfer_item_new_with_item all args NULL", test_g_mozilla_transfer_item_new_with_item },
        { "test_g_mozilla_transfer_item_new_with_url all args NULL", test_g_mozilla_transfer_item_new_with_url },
        { "test_g_mozilla_transfer_item_new_with_url with url not NULL", test_g_mozilla_transfer_item_new_with_url },
        { "test_g_mozilla_transfer_item_new_with_url with filename not NULL", test_g_mozilla_transfer_item_new_with_url },
        { "test_g_mozilla_transfer_item_progress_download all args NULL", test_g_mozilla_transfer_item_progress_download },
        { "test_g_mozilla_transfer_item_set_latest_object all args NULL", test_g_mozilla_transfer_item_set_latest_object },
        { "test_g_mozilla_transfer_item_set_restart_flag all args NULL", test_g_mozilla_transfer_item_set_restart_flag },
        { "test_g_mozilla_transfer_item_start_download all args NULL", test_g_mozilla_transfer_item_start_download },
        { "test_g_mozilla_transfer_item_start_download with file_name_with_path pointing to NULL", test_g_mozilla_transfer_item_start_download },
        { "test_g_mozilla_transfer_item_start_download with file_name_with_path pointing to string", test_g_mozilla_transfer_item_start_download },
        { "test_init_progress_timeout", test_init_progress_timeout },
        //PRIVATE TODO: Segmentation fault. { "test_reset_progress_timeout", test_reset_progress_timeout },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillatransferitem_advanced[] = {
        { "test_g_mozilla_transfer_item_aborted_download", test_g_mozilla_transfer_item_aborted_download },
        { "test_g_mozilla_transfer_item_completed_download", test_g_mozilla_transfer_item_completed_download },
        { "test_g_mozilla_transfer_item_set_latest_object", test_g_mozilla_transfer_item_set_latest_object },
        { "test_g_mozilla_transfer_item_get_latest_object", test_g_mozilla_transfer_item_get_latest_object },
        { "test_g_mozilla_transfer_item_error_download", test_g_mozilla_transfer_item_error_download },
        { "test_g_mozilla_transfer_item_set_restart_flag", test_g_mozilla_transfer_item_set_restart_flag },
        { "test_g_mozilla_transfer_item_get_restart_flag", test_g_mozilla_transfer_item_get_restart_flag },
        { "test_g_mozilla_transfer_item_new", test_g_mozilla_transfer_item_new },
        { "test_g_mozilla_transfer_item_new_with_item", test_g_mozilla_transfer_item_new_with_item },
        { "test_g_mozilla_transfer_item_new_with_url", test_g_mozilla_transfer_item_new_with_url },
        { "test_g_mozilla_transfer_item_progress_download", test_g_mozilla_transfer_item_progress_download },
        //TODO: Segmentation fault, because parameter(gchar **file_name_with_path) is not checked against NULL pointer. { "test_g_mozilla_transfer_item_start_download", test_g_mozilla_transfer_item_start_download },
        { "test_init_progress_timeout", test_init_progress_timeout },
        //PRIVATE { "test_reset_progress_timeout", test_reset_progress_timeout },
        CU_TEST_INFO_NULL, //null terminated
};
static CU_TestInfo testgmozillatransferitem_advanced2[] = {
        { "test_g_mozilla_transfer_item_new", test_g_mozilla_transfer_item_new },
        { "test_g_mozilla_transfer_item_new_with_item", test_g_mozilla_transfer_item_new_with_item },
        { "test_g_mozilla_transfer_item_new_with_url", test_g_mozilla_transfer_item_new_with_url },
        { "test_g_mozilla_transfer_item_progress_download", test_g_mozilla_transfer_item_progress_download },
        { "test_g_mozilla_transfer_item_set_latest_object", test_g_mozilla_transfer_item_set_latest_object },
        { "test_g_mozilla_transfer_item_get_latest_object", test_g_mozilla_transfer_item_get_latest_object },
        { "test_g_mozilla_transfer_item_start_download", test_g_mozilla_transfer_item_start_download },
        CU_TEST_INFO_NULL, //null terminated
};

static CU_TestInfo testgmozillatransferitem_interface_advanced[] = {
        { "test_iface_g_mozilla_transfer_item_destroy", test_iface_g_mozilla_transfer_item_destroy},
        { "test_iface_g_mozilla_transfer_item_start", test_iface_g_mozilla_transfer_item_start},
        { "test_iface_g_mozilla_transfer_item_stop", test_iface_g_mozilla_transfer_item_stop},
        { "test_iface_g_mozilla_transfer_item_continue", test_iface_g_mozilla_transfer_item_continue},
        { "test_iface_g_mozilla_transfer_item_cancel", test_iface_g_mozilla_transfer_item_cancel},
        { "test_iface_g_mozilla_transfer_item_reload", test_iface_g_mozilla_transfer_item_reload},
        { "test_iface_g_mozilla_transfer_item_get_web_item", test_iface_g_mozilla_transfer_item_get_web_item},
        { "test_iface_g_mozilla_transfer_item_get_url", test_iface_g_mozilla_transfer_item_get_url},
        { "test_iface_g_mozilla_transfer_item_get_filename", test_iface_g_mozilla_transfer_item_get_filename},
        { "test_iface_g_mozilla_transfer_item_get_total_size", test_iface_g_mozilla_transfer_item_get_total_size},
        { "test_iface_g_mozilla_transfer_item_get_progress", test_iface_g_mozilla_transfer_item_get_progress},
        CU_TEST_INFO_NULL, //null terminated
};

/**
 * Main table holding all the test cases.
 */
CU_SuiteInfo testgmozillatransferitem[] = {
        {"testgmozillatransferitem_automatic_added", testgmozillatransferitem_automatic_init, testgmozillatransferitem_automatic_clean, testgmozillatransferitem_automatic_added },
        {"testgmozillatransferitem_basics", testgmozillatransferitem_basics_init, testgmozillatransferitem_basics_clean, testgmozillatransferitem_basics },
        {"testgmozillatransferitem_advanced", testgmozillatransferitem_advanced_init, testgmozillatransferitem_advanced_clean, testgmozillatransferitem_advanced },
        {"testgmozillatransferitem_advanced2", testgmozillatransferitem_advanced2_init, testgmozillatransferitem_advanced2_clean, testgmozillatransferitem_advanced2 },
        {"testgmozillatransferitem_interface_advanced", testgmozillatransferitem_interface_advanced_init, testgmozillatransferitem_interface_advanced_clean, testgmozillatransferitem_interface_advanced },
        CU_SUITE_INFO_NULL, //null terminated
};
