#!/usr/bin/awk -f

#/* ***** BEGIN LICENSE BLOCK *****
# * Version: MPL 1.1
# *
# * The contents of this file are subject to the Mozilla Public License Version
# * 1.1 (the "License"); you may not use this file except in compliance with
# * the License. You may obtain a copy of the License at
# * http://www.mozilla.org/MPL/
# *
# * Software distributed under the License is distributed on an "AS IS" basis,
# * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# * for the specific language governing rights and limitations under the
# * License.
# *
# * The Original Code is the MICROB EAL package.
# *
# * The Initial Developer of the Original Code is Nokia Corporation.
# * Portions created by the Initial Developer are Copyright (C) 2005
# * the Initial Developer. All Rights Reserved.
# *
# * Contact: Oleg Romashin <oleg.romashin@nokia.com>
# *
# * ***** END LICENSE BLOCK ***** */

BEGIN {
	exitFlag = 0
	
	
	if( ARGC < 2 )
	{
		print "Source file missing."
		exitFlag = 1
		exit 1
	}
	


	if(!target)
	{
		print "Target missing."
		exitFlag = 1
		exit 1
	}

	htarget = target".h"
	numberOfOldHLines = read_old_file(htarget, oldHLines)

	ctarget = target".c"
	numberOfOldCLines = read_old_file(ctarget, oldCLines)
	
	last = split(target,sourceLast, "test")
	preCompiledFileName = "pre_compiling-"sourceLast[last]".o"
	preInOneLine = read_pre_compiled_file(preCompiledFileName)
	
	numberOfLicenseCommentLines = 0
	while( (getline x < "license_comments.txt") > 0 ) {
		licenseComments[numberOfLicenseCommentLines] = x
		++numberOfLicenseCommentLines
	}

	#print "After reading of all files. preLine: "preLine

	numberOfFoundFunctions = 0
}




# Reading of function names from text file.
($2 == "T") {
	foundFunctionNames[numberOfFoundFunctions++] = $NF
}







END {
	if( exitFlag )
	{
		exit exitFlag
	}

	print "Old lines in test h file: " numberOfOldHLines
	print "Old lines in test c file: " numberOfOldCLines
	print "Number of functions found from file to be tested: " numberOfFoundFunctions

	


	automaticAdded = target"_automatic_added"
	basics = target"_basics"
	advanced = target"_advanced"

	tableComment = "/**\n * Main table holding all the test cases.\n */"
	testSuiteComment = "/**\n * All new test cases are going to start from here. They are also added to automatic suite.\n * DO NOT DELETE AUTOMATIC SUITE!\n */\n"
	testCreationComment = "/**\n * New test case added automatically by test creation script.\n */"
	newTestCasesComment = "/**\n * New test cases start from here!.\n */"
	initFunctionComment = "/**\n * Init function created by test creation script. It is success always.\n */"
	cleanFunctionComment = "/**\n * Clean function created by test creation script. It is success always.\n */"
	
	numberOfNew = new_fuctions_and_variables_and_retvalues_for_them(preInOneLine,
				foundFunctionNames, numberOfFoundFunctions, newFunctions,
				foundRetValues, foundParameters, target)

	last = split(target,cSourceLast, "test")
	nameOfSourceFile = cSourceLast[last]".c"
	print "Name of code source file: "nameOfSourceFile
	numberOfIncludeLines = 0
	while( (getline x < nameOfSourceFile) > 0 )
	{
		if(x ~ ("^[[:blank:]]*#include"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
		if(x ~ ("^[[:blank:]]*#if"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
		else if(x ~ ("^[[:blank:]]*#ifdef"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
		else if(x ~ ("^[[:blank:]]*#ifndef"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
		else if(x ~ ("^[[:blank:]]*#else"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
		else if(x ~ ("^[[:blank:]]*#endif"))
		{
			includes[numberOfIncludeLines] = x
			++numberOfIncludeLines
		}
	}


	print "Number of new functions found: "numberOfNew
	create_h_test_file(target, oldHLines, numberOfOldHLines, newFunctions,
				numberOfNew, foundRetValues, foundParameters, licenseComments, numberOfLicenseCommentLines)

	print "Starting create_c_test_file"
	create_c_test_file(target, oldCLines, numberOfOldCLines, preInOneLine,
				newFunctions, numberOfNew, foundRetValues, foundParameters, includes, numberOfIncludeLines, licenseComments, numberOfLicenseCommentLines)
}





function read_old_file(target, lines)
{
	numberOfLines = 0
	while( (getline x < target) > 0 ) {
		lines[numberOfLines] = x
		++numberOfLines
	}
	return numberOfLines
}




function read_pre_compiled_file(source)
{
	#print "Start of read_pre_compiled_file. source: "source
	theLine ="";

	#lastBlockCloseRow = 0
	lastBlockCloseIndex = 0
	lineCounter = 0
	count = 0
	while( (getline x < source) > 0 ) {
		# This will not save code that is implementing and or otherwise is not usefull for us.
		if(index(x,"#"))
		{
			split(x,neededAndNotNeeded,"#")
			x = neededAndNotNeeded[1]
		}
		#print "Source: "source" Linenumber: "++lineCounter". Line after removing of '#' lines: "x
		numberOfCharacters=split(x,lineCharacters,"");

		commentLine = ""

		for( i=1; i<=numberOfCharacters; i++ ) {

			if( lineCharacters[i] == "{" )
			{
				count++;
				if(count == 1)
				{
					theLine = theLine " {"
				}
			}
			else if( lineCharacters[i] == "}" )
			{
				count--;
				if(count == 0)
				{
					#print "Function declaration ended. Function: "substr(theLine, lastBlockCloseIndex, length(theLine) - lastBlockCloseIndex)
					theLine = theLine "} "
					lastBlockCloseIndex = length(theLine)
				}
			}
			else if( count == 0)
			{
				if(lineCharacters[i] == ";")
				{
					# Removes everything from last "}" to ";"
					theLine = substr(theLine, 1, lastBlockCloseIndex)
					#print "Implementing code removed. theLine: "theLine
				}
				else if(lineCharacters[i] == "*")
				{
					# We remove all spaces before star and
					# puts star and space to the end of line, so that function definitions would look like
					# "return_type* fuction_name(void* param1, string** param2)" and not
					# "return_type *function_name(void *param1, string **param2)" removing all the spaces
					# berfore space, will also take care of functions definitions not looking like
					# return_type* function_name(void* param1, string* * param2). When function definitions are
					# in that form, those are easy to parse, when return types and parameters lists are looked for.
					while(substr( theLine, length(theLine), 1 ) == " ") {
						theLine = substr( theLine, 1, length(theLine)-1 )
					}
					theLine = theLine"* "
				}
				else
				{
					theLine = theLine lineCharacters[i]
				}
			}
		}

		# inserts space between every line in preProcessed.
		theLine = theLine" "
	}
	theLine = strip(theLine)
	return theLine
}




function new_fuctions_and_variables_and_retvalues_for_them(preProcessedInOneLine, foundFunctionNames,
		numberOfFoundFunctions, newFunctions, foundRetValues, foundParameters, target)
{
	#print "Starting finding of fuctions, variables and retvalues. Parsed Preprocessed: "preProcessedInOneLine
	notReachedFilename = target"_NOT_REACHED.txt"
	numberOfParts = 0
	notNew = 0
	numberOfNew = 0
	for(foundFunctionIter=0; foundFunctionIter < numberOfFoundFunctions; foundFunctionIter++)
	{
		notNew = 0
		t = "void test_" foundFunctionNames[foundFunctionIter] "(void)"
		numberOfParts = split(foundFunctionNames[foundFunctionIter],partsOfFunctionName,"_")
		for(i=0; i < numberOfOldHLines; i++)
		{
			if( oldHLines[i] ~ ("^[[:blank:]]*void[[:blank:]]*" "test_" foundFunctionNames[foundFunctionIter] "[[:blank:]]*(.*)[[:blank:]]*$") )
			{
				notNew = 1
				break
			}
		}

		if(!notNew)
		{
			# If last part of fuction name is "net" then it is private function
			# and test case is not made.
			if(partsOfFunctionName[numberOfParts] == "net")
			{
				print "Test function is not made for \"*_net\" function\n"
			}
			# We have found a new function and we will make a new test case.
			else
			{
				newFunctions[numberOfNew] = foundFunctionNames[foundFunctionIter]
				print "New found!: "newFunctions[numberOfNew]
				functionStartIndex = match(preProcessedInOneLine, "\\<"foundFunctionNames[foundFunctionIter]"[^a-zA-Z0-9_]")
				if(functionStartIndex == 0)
				{
					print "Function is not found from preProcessed file and tests is not made for it!: "foundFunctionNames[foundFunctionIter]"\n"
					print foundFunctionNames[foundFunctionIter] > notReachedFilename
					continue
				}
				searchIndex = functionStartIndex + length(newFunctions[numberOfNew])
				startOfParameterList = searchIndex + (index( substr(preProcessedInOneLine, searchIndex), "(" ) - 1) + 1
				endOfParameterList = searchIndex + (index( substr(preProcessedInOneLine, searchIndex), ")" ) - 1) - 1
				parametersString = substr(preProcessedInOneLine, startOfParameterList, endOfParameterList - startOfParameterList + 1)
				if(parametersString ~ ("^[[:blank:]]*void[[:blank:]]*$"))
				{
					foundParameters[numberOfNew] = ""
				}
				else
				{
					foundParameters[numberOfNew] = parametersString
				}
				print "Found parameters: "foundParameters[numberOfNew]

				#End of retvalue is one space backwards from start of the function.
				endOfRetValue = functionStartIndex -2
				searchIndex--
				while(substr(preProcessedInOneLine, searchIndex, 1) != "}" && searchIndex > 0)
				{
					searchIndex--
				}
				startOfRetValue = searchIndex + 2
				foundRetValues[numberOfNew] = substr(preProcessedInOneLine, startOfRetValue, endOfRetValue - startOfRetValue + 1)
				print "Found retvalue: "foundRetValues[numberOfNew]
				numberOfNew++
			}
		}
	}
	return numberOfNew
}

function printComments(target, commentLines, numberOfCommentLines)
{
	for( i=0; i < numberOfCommentLines; i++ ) {
		print commentLines[i] > target
	}
	print "\n" > target
}

function insert_lines_from_last_occurence_of(numberOfTargetLines, targetLines, stringToOccure, numberOfLinesToInsert, linesToInsert)
{
	# First step back is to get into indexes
	lastLineIndex = numberOfTargetLines -1
	currentLineIndex = lastLineIndex
	while(targetLines[currentLineIndex] !~ stringToOccure && currentLineIndex != 0)
	{
		currentLineIndex--
	}
	currentLineIndex++
	numberOfTempLines = 0
	for(z=0; currentLineIndex+z <= lastLineIndex; z++)
	{
		tempLines[numberOfTempLines] = targetLines[currentLineIndex + z]
		targetLines[currentLineIndex + z] = ""
		numberOfTempLines++
	}
	for(linesToInsertIter=0; linesToInsertIter<numberOfLinesToInsert; linesToInsertIter++)
	{
	
		# When we are putting data to table for place that is already existing
		# we don't need to increase numberOfTargetLines.
		if(currentLineIndex <= lastLineIndex)
		{
			targetLines[currentLineIndex] = linesToInsert[linesToInsertIter]
			currentLineIndex++
		}
		else
		{
			targetLines[numberOfTargetLines] = linesToInsert[linesToInsertIter]
			numberOfTargetLines++
		}
	}
	for(z=0; z < numberOfTempLines; z++)
	{
		# When we are putting data to table for place that is already existing
		# we don't need to increase numberOfTargetLines.
		if(currentLineIndex < lastLineIndex)
		{
			targetLines[currentLineIndex] = tempLines[z]
			currentLineIndex++
		}
		else
		{
			targetLines[numberOfTargetLines] = tempLines[z]
			numberOfTargetLines++
		}
	}
	return numberOfTargetLines
}


function create_h_test_file(target, oldHLines, numberOfOldHLines, newFunctionNames,
			numberOfNew, newFuctionsRetValues, newFuctionsParameters, comments, numberOfComments)
{
	newHTarget = "new_"target".h"
	print "" > newHTarget


	# Completely new h file can contain one row, because we have put empty line to it.
	# If we have completely new h file, we need to create it from scratch.
	if(numberOfOldHLines < 2)
	{
#		for(i=0; i<numberOfComments; i++)
#		{
#			print comments[numberOfComments] >> newHTarget
#		}
		printComments(newHTarget, licenseComments, numberOfLicenseCommentLines)

		print "#ifndef __"target"_H__\n#define __"target"_H__" >> newHTarget
		print "\n#include <stdlib.h>\n#include <CUnit.h>" >> newHTarget
		for(i=0; i<numberOfNew; i++)
		{
			#print "\n" >> newHTarget
			print testCreationComment >> newHTarget
			print "void test_"newFunctionNames[i]"(void);" >> newHTarget
		}
		
		print "\n"initFunctionComment >> newHTarget
		print "static int "target"_automatic_init(void);" >> newHTarget
		print "\n"cleanFunctionComment >> newHTarget
		print "static int "target"_automatic_clean(void);" >> newHTarget

		print "\n"initFunctionComment >> newHTarget
		print "static int "target"_basics_init(void);" >> newHTarget
		print "\n"cleanFunctionComment >> newHTarget
		print "static int "target"_basics_clean(void);" >> newHTarget

		print "\n"initFunctionComment >> newHTarget
		print "static int "target"_advanced_init(void);" >> newHTarget
		print "\n"cleanFunctionComment >> newHTarget
		print "static int "target"_advanced_clean(void);" >> newHTarget

		print "\n"testSuiteComment >> newHTarget
		print "static CU_TestInfo "automaticAdded"[];" >> newHTarget

		print "static CU_TestInfo "basics"[];" >> newHTarget

		print "static CU_TestInfo "advanced"[];" >> newHTarget

		print "\n"tableComment >> newHTarget
		print "CU_SuiteInfo "target"[];" >> newHTarget
		print "\n#endif" >> newHTarget
	}

	# Else we have already existing h file and we can take existing code to start with.
	else
	{

		print "Updating header file!\n"

		numberOfNewHLines = 0
		for(i=0; i < numberOfOldHLines; i++)
		{

			if(oldHLines[i] ~ "automatic_init")
			{

				numberOfLinesToInsert = 0
				for(newFunctionNamesIterator=0; newFunctionNamesIterator<numberOfNew; newFunctionNamesIterator++)
				{
					linesToInsert[numberOfLinesToInsert] =  "//NEW"
					numberOfLinesToInsert++
					linesToInsert[numberOfLinesToInsert] =  "void test_"newFunctionNames[newFunctionNamesIterator]"(void);"
					numberOfLinesToInsert++
					print "Lines to be added to header file: "linesToInsert[numberOfLinesToInsert-1]
					print "                                  "linesToInsert[numberOfLinesToInsert]
				}
				lastIndex = i-1
				numberOfNewHLines = insert_lines_from_last_occurence_of(numberOfNewHLines, newHLines, "void test", numberOfLinesToInsert, linesToInsert)
				newHLines[numberOfNewHLines] = oldHLines[i]
				numberOfNewHLines++
			}
			else
			{
				newHLines[numberOfNewHLines] = oldHLines[i]
				numberOfNewHLines++
			}

		}
		for(k=0; k < numberOfNewHLines; k++)
		{
			print newHLines[k] >> newHTarget
		}
	}
}

function return_init_value_for_given_type(typeToMatch)
{
	retInital = "0"
	if(index(typeToMatch, "*"))
	{
		retInital = "NULL"
	}
	else if(typeToMatch ~ ("gpointer"))
	{
		retInital = "NULL"
	}
	else if(typeToMatch ~ ("int"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("glong"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("gulong"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("gshort"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("gushort"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("float"))
	{
		retInital = "0.0"
	}
	else if(typeToMatch ~ ("double"))
	{
		retInital = "0.0"
	}
		else if(typeToMatch ~ ("char"))
	{
		retInital = "A"
	}
	else if(typeToMatch ~ ("gboolean"))
	{
		retInital = "FALSE"
	}
	else if(typeToMatch ~ ("GType"))
	{
		retInital = "0"
	}
	else if(typeToMatch ~ ("GWebStatus"))
	{
		retInital = "G_WEB_STATUS_OK"
	}
	else if(typeToMatch ~ ("GWebEngineEncoding"))
	{
		retInital = "G_WEBENGINE_ENCODING_AUTOMATIC"
	}
	else if(typeToMatch ~ ("GWebEngineLayoutMode"))
	{
		retInital = "G_WEBENGINE_LAYOUT_NORMAL"
	}
	else if(typeToMatch ~ ("GWebEngineImagePolicy"))
	{
		retInital = "G_WEBENGINE_POLICY_NO_IMAGES"
	}
	else if(typeToMatch ~ ("GWebPasswordAction"))
	{
		retInital = "G_WEB_PASSWORD_STORE"
	}
	else if(typeToMatch ~ ("GWebEngineSaveAction"))
	{
		retInital = "G_WEBENGINE_SAVE_NO_INLINES"
	}
	else if(typeToMatch ~ ("GWebCookieAction"))
	{
		retInital = "G_WEB_COOKIE_NO_ACTION"
	}
	else if(typeToMatch ~ ("GWebCertificateAction"))
	{
		retInital = "G_WEB_CERT_ACTION_OK"
	}
	else if(typeToMatch ~ ("GWebCertificateReaction"))
	{
		retInital = "G_WEB_CERT_REACTION_NOTHING"
	}
	else if(typeToMatch ~ ("GWebCertificateMessage"))
	{
		retInital = "G_WEB_CERT_MESS_NOSTATE"
	}
	else if(typeToMatch ~ ("GWebDialogButton"))
	{
		retInital = "G_WEB_DIALOG_NO_BUTTON"
	}
	else if(typeToMatch ~ ("GWebDialogMessageType"))
	{
		retInital = "G_WEB_DIALOG_MESSAGE_TYPE_INFO"
	}
	else if(typeToMatch ~ ("GWebPluginEvent"))
	{
		retInital = "G_WEB_PLUGINS_SHOW"
	}
	else if(typeToMatch ~ ("GWebWindowChromeFlags"))
	{
		retInital = "G_WEB_WINDOW_FLAG_DEFAULTCHROME"
	}
	return retInital
}

function struct_lines_for_function(structLines, parametersString, returnValuesString, typeNamesString)
{
	numberOfStructLines = 0
	numberOfParams = split(parametersString, params, ",")
	structLines[numberOfStructLines] = "typedef struct {"
	numberOfStructLines++
	for(paramsIter=1; paramsIter<=numberOfParams; paramsIter++)
	{
		numberOfItems = split(params[paramsIter], items, " ")
		variablesString = ""
		for(k=1; k <= numberOfItems; k++)
		{
			if(items[k] !~ /^[[:blank:]]*const[[:blank:]]*/ && items[k] !~ /^[[:blank:]]const\*[[:blank:]]*/)
			{
				variablesString = variablesString" "items[k]
			}
			if(items[k] ~ /^[[:blank:]]*const\*[[:blank:]]*/)
			{
				variablesString = variablesString"*"
			}
		}
		structLines[numberOfStructLines] =  "    "variablesString";"
		numberOfStructLines++
	}
	numberOfRetValueItems = split(returnValuesString, retitems, " ")
	indexOfRetValue = numberOfRetValueItems
	if(retitems[indexOfRetValue] != "void")
	{
		structLines[numberOfStructLines] =  "    "returnValuesString" expected_retvalue;"
		numberOfStructLines++
	}
	structLines[numberOfStructLines] =  "} "typeNamesString";"
	numberOfStructLines++
	return numberOfStructLines
}

function initialization_lines_for_function(initializationLines, functionStructName, functionNameString, parametersString, returnValuesString, nameOfTestDataVariable)
{
	NumberOfInitializationLines = 0

	initializationLines[NumberOfInitializationLines] =  "    "functionStructName"* tmp_"functionNameString" = g_new0("functionStructName", 1);"
	NumberOfInitializationLines++

	numberOfParams = split(parametersString, params, ",")
	for(paramsIter=1; paramsIter<=numberOfParams; paramsIter++)
	{
		inital = " = "
		typesString = ""
		numberOfItems = split(params[paramsIter], items, " ")
		paramName = items[numberOfItems]
		# Types of parameter is taken to different string
		typesString = items[1]
		for(k=2; k<=numberOfItems-1; k++)
		{
			typesString = typesString" "items[k]
		}
		inital = inital return_init_value_for_given_type(typesString)
		initializationLines[NumberOfInitializationLines] =  "    /* "typesString" */tmp_"functionNameString"->"paramName inital";"
		NumberOfInitializationLines++
	}
	numberOfRetValueItems = split(returnValuesString, retitems, " ")
	indexOfRetValue = numberOfRetValueItems
	if(retitems[indexOfRetValue] != "void")
	{
		initializationLines[NumberOfInitializationLines] =  "    /* "returnValuesString" */tmp_"functionNameString"->expected_retvalue = "return_init_value_for_given_type(newFuctionsRetValues[functionsIter])";"
		NumberOfInitializationLines++
	}
    initializationLines[NumberOfInitializationLines] = "    "nameOfTestDataVariable"."functionNameString".table ="
	NumberOfInitializationLines++
    initializationLines[NumberOfInitializationLines] = "        g_list_append ("nameOfTestDataVariable"."functionNameString".table, tmp_"functionNameString");"
	NumberOfInitializationLines++
    initializationLines[NumberOfInitializationLines] = "    "nameOfTestDataVariable"."functionNameString".index = 0;"
	NumberOfInitializationLines++
	initializationLines[NumberOfInitializationLines] =  ""
	NumberOfInitializationLines++
	return NumberOfInitializationLines
}

function initialization_lines_for_test_table(tableInitializationLines, testFunctionNameString, nameOfTestDataVariable)
{
	NumberOfTableInitializationLines = 0
	tableInitializationLines[NumberOfTableInitializationLines] =  ""
	NumberOfTableInitializationLines++
	tableInitializationLines[NumberOfTableInitializationLines] =  "    g_list_free("nameOfTestDataVariable"."testFunctionNameString".table);"
	NumberOfTableInitializationLines++
	tableInitializationLines[NumberOfTableInitializationLines] =  "    "nameOfTestDataVariable"."testFunctionNameString".table = NULL;"
	NumberOfTableInitializationLines++
	tableInitializationLines[NumberOfTableInitializationLines] =  "    "nameOfTestDataVariable"."testFunctionNameString".index = -1;"
	NumberOfTableInitializationLines++
	return NumberOfTableInitializationLines
	
}

function test_function_lines_for_function(functionLines, functionStructName, functionNameString, parametersString, returnValuesString, nameOfTestDataVariable)
{
	NumberOfFunctionLines = 0
	functionLines[NumberOfFunctionLines] =  ""
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  testCreationComment
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "void test_"functionNameString"(void)"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "{"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  ""
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    DEBUG_FUNCTIONS_STARTED(\""functionNameString"\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    "
	NumberOfFunctionLines++
	numberOfParams = split(parametersString, params, ",")
	functionLines[NumberOfFunctionLines] =  "    if("nameOfTestDataVariable".automatic)"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    {"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        CU_FAIL(\"Test is not done yet!\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        printf(\"Automatic test runned.\\n\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    }"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    else"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    {"
	NumberOfFunctionLines++
	
	functionLines[NumberOfFunctionLines] =  "        gint test_index = "nameOfTestDataVariable"."functionNameString".index;"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        printf(\"Index of test data: %i\\n\", test_index);"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        "functionStructName"* test_item_data ="
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "            ("functionStructName"*)g_list_nth_data("nameOfTestDataVariable"."functionNameString".table, test_index);"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        "nameOfTestDataVariable"."functionNameString".index++;"
	NumberOfFunctionLines++
		
	paramName = ""
	for(parameterIterator=1; parameterIterator<=numberOfParams; parameterIterator++)
	{
		numberOfItems = split(params[parameterIterator], items, " ")
		paramName = items[numberOfItems]
		functionLines[NumberOfFunctionLines] =  "        "params[parameterIterator]" = test_item_data->"paramName";"
		NumberOfFunctionLines++
	}
	retValueExists = 0
	numberOfRetValueItems = split(returnValuesString, retitems, " ")
	indexOfRetValue = numberOfRetValueItems
	if(retitems[numberOfRetValueItems] != "void")
	{
		functionLines[NumberOfFunctionLines] =  "        "returnValuesString" retvalue;"
		NumberOfFunctionLines++
		retValueExists = 1
	}
	functionLines[NumberOfFunctionLines] =  "        if("nameOfTestDataVariable".basics) {"
	NumberOfFunctionLines++
	retValueString = ""
	if(retValueExists != 0){
		retValueString = "retvalue = "
	}
	functionCallString = retValueString functionNameString"("
	numberOfParams = split(parametersString, params, ",")
	for(parameterIterator=1; parameterIterator<=numberOfParams; parameterIterator++)
	{
		numberOfItems = split(params[parameterIterator], items, " ")
		comma = ""
		if(parameterIterator != numberOfParams)
		{
			comma = ","
		}
		paramName = items[numberOfItems]
		functionCallString = functionCallString paramName comma
	}
	functionCallString = functionCallString");"
	functionLines[NumberOfFunctionLines] =  "            "functionCallString
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "            CU_PASS(\"Basic test!\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "            printf(\"Basic test runned.\\n\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        }"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        else"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        {"
	NumberOfFunctionLines++
	if(retValueExists)
	{
		functionLines[NumberOfFunctionLines] =  "            "returnValuesString" expected_retvalue = test_item_data->expected_retvalue;"
		NumberOfFunctionLines++
	}
	functionLines[NumberOfFunctionLines] =  "            "functionCallString
	NumberOfFunctionLines++
	if(retValueExists)
	{
		functionLines[NumberOfFunctionLines] =  "            CU_ASSERT_EQUAL(retvalue, expected_retvalue);"
		NumberOfFunctionLines++
	}
	functionLines[NumberOfFunctionLines] =  "            printf(\"Advanced test runned.\\n\");"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "        }"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    }"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    fflush(stdout);"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "    DEBUG_FUNCTION_ENDED;\n"
	NumberOfFunctionLines++
	functionLines[NumberOfFunctionLines] =  "}"
	NumberOfFunctionLines++
	return NumberOfFunctionLines
}

function return_add_function_to_table_string(functionNameString)
{
	return "{ \"test_"functionNameString"\", test_"functionNameString" },"
}

function return_create_variable_string(typeString, nameString)
{
	return "    "typeString" "nameString";"
}

function create_c_test_file(target, oldCLines, numberOfOldCLines, preProcessedInOneLine,
				newFunctionNames, numberOfNew, newFuctionsRetValues, newFuctionsParams, includes, numberOfIncludeLines, comments, numberOfComments)
{
	nameOfTestDataVariable = "testdata"
	for(i=0; i < numberOfNew; i++)
	{
		numberOfFields = split(newFunctionNames[i], name_parts_array, "_")
		newFunctionTypeName = ""
		for(typeIter=1; typeIter <= numberOfFields; typeIter++)
		{
			newFunctionTypeName = newFunctionTypeName toupper(substr(name_parts_array[typeIter],1,1)) substr(name_parts_array[typeIter],2)
		}
		newFunctionTypeNames[i] = newFunctionTypeName"Struct"
	}
	newCTarget = "new_"target".c"
	print "" > newCTarget
	if(numberOfOldCLines < 2)
	{
#		for(i=0; i<numberOfComments; i++)
#		{
#			print comments[numberOfComments] >> newCTarget
#		}

		printComments(newCTarget, licenseComments, numberOfLicenseCommentLines)



		indexOfOrigFileName = split(target, origFileNameIsLast, "test")
		print "#include \""target".h\"\n#include \"tests_common.h\"" >> newCTarget
		print "\n#include <assert.h>\n#include <Automated.h>" >> newCTarget
		print "\n#include <stdio.h>\n#include <string.h>\n#include <glib.h>\n#include <gtk/gtk.h>" >> newCTarget

		print "" >> newCTarget
		print "\ntypedef struct {" >> newCTarget
		print "    gint index;" >> newCTarget
		print "    GList* table;" >> newCTarget
		print "} TestTableData;" >> newCTarget
		print "" >> newCTarget

		for(i=0; i<numberOfIncludeLines; i++)
		{
			print  includes[i] >> newCTarget
		}
		print "" >> newCTarget

		for(i=0; i<numberOfNew; i++)
		{
			numberOfStructLines = struct_lines_for_function(structLines, newFuctionsParams[i], newFuctionsRetValues[i], newFunctionTypeNames[i])
			for(j=0; j<numberOfStructLines; j++)
			{
				print structLines[j] >> newCTarget
			}
		}
		print "\ntypedef struct {" >> newCTarget
		print "    gboolean automatic;" >> newCTarget
		print "    gboolean basics;" >> newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			print return_create_variable_string("TestTableData", newFunctionNames[i]) >> newCTarget
		}
		print "} TestData;" >> newCTarget
		print "TestData "nameOfTestDataVariable";" >> newCTarget
	
		print "static void init_test_data()\n{" >> newCTarget
		print "    "nameOfTestDataVariable".automatic = FALSE;" >> newCTarget
		print "    "nameOfTestDataVariable".basics = FALSE;" >> newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			numberOfInitializationLines = initialization_lines_for_test_table(initializationLines, newFunctionNames[i], nameOfTestDataVariable)
			for(j=0; j<numberOfInitializationLines; j++)
			{
				print initializationLines[j] >> newCTarget
			}
		}
		print "\n}" >> newCTarget
		
		for(newFunctionNamesIter=0; newFunctionNamesIter < numberOfNew; newFunctionNamesIter++)
		{
			numberOfTestFunctionLines = test_function_lines_for_function(testFunctionLines, newFunctionTypeNames[newFunctionNamesIter], newFunctionNames[newFunctionNamesIter], newFuctionsParams[newFunctionNamesIter], newFuctionsRetValues[newFunctionNamesIter], nameOfTestDataVariable)
			for(j=0; j<numberOfTestFunctionLines; j++)
			{
				print testFunctionLines[j] >> newCTarget
			}
		}

		# Init functions for test cases.
		print "\n"initFunctionComment >> newCTarget
		print "static int\n"target"_automatic_init()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_init\");\n    //init_test_data();\n    "nameOfTestDataVariable".automatic = TRUE;\n    return 0;\n}" >> newCTarget
		print "\n"cleanFunctionComment >> newCTarget
		print "static int\n"target"_automatic_clean()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_clean\");\n    "nameOfTestDataVariable".automatic = FALSE;\n    return 0;\n}" >> newCTarget

		# Init functions for test cases.
		print "\n"initFunctionComment >> newCTarget
		print "static int\n"target"_basics_init()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_basics_init\");\n    g_type_init();\n    init_test_data();\n    "nameOfTestDataVariable".basics = TRUE;" >> newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			numberOfInitializationLines = initialization_lines_for_function(initializationLines, newFunctionTypeNames[i], newFunctionNames[i], newFuctionsParams[i], newFuctionsRetValues[i], nameOfTestDataVariable)
			for(j=0; j<numberOfInitializationLines; j++)
			{
				print initializationLines[j] >> newCTarget
			}
		}
		print "    return 0;\n}" >> newCTarget
		print "\n"cleanFunctionComment >> newCTarget
		print "static int\n"target"_basics_clean()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_basics_clean\");\n    "nameOfTestDataVariable".basics = FALSE;" >> newCTarget
		print "    return 0;\n}" >> newCTarget

		# Init functions for test cases.
		print "\n"initFunctionComment >> newCTarget
		print "static int\n"target"_advanced_init()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_advanced_init\");\n    g_type_init();\n    init_test_data();\n    return 0;\n}" >> newCTarget
		print "\n"cleanFunctionComment >> newCTarget
		print "static int\n"target"_advanced_clean()\n{\n    INIT_OR_CLEAN_STARTED(\""target"_advanced_clean\");\n    return 0;\n}" >> newCTarget

		# Tables for test cases.
		print "\n" >> newCTarget
		print testSuiteComment >> newCTarget
		print "static CU_TestInfo "automaticAdded"[] = {" > newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			print return_add_function_to_table_string(newFunctionNames[i]) >> newCTarget
		}
		print "    CU_TEST_INFO_NULL, //null terminated\n};" >> newCTarget

		print "static CU_TestInfo "basics"[] = {" > newCTarget
		print "/*" > newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			print return_add_function_to_table_string(newFunctionNames[i]) >> newCTarget
		}
		print "*/" > newCTarget
		print "    CU_TEST_INFO_NULL, //null terminated\n};" >> newCTarget

		print "static CU_TestInfo "advanced"[] = {" > newCTarget
		for(i=0; i<numberOfNew; i++)
		{
			print "//"return_add_function_to_table_string(newFunctionNames[i]) >> newCTarget
		}
		print "    CU_TEST_INFO_NULL, //null terminated\n};" >> newCTarget


		# Table for suite containing test cases.
		print "\n"tableComment >> newCTarget
		print "CU_SuiteInfo "target"[] = {" >> newCTarget
		print "{\""automaticAdded"\", "target"_automatic_init, "target"_automatic_clean, "automaticAdded" }," >> newCTarget
		print "{\""basics"\", "target"_basics_init, "target"_basics_clean, "basics" }," >> newCTarget
		print "{\""advanced"\", "target"_advanced_init, "target"_advanced_clean, "advanced" }," >> newCTarget
		print "CU_SUITE_INFO_NULL, //null terminated\n};" >> newCTarget
	}
	else
	{
		numberOfNewCLinesToAdd = 0
		oldLinesIterator = 0
		newCLinesToAdd[0] = ""
		print "" >> newCTarget
		while(oldCLines[oldLinesIterator] !~ "typedef struct {")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		for(includeIterator=0; includeIterator<numberOfIncludeLines; includeIterator++)
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  includes[includeIterator]
			numberOfNewCLinesToAdd++
		}
		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		
		while(oldCLines[oldLinesIterator] !~ "gboolean automatic;")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfStructLinesToInsert = 0
		print "Number of new functions: "numberOfNew
		for(j=0; j<numberOfNew; j++)
		{
			for(clearIterator=0; clearIterator<numberOfStructLinesToInsert; clearIterator++)
			{
				structLines[clearIterator] = ""
			}
			numberOfStructLines = struct_lines_for_function(structLines, newFuctionsParams[j], newFuctionsRetValues[j], newFunctionTypeNames[j])
			for(k=0; k<numberOfStructLines; k++)
			{
				structLinesToInsert[numberOfStructLinesToInsert] = structLines[k]
				numberOfStructLinesToInsert++
			}
		}
		for(j=0; j<numberOfStructLinesToInsert; j++)
		{
			if(j == 0)
			{
				print "All struct lines to insert:                ..."
			}
			print "All struct lines to insert:                +"structLinesToInsert[j]
			if(j == numberOfStructLinesToInsert-1)
			{
				print "All struct lines to insert:                ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ";", numberOfStructLinesToInsert, structLinesToInsert)

		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++

		while(oldCLines[oldLinesIterator] !~ "} TestData;")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}

		numberOfVariableLinesToInsert = 0
		for(j=0; j<numberOfNew; j++)
		{
			variableLinesToInsert[numberOfVariableLinesToInsert] = return_create_variable_string("TestTableData", newFunctionNames[j])
			numberOfVariableLinesToInsert++
		}
		for(j=0; j<numberOfVariableLinesToInsert; j++)
		{
			if(j == 0)
			{
				print "All variable lines to insert:              ..."
				print "All variable lines to insert:              typedef struct {"
				print "All variable lines to insert:                  gboolean automatic;"
				print "All variable lines to insert:                  gboolean basics;"
				print "All variable lines to insert:                  ..."
			}
			print "All variable lines to insert:              +"variableLinesToInsert[j]
			if(j == numberOfVariableLinesToInsert-1)
			{
				print "All variable lines to insert:              } TestData;"
				print "All variable lines to insert:              ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ";", numberOfVariableLinesToInsert, variableLinesToInsert)

		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
			
		while(oldCLines[oldLinesIterator] !~ "static void init_test_data()")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++;
		}
		while(oldCLines[oldLinesIterator] !~ "}")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfInitializationLinesToInsert = 0
		for(j=0; j<numberOfNew; j++)
		{
			for(clearIterator=0; clearIterator<numberOfInitializationLines; clearIterator++)
			{
				initializationLines[clearIterator] = ""
			}
			numberOfInitializationLines = initialization_lines_for_test_table(initializationLines, newFunctionNames[j], nameOfTestDataVariable)
			
			for(k=0; k<numberOfInitializationLines; k++)
			{
				initializationLinesToInsert[numberOfInitializationLinesToInsert] = initializationLines[k]
				numberOfInitializationLinesToInsert++
			}
		}
		for(j=0; j<numberOfInitializationLinesToInsert; j++)
		{
			if(j == 0)
			{
				print "All initialization lines to insert:        ..."
				print "All initialization lines to insert:        static void init_test_data()"
				print "All initialization lines to insert:        {"
				print "All initialization lines to insert:            ..."
			}
			print "All initialization lines to insert:        +"initializationLinesToInsert[j]
			if(j == numberOfInitializationLinesToInsert-1)
			{
				print "All initialization lines to insert:        }"
				print "All initialization lines to insert:        ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ";", numberOfInitializationLinesToInsert, initializationLinesToInsert)

		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		while(oldCLines[oldLinesIterator] !~ "automatic_init()")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfFunctionLinesToInsert = 0
		for(j=0; j<numberOfNew; j++)
		{
			for(clearIterator=0; clearIterator<numberOfTestFunctionLines; clearIterator++)
			{
				testFunctionLines[clearIterator] = ""
			}
			numberOfTestFunctionLines = test_function_lines_for_function(testFunctionLines, newFunctionTypeNames[j], newFunctionNames[j], newFuctionsParams[j], newFuctionsRetValues[j], nameOfTestDataVariable)
			
			for(k=0; k<numberOfTestFunctionLines; k++)
			{
				functionLinesToInsert[numberOfFunctionLinesToInsert] = testFunctionLines[k]
				numberOfFunctionLinesToInsert++
			}
		}
		for(j=0; j<numberOfFunctionLinesToInsert; j++)
		{
			if(j == 0)
			{
				print "All function lines to insert:              ..."
				print "All function lines to insert:              }"
			}
			print "All function lines to insert:              +"functionLinesToInsert[j]
			if(j == numberOfFunctionLinesToInsert-1)
			{
				print "All function lines to insert:              ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, "}", numberOfFunctionLinesToInsert, functionLinesToInsert)

		# Here we put the starting point of modifications to new lines
		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		while(oldCLines[oldLinesIterator] !~ "basics_init()")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		while(oldCLines[oldLinesIterator] !~ "}")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfFunctionInitializationLinesToInsert = 0
		for(j=0; j<numberOfNew; j++)
		{
			numberOfFunctionInitializationLines = initialization_lines_for_function(functionInitializationLines, newFunctionTypeNames[j], newFunctionNames[j], newFuctionsParams[j], newFuctionsRetValues[j], nameOfTestDataVariable)
			
			for(k=0; k<numberOfFunctionInitializationLines; k++)
			{
				initializationLinesToInsert[numberOfFunctionInitializationLinesToInsert] = functionInitializationLines[k]
				numberOfFunctionInitializationLinesToInsert++
			}
		}
		for(j=0; j<numberOfFunctionInitializationLinesToInsert; j++)
		{
			if(j == 0)
			{
				print "All initialization lines to insert:        ..."
				print "All initialization lines to insert:        testgmozillaweb_basics_init()"
				print "All initialization lines to insert:        {"
				print "All initialization lines to insert:            ..."
			}
			print "All initialization lines to insert:        +"initializationLinesToInsert[j]
			if(j == numberOfFunctionInitializationLinesToInsert-1)
			{
				print "All initialization lines to insert:        }"
				print "All initialization lines to insert:        ...\n"
			}
		}
		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ";", numberOfFunctionInitializationLinesToInsert, initializationLinesToInsert)

		
		# Here we put the starting point of modifications to new lines
		newCLinesToAdd[numberOfNewCLinesToAdd] = oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		
		while(oldCLines[oldLinesIterator] !~ "static CU_TestInfo")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		while(oldCLines[oldLinesIterator] !~ "CU_TEST_INFO_NULL")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfToAutomaticTableAddLines = 0
		for(j=0; j<numberOfNew; j++)
		{
			toAutomaticTableAddLines[numberOfToAutomaticTableAddLines] =  "/*NEW*/"return_add_function_to_table_string(newFunctionNames[j])
			numberOfToAutomaticTableAddLines++
		}
		for(j=0; j<numberOfToAutomaticTableAddLines; j++)
		{
			if(j == 0)
			{
				print "All lines to insert to automatic table:    ..."
				print "All lines to insert to automatic table:    static CU_TestInfo "automatic"[] = {"
				print "All lines to insert to automatic table:        ..."
			}
			print "All lines to insert to automatic table:    +"toAutomaticTableAddLines[j]
			if(j == numberOfToAutomaticTableAddLines-1)
			{
				print "All lines to insert to automatic table:        CU_TEST_INFO_NULL, //null terminated"
				print "All lines to insert to automatic table:    };"
				print "All lines to insert to automatic table:    ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ",", numberOfToAutomaticTableAddLines, toAutomaticTableAddLines)

		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++				

		while(oldCLines[oldLinesIterator] !~ "static CU_TestInfo "basics)
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		while(oldCLines[oldLinesIterator] !~ "CU_TEST_INFO_NULL")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfToBasicsTableAddLines = 0
		for(j=0; j<numberOfNew; j++)
		{
			toBasicsTableAddLines[numberOfToBasicsTableAddLines] =  "//NEW " return_add_function_to_table_string(newFunctionNames[j])
			numberOfToBasicsTableAddLines++
		}
		for(j=0; j<numberOfToBasicsTableAddLines; j++)
		{
			if(j == 0)
			{
				print "All lines to insert to basics table:       ..."
				print "All lines to insert to basics table:       static CU_TestInfo "basics"[] = {"
				print "All lines to insert to basics table:           ..."
			}
			print "All lines to insert to basics table:       +"toBasicsTableAddLines[j]
			if(j == numberOfToBasicsTableAddLines-1)
			{
				print "All lines to insert to basics table:           CU_TEST_INFO_NULL, //null terminated"
				print "All lines to insert to basics table:       };"
				print "All lines to insert to basics table:       ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ",", numberOfToBasicsTableAddLines, toBasicsTableAddLines)

		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++				
		while(oldCLines[oldLinesIterator] !~ "static CU_TestInfo "advanced)
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++
		while(oldCLines[oldLinesIterator] !~ "CU_TEST_INFO_NULL")
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
		numberOfToAdvanceTableAddLines = 0
		for(j=0; j<numberOfNew; j++)
		{
			toAdvanceTableAddLines[numberOfToAdvanceTableAddLines] =  "//NEW " return_add_function_to_table_string(newFunctionNames[j])
			numberOfToAdvanceTableAddLines++
		}
		for(j=0; j<numberOfToAdvanceTableAddLines; j++)
		{
			if(j == 0)
			{
				print "All lines to insert to advance table:      ..."
				print "All lines to insert to advance table:      static CU_TestInfo "advanced"[] = {"
				print "All lines to insert to advance table:          ..."
			}
			print "All lines to insert to advance table:      +"toAdvanceTableAddLines[j]
			if(j == numberOfToAdvanceTableAddLines-1)
			{
				print "All lines to insert to advance table:          CU_TEST_INFO_NULL, //null terminated"
				print "All lines to insert to advance table:      };"
				print "All lines to insert to advance table:      ...\n"
			}
		}

		numberOfNewCLinesToAdd = insert_lines_from_last_occurence_of(numberOfNewCLinesToAdd, newCLinesToAdd, ",", numberOfToAdvanceTableAddLines, toAdvanceTableAddLines)

		newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
		numberOfNewCLinesToAdd++
		oldLinesIterator++				
		while(oldLinesIterator < numberOfOldCLines)
		{
			newCLinesToAdd[numberOfNewCLinesToAdd] =  oldCLines[oldLinesIterator]
			numberOfNewCLinesToAdd++
			oldLinesIterator++
		}
	}
	for(k=0; k < numberOfNewCLinesToAdd; k++)
	{
		print newCLinesToAdd[k] >> newCTarget
	}
}

function strip(stringToStrip)
{
	numberOfRetvalues = split(stringToStrip, retValues, " ")
	retValueString = ""
	if(numberOfRetvalues > 0)
	{
		retValueString = retValues[1]
		for(numberOfNewLines=2; i<=numberOfRetvalues; i++)
		{
			retValueString = retValueString" "retValues[i]
		}
	}
	return retValueString
}
