/*
 * This is main function for all the tests in this package
 * For main file, name of the outputfile needs to be changed according
 * to the package and the makefile, other than that, it needs no changes.
 */

#include <stdlib.h>
#include <string.h>
#include <CUnit.h>
#include <assert.h>
#include <Automated.h>
#include <stdio.h>
#include <dlfcn.h>
#include <gtk/gtk.h>


void AddTests(char* tests_name);


// This needs to be changed for every package.
static char* SO_FILENAME = "./.libs/libtestmicrob-eal.so";


//MAIN:
int main(int argc, char* argv[])
{
    gtk_init_check (&argc, &argv);
    
    CU_set_error_action(CUEA_IGNORE);

    //initalize the registry
    if (CU_initialize_registry())
    {
        printf("\nInitialization of Test Registry failed.");
    }
    else
    {
        char tests_name[1000];
        char output_name[1000] = "";
        //add the tests to the suites
        if(argc > 1)
        {
            int i = 1;
            while(i < argc)
            {
                strcpy (tests_name, argv[i]);
                strcat (output_name, tests_name);
                AddTests(tests_name);
                ++i;
            }
        }
        
        //AddTests("testgmozillahistorylist");
        //set the output files and run the suites
        CU_set_output_filename(output_name);
        CU_list_tests_to_file();
        CU_automated_run_tests();

        //cleanup the registry
        CU_cleanup_registry();
    }
    return 0;
}







// the following AddTests method need-not be changed
// it is called by main function.
void AddTests(char* tests_name)
{
    assert(NULL != CU_get_registry());
    assert(!CU_is_test_running());
    
    dlerror();

    
    void* d = dlopen (SO_FILENAME, RTLD_LAZY);
    if(d == NULL)
    {
        fprintf(stderr, "ERROR: dlopen failed:\n%s\n", dlerror());
        exit(EXIT_FAILURE);
    }

    CU_SuiteInfo *data = dlsym(d, tests_name);
    if(data == NULL)
    {
        fprintf(stderr, "ERROR: dlsym failed:\n%s\n", dlerror());
        exit(EXIT_FAILURE);
    }

    if (CU_register_suites((CU_SuiteInfo*)data) != CUE_SUCCESS) {
        fprintf(stderr, "suite registration failed - %s\n",
            CU_get_error_msg());
        exit(EXIT_FAILURE);
    }


}
