/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *   Ramiro Estrugo <ramiro@eazel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef microb_eal_context_h
#define microb_eal_context_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stddef.h>
#include <gtk/gtk.h>
#include "common.h"

#ifdef MOZILLA_CLIENT
#include "nscore.h"
#else /* MOZILLA_CLIENT */
#ifndef nscore_h__
/* Because this header may be included from files which not part of the mozilla
   build system, define macros from nscore.h */

#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#define NS_HIDDEN __attribute__((visibility("hidden")))
#else
#define NS_HIDDEN
#endif

#define NS_FROZENCALL
#define NS_EXPORT_(type) type
#define NS_IMPORT_(type) type
#endif /* nscore_h__ */
#endif /* MOZILLA_CLIENT */

#ifdef XPCOM_GLUE

#define MICROBEAL_API(type, name, params) \
  typedef type (NS_FROZENCALL * name##Type) params; \
  extern name##Type name NS_HIDDEN;

#else /* XPCOM_GLUE */

#ifdef _IMPL_GTKMICROB
#define MICROBEAL_API(type, name, params) NS_EXPORT_(type) name params;
#else
#define MICROBEAL_API(type,name, params) NS_IMPORT_(type) name params;
#endif

#endif /* XPCOM_GLUE */

#define GTK_TYPE_MICROB_CONTEXT             (gtk_microb_context_get_type())
#define GTK_MICROB_CONTEXT(obj)             GTK_CHECK_CAST((obj), GTK_TYPE_MICROB_CONTEXT, GtkMicroBContext)
#define GTK_MICROB_CONTEXT_CLASS(klass)     GTK_CHECK_CLASS_CAST((klass), GTK_TYPE_MICROB_CONTEXT, GtkMicroBContextClass)
#define GTK_IS_MICROB_CONTEXT(obj)          GTK_CHECK_TYPE((obj), GTK_TYPE_MICROB_CONTEXT)
#define GTK_IS_MICROB_CONTEXT_CLASS(klass)  GTK_CHECK_CLASS_TYPE((klass), GTK_TYPE_MICROB_CONTEXT)
#define GTK_MICROB_CONTEXT_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MICROB_CONTEXT, GtkMicroBContextClass))

typedef struct _GtkMicroBContext        GtkMicroBContext;
typedef struct _GtkMicroBContextClass   GtkMicroBContextClass;
typedef struct _GtkMicroBContextPrivate GtkMicroBContextPrivate;

struct _GtkMicroBContext
{
  GObject  object;
  /*< private > */
  GtkMicroBContextPrivate *priv;

  guint button;
  guint type;
  guint modifier;
  guint x, y;
  gint  x_root, y_root;
  gint  docindex;
};

struct _GtkMicroBContextClass
{
  GObjectClass parent_class;
};

MICROBEAL_API(GType,             gtk_microb_context_get_type,           (void))
MICROBEAL_API(GtkMicroBContext*, gtk_microb_context_new,                (void))
/* Suggest data "mozembed" pointer on GtkMozEmbed widget */
MICROBEAL_API(gboolean,          gtk_microb_context_set_prop,           (GtkMicroBContext *ctx, const char *name, GValue *value))
MICROBEAL_API(const GValue*,     gtk_microb_context_get_prop,           (GtkMicroBContext *ctx, const char *name))
/* Possible context props:
"image" - Image src
"link"  - <a> href
"docuri"- URI of context document
*/
MICROBEAL_API(gboolean,       gtk_microb_context_update_from_event,  (GtkMicroBContext *ctx, gpointer event))
MICROBEAL_API(gboolean,       gtk_microb_context_update_from_element,(GtkMicroBContext *ctx, gpointer aDOMNSElement))
MICROBEAL_API(gpointer,       gtk_microb_context_get_node,           (GtkMicroBContext *ctx))
MICROBEAL_API(gpointer,       gtk_microb_context_get_original_node,  (GtkMicroBContext *ctx))
MICROBEAL_API(gboolean,       gtk_microb_context_get_text,           (GtkMicroBContext *ctx, gchar **text, gint *position))
MICROBEAL_API(gboolean,       gtk_microb_context_insert_text,        (GtkMicroBContext *ctx, const gchar *string, gpointer node, gint surr1, gint surr2))
MICROBEAL_API(gboolean,       gtk_microb_context_update_scrollable,  (GtkMicroBContext *ctx))
MICROBEAL_API(gboolean,       gtk_microb_context_scroll_scrollable,  (GtkMicroBContext *ctx, int adx, int ady))
MICROBEAL_API(int,            gtk_microb_context_get_scrollable_type,(GtkMicroBContext *ctx))
MICROBEAL_API(gboolean,       gtk_microb_context_do_handle_event_with_target, (GtkMicroBContext *ctx, gpointer node))

typedef enum
{
  GTK_MICROB_EAL_CONTEXT_NONE       = 0,
  GTK_MICROB_EAL_CONTEXT_XUL        = 1 << 0,
  GTK_MICROB_EAL_CONTEXT_DOCUMENT   = 1 << 1,
  GTK_MICROB_EAL_CONTEXT_LINK       = 1 << 2,
  GTK_MICROB_EAL_CONTEXT_MAILTO     = 1 << 3,
  GTK_MICROB_EAL_CONTEXT_IMAGE      = 1 << 4,
  GTK_MICROB_EAL_CONTEXT_IFRAME     = 1 << 5,
  GTK_MICROB_EAL_CONTEXT_INPUT_TEXT = 1 << 6,
  GTK_MICROB_EAL_CONTEXT_IPASSWORD  = 1 << 7,
  GTK_MICROB_EAL_CONTEXT_RICHEDIT   = 1 << 8,
  GTK_MICROB_EAL_CONTEXT_MULTILINE  = 1 << 9,
  GTK_MICROB_EAL_CONTEXT_SELECT     = 1 << 10,
  GTK_MICROB_EAL_CONTEXT_EMBED      = 1 << 11,
  GTK_MICROB_EAL_CONTEXT_FORM       = 1 << 12
} GtkMicroBContextFlags;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* microb_eal_context_h */

