/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __MICROBEALNOTIFICATION_H__
#define __MICROBEALNOTIFICATION_H__

#include "nsINotificationBox.h"
#include "MicrobEalNotificationButton.h"
#include <nsCOMArray.h>
#include "nsStringAPI.h"

#define NOTIFICATION_CONTRACTID "@browser.garage.maemo.org/microb/notification;1"
#define NOTIFICATION_CLASSNAME "MicroB Notification"
//bb6bc85e-dda7-458d-836c-7549c92a6914
#define NOTIFICATION_CID  { 0xbb6bc85e, 0xdda7, 0x458d, { 0x83, 0x6c, 0x75, 0x49, 0xc9, 0x2a, 0x69, 0x14 } }

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "gmozillaengine.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* Header file */
class MicrobEalNotification : public nsINotification
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSINOTIFICATION

  MicrobEalNotification();
  nsresult AddButtons(nsIArray *aButtons);
  nsresult AddToUi();
  nsresult RemoveFromUi();
  nsresult ButtonPressed(MicrobEalNotificationButton *aButton);

  nsresult SetEngine(GMozillaEngine *aEngine);
  nsresult GetEngine(GMozillaEngine **aEngine);

private:
  ~MicrobEalNotification();

  PRInt32 mPersistence;
  nsString mValue;
  nsString mLabel;
  PRUint32 mButtonCount;
  GMozillaEngine *mEngine;
  gpointer mNotificationWidget;

  nsresult AddButton(MicrobEalNotificationButton *aButton);

  nsCOMArray<MicrobEalNotificationButton> mButtons;

protected:
  // None
};

#endif // __MICROBEALNOTIFICATION_H__
