/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLATRANSFERITEM_H__
#define __GMOZILLATRANSFERITEM_H__

#include <gwebtransferitem.h>
#include <gtk/gtk.h>

#ifdef __cplusplus /* If this is a C++ compiler, use C linkage */
extern "C" {
#endif

G_BEGIN_DECLS

#define G_TYPE_MOZILLA_TRANSFER_ITEM             (g_mozilla_transfer_item_get_type ())
#define G_MOZILLA_TRANSFER_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItem))
#define G_MOZILLA_TRANSFER_ITEM_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItemClass))
#define G_IS_MOZILLA_TRANSFER_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM))
#define G_IS_MOZILLA_TRANSFER_ITEM_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM))
#define G_MOZILLA_TRANSFER_ITEM_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItemClass))

typedef struct _GMozillaTransferItem GMozillaTransferItem;
typedef struct _GMozillaTransferItemClass GMozillaTransferItemClass;

/** @struct GMozillaTransferItem.
  * Defines a Mozilla Transfer Item.
  */
struct _GMozillaTransferItem
{
    GObject parent;                     /** < Object parent */
    GObject* item;                      /** < Object item */
    void* data;

    gchar*      file_name;             /** < The file's name */
    const char* server;                /** < The server's name */
    int         download_id;

    guint progress_timer_id;
    char*       file_name_with_path;   /** < The file's name */
    const char* file_type;             /** < The file's type */
    const char* handler_app;           /** < The application's name */
    gulong      file_size;             /** < The file's size */
    glong       downloaded_size;       /** < The download's size */
    gboolean    is_paused;             /** < If download is paused or not */
};

struct _GMozillaTransferItemClass
{
    GObjectClass parent;

    void (*started) (GMozillaTransferItem* item);
    void (*completed) (GMozillaTransferItem* item);
    void (*error) (GMozillaTransferItem* item);
    void (*aborted) (GMozillaTransferItem* item);
    void (*progress) (GMozillaTransferItem* item, gulong , gulong , gulong );
};

typedef enum
{
  GMOZILLA_DOWNLOAD_RESUME,
  GMOZILLA_DOWNLOAD_CANCEL,
  GMOZILLA_DOWNLOAD_PAUSE,
  GMOZILLA_DOWNLOAD_RELOAD,
  GMOZILLA_DOWNLOAD_STORE,
  GMOZILLA_DOWNLOAD_RESTORE
} GMozillaDownloadActions;

/** < This structure will be used to registry the signals in the mozilla engine */

GType g_mozilla_transfer_item_get_type (void);

/** Creates a new transfer item's instance
  * @return A transfer item.
  */
GObject* g_mozilla_transfer_item_new (void);

/** Creates a new transfer item's instance with a item passed as a parameter
  * @param item A transfer item.
  * @return A transfer item. 
  */
GObject* g_mozilla_transfer_item_new_with_item (GObject *item);

/** Creates a new transfer item's instance with the URL passed as a parameter
  * @param url An URL.
  * @param filename The file's name.
  * @return A transfer item. 
  */
GObject* g_mozilla_transfer_item_new_with_url  (const gchar *url, const gchar *filename);

/**
  *
  */
void g_mozilla_transfer_item_start_download (gchar **file_name_with_path);

/**
  *
  */
void g_mozilla_transfer_item_error_download (void);

/**
  *
  */
void g_mozilla_transfer_item_aborted_download (void);

/**
  *
  */
void g_mozilla_transfer_item_completed_download (void);

/**
  *
  */
void g_mozilla_transfer_item_progress_download (glong current, glong total, glong mode);

/** Holds the instance of GMozillaWeb object
  * @param webglobal The GMozillaWeb object itself
  * @return nothing
  */
void g_mozilla_transfer_item_set_webglobal (GObject *webglobal);

/** Initializes a progress timeout aiming to detect internet/connection problems during downloading
  * @param transferitem Transfer item itseft
  * @return nothing
  */
void init_progress_timeout (GMozillaTransferItem *transferitem);

/**
  *
  */
gboolean g_mozilla_transfer_item_get_restart_flag (void);

/**
  *
  */
void g_mozilla_transfer_item_set_restart_flag (gboolean restart_flag);

/**
  *
  */
GObject* g_mozilla_transfer_item_get_latest_object (void);

/**
  *
  */
void g_mozilla_transfer_item_set_latest_object(GObject* latest_object);


G_END_DECLS

#ifdef __cplusplus /* If this is a C++ compiler, end C linkage */
}
#endif

#endif /* __GMOZILLATRANSFERITEM_H__ */
