/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __NSTOUCHINTERACTLISTENER_H__
#define __NSTOUCHINTERACTLISTENER_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef USE_WIDGETUTILS
#include "nsITouchInteractListener.h"
#else
#include "nsITouchInteractListenerL.h"
#endif
#include <nsIGenericFactory.h>

#define TOUCHINTERACTLISTENER_CONTRACTID "@browser.garage.maemo.org/microb/touchinteractlistener;1"
#define TOUCHINTERACTLISTENER_CLASSNAME "MicroB Touch Interact Listener"
//6844bc28-6e72-49eb-a984-f74977410532
#define TOUCHINTERACTLISTENER_CID  { 0x6844bc28, 0x6e72, 0x49eb, { 0xa9, 0x84, 0xf7, 0x49, 0x77, 0x41, 0x05, 0x32 } }

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "gmozillaengine.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* Header file */
class nsTouchInteractListener : public nsITouchInteractListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITOUCHINTERACTLISTENER

  static nsTouchInteractListener* GetInstance();
  static void DeleteInstance();

private:
  nsTouchInteractListener();
  virtual ~nsTouchInteractListener();

private:
  static nsTouchInteractListener* sTouchInteractListener;
  static GtkMozEmbed* GetGtkMozEmbedFromWidget(nsIWidget *aWidget);
  static GMozillaEngine* GetGMozillaEngine(GtkMozEmbed* aGtkMozEmbed);

protected:
  /* additional members */
};

#endif //#ifndef __NSTOUCHINTERACTLISTENER_H__
