/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSHistoryThumbnailManager.h"
#include "nsSHistoryThumbnailManager_contractid.h"
#include <nsISHistory.h>
#include <nsIWindowWatcher.h>
#include <nsIDOMWindow.h>
#include <nsIDOMDocument.h>
#include <nsIDOMHTMLCanvasElement.h>
#include <nsIDOMWindowInternal.h>
#include <nsICanvasRenderingContextInternal.h>
#include <nsIDOMCanvasRenderingContext2D.h>
#include <nsIComponentManager.h>
#include <plbase64.h>
#include <nsServiceManagerUtils.h>
#include <nsILocalFile.h>
#include <nsIFileStreams.h>
#include <prmem.h>
#include <prsystem.h>
#include <nsIWebBrowser.h>
#include <nsIWebBrowserChrome.h>
#include <nsIWebNavigation.h>
#include <nsComponentManagerUtils.h>
#include <nsIDOMEventTarget.h>
#include <nsPIDOMWindow.h>
#include <nsCOMArray.h>
#include <nsISimpleEnumerator.h>
#include <nsIHistoryEntry.h>
#include <nsIDOMEvent.h>
#include <nsIRequest.h>
#include "gwebengine.h"
#include "gmozillahistorylist.h"
#include "MicrobEalUtils.h"

#include <stdio.h>
#include "common.h"

#define SCROLL_EVENT_TYPE "scroll"

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsThumbnailProvider, nsIThumbnailProvider)
NS_IMPL_ISUPPORTS2(HistoryListener, nsISHistoryListener, nsSupportsWeakReference)

nsThumbnailProvider::nsThumbnailProvider()
{

}

nsThumbnailProvider::~nsThumbnailProvider()
{

}


NS_IMETHODIMP
nsThumbnailProvider::CreateThumbnailFromActiveWindow(const nsACString & aFileName,
                                                     PRInt32 aWidth,
                                                     PRInt32 aHeight)
{
#if 0
  nsCOMPtr<nsIWindowWatcher> wwatch =
    do_GetService(NS_WINDOWWATCHER_CONTRACTID);
  NS_ENSURE_TRUE(wwatch, NS_ERROR_NULL_POINTER);
  nsCOMPtr<nsIDOMWindow> DOMWindow;
  nsresult rv = wwatch->GetActiveWindow(getter_AddRefs(DOMWindow));
  NS_ENSURE_SUCCESS(rv, rv);
  rv = CreateThumbnail(DOMWindow, aFileName, aWidth, aHeight);

  return rv;
#endif
  return NS_ERROR_NOT_AVAILABLE;
}


NS_IMETHODIMP
nsThumbnailProvider::CreateThumbnail(nsIDOMWindow *aDOMWindow,
                                     const nsACString & aFileName,
                                     PRInt32 aWidth,
                                     PRInt32 aHeight)
{
#if 0
  NS_ENSURE_ARG(aDOMWindow);

  nsCOMPtr<nsIDOMDocument> DOMDocument;
  aDOMWindow->GetDocument(getter_AddRefs(DOMDocument));
  NS_ENSURE_TRUE(DOMDocument, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIDOMElement> element;
  nsresult rv = DOMDocument->CreateElement(NS_LITERAL_STRING("canvas"),
                                           getter_AddRefs(element));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIDOMHTMLCanvasElement> canvas =
    do_QueryInterface(element, &rv);
  NS_ENSURE_TRUE(canvas, NS_ERROR_NULL_POINTER);
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIDOMWindowInternal> DOMWindowInternal =
    do_QueryInterface(aDOMWindow, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(DOMWindowInternal, NS_ERROR_NULL_POINTER);

  PRInt32 WindowWidth(0);
  rv = DOMWindowInternal->GetInnerWidth(&WindowWidth);
  NS_ENSURE_SUCCESS(rv, rv);
  PRInt32 WindowHeight(0);
  rv = DOMWindowInternal->GetInnerHeight(&WindowHeight);
  NS_ENSURE_SUCCESS(rv, rv);

  rv = canvas->SetWidth(aWidth);
  NS_ENSURE_SUCCESS(rv, rv);
  rv = canvas->SetHeight(aHeight);
  NS_ENSURE_SUCCESS(rv, rv);

  /* There seems to be problems to get Context2D.
     This works only if we get Context2D first to ContextInternal and
     then Query Context2D interface from ContextInternal */
  nsCOMPtr<nsICanvasRenderingContextInternal> ctx;
  rv = canvas->GetContext(NS_LITERAL_STRING("2d"),
                          getter_AddRefs(ctx));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIDOMCanvasRenderingContext2D> ctx2d =
    do_QueryInterface(ctx, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(ctx2d, NS_ERROR_NULL_POINTER);

  const float scaleX(float(aWidth) / float(WindowWidth));
  const float scaleY(float(aHeight) / float(WindowHeight));
  rv = ctx2d->Scale(scaleX, scaleY);
  NS_ENSURE_SUCCESS(rv, rv);

  PRInt32 scrollPosition = 0;
  aDOMWindow->GetScrollY(&scrollPosition);
  rv = ctx2d->DrawWindow(aDOMWindow,
                         0,
                         scrollPosition,
                         WindowWidth,
                         WindowHeight,
                         NS_LITERAL_STRING("rgb(255,255,255)"), PR_TRUE);
  NS_ENSURE_SUCCESS(rv, rv);

  nsAutoString data;
  rv = canvas->ToDataURLAs(NS_LITERAL_STRING("image/png"),
                           NS_LITERAL_STRING(""),
                           data);
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIComponentManager> compMgr;
  rv = NS_GetComponentManager(getter_AddRefs(compMgr));
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(compMgr, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsILocalFile> localFile;
  rv = compMgr->CreateInstanceByContractID(NS_LOCAL_FILE_CONTRACTID,
                                           NULL,
                                           NS_GET_IID(nsILocalFile),
                                           getter_AddRefs(localFile));
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(localFile, NS_ERROR_NULL_POINTER);

  rv = localFile->InitWithNativePath(aFileName);
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIFileOutputStream> fileOutputStream;
  rv = compMgr->CreateInstanceByContractID(
      "@mozilla.org/network/file-output-stream;1",
      nsnull,
      NS_GET_IID(nsIFileOutputStream),
      getter_AddRefs(fileOutputStream));
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(fileOutputStream, NS_ERROR_NULL_POINTER);

  rv = fileOutputStream->Init(localFile,
                              (PR_WRONLY | PR_CREATE_FILE | PR_TRUNCATE),
                              0644, 0);
  NS_ENSURE_SUCCESS(rv, rv);

  /* We need remove additional data from buffer begin */
  PRInt32 pos = data.Find(NS_LITERAL_STRING(","));
  const PRInt32 dataBegin(pos+1);
  if (dataBegin > (PRInt32) data.Length()) {
    return NS_ERROR_ILLEGAL_VALUE;
  }
  data.Cut(0, dataBegin);

  PRInt32 dataLen = data.Length();
  char* decodedImg = PL_Base64Decode(NS_ConvertUTF16toUTF8(data).get(),
                                     dataLen,
                                     nsnull);
  NS_ENSURE_TRUE(decodedImg, NS_ERROR_NULL_POINTER);

  // Base64 maps 3 binary bytes to 4 ASCII bytes.
  // See comments in plbase64.h.
  PRInt32 resultLen = dataLen;
  if (!data.IsEmpty() && data[dataLen - 1] == '=') {
    if (dataLen > 1 && data[dataLen - 2] == '=') {
      resultLen = dataLen - 2;
    } else {
      resultLen = dataLen - 1;
    }
  }
  resultLen = (resultLen * 3) / 4;

  PRUint32 writeCount = 0;
  rv = fileOutputStream->Write(decodedImg, resultLen, &writeCount);
  PR_Free(decodedImg);
  NS_ENSURE_SUCCESS(rv, rv);
  rv = fileOutputStream->Close();
  return rv;
#endif
  return NS_ERROR_NOT_AVAILABLE;
}

NS_IMPL_ISUPPORTS4(nsSHistoryThumbnailManager, \
                   nsISHistoryThumbnailManager, \
                   nsISHistoryListener, \
                   nsIWebProgressListener, \
                   nsSupportsWeakReference)

nsSHistoryThumbnailManager::nsSHistoryThumbnailManager()
: mWidth(0),
  mHeight(0),
  mNewURI(nsnull),
  mHistoryListener(0),
  mRedirecting(PR_FALSE)
{
  mRedirectedUri.SetIsVoid(PR_TRUE);
}

nsresult nsSHistoryThumbnailManager::Init()
{
  nsresult rv = NS_OK;
  mThumbnailProvider = do_CreateInstance(THUMBNAILPROVIDER_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(mThumbnailProvider, NS_ERROR_NULL_POINTER);

  return rv;
}

nsSHistoryThumbnailManager::~nsSHistoryThumbnailManager()
{
  Stop();
}

nsresult
nsSHistoryThumbnailManager::GetThumbnailFolder(nsILocalFile** aFolder)
{
#if 0
  nsresult rv;
  nsCOMPtr<nsILocalFile> localFile =
    do_CreateInstance(NS_LOCAL_FILE_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(localFile, NS_ERROR_NULL_POINTER);
  rv = localFile->InitWithNativePath(mThumbnailFolder);
  NS_ENSURE_SUCCESS(rv, rv);
  *aFolder = localFile;
  NS_ADDREF(*aFolder);

  return rv;
#endif
  return NS_ERROR_NOT_AVAILABLE;
}

nsresult
nsSHistoryThumbnailManager::RemoveDataFiles()
{
#if 0
  nsCOMPtr<nsILocalFile> folder;
  nsresult rv = GetThumbnailFolder(getter_AddRefs(folder));
  NS_ENSURE_SUCCESS(rv, rv);
  rv = folder->Remove(PR_TRUE);
  return rv;
#endif
  return NS_ERROR_NOT_AVAILABLE;
}

nsresult
nsSHistoryThumbnailManager::GetSessionHistory(nsIDOMWindow* aDOMWindow,
                                              nsISHistory** aSessionHistory)
{
  NS_ENSURE_TRUE(aDOMWindow, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWindowWatcher> wwatch =
    do_GetService("@mozilla.org/embedcomp/window-watcher;1");
  NS_ENSURE_TRUE(wwatch, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWebBrowserChrome> chrome;
  wwatch->GetChromeForWindow(aDOMWindow, getter_AddRefs(chrome));
  NS_ENSURE_TRUE(chrome, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWebBrowser> webBrowser;
  chrome->GetWebBrowser(getter_AddRefs(webBrowser));
  NS_ENSURE_TRUE(webBrowser, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWebNavigation> navigation = do_QueryInterface(webBrowser);
  NS_ENSURE_TRUE(navigation, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsISHistory> sessionHistory;
  nsresult rv = navigation->GetSessionHistory(getter_AddRefs(sessionHistory));
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE (sessionHistory, NS_ERROR_NULL_POINTER);

  *aSessionHistory = sessionHistory;
  NS_ADDREF(*aSessionHistory);
  return rv;
}

nsresult
nsSHistoryThumbnailManager::GetWindowEventTarget(nsIDOMEventTarget** aEventTarget)
{
  NS_ENSURE_TRUE(aEventTarget, NS_ERROR_NULL_POINTER);
  *aEventTarget = nsnull;
  NS_ENSURE_TRUE(mDOMWindow, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsPIDOMWindow> privateDOMWindow(do_QueryInterface(mDOMWindow));
  NS_ENSURE_TRUE(privateDOMWindow, NS_ERROR_NULL_POINTER);

  nsPIDOMEventTarget *chromeEventHandler =
    privateDOMWindow->GetChromeEventHandler();
  NS_ENSURE_TRUE(chromeEventHandler, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIDOMEventTarget> eventTarget(
    do_QueryInterface(chromeEventHandler));
  NS_ENSURE_TRUE(eventTarget, NS_ERROR_NULL_POINTER);

  *aEventTarget = eventTarget;
  NS_ADDREF(*aEventTarget);
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::Start(nsIDOMWindow *aDOMWindow,
                                  const nsACString & aThumbnailFolder,
                                  PRInt32 aWidth,
                                  PRInt32 aHeight)
{
  Stop();

  NS_ENSURE_ARG(aDOMWindow);

#if 0
  mWidth = aWidth;
  mHeight = aHeight;
  mThumbnailFolder.Assign(aThumbnailFolder);
  nsCOMPtr<nsILocalFile> folder;
  nsresult rv = GetThumbnailFolder(getter_AddRefs(folder));
  NS_ENSURE_SUCCESS(rv, rv);

  rv = folder->Create(nsIFile::DIRECTORY_TYPE, 0700);
  if (NS_FAILED(rv) &&
      rv != NS_ERROR_FILE_ALREADY_EXISTS) {
    return rv;
  }
#endif

  nsCOMPtr<nsIWindowWatcher> wwatch =
    do_GetService("@mozilla.org/embedcomp/window-watcher;1");
  NS_ENSURE_TRUE(wwatch, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWebBrowserChrome> chrome;
  wwatch->GetChromeForWindow(aDOMWindow, getter_AddRefs(chrome));
  NS_ENSURE_TRUE(chrome, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsIWebBrowser> webBrowser;
  chrome->GetWebBrowser(getter_AddRefs(webBrowser));
  NS_ENSURE_TRUE(webBrowser, NS_ERROR_NULL_POINTER);

  nsCOMPtr<nsISupportsWeakReference> supportsWeak;
  supportsWeak = do_QueryInterface(
      static_cast<nsSupportsWeakReference*>(this));
  nsCOMPtr<nsIWeakReference> weakRef;
  supportsWeak->GetWeakReference(getter_AddRefs(weakRef));
  nsresult rv = webBrowser->AddWebBrowserListener(
      weakRef, NS_GET_IID(nsISHistoryListener));
  NS_ENSURE_SUCCESS(rv, rv);
  rv = webBrowser->AddWebBrowserListener(
      weakRef, NS_GET_IID(nsIWebProgressListener));
  NS_ENSURE_SUCCESS(rv, rv);

  mHistoryListener = new HistoryListener();
  GMozillaEngine* moz_engine = GetGMozEngineForDOMWindow(aDOMWindow);
  mHistoryListener->SetEngine(moz_engine);

  return rv;

}

void
nsSHistoryThumbnailManager::ClearThumbnailContainer()
{
#if 0
  const PRInt32 count = mThumbnailContainer.Count();
  for (PRInt32 i = 0 ; i < count ; ++i) {
    SHistoryThumbnailItem* item = static_cast<SHistoryThumbnailItem*>(
        mThumbnailContainer.FastElementAt(i));
    delete item;
  }
  mThumbnailContainer.Clear();
#endif
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::Stop()
{
#if 0
  RemoveDataFiles();
  mThumbnailFolder.Truncate();

  ClearThumbnailContainer();
#endif

  nsCOMPtr<nsISHistory> sessionHistory;
  nsresult rv = nsSHistoryThumbnailManager::GetSessionHistory(
      mDOMWindow,
      getter_AddRefs(sessionHistory));

  if (NS_SUCCEEDED(rv)) {
    rv = sessionHistory->RemoveSHistoryListener(
        static_cast<nsISHistoryListener*>(this));
  }

  if (mHistoryListener) {
    delete mHistoryListener;
    mHistoryListener = 0;
  }

  NS_IF_RELEASE(mNewURI);
  mNewURI = nsnull;

  return rv;
}

nsSHistoryThumbnailManager::SHistoryThumbnailItem*
nsSHistoryThumbnailManager::SHistoryItemByUri(nsACString &aURI)
{
#if 0
  const PRInt32 count = mThumbnailContainer.Count();
  for (PRInt32 i = 0 ; i < count ; ++i) {
    SHistoryThumbnailItem* item = static_cast<SHistoryThumbnailItem*>(
        mThumbnailContainer.FastElementAt(i));
    if (*(item->mUri) == aURI) {
      return item;
    }
  }
#endif
  return nsnull;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::GetThumbnailByUri(nsIURI *aURI,
                                              PRBool *aIsThumbnail NS_OUTPARAM,
                                              nsACString & aThumbnail NS_OUTPARAM)
{
#if 0
  NS_ENSURE_ARG(aURI);
  NS_ENSURE_ARG(aIsThumbnail);

  *aIsThumbnail = PR_FALSE;
  nsCAutoString uri;
  nsresult rv = aURI->GetSpec(uri);
  NS_ENSURE_SUCCESS(rv, rv);

  SHistoryThumbnailItem* item = SHistoryItemByUri(uri);
  if (!item) {
    // Create thumbnail for pending uri, the page may not have fully loaded
    doCreateThumbnail();
    item = SHistoryItemByUri(uri);
  }

  if (item && item->mThumbnailFileName) {
    aThumbnail.Assign(*(item->mThumbnailFileName));
    *aIsThumbnail = PR_TRUE;
  }
  return rv;
#endif
  return NS_ERROR_NOT_AVAILABLE;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryNewEntry(nsIURI *aNewURI)
{
  if (mHistoryListener) mHistoryListener->OnHistoryNewEntry(aNewURI);
#if 0
  // create thumbnail for pending uri
  doCreateThumbnail();

  /* We can't create thumbnail yet, because dom model is not updated.
   * Store uri and create thumbnail when whole page is load.*/
  NS_IF_RELEASE(mNewURI);
  mNewURI = aNewURI;
  NS_IF_ADDREF(mNewURI);
#endif
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryGoBack(nsIURI *aBackURI,
                                            PRBool *_retval NS_OUTPARAM)
{
  if (mHistoryListener) mHistoryListener->OnHistoryGoBack(aBackURI, _retval);
  NS_IF_RELEASE(mNewURI);
  mNewURI = aBackURI;
  NS_IF_ADDREF(mNewURI);
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryGoForward(nsIURI *aForwardURI,
                                               PRBool *_retval NS_OUTPARAM)
{
  if (mHistoryListener) mHistoryListener->OnHistoryGoForward(aForwardURI, _retval);
  NS_IF_RELEASE(mNewURI);
  mNewURI = aForwardURI;
  NS_IF_ADDREF(mNewURI);
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryReload(nsIURI *aReloadURI,
                                            PRUint32 aReloadFlags,
                                            PRBool *_retval NS_OUTPARAM)
{
  if (mHistoryListener) mHistoryListener->OnHistoryReload(aReloadURI, aReloadFlags, _retval);
  NS_IF_RELEASE(mNewURI);
  mNewURI = aReloadURI;
  NS_IF_ADDREF(mNewURI);
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryGotoIndex(PRInt32 aIndex,
                                               nsIURI *aGotoURI,
                                               PRBool *_retval NS_OUTPARAM)
{
  if (mHistoryListener) mHistoryListener->OnHistoryGotoIndex(aIndex, aGotoURI, _retval);
  NS_IF_RELEASE(mNewURI);
  mNewURI = aGotoURI;
  NS_IF_ADDREF(mNewURI);
  return NS_OK;
}

PRBool FindUrl(const nsACString& aUrl, const nsCOMArray<nsIURI>& aUriArray)
{
#if 0
  const PRInt32 count = aUriArray.Count();
  for (PRInt32 i = 0 ; i < count ; ++i) {
    nsCAutoString uri;
    aUriArray.ObjectAt(i)->GetSpec(uri);
    if (aUrl == uri) {
      return PR_TRUE;
    }
  }
#endif
  return PR_FALSE;
}

nsresult RemoveFile(const nsACString& aFile)
{
  nsresult rv = NS_OK;
#if 0
  nsCOMPtr<nsILocalFile> localFile =
    do_CreateInstance(NS_LOCAL_FILE_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(localFile, NS_ERROR_NULL_POINTER);
  rv = localFile->InitWithNativePath(aFile);
  NS_ENSURE_SUCCESS(rv, rv);
  rv = localFile->Remove(PR_TRUE);
#endif
  return rv;
}

nsresult GetSHistoryUriArray(nsCOMArray<nsIURI>& aUriArray,
                             nsISimpleEnumerator* aSHistoryEnumerator)
{
  nsresult rv = NS_OK;
#if 0
  nsCOMPtr<nsISupports> element;
  while (NS_OK == aSHistoryEnumerator->GetNext(getter_AddRefs(element))) {
    nsCOMPtr<nsIHistoryEntry> historyEntry = do_QueryInterface(element);
    NS_ENSURE_TRUE(historyEntry, NS_ERROR_NULL_POINTER);
    nsCOMPtr<nsIURI> uri;
    rv = historyEntry->GetURI(getter_AddRefs(uri));
    NS_ENSURE_SUCCESS(rv, rv);
    PRBool ret = aUriArray.AppendObject(uri);
    NS_ENSURE_TRUE(ret, NS_ERROR_OUT_OF_MEMORY);
  }
#endif
  return rv;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnHistoryPurge(PRInt32 aNumEntries,
                                           PRBool *_retval NS_OUTPARAM)
{
  *_retval = PR_TRUE;
  if (mHistoryListener) mHistoryListener->OnHistoryPurge(aNumEntries, _retval);
  NS_ENSURE_TRUE(mDOMWindow, NS_OK);

#if 0
  nsCOMPtr<nsISHistory> sessionHistory;
  nsresult rv = nsSHistoryThumbnailManager::GetSessionHistory(
      mDOMWindow,
      getter_AddRefs(sessionHistory));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsISimpleEnumerator> historyEnum;
  rv = sessionHistory->GetSHistoryEnumerator(getter_AddRefs(historyEnum));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMArray<nsIURI> uriArray;
  rv = GetSHistoryUriArray(
      uriArray,
      historyEnum);
  NS_ENSURE_SUCCESS(rv, rv);

  /*Remove useless thumbnails from file system*/
  for (PRInt32 i = 0 ; i < mThumbnailContainer.Count() ; ++i) {
    SHistoryThumbnailItem* item = static_cast<SHistoryThumbnailItem*>(
        mThumbnailContainer.FastElementAt(i));
    PRBool ret = FindUrl(*(item->mUri), uriArray);
    if (!ret) {
      nsresult removeFileRv = RemoveFile(*(item->mThumbnailFileName));
      if (NS_SUCCEEDED(removeFileRv) &&
          mThumbnailContainer.RemoveElementAt(i)) {
        delete item;
        --i;
      }
    }
  }
#endif

  return NS_OK;
}

static void
myLL_L2II(PRInt64 result, PRInt32 *hi, PRInt32 *lo)
{
#if 0
  PRInt64 a64, b64;
  LL_SHR(a64, result, 32);
  LL_L2I(*hi, a64);

  LL_SHL(b64, result, 32);
  LL_SHR(a64, b64, 32);
  LL_L2I(*lo, a64);
#endif
}

nsresult
nsSHistoryThumbnailManager::doCreateThumbnail()
{
#if 0
  NS_ENSURE_TRUE(mNewURI || !mRedirectedUri.IsVoid(), NS_OK);

  nsresult rv = NS_ERROR_OUT_OF_MEMORY;
  nsCString* uri = new nsCString();
  if (mNewURI)
  {
    if (uri) {
      rv = mNewURI->GetSpec(*uri);
    }
    NS_ENSURE_SUCCESS(rv, rv);
  }
  else
  {
    *uri = mRedirectedUri;
  }
  mRedirectedUri.SetIsVoid(PR_TRUE); 


  nsCString* thumbnailFileName = new nsCString();
  if (!thumbnailFileName)
  {
    delete uri;
    return NS_ERROR_OUT_OF_MEMORY;
  }

  thumbnailFileName->Append(mThumbnailFolder);
  thumbnailFileName->Append(PR_GetDirectorySeparator());
  thumbnailFileName->Append("thumbnail-");
  PRTime time = PR_Now();
  PRInt32 hi = 0;
  PRInt32 lo = 0;
  myLL_L2II(time, &hi, &lo);
  thumbnailFileName->AppendInt(hi);
  thumbnailFileName->AppendInt(lo);
  thumbnailFileName->Append(".png");

  rv = mThumbnailProvider->CreateThumbnail(
      mDOMWindow,
      *thumbnailFileName,
      mWidth, mHeight);
  if (NS_FAILED(rv)) {
    delete uri;
    delete thumbnailFileName;
    return rv;
  }

  SHistoryThumbnailItem* item;

  if ((item = SHistoryItemByUri(*uri)))
  {
    // URI has already a history item
    RemoveFile(*(item->mThumbnailFileName));
    delete item->mThumbnailFileName;
    delete item->mUri;
    mThumbnailContainer.RemoveElement(item);
  }

  item = new SHistoryThumbnailItem(uri, thumbnailFileName);
  if (!item) {
    delete uri;
    delete thumbnailFileName;
    return NS_ERROR_OUT_OF_MEMORY;
  }

  PRBool ret = mThumbnailContainer.AppendElement(item);
  if (!ret) {
    delete item;
    return NS_ERROR_OUT_OF_MEMORY;
  }
#endif
  return NS_OK;
}


NS_IMETHODIMP
nsSHistoryThumbnailManager::OnStateChange(nsIWebProgress *aWebProgress,
                                          nsIRequest *aRequest,
                                          PRUint32 aStateFlags,
                                          nsresult aStatus)
{
#if 0 
  if ((aStateFlags & STATE_IS_NETWORK) && (aStateFlags & STATE_STOP)) {
    // No more redirections and loading etc. -> create thumbnail
    // ignore errors
    doCreateThumbnail();
  }
  else if (mRedirecting && (aStateFlags & STATE_START))
  {
    // Loading a redirected page has started, get the URI
    if (aRequest)
    {
      nsCString name;
      aRequest->GetName(name);

      if (!name.IsEmpty())
      {
        NS_IF_RELEASE(mNewURI);
        mNewURI = nsnull;

        mRedirectedUri.Assign(name);
      }
    }
    mRedirecting = PR_FALSE;
  }

  if ((aStateFlags & (STATE_REDIRECTING | STATE_IS_REQUEST | STATE_IS_DOCUMENT) ) == (STATE_REDIRECTING | STATE_IS_REQUEST | STATE_IS_DOCUMENT))
  {
    // A redirect request
    mRedirecting = PR_TRUE;
  }
#endif
 
  return NS_OK;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnProgressChange(nsIWebProgress *aWebProgress,
                                             nsIRequest *aRequest,
                                             PRInt32 aCurSelfProgress,
                                             PRInt32 aMaxSelfProgress,
                                             PRInt32 aCurTotalProgress,
                                             PRInt32 aMaxTotalProgress)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnLocationChange(nsIWebProgress *aWebProgress,
                                             nsIRequest *aRequest,
                                             nsIURI *aLocation)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnStatusChange(nsIWebProgress *aWebProgress,
                                           nsIRequest *aRequest,
                                           nsresult aStatus,
                                           const PRUnichar *aMessage)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
nsSHistoryThumbnailManager::OnSecurityChange(nsIWebProgress *aWebProgress,
                                             nsIRequest *aRequest,
                                             PRUint32 aState)
{
  return NS_ERROR_NOT_IMPLEMENTED;
}

GWebEngineEncoding HistoryListener::GetEncoding()
{
  GMozillaEngine* engine = mEngine ? mEngine : GetGMozEngineForDOMWindow(nsnull);
  NS_ENSURE_TRUE(engine, G_WEBENGINE_ENCODING_AUTOMATIC);

  GtkMozEmbed *embed = GTK_MOZ_EMBED(engine->engine);
  NS_ENSURE_TRUE(embed, G_WEBENGINE_ENCODING_AUTOMATIC);

  return g_mozilla_engine_get_encoding(embed);
}

NS_IMETHODIMP
HistoryListener::OnHistoryNewEntry(nsIURI *aNewURI)
{
  NS_ENSURE_ARG(mEngine);

  nsCAutoString newUrl;
  aNewURI->GetSpec(newUrl);
  bool hashUrl = newUrl.RFindChar('#') >= 0;
  int flag = !hashUrl;

  if (mURI)
  {
    nsCAutoString oldUrl;
    mURI->GetSpec(oldUrl);

    if (newUrl.Equals(oldUrl))
      flag = 0;

    if (mEngine->mMinWindowSize.width || mEngine->mMinWindowSize.height) {
      nsCAutoString newPre;
      nsCAutoString oldPre;
      mURI->GetPrePath(oldPre);
      aNewURI->GetPrePath(newPre);
      ULOG("FrameEXP state: minSize:%i,%i, PrePathEq:%i, hashUrl:%i",
            mEngine->mMinWindowSize.width, mEngine->mMinWindowSize.height, oldPre.Equals(newPre), hashUrl);
      if (!(oldPre.Equals(newPre) && hashUrl)) {
        mEngine->mMinWindowSize.width = 0;
        mEngine->mMinWindowSize.height = 0;
      }
    }
  }
  if (aNewURI)
    aNewURI->Clone(getter_AddRefs(mURI));

  send_history_message(mEngine, G_WEBENGINE_HISTORY_NEW_ENTRY, flag, GetEncoding());
  return NS_OK;
}

NS_IMETHODIMP
HistoryListener::OnHistoryGoBack(nsIURI *aBackURI, PRBool *_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(mEngine);
  send_history_message(mEngine, G_WEBENGINE_HISTORY_GO_BACK, 0, GetEncoding());
  return NS_OK;
}

NS_IMETHODIMP
HistoryListener::OnHistoryGoForward(nsIURI *aForwardURI, PRBool *_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(mEngine);
  send_history_message(mEngine, G_WEBENGINE_HISTORY_GO_FORWARD, 0, GetEncoding());
  return NS_OK;
}

NS_IMETHODIMP
HistoryListener::OnHistoryReload(nsIURI *aReloadURI, PRUint32 aReloadFlags, PRBool *_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(mEngine);
  send_history_message(mEngine, G_WEBENGINE_HISTORY_RELOAD, 0, GetEncoding());
  return NS_OK;
}

NS_IMETHODIMP
HistoryListener::OnHistoryGotoIndex(PRInt32 aIndex, nsIURI *aGotoURI, PRBool *_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(mEngine);
  send_history_message(mEngine, G_WEBENGINE_HISTORY_GOTO_INDEX, aIndex, GetEncoding());
  return NS_OK;
}

NS_IMETHODIMP
HistoryListener::OnHistoryPurge(PRInt32 aNumEntries, PRBool *_retval NS_OUTPARAM)
{
  NS_ENSURE_ARG(mEngine);
  send_history_message(mEngine, G_WEBENGINE_HISTORY_PURGE, aNumEntries, GetEncoding());
  return NS_OK;
}

