/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/* without this define NS_IMPL_NSGETMODULE does not provide (name)_NSGetModule
 * see: http://mxr.mozilla.org/mozilla-central/source/xpcom/glue/nsIGenericFactory.h#327
 */
#define XPCOM_TRANSLATE_NSGM_ENTRY_POINT

#include "microb_eal_components.h"

#include "MicrobEalObserver.h"
#include "nsIComponentRegistrar.h"
#include "nsIComponentManager.h"
#include "MicrobEalFilePicker.h"
#include "nsEmbedCID.h"
#include "MicrobEalPromptService.h"
#include "MicrobEalDownloadMgr.h"
#include "MicrobEalXulAppInfo.h"
#include "MicrobEalCertificate.h"
#include "nsSHistoryThumbnailManager.h"
#include "nsSHistoryThumbnailManager_contractid.h"
#include "MicrobEalNotificationBox.h"
#include "MicrobEalNotificationButton.h"
#include "MicrobEalNotification.h"
#include "gtkmozembed_internal2.h"

NS_GENERIC_FACTORY_CONSTRUCTOR(EmbedXulAppInfo)
NS_GENERIC_FACTORY_CONSTRUCTOR(MicrobEalFilePicker)
NS_GENERIC_FACTORY_CONSTRUCTOR (MicrobEalPromptService)
NS_GENERIC_FACTORY_CONSTRUCTOR(MicrobEalNotificationBox)
NS_GENERIC_FACTORY_CONSTRUCTOR(MicrobEalNotificationButton)
NS_GENERIC_FACTORY_CONSTRUCTOR(MicrobEalNotification)
NS_GENERIC_FACTORY_CONSTRUCTOR(MicrobEalDownloadMgr)
NS_GENERIC_FACTORY_CONSTRUCTOR_INIT(MicrobEalCertificate, Init)
NS_GENERIC_FACTORY_CONSTRUCTOR_INIT(nsSHistoryThumbnailManager, Init)
NS_GENERIC_FACTORY_CONSTRUCTOR(nsThumbnailProvider)

static const nsModuleComponentInfo microbEalAppComps[] =
{
  {
    "Microb Cert dialogs",
    MICROB_NSSDIALOGS_CID,
    NS_SSLCERTERRORDIALOG_CONTRACTID,
    MicrobEalCertificateConstructor
  },
  { "MicrobEalObserver",
    NS_EMBED_MICROB_OBSERVER_CID,
    NS_EMBED_CLIENT_OBSERVER_CONTRACTID,
    MicrobEalObserver::Create,
    MicrobEalObserver::RegisterSelf,
    MicrobEalObserver::UnregisterSelf
  },
  {
    NOTIFICATIONBOX_CLASSNAME,
    NOTIFICATIONBOX_CID,
    NOTIFICATIONBOX_CONTRACTID,
    MicrobEalNotificationBoxConstructor
  },
  {
    NOTIFICATIONBUTTON_CLASSNAME,
    NOTIFICATIONBUTTON_CID,
    NOTIFICATIONBUTTON_CONTRACTID,
    MicrobEalNotificationButtonConstructor
  },
  {
    NOTIFICATION_CLASSNAME,
    NOTIFICATION_CID,
    NOTIFICATION_CONTRACTID,
    MicrobEalNotificationConstructor
  },
  {
    MICROBEAL_FILEPICKER_CLASSNAME,
    MICROBEAL_FILEPICKER_CID,
    MICROBEAL_FILEPICKER_CONTRACTID,
    MicrobEalFilePickerConstructor
  },
  {
    MICROBEAL_DOWNLOADMGR_DESCRIPTION,
    MICROBEAL_DOWNLOADMGR_CID,
    NS_IHELPERAPPLAUNCHERDLG_CONTRACTID,
    MicrobEalDownloadMgrConstructor
  },
  {
    SHISTORYTHUMBNAILMANAGER_CLASSNAME, 
    SHISTORYTHUMBNAILMANAGER_CID,
    SHISTORYTHUMBNAILMANAGER_CONTRACTID,
    nsSHistoryThumbnailManagerConstructor,
  },
  {
    THUMBNAILPROVIDER_CLASSNAME, 
    THUMBNAILPROVIDER_CID,
    THUMBNAILPROVIDER_CONTRACTID,
    nsThumbnailProviderConstructor,
  }
};

static const nsModuleComponentInfo *sMicrobEalAppComps = microbEalAppComps;
static int   sMicrobEalNumAppComps = sizeof(microbEalAppComps) / sizeof(nsModuleComponentInfo);

static nsModuleComponentInfo kComponents[] =
{
  {
    "nsEmbedXulAppInfoService",
    EMBED_XULAPPINFO_CID,
    EMBED_XULAPPINFO_SERVICE_CONTRACTID,
    EmbedXulAppInfoConstructor
  },
  {
    "GtkPrompter Service",
    MICROB_EAL_PROMPT_SERVICE_CID,
    NS_PROMPTSERVICE_CONTRACTID,
    MicrobEalPromptServiceConstructor
  },
  {
    "GtkPrompter Cookie Service",
    NS_COOKIEPROMPTSERVICE_CID,
    NS_COOKIEPROMPTSERVICE_CONTRACTID,
    MicrobEalPromptServiceConstructor
  },
  {
    "GtkPrompter Nonblocking Alert Service",
    NS_NONBLOCKINGALERTSERVICE_CID,
    "@mozilla.org/embedcomp/nbalert-service;1",
    MicrobEalPromptServiceConstructor
  }
};
NS_IMPL_NSGETMODULE(MicrobApprunner, kComponents)
static nsStaticModuleInfo const kXREStaticModules[] =
{
  {
    "MicrobApprunner",
    MicrobApprunner_NSGetModule
  }
};
nsStaticModuleInfo const *const kPStaticModules = kXREStaticModules;
PRUint32 const kStaticModuleCount = NS_ARRAY_LENGTH(kXREStaticModules);

int microb_eal_components_static_init(void)
{
  gtk_moz_embed_set_static_components(kPStaticModules, kStaticModuleCount);
  return true;
}

int microb_eal_components_init(void)
{
  // Call gtk_moz_common_microb_init after gtk_moz_embed_push_startup call
  // It will add microb components
  // Whould be better to create something like gtk_moz_embed_register_app_components(aAppComps, aNumAppComps);
  nsCOMPtr<nsIComponentRegistrar> cr;
  nsresult rv = NS_GetComponentRegistrar(getter_AddRefs(cr));
  NS_ENSURE_SUCCESS(rv, rv);

  nsCOMPtr<nsIComponentManager> cm;
  rv = NS_GetComponentManager (getter_AddRefs (cm));
  NS_ENSURE_SUCCESS (rv, rv);

  for (int i = 0; i < sMicrobEalNumAppComps; ++i) {
    nsCOMPtr<nsIGenericFactory> componentFactory;
    rv = NS_NewGenericFactory(getter_AddRefs(componentFactory),
                              &(sMicrobEalAppComps[i]));
    if (NS_FAILED(rv)) {
      NS_WARNING("Unable to create factory for component");
      continue;  // don't abort registering other components
    }

    rv = cr->RegisterFactory(sMicrobEalAppComps[i].mCID, sMicrobEalAppComps[i].mDescription,
                             sMicrobEalAppComps[i].mContractID, componentFactory);
    NS_ASSERTION(NS_SUCCEEDED(rv), "Unable to register factory for component");

    // Call the registration hook of the component, if any
    if (sMicrobEalAppComps[i].mRegisterSelfProc) {
      rv = sMicrobEalAppComps[i].mRegisterSelfProc(cm, nsnull, nsnull, nsnull,
                                                   &(sMicrobEalAppComps[i]));
      NS_ASSERTION(NS_SUCCEEDED(rv), "Unable to self-register component");
    }
  }

  return true;
}

void microb_eal_components_del(void)
{
}
