/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLAWEB_H__
#define __GMOZILLAWEB_H__

#include <gweb.h>
#include <gwebengine.h>
#include <gwebbus.h>

#include "gmozillaengine.h"

#ifdef __cplusplus /* If this is a C++ compiler, use C linkage */
extern "C" {
#endif

G_BEGIN_DECLS

/* GMozillaWeb */

#define G_MOZILLA_WEB_NAME             "GMozillaWeb"
#define G_TYPE_MOZILLA_WEB             (g_mozilla_web_get_type ())
#define G_MOZILLA_WEB(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_WEB, GMozillaWeb))
#define G_MOZILLA_WEB_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_WEB, GMozillaWebClass))
#define G_IS_MOZILLA_WEB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_WEB))
#define G_IS_MOZILLA_WEB_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_WEB))
#define G_MOZILLA_WEB_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_WEB, GMozillaWebClass))

#define MAXIMUM_GLOBAL_HISTORY 50  //Moved from C file

typedef struct _GMozillaWebCertContext GMozillaWebCertContext;
typedef struct _GMozillaWeb GMozillaWeb;
typedef struct _GMozillaWebClass GMozillaWebClass;

struct _GMozillaWebCertContext
{
    gpointer mozcert;
    gpointer x509cert;
    gpointer rawcert;
    guint rawlen;
    guint error;
};

/** @struct GMozillaWeb.
  * Defines a Mozilla Web.
  */
struct _GMozillaWeb
{
    GObject parent;          /** < Object parent */
    GObject *global;         /** < Global object */
    GList *logins_list;
    GList *mCertContexts;
    GList *ongoing_download_list;
    gboolean is_configured;
    GSList *disabled_pllist;
    GdkCursor *default_cursor;
    gboolean connected;
    gpointer download_listener;
    GList *window_list;
    GWebBus* web_bus;
    GObject* password_manager;
    char* ui_bus_name;
    gboolean no_xembed;
    gboolean web_is_active;
    gboolean shutdown_xpcom;
    gboolean mHideFixedFrames;
};

struct _GMozillaWebClass
{
    GObjectClass parent;
    gint (*modal_dialog)               (GObject *, const gchar *, const gchar *,
                                        gint, gint, gint, gint);
    gboolean (*certificate_dialog)     (GObject *, GObject *);
    void (*certificate_password_dialog)(GObject *, const gchar *,
                                        const gchar *, gchar **);
    void (*certificate_details)        (GObject *, gchar *);
    void (*history_added)              (GObject *, const gchar *, GObject *);
    void (*connectivity_status)        (GObject *, gint);
    gint (*on_service_notify)          (GObject *, gpointer ctx, const gchar *topic, const gchar *data);
};

GType       g_mozilla_web_get_type      (void);

/** Gets the mozilla web global instance
  * @return The mozilla global instance.
  */
GMozillaWeb* g_mozilla_get_current_web(void);

/** Pauses all not finished downloads
  * @param self The GMozillaWeb object itself
  * @return
  */
void
g_mozilla_web_pause_all_transfer_item (GMozillaWeb *self);

gint
g_mozilla_web_confirm_ex (GMozillaEngine *engine,
        const char *title, const char *text, guint bt_flags,
        const char *button1, const char *button2, const char *button3,
        const char *check_msg, gboolean *check_val);

void
g_mozilla_web_ask_cookie (GMozillaEngine *engine,
        gboolean *remember, gint *action, gint expire,
        const gchar * url, const gchar * name, const gchar * value,
        const gchar * domain, const gchar * path);

gboolean
g_mozilla_web_prompt (GMozillaEngine *engine, const gchar * dialog_title,
        const gchar * dialog_msg, gchar ** default_msg,
        const gchar * check_msg, gboolean * check_value);

gboolean
g_mozilla_web_prompt_auth (GMozillaEngine * engine, GObject * mozembed,
        const gchar * dialog_title, const gchar * dialog_msg,
        gchar ** user_name, gchar ** user_passwd,
        const gchar * check_msg, gboolean * check_value);

gboolean
g_mozilla_web_select (GMozillaEngine * engine, const gchar * dialog_title,
        const gchar * dialog_text, gpointer dialog_options,
        gpointer dialog_choice);

void
g_mozilla_web_create_web_buses(GMozillaWeb* self);

gboolean
g_mozilla_web_check_bus(GMozillaWeb* self);

void
g_web_exit(void);

G_END_DECLS

#ifdef __cplusplus /* If this is a C++ compiler, end C linkage */
}
#endif

#endif /* __GMOZILLAWEB_H__ */
